/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.Transport;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.ConnectionListener;
import org.gudy.azureus2.plugins.network.IncomingMessageQueue;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueue;
import org.gudy.azureus2.pluginsimpl.local.network.IncomingMessageQueueImpl;
import org.gudy.azureus2.pluginsimpl.local.network.OutgoingMessageQueueImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportImpl;

public class ConnectionImpl
implements Connection {
    private final NetworkConnection core_connection;
    private final OutgoingMessageQueueImpl out_queue;
    private final IncomingMessageQueueImpl in_queue;
    private final TransportImpl transport;
    private final boolean incoming;

    public ConnectionImpl(NetworkConnection networkConnection, boolean bl) {
        this.core_connection = networkConnection;
        this.out_queue = new OutgoingMessageQueueImpl(networkConnection.getOutgoingMessageQueue());
        this.in_queue = new IncomingMessageQueueImpl(networkConnection.getIncomingMessageQueue());
        this.transport = new TransportImpl(networkConnection);
        this.incoming = bl;
    }

    public void connect(final ConnectionListener connectionListener) {
        this.core_connection.connect(3, new NetworkConnection.ConnectionListener(){

            public int connectStarted(int n) {
                connectionListener.connectStarted();
                return n;
            }

            public void connectSuccess(ByteBuffer byteBuffer) {
                connectionListener.connectSuccess();
            }

            public void connectFailure(Throwable throwable) {
                connectionListener.connectFailure(throwable);
            }

            public void exceptionThrown(Throwable throwable) {
                connectionListener.exceptionThrown(throwable);
            }

            public String getDescription() {
                return "plugin connection: " + ConnectionImpl.this.core_connection.getString();
            }
        });
    }

    public void close() {
        this.core_connection.close();
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.out_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.in_queue;
    }

    public void startMessageProcessing() {
        this.core_connection.startMessageProcessing();
        this.core_connection.enableEnhancedMessageProcessing(true, -1);
    }

    public org.gudy.azureus2.plugins.network.Transport getTransport() {
        return this.transport;
    }

    public NetworkConnection getCoreConnection() {
        return this.core_connection;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public String getString() {
        Transport transport = this.core_connection.getTransport();
        if (transport == null) {
            return "";
        }
        return transport.getEncryption(false);
    }
}

