/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageDecoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEncoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class GenericMessageConnectionDirect
implements GenericMessageConnectionAdapter {
    public static final int MAX_MESSAGE_SIZE = 262144;
    private GenericMessageConnectionImpl owner;
    private String msg_id;
    private String msg_desc;
    private int stream_crypto;
    private byte[][] shared_secrets;
    private GenericMessageEndpointImpl endpoint;
    private NetworkConnection connection;
    private volatile boolean connected;
    private boolean processing;
    private volatile boolean closed;
    private List inbound_rls;
    private List outbound_rls;

    protected static GenericMessageConnectionDirect receive(GenericMessageEndpointImpl genericMessageEndpointImpl, String string, String string2, int n, byte[][] byArray) {
        GenericMessageConnectionDirect genericMessageConnectionDirect = new GenericMessageConnectionDirect(string, string2, genericMessageEndpointImpl, n, byArray);
        return genericMessageConnectionDirect;
    }

    protected GenericMessageConnectionDirect(String string, String string2, GenericMessageEndpointImpl genericMessageEndpointImpl, int n, byte[][] byArray) {
        this.msg_id = string;
        this.msg_desc = string2;
        this.endpoint = genericMessageEndpointImpl;
        this.stream_crypto = n;
        this.shared_secrets = byArray;
    }

    public void setOwner(GenericMessageConnectionImpl genericMessageConnectionImpl) {
        this.owner = genericMessageConnectionImpl;
    }

    public int getMaximumMessageSize() {
        return 262144;
    }

    public String getType() {
        if (this.connection == null) {
            return "";
        }
        Transport transport = this.connection.getTransport();
        if (transport == null) {
            return "";
        }
        return transport.getEncryption(true);
    }

    public int getTransportType() {
        if (this.connection == null) {
            return 0;
        }
        Transport transport = this.connection.getTransport();
        if (transport == null) {
            return 0;
        }
        if (transport.isTCP()) {
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.addRateLimiter(rateLimiter, false);
            } else {
                if (this.inbound_rls == null) {
                    this.inbound_rls = new ArrayList();
                }
                this.inbound_rls.add(rateLimiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.removeRateLimiter(rateLimiter, false);
            } else if (this.inbound_rls != null) {
                this.inbound_rls.remove(rateLimiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.addRateLimiter(rateLimiter, true);
            } else {
                if (this.outbound_rls == null) {
                    this.outbound_rls = new ArrayList();
                }
                this.outbound_rls.add(rateLimiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutboundRateLimiter(RateLimiter rateLimiter) {
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            if (this.processing) {
                this.connection.removeRateLimiter(rateLimiter, true);
            } else if (this.outbound_rls != null) {
                this.outbound_rls.remove(rateLimiter);
            }
        }
    }

    protected void connect(NetworkConnection networkConnection) {
        this.connection = networkConnection;
        this.connection.connect(3, new NetworkConnection.ConnectionListener(){

            public int connectStarted(int n) {
                return n;
            }

            public void connectSuccess(ByteBuffer byteBuffer) {
                GenericMessageConnectionDirect.this.connected = true;
            }

            public void connectFailure(Throwable throwable) {
                GenericMessageConnectionDirect.this.owner.reportFailed(throwable);
                GenericMessageConnectionDirect.this.connection.close();
            }

            public void exceptionThrown(Throwable throwable) {
                GenericMessageConnectionDirect.this.owner.reportFailed(throwable);
                GenericMessageConnectionDirect.this.connection.close();
            }

            public String getDescription() {
                return "generic connection: " + GenericMessageConnectionDirect.this.endpoint.getNotionalAddress();
            }
        });
    }

    public void accepted() {
        this.startProcessing();
    }

    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void connect(ByteBuffer byteBuffer, final GenericMessageConnectionAdapter.ConnectionListener connectionListener) {
        if (this.connected) {
            return;
        }
        ConnectionEndpoint connectionEndpoint = this.endpoint.getConnectionEndpoint();
        connectionEndpoint = connectionEndpoint.getLANAdjustedEndpoint();
        this.connection = NetworkManager.getSingleton().createConnection(connectionEndpoint, new GenericMessageEncoder(), new GenericMessageDecoder(this.msg_id, this.msg_desc), this.stream_crypto != 1, this.stream_crypto != 3, this.shared_secrets);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.msg_id.getBytes());
        if (byteBuffer != null) {
            GenericMessage genericMessage = new GenericMessage(this.msg_id, this.msg_desc, new DirectByteBuffer(byteBuffer), false);
            DirectByteBuffer[] directByteBufferArray = new GenericMessageEncoder().encodeMessage(genericMessage)[0].getRawData();
            int n = byteBuffer2.remaining();
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                n += directByteBufferArray[i].remaining((byte)11);
            }
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(n);
            byteBuffer3.put(byteBuffer2);
            for (int i = 0; i < directByteBufferArray.length; ++i) {
                byteBuffer3.put(directByteBufferArray[i].getBuffer((byte)11));
            }
            byteBuffer3.rewind();
            byteBuffer2 = byteBuffer3;
        }
        this.connection.connect(byteBuffer2, 3, new NetworkConnection.ConnectionListener(){

            public int connectStarted(int n) {
                return n;
            }

            public void connectSuccess(ByteBuffer byteBuffer) {
                GenericMessageConnectionDirect.this.connected = true;
                try {
                    if (byteBuffer != null && byteBuffer.remaining() > 0) {
                        GenericMessageConnectionDirect.this.connection.getOutgoingMessageQueue().addMessage(new GenericMessage(GenericMessageConnectionDirect.this.msg_id, GenericMessageConnectionDirect.this.msg_desc, new DirectByteBuffer(byteBuffer), true), false);
                    }
                    connectionListener.connectSuccess();
                    GenericMessageConnectionDirect.this.startProcessing();
                }
                catch (Throwable throwable) {
                    this.connectFailure(throwable);
                }
            }

            public void connectFailure(Throwable throwable) {
                connectionListener.connectFailure(throwable);
                GenericMessageConnectionDirect.this.connection.close();
            }

            public void exceptionThrown(Throwable throwable) {
                connectionListener.connectFailure(throwable);
                GenericMessageConnectionDirect.this.connection.close();
            }

            public String getDescription() {
                return "generic connection";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startProcessing() {
        this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

            public boolean messageReceived(Message message) {
                GenericMessage genericMessage = (GenericMessage)message;
                GenericMessageConnectionDirect.this.owner.receive(genericMessage);
                return true;
            }

            public void protocolBytesReceived(int n) {
            }

            public void dataBytesReceived(int n) {
            }

            public boolean isPriority() {
                return false;
            }
        });
        this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageQueued(Message message) {
            }

            public void messageRemoved(Message message) {
            }

            public void messageSent(Message message) {
            }

            public void protocolBytesSent(int n) {
            }

            public void dataBytesSent(int n) {
            }

            public void flush() {
            }
        });
        this.connection.startMessageProcessing();
        this.connection.enableEnhancedMessageProcessing(true, -1);
        GenericMessageConnectionDirect genericMessageConnectionDirect = this;
        synchronized (genericMessageConnectionDirect) {
            int n;
            if (this.inbound_rls != null) {
                for (n = 0; n < this.inbound_rls.size(); ++n) {
                    this.connection.addRateLimiter((LimitedRateGroup)this.inbound_rls.get(n), false);
                }
                this.inbound_rls = null;
            }
            if (this.outbound_rls != null) {
                for (n = 0; n < this.outbound_rls.size(); ++n) {
                    this.connection.addRateLimiter((LimitedRateGroup)this.outbound_rls.get(n), true);
                }
                this.inbound_rls = null;
            }
            this.processing = true;
        }
    }

    public void send(PooledByteBuffer pooledByteBuffer) throws MessageException {
        if (!this.connected) {
            throw new MessageException("not connected");
        }
        PooledByteBufferImpl pooledByteBufferImpl = (PooledByteBufferImpl)pooledByteBuffer;
        try {
            this.connection.getOutgoingMessageQueue().addMessage(new GenericMessage(this.msg_id, this.msg_desc, pooledByteBufferImpl.getBuffer(), false), false);
        }
        catch (Throwable throwable) {
            throw new MessageException("send failed", throwable);
        }
    }

    public void close() throws MessageException {
        if (!this.connected) {
            throw new MessageException("not connected");
        }
        if (!this.closed) {
            this.closed = true;
            this.connection.close();
        }
    }
}

