/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import java.net.URL;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

public class DownloadScrapeResultImpl
implements DownloadScrapeResult {
    protected DownloadImpl download;
    protected TRTrackerScraperResponse response;

    protected DownloadScrapeResultImpl(DownloadImpl downloadImpl, TRTrackerScraperResponse tRTrackerScraperResponse) {
        this.download = downloadImpl;
        this.response = tRTrackerScraperResponse;
    }

    protected void setContent(TRTrackerScraperResponse tRTrackerScraperResponse) {
        this.response = tRTrackerScraperResponse;
    }

    public Download getDownload() {
        return this.download;
    }

    public int getResponseType() {
        if (this.response != null && this.response.isValid()) {
            return 1;
        }
        return 2;
    }

    public int getSeedCount() {
        return this.response == null ? -1 : this.response.getSeeds();
    }

    public int getNonSeedCount() {
        return this.response == null ? -1 : this.response.getPeers();
    }

    public long getScrapeStartTime() {
        return this.response == null ? -1L : this.response.getScrapeStartTime();
    }

    public void setNextScrapeStartTime(long l) {
        TRTrackerScraperResponse tRTrackerScraperResponse = this.getCurrentResponse();
        if (tRTrackerScraperResponse != null) {
            tRTrackerScraperResponse.setNextScrapeStartTime(l);
        }
    }

    public long getNextScrapeStartTime() {
        TRTrackerScraperResponse tRTrackerScraperResponse = this.getCurrentResponse();
        return tRTrackerScraperResponse == null ? -1L : tRTrackerScraperResponse.getNextScrapeStartTime();
    }

    public String getStatus() {
        if (this.response != null) {
            return this.response.getStatusString();
        }
        return "";
    }

    public URL getURL() {
        if (this.response != null) {
            return this.response.getURL();
        }
        return null;
    }

    protected TRTrackerScraperResponse getCurrentResponse() {
        TRTrackerScraperResponse tRTrackerScraperResponse = this.download.getDownload().getTrackerScrapeResponse();
        if (tRTrackerScraperResponse == null) {
            tRTrackerScraperResponse = this.response;
        }
        return tRTrackerScraperResponse;
    }
}

