/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import java.io.File;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo {
    protected DownloadImpl download;
    protected org.gudy.azureus2.core3.disk.DiskManagerFileInfo core;

    public DiskManagerFileInfoImpl(DownloadImpl downloadImpl, org.gudy.azureus2.core3.disk.DiskManagerFileInfo diskManagerFileInfo) {
        this.core = diskManagerFileInfo;
        this.download = downloadImpl;
    }

    public void setPriority(boolean bl) {
        this.core.setPriority(bl ? 1 : 0);
    }

    public void setSkipped(boolean bl) {
        this.core.setSkipped(bl);
    }

    public int getNumericPriorty() {
        return this.core.getPriority();
    }

    public void setNumericPriority(int n) {
        this.core.setPriority(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDeleted(boolean bl) {
        int n;
        int n2 = this.core.getStorageType();
        if (bl) {
            if (n2 == 1) {
                n = 2;
            } else {
                if (n2 != 3) return;
                n = 4;
            }
        } else if (n2 == 2) {
            n = 1;
        } else {
            if (n2 != 4) return;
            n = 3;
        }
        this.core.setStorageType(n);
    }

    public boolean isDeleted() {
        int n = this.core.getStorageType();
        return n == 2 || n == 4;
    }

    public void setLink(File file) {
        this.core.setLink(file);
    }

    public File getLink() {
        return this.core.getLink();
    }

    public int getAccessMode() {
        return this.core.getAccessMode();
    }

    public long getDownloaded() {
        return this.core.getDownloaded();
    }

    public long getLength() {
        return this.core.getLength();
    }

    public File getFile() {
        return this.core.getFile(false);
    }

    public File getFile(boolean bl) {
        return this.core.getFile(bl);
    }

    public int getFirstPieceNumber() {
        return this.core.getFirstPieceNumber();
    }

    public long getPieceSize() {
        try {
            return this.getDownload().getTorrent().getPieceSize();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return 0L;
        }
    }

    public int getNumPieces() {
        return this.core.getNbPieces();
    }

    public boolean isPriority() {
        return this.core.getPriority() > 0;
    }

    public boolean isSkipped() {
        return this.core.isSkipped();
    }

    public int getIndex() {
        return this.core.getIndex();
    }

    public byte[] getDownloadHash() throws DownloadException {
        return this.getDownload().getTorrent().getHash();
    }

    public Download getDownload() throws DownloadException {
        if (this.download != null) {
            return this.download;
        }
        return DownloadManagerImpl.getDownloadStatic(this.core.getDownloadManager());
    }

    public DiskManagerChannel createChannel() throws DownloadException {
        return new DiskManagerChannelImpl(this.download, this);
    }

    public org.gudy.azureus2.core3.disk.DiskManagerFileInfo getCore() {
        return this.core;
    }
}

