/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.unix;

import com.aelitis.azureus.core.impl.AzureusCoreSingleInstanceClient;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class ScriptBeforeStartup {
    private static PrintStream sysout;
    private static Object display;

    public static void main(String[] stringArray) {
        boolean bl;
        boolean bl2;
        System.setProperty("transitory.startup", "1");
        sysout = System.out;
        try {
            System.setOut(new PrintStream(new FileOutputStream("/dev/stderr")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        String string = System.getProperty("MULTI_INSTANCE");
        boolean bl3 = bl2 = string != null && string.equalsIgnoreCase("true");
        if (!bl2 && (bl = new AzureusCoreSingleInstanceClient().sendArgs(stringArray, 500))) {
            String string2 = "Passing startup args to already-running " + Constants.APP_NAME + " java process listening on [127.0.0.1: 6880]";
            ScriptBeforeStartup.log(string2);
            sysout.println("exit");
            return;
        }
        String string3 = COConfigurationManager.getStringParameter("scriptaftershutdown", null);
        COConfigurationManager.removeParameter("scriptaftershutdown.exit");
        COConfigurationManager.removeParameter("scriptaftershutdown");
        COConfigurationManager.save();
        if (string3 != null) {
            ScriptBeforeStartup.log("Script after " + Constants.APP_NAME + " shutdown did not run.. running now");
            sysout.println(string3);
            if (string3.indexOf("$0") < 0) {
                sysout.println("echo \"Restarting Azureus..\"");
                sysout.println("$0\n");
            }
            sysout.println("exit");
            return;
        }
        String string4 = ScriptBeforeStartup.getNewGreDir();
        if (string4 != null) {
            String string5 = "export MOZILLA_FIVE_HOME=\"" + string4 + "\"\n" + "if [ \"$LD_LIBRARY_PATH x\" = \" x\" ] ; then\n" + "\texport LD_LIBRARY_PATH=$MOZILLA_FIVE_HOME;\n" + "else\n" + "\texport LD_LIBRARY_PATH=$MOZILLA_FIVE_HOME:$LD_LIBRARY_PATH\n" + "fi\n";
            sysout.println(string5);
            ScriptBeforeStartup.log("setting LD_LIBRARY_PATH to: $LD_LIBRARY_PATH");
            ScriptBeforeStartup.log("setting MOZILLA_FIVE_HOME to: $MOZILLA_FIVE_HOME");
        } else {
            ScriptBeforeStartup.log("GRE/XULRunner automatically found");
        }
    }

    public static String getNewGreDir() {
        if (ScriptBeforeStartup.canOpenBrowser()) {
            return null;
        }
        String string = null;
        String[] stringArray = new String[]{"/etc/gre64.conf", "/etc/gre.d/gre64.conf", "/etc/gre.conf", "/etc/gre.d/gre.conf", "/etc/gre.d/xulrunner.conf", "/etc/gre.d/libxul0d.conf"};
        ScriptBeforeStartup.log("Auto-scanning for GRE/XULRunner.  You can skip this by appending the GRE path to LD_LIBRARY_PATH and setting MOZILLA_FIVE_HOME.");
        try {
            Object object;
            String[] stringArray2;
            File file;
            Pattern pattern = Pattern.compile("GRE_PATH=(.*)", 2);
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2;
                file = new File(stringArray[i]);
                if (!file.isFile() || !file.canRead()) continue;
                ScriptBeforeStartup.log("  checking " + file + " for GRE_PATH");
                stringArray2 = FileUtil.readFileAsString(file, 16384);
                if (stringArray2 == null || !((Matcher)(object = pattern.matcher((CharSequence)stringArray2))).find() || !ScriptBeforeStartup.isValidGrePath(new File((String)(object2 = ((Matcher)object).group(1))))) continue;
                string = object2;
                break;
            }
            if (string == null) {
                final ArrayList<File> arrayList = new ArrayList<File>();
                file = new File("/usr");
                file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        if (file.getName().startsWith("lib")) {
                            arrayList.add(file);
                        }
                        return false;
                    }
                });
                arrayList.add(new File("/usr/local"));
                arrayList.add(new File("/opt"));
                stringArray2 = new String[]{"mozilla", "firefox", "seamonkey", "xulrunner"};
                object = new FileFilter(){

                    public boolean accept(File file) {
                        String string = file.getName().toLowerCase();
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (!string.startsWith(stringArray2[i])) continue;
                            return true;
                        }
                        return false;
                    }
                };
                for (File file2 : arrayList) {
                    File[] fileArray = file2.listFiles((FileFilter)object);
                    for (int i = 0; i < fileArray.length; ++i) {
                        ScriptBeforeStartup.log("  checking " + fileArray[i] + " for GRE");
                        if (!ScriptBeforeStartup.isValidGrePath(fileArray[i])) continue;
                        string = fileArray[i].getAbsolutePath();
                        break;
                    }
                    if (string == null) continue;
                    break;
                }
            }
            if (string != null) {
                ScriptBeforeStartup.log("GRE found at " + string + ".");
                System.setProperty("org.eclipse.swt.browser.XULRunnerPath", string);
            }
        }
        catch (Throwable throwable) {
            ScriptBeforeStartup.log("Error trying to find suitable GRE: " + Debug.getNestedExceptionMessage(throwable));
            string = null;
        }
        if (!ScriptBeforeStartup.canOpenBrowser()) {
            ScriptBeforeStartup.log("Can't create browser.  Will try to set LD_LIBRARY_PATH and hope " + Constants.APP_NAME + " has better luck.");
        }
        return string;
    }

    private static boolean canOpenBrowser() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.widgets.Display");
            if (display != null) {
                display = clazz.newInstance();
            }
            Class<?> clazz2 = Class.forName("org.eclipse.swt.widgets.Shell");
            Constructor<?> constructor = clazz2.getConstructor(clazz);
            Object obj = constructor.newInstance(display);
            Class<?> clazz3 = Class.forName("org.eclipse.swt.browser.Browser");
            Constructor<?>[] constructorArray = clazz3.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                if (constructorArray[i].getParameterTypes().length != 2) continue;
                Object obj2 = constructorArray[i].newInstance(obj, new Integer(0));
                Method method = clazz3.getMethod("setUrl", String.class);
                method.invoke(obj2, "about:blank");
                break;
            }
            Method method = clazz2.getMethod("dispose", new Class[0]);
            method.invoke(obj, new Object[0]);
            return true;
        }
        catch (Throwable throwable) {
            ScriptBeforeStartup.log("Browser check failed with: " + Debug.getNestedExceptionMessage(throwable));
            return false;
        }
    }

    private static boolean isValidGrePath(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        if (new File(file, "components/libwidget_gtk.so").exists() || new File(file, "libwidget_gtk.so").exists()) {
            ScriptBeforeStartup.log("\tCan not use GRE from " + file + " as it's too old (GTK2 version required).");
            return false;
        }
        if (new File(file, "components/libwidget_gtk2.so").exists() || new File(file, "libwidget_gtk2.so").exists()) {
            return true;
        }
        if (!new File(file, "components/libxpcom.so").exists() && !new File(file, "libxpcom.so").exists()) {
            ScriptBeforeStartup.log("\tCan not use GRE from " + file + " because it's missing libxpcom.so.");
            return false;
        }
        return true;
    }

    private static void log(String string) {
        sysout.println("echo \"" + string.replaceAll("\"", "\\\"") + "\"");
    }
}

