/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class ReferenceCountedDirectByteBuffer
extends DirectByteBuffer {
    private DirectByteBuffer basis;
    private int ref_count = 1;

    protected ReferenceCountedDirectByteBuffer(DirectByteBuffer directByteBuffer) {
        this(directByteBuffer.getBufferInternal());
        this.basis = directByteBuffer;
    }

    protected ReferenceCountedDirectByteBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public ReferenceCountedDirectByteBuffer duplicate(int n, int n2) {
        ByteBuffer byteBuffer = this.getBufferInternal().duplicate();
        byteBuffer.position(byteBuffer.position() + n);
        byteBuffer.limit(byteBuffer.position() + n2);
        ReferenceCountedDirectByteBufferDuplicate referenceCountedDirectByteBufferDuplicate = new ReferenceCountedDirectByteBufferDuplicate(byteBuffer);
        return referenceCountedDirectByteBufferDuplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReferenceCount() {
        ReferenceCountedDirectByteBuffer referenceCountedDirectByteBuffer = this;
        synchronized (referenceCountedDirectByteBuffer) {
            ++this.ref_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementReferenceCount() {
        ReferenceCountedDirectByteBuffer referenceCountedDirectByteBuffer = this;
        synchronized (referenceCountedDirectByteBuffer) {
            --this.ref_count;
            if (this.ref_count == 0) {
                this.basis.returnToPool();
            }
        }
    }

    public int getReferenceCount() {
        return this.ref_count;
    }

    public void returnToPool() {
        this.decrementReferenceCount();
    }

    protected class ReferenceCountedDirectByteBufferDuplicate
    extends ReferenceCountedDirectByteBuffer {
        protected ReferenceCountedDirectByteBufferDuplicate(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.incrementReferenceCount();
        }

        public ReferenceCountedDirectByteBuffer duplicate(int n, int n2) {
            Debug.out("dup dup");
            return null;
        }

        public void returnToPool() {
            this.decrementReferenceCount();
        }

        public void incrementReferenceCount() {
            ReferenceCountedDirectByteBuffer.this.incrementReferenceCount();
        }

        public void decrementReferenceCount() {
            ReferenceCountedDirectByteBuffer.this.decrementReferenceCount();
        }
    }
}

