/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ConcurrentHasher;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class ConcurrentHasherRequest {
    private static AEMonitor class_mon = new AEMonitor("ConcHashRequest:class");
    private ConcurrentHasher concurrent_hasher;
    private ByteBuffer buffer;
    private ConcurrentHasherRequestListener listener;
    private int size;
    private byte[] result;
    private boolean cancelled;
    private boolean low_priority;
    private AESemaphore sem = new AESemaphore("ConcHashRequest");

    protected ConcurrentHasherRequest(ConcurrentHasher concurrentHasher, ByteBuffer byteBuffer, ConcurrentHasherRequestListener concurrentHasherRequestListener, boolean bl) {
        this.concurrent_hasher = concurrentHasher;
        this.buffer = byteBuffer;
        this.listener = concurrentHasherRequestListener;
        this.low_priority = bl;
        this.size = this.buffer.limit() - this.buffer.position();
    }

    public byte[] getResult() {
        this.sem.reserve();
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.cancelled) {
            ConcurrentHasherRequestListener concurrentHasherRequestListener;
            this.cancelled = true;
            this.sem.releaseForever();
            try {
                class_mon.enter();
                concurrentHasherRequestListener = this.listener;
                this.listener = null;
                Object var3_2 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                class_mon.exit();
                throw throwable;
            }
            if (concurrentHasherRequestListener != null) {
                concurrentHasherRequestListener.complete(this);
            }
        }
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isLowPriority() {
        return this.low_priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(SHA1Hasher sHA1Hasher) {
        if (!this.cancelled) {
            this.result = sHA1Hasher.calculateHash(this.buffer);
            this.sem.releaseForever();
            if (!this.cancelled) {
                ConcurrentHasherRequestListener concurrentHasherRequestListener;
                try {
                    class_mon.enter();
                    concurrentHasherRequestListener = this.listener;
                    this.listener = null;
                    Object var4_3 = null;
                    class_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    class_mon.exit();
                    throw throwable;
                }
                if (concurrentHasherRequestListener != null) {
                    concurrentHasherRequestListener.complete(this);
                }
            }
        }
    }
}

