/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.BEncodableObject;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;

public class BEncoder {
    private static final int BUFFER_DOUBLE_LIMIT = 262144;
    private static final byte[] MINUS_1_BYTES = "-1".getBytes();
    private byte[] current_buffer = new byte[256];
    private int current_buffer_pos = 0;
    private byte[][] old_buffers;
    private byte[] int_buffer = new byte[12];
    private boolean url_encode;
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public static byte[] encode(Map map) throws IOException {
        return BEncoder.encode(map, false);
    }

    public static byte[] encode(Map map, boolean bl) throws IOException {
        BEncoder bEncoder = new BEncoder(bl);
        bEncoder.encodeObject(map);
        return bEncoder.toByteArray();
    }

    private BEncoder(boolean bl) {
        this.url_encode = bl;
    }

    private boolean encodeObject(Object object) throws IOException {
        if (object instanceof BEncodableObject) {
            object = ((BEncodableObject)object).toBencodeObject();
        }
        if (object instanceof String || object instanceof Float) {
            String string = object instanceof String ? (String)object : String.valueOf((Float)object);
            boolean bl = true;
            int n = string.length();
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= '\u0080') {
                    bl = false;
                    break;
                }
                byArray[i] = (byte)c;
            }
            if (bl) {
                this.writeInt(n);
                this.writeChar(':');
                this.writeBytes(byArray);
            } else {
                ByteBuffer byteBuffer = Constants.DEFAULT_CHARSET.encode(string);
                this.writeInt(byteBuffer.limit());
                this.writeChar(':');
                this.writeByteBuffer(byteBuffer);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            TreeMap treeMap = null;
            boolean bl = object instanceof ByteEncodedKeyHashMap;
            this.writeChar('d');
            treeMap = map instanceof TreeMap ? (TreeMap)map : new TreeMap(map);
            for (Map.Entry entry : treeMap.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) continue;
                if (k instanceof byte[]) {
                    this.encodeObject(k);
                    if (this.encodeObject(v)) continue;
                    this.encodeObject("");
                    continue;
                }
                if (k instanceof String) {
                    String string = (String)k;
                    if (bl) {
                        try {
                            this.encodeObject(Constants.BYTE_CHARSET.encode(string));
                            if (this.encodeObject(v)) continue;
                            this.encodeObject("");
                            continue;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new IOException("BEncoder: unsupport encoding: " + unsupportedEncodingException.getMessage());
                        }
                    }
                    this.encodeObject(string);
                    if (this.encodeObject(v)) continue;
                    this.encodeObject("");
                    continue;
                }
                Debug.out("Attempt to encode an unsupported map key type: " + object.getClass() + ";value=" + object);
            }
            this.writeChar('e');
        } else if (object instanceof List) {
            List list = (List)object;
            this.writeChar('l');
            for (int i = 0; i < list.size(); ++i) {
                this.encodeObject(list.get(i));
            }
            this.writeChar('e');
        } else if (object instanceof Long) {
            Long l = (Long)object;
            this.writeChar('i');
            this.writeLong(l);
            this.writeChar('e');
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            this.writeChar('i');
            this.writeInt(n);
            this.writeChar('e');
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.writeInt(byArray.length);
            this.writeChar(':');
            if (this.url_encode) {
                this.writeBytes(URLEncoder.encode(new String(byArray, "ISO-8859-1"), "ISO-8859-1").getBytes());
            } else {
                this.writeBytes(byArray);
            }
        } else if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            this.writeInt(byteBuffer.limit());
            this.writeChar(':');
            this.writeByteBuffer(byteBuffer);
        } else {
            if (object == null) {
                Debug.out("Attempt to encode a null value: sofar=" + this.getEncodedSoFar());
                return false;
            }
            Debug.out("Attempt to encode an unsupported entry type: " + object.getClass() + ";value=" + object);
            return false;
        }
        return true;
    }

    private void writeChar(char c) {
        int n = this.current_buffer.length - this.current_buffer_pos;
        if (n > 0) {
            this.current_buffer[this.current_buffer_pos++] = (byte)c;
        } else {
            int n2 = this.current_buffer.length < 262144 ? this.current_buffer.length << 1 : this.current_buffer.length + 262144;
            byte[] byArray = new byte[n2];
            byArray[0] = (byte)c;
            if (this.old_buffers == null) {
                this.old_buffers = new byte[][]{this.current_buffer};
            } else {
                byte[][] byArrayArray = new byte[this.old_buffers.length + 1][];
                System.arraycopy(this.old_buffers, 0, byArrayArray, 0, this.old_buffers.length);
                byArrayArray[this.old_buffers.length] = this.current_buffer;
                this.old_buffers = byArrayArray;
            }
            this.current_buffer = byArray;
            this.current_buffer_pos = 1;
        }
    }

    private void writeInt(int n) {
        if (n == -1) {
            this.writeBytes(MINUS_1_BYTES);
            return;
        }
        int n2 = this.intToBytes(n);
        this.writeBytes(this.int_buffer, n2, 12 - n2);
    }

    private void writeLong(long l) {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeInt((int)l);
        } else {
            this.writeBytes(Long.toString(l).getBytes());
        }
    }

    private void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
    }

    private void writeBytes(byte[] byArray, int n, int n2) {
        int n3 = this.current_buffer.length - this.current_buffer_pos;
        if (n3 >= n2) {
            System.arraycopy(byArray, n, this.current_buffer, this.current_buffer_pos, n2);
            this.current_buffer_pos += n2;
        } else {
            if (n3 > 0) {
                System.arraycopy(byArray, n, this.current_buffer, this.current_buffer_pos, n3);
                n2 -= n3;
            }
            int n4 = this.current_buffer.length < 262144 ? this.current_buffer.length << 1 : this.current_buffer.length + 262144;
            byte[] byArray2 = new byte[Math.max(n4, n2 + 512)];
            System.arraycopy(byArray, n + n3, byArray2, 0, n2);
            if (this.old_buffers == null) {
                this.old_buffers = new byte[][]{this.current_buffer};
            } else {
                byte[][] byArrayArray = new byte[this.old_buffers.length + 1][];
                System.arraycopy(this.old_buffers, 0, byArrayArray, 0, this.old_buffers.length);
                byArrayArray[this.old_buffers.length] = this.current_buffer;
                this.old_buffers = byArrayArray;
            }
            this.current_buffer = byArray2;
            this.current_buffer_pos = n2;
        }
    }

    private void writeByteBuffer(ByteBuffer byteBuffer) {
        this.writeBytes(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
    }

    private String getEncodedSoFar() {
        return new String(this.toByteArray());
    }

    private byte[] toByteArray() {
        if (this.old_buffers == null) {
            byte[] byArray = new byte[this.current_buffer_pos];
            System.arraycopy(this.current_buffer, 0, byArray, 0, this.current_buffer_pos);
            return byArray;
        }
        int n = this.current_buffer_pos;
        for (int i = 0; i < this.old_buffers.length; ++i) {
            n += this.old_buffers[i].length;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < this.old_buffers.length; ++i) {
            byte[] byArray2 = this.old_buffers[i];
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
        }
        System.arraycopy(this.current_buffer, 0, byArray, n2, this.current_buffer_pos);
        return byArray;
    }

    private static Object normaliseObject(Object object) {
        if (object instanceof Integer) {
            object = new Long(((Integer)object).longValue());
        } else if (object instanceof Boolean) {
            object = new Long((Boolean)object != false ? 1L : 0L);
        } else if (object instanceof Float) {
            object = String.valueOf((Float)object);
        } else if (object instanceof byte[]) {
            try {
                object = new String((byte[])object, "UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return object;
    }

    public static boolean isEncodable(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof byte[] || object instanceof String || object instanceof BEncodableObject) {
            return true;
        }
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).keySet()) {
                Object k = entry.getKey();
                if ((k instanceof String || k instanceof byte[]) && BEncoder.isEncodable(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                if (BEncoder.isEncodable(iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean objectsAreIdentical(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!(object.getClass() == object2.getClass() || object instanceof Map && object2 instanceof Map || object instanceof List && object2 instanceof List)) {
            object = BEncoder.normaliseObject(object);
            object2 = BEncoder.normaliseObject(object2);
            if (object.getClass() != object2.getClass()) {
                Debug.out("Failed to normalise classes " + object.getClass() + "/" + object2.getClass());
                return false;
            }
        }
        if (object instanceof Long || object instanceof String) {
            return object.equals(object2);
        }
        if (object instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof List) {
            return BEncoder.listsAreIdentical((List)object, (List)object2);
        }
        if (object instanceof Map) {
            return BEncoder.mapsAreIdentical((Map)object, (Map)object2);
        }
        if (object instanceof Integer || object instanceof Boolean || object instanceof Float || object instanceof ByteBuffer) {
            return object.equals(object2);
        }
        Debug.out("Invalid type: " + object);
        return false;
    }

    public static boolean listsAreIdentical(List list, List list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (BEncoder.objectsAreIdentical(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean mapsAreIdentical(Map map, Map map2) {
        if (map == null && map2 == null) {
            return true;
        }
        if (map == null || map2 == null) {
            return false;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        for (Object k : map.keySet()) {
            Object v;
            Object v2 = map.get(k);
            if (BEncoder.objectsAreIdentical(v2, v = map2.get(k))) continue;
            return false;
        }
        return true;
    }

    public static Map cloneMap(Map map) {
        if (map == null) {
            return null;
        }
        TreeMap treeMap = new TreeMap();
        for (Map.Entry entry : map.entrySet()) {
            Object object = entry.getKey();
            Object v = entry.getValue();
            if (object instanceof byte[]) {
                object = ((byte[])object).clone();
            }
            treeMap.put(object, BEncoder.clone(v));
        }
        return treeMap;
    }

    public static List cloneList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(BEncoder.clone(iterator.next()));
        }
        return arrayList;
    }

    public static Object clone(Object object) {
        if (object instanceof List) {
            return BEncoder.cloneList((List)object);
        }
        if (object instanceof Map) {
            return BEncoder.cloneMap((Map)object);
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        return object;
    }

    public static StringBuffer encodeToXML(Map map, boolean bl) {
        XMLEncoder xMLEncoder = new XMLEncoder();
        return xMLEncoder.encode(map, bl);
    }

    private int intToBytes(int n) {
        int n2;
        int n3;
        int n4 = 12;
        int n5 = 0;
        if (n < 0) {
            n5 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n3 = n / 100;
            n2 = n - ((n3 << 6) + (n3 << 5) + (n3 << 2));
            n = n3;
            this.int_buffer[--n4] = DigitOnes[n2];
            this.int_buffer[--n4] = DigitTens[n2];
        }
        do {
            n3 = n * 52429 >>> 19;
            n2 = n - ((n3 << 3) + (n3 << 1));
            this.int_buffer[--n4] = digits[n2];
        } while ((n = n3) != 0);
        if (n5 != 0) {
            this.int_buffer[--n4] = n5;
        }
        return n4;
    }

    protected static class XMLEncoder
    extends XUXmlWriter {
        protected XMLEncoder() {
        }

        protected StringBuffer encode(Map map, boolean bl) {
            StringWriter stringWriter = new StringWriter(1024);
            this.setOutputWriter(stringWriter);
            this.setGenericSimple(bl);
            this.writeGeneric(map);
            this.flushOutputStream();
            return stringWriter.getBuffer();
        }
    }
}

