/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class AsyncDispatcher {
    private String name;
    private AEThread2 thread;
    private int priority = 5;
    private LinkedList queue = new LinkedList();
    private AESemaphore queue_sem = new AESemaphore("AsyncDispatcher");
    private int quiesce_after_millis;

    public AsyncDispatcher() {
        this("AsyncDispatcher", 10000);
    }

    public AsyncDispatcher(String string) {
        this(string, 10000);
    }

    public AsyncDispatcher(int n) {
        this("AsyncDispatcher", n);
    }

    public AsyncDispatcher(String string, int n) {
        this.name = string;
        this.quiesce_after_millis = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(AERunnable aERunnable) {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            this.queue.add(aERunnable);
            if (this.thread == null) {
                this.thread = new AEThread2(this.name, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            AsyncDispatcher.this.queue_sem.reserve(AsyncDispatcher.this.quiesce_after_millis);
                            AERunnable aERunnable = null;
                            AsyncDispatcher asyncDispatcher = AsyncDispatcher.this;
                            synchronized (asyncDispatcher) {
                                if (AsyncDispatcher.this.queue.isEmpty()) {
                                    AsyncDispatcher.this.thread = null;
                                    break;
                                }
                                aERunnable = (AERunnable)AsyncDispatcher.this.queue.removeFirst();
                            }
                            try {
                                aERunnable.runSupport();
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }
                };
                this.thread.setPriority(this.priority);
                this.thread.start();
            }
        }
        this.queue_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiescent() {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            return this.thread == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            return this.queue.size();
        }
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDispatchThread() {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            return this.thread != null && this.thread.isCurrentThread();
        }
    }
}

