/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;

public abstract class TRTrackerServerTCP
extends TRTrackerServerImpl {
    private static int THREAD_POOL_SIZE = COConfigurationManager.getIntParameter("Tracker Max Threads");
    public static long PROCESSING_GET_LIMIT = COConfigurationManager.getIntParameter("Tracker Max GET Time") * 1000;
    public static int PROCESSING_POST_MULTIPLIER = COConfigurationManager.getIntParameter("Tracker Max POST Time Multiplier");
    private boolean ssl;
    private int port;
    private boolean apply_ip_filter;
    private ThreadPool thread_pool;
    static boolean LOG_DOS_TO_FILE;
    protected static File dos_log_file;
    protected static AEMonitor class_mon;
    Map DOS_map = new LinkedHashMap(1000, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return TRTrackerServerTCP.this.checkDOSRemove(entry);
        }
    };
    List dos_list = new ArrayList(128);
    long last_dos_check = 0L;
    long MAX_DOS_ENTRIES = 10000L;
    long MAX_DOS_RETENTION = 10000L;
    int DOS_CHECK_DEAD_WOOD_COUNT = 512;
    int DOS_MIN_INTERVAL = 1000;
    int dos_check_count = 0;

    public TRTrackerServerTCP(String string, int n, boolean bl, boolean bl2, boolean bl3) throws TRTrackerServerException {
        super(string, bl3);
        this.port = n;
        this.ssl = bl;
        this.apply_ip_filter = bl2;
        this.thread_pool = new ThreadPool("TrackerServer:TCP:" + this.port, THREAD_POOL_SIZE);
        if (PROCESSING_GET_LIMIT > 0L) {
            this.thread_pool.setExecutionLimit(PROCESSING_GET_LIMIT);
        }
    }

    public void runProcessor(TRTrackerServerProcessorTCP tRTrackerServerProcessorTCP) {
        this.thread_pool.run(tRTrackerServerProcessorTCP);
    }

    protected boolean isIPFilterEnabled() {
        return this.apply_ip_filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkDOS(String var1_1) throws UnknownHostException {
        var2_2 = InetAddress.getByName(var1_1);
        if (var2_2.isLoopbackAddress() != false) return false;
        if (InetAddress.getLocalHost().equals(var2_2)) {
            return false;
        }
        this.last_dos_check = SystemTime.getCurrentTime();
        var4_3 = (DOSEntry)this.DOS_map.get(var1_1);
        if (var4_3 == null) {
            var4_3 = new DOSEntry(var1_1);
            this.DOS_map.put(var1_1, var4_3);
            var3_4 = false;
        } else {
            v0 = var3_4 = this.last_dos_check - var4_3.last_time < (long)this.DOS_MIN_INTERVAL;
            if (var3_4 && TRTrackerServerTCP.LOG_DOS_TO_FILE) {
                this.dos_list.add(var4_3);
            }
            var4_3.last_time = this.last_dos_check;
        }
        ++this.dos_check_count;
        if (this.dos_check_count != this.DOS_CHECK_DEAD_WOOD_COUNT) return var3_4;
        this.dos_check_count = 0;
        var5_5 = this.DOS_map.values().iterator();
        while (var5_5.hasNext()) {
            var6_6 = (DOSEntry)var5_5.next();
            if (this.last_dos_check - var6_6.last_time <= this.MAX_DOS_RETENTION) break;
            var5_5.remove();
        }
        if (this.dos_list.size() <= 0) return var3_4;
        try {
            block18: {
                TRTrackerServerTCP.class_mon.enter();
                if (TRTrackerServerTCP.dos_log_file == null) {
                    TRTrackerServerTCP.dos_log_file = new File(System.getProperty("user.dir") + File.separator + "dos.log");
                }
                var6_6 = null;
                try {
                    try {
                        var6_6 = new PrintWriter(new FileWriter(TRTrackerServerTCP.dos_log_file, true));
                        for (var7_7 = 0; var7_7 < this.dos_list.size(); ++var7_7) {
                            var8_9 = (DOSEntry)this.dos_list.get(var7_7);
                            var9_10 = new SimpleDateFormat("hh:mm:ss - ").format(new Date(var8_9.last_time));
                            var6_6.println(var9_10 + var8_9.ip);
                        }
                        var11_11 = null;
                        this.dos_list.clear();
                        if (var6_6 == null) break block18;
                    }
                    catch (Throwable var7_8) {
                        var11_12 = null;
                        this.dos_list.clear();
                        if (var6_6 != null) {
                            try {
                                var6_6.close();
                            }
                            catch (Throwable var12_15) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable var10_17) {
                    var11_13 = null;
                    this.dos_list.clear();
                    if (var6_6 == null) throw var10_17;
                    ** try [egrp 3[TRYBLOCK] [4 : 445->453)] { 
lbl61:
                    // 1 sources

                    var6_6.close();
                    throw var10_17;
lbl63:
                    // 1 sources

                    catch (Throwable var12_16) {
                        // empty catch block
                    }
                    throw var10_17;
                }
                try {}
                catch (Throwable var12_14) {}
                var6_6.close();
            }
            var14_18 = null;
            TRTrackerServerTCP.class_mon.exit();
            return var3_4;
        }
        catch (Throwable var13_20) {
            var14_19 = null;
            TRTrackerServerTCP.class_mon.exit();
            throw var13_20;
        }
    }

    protected boolean checkDOSRemove(Map.Entry entry) {
        boolean bl = (long)this.DOS_map.size() > this.MAX_DOS_ENTRIES || this.last_dos_check - ((DOSEntry)entry.getValue()).last_time > this.MAX_DOS_RETENTION;
        return bl;
    }

    public int getPort() {
        return this.port;
    }

    protected void setPort(int n) {
        this.port = n;
    }

    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    public boolean isSSL() {
        return this.ssl;
    }

    protected boolean handleExternalRequest(final InetSocketAddress inetSocketAddress, final InetSocketAddress inetSocketAddress2, final String string, final String string2, final URL uRL, final String string3, final InputStream inputStream, final OutputStream outputStream, final AsyncController asyncController, final boolean[] blArray) throws IOException {
        final boolean bl = blArray[0];
        blArray[0] = false;
        for (Object object : this.listeners) {
            if (!object.handleExternalRequest(inetSocketAddress2, string, string2, uRL, string3, inputStream, outputStream, asyncController)) continue;
            return true;
        }
        for (Object object : this.listeners2) {
            TRTrackerServerListener2.ExternalRequest externalRequest;
            if (!object.handleExternalRequest(externalRequest = new TRTrackerServerListener2.ExternalRequest(){

                public InetSocketAddress getClientAddress() {
                    return inetSocketAddress2;
                }

                public InetSocketAddress getLocalAddress() {
                    return inetSocketAddress;
                }

                public String getUser() {
                    return string;
                }

                public String getURL() {
                    return string2;
                }

                public URL getAbsoluteURL() {
                    return uRL;
                }

                public String getHeader() {
                    return string3;
                }

                public InputStream getInputStream() {
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    return outputStream;
                }

                public AsyncController getAsyncController() {
                    return asyncController;
                }

                public boolean canKeepAlive() {
                    return bl;
                }

                public void setKeepAlive(boolean bl2) {
                    blArray[0] = bl && bl2;
                }
            })) continue;
            return true;
        }
        return false;
    }

    static {
        if (THREAD_POOL_SIZE <= 0) {
            THREAD_POOL_SIZE = 1;
        }
        if (PROCESSING_GET_LIMIT < 0L) {
            PROCESSING_GET_LIMIT = 0L;
        }
        if (PROCESSING_POST_MULTIPLIER < 0) {
            PROCESSING_POST_MULTIPLIER = 0;
        }
        LOG_DOS_TO_FILE = false;
        LOG_DOS_TO_FILE = System.getProperty("azureus.log.dos") != null;
        class_mon = new AEMonitor("TRTrackerServerTCP:class");
    }

    protected class DOSEntry {
        String ip;
        long last_time;

        protected DOSEntry(String string) {
            this.ip = string;
            this.last_time = TRTrackerServerTCP.this.last_dos_check;
        }
    }
}

