/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTScraperResponseImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerDHTScraperImpl {
    protected static TRTrackerDHTScraperImpl singleton;
    protected static AEMonitor class_mon;
    private TRTrackerScraperImpl scraper;
    private Map<HashWrapper, TRTrackerDHTScraperResponseImpl> responses = new HashMap<HashWrapper, TRTrackerDHTScraperResponseImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerDHTScraperImpl create(TRTrackerScraperImpl tRTrackerScraperImpl) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerDHTScraperImpl(tRTrackerScraperImpl);
            }
            TRTrackerDHTScraperImpl tRTrackerDHTScraperImpl = singleton;
            Object var3_2 = null;
            class_mon.exit();
            return tRTrackerDHTScraperImpl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected TRTrackerDHTScraperImpl(TRTrackerScraperImpl tRTrackerScraperImpl) {
        this.scraper = tRTrackerScraperImpl;
    }

    public void setScrape(TOTorrent tOTorrent, URL uRL, DownloadScrapeResult downloadScrapeResult) {
        if (tOTorrent != null && downloadScrapeResult != null) {
            try {
                TRTrackerDHTScraperResponseImpl tRTrackerDHTScraperResponseImpl = new TRTrackerDHTScraperResponseImpl(tOTorrent.getHashWrapper(), downloadScrapeResult.getURL());
                tRTrackerDHTScraperResponseImpl.setSeedsPeers(downloadScrapeResult.getSeedCount(), downloadScrapeResult.getNonSeedCount());
                tRTrackerDHTScraperResponseImpl.setScrapeStartTime(downloadScrapeResult.getScrapeStartTime());
                tRTrackerDHTScraperResponseImpl.setNextScrapeStartTime(downloadScrapeResult.getNextScrapeStartTime());
                tRTrackerDHTScraperResponseImpl.setStatus(downloadScrapeResult.getResponseType() == 1 ? 2 : 1, downloadScrapeResult.getStatus());
                this.responses.put(tOTorrent.getHashWrapper(), tRTrackerDHTScraperResponseImpl);
                this.scraper.scrapeReceived(tRTrackerDHTScraperResponseImpl);
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent tOTorrent, URL uRL, boolean bl) {
        if (tOTorrent != null) {
            try {
                int[] nArray;
                TRTrackerScraperClientResolver tRTrackerScraperClientResolver;
                HashWrapper hashWrapper = tOTorrent.getHashWrapper();
                TRTrackerDHTScraperResponseImpl tRTrackerDHTScraperResponseImpl = this.responses.get(hashWrapper);
                if (tRTrackerDHTScraperResponseImpl == null && (tRTrackerScraperClientResolver = this.scraper.getClientResolver()) != null && (nArray = tRTrackerScraperClientResolver.getCachedScrape(hashWrapper)) != null) {
                    tRTrackerDHTScraperResponseImpl = new TRTrackerDHTScraperResponseImpl(hashWrapper, tOTorrent.getAnnounceURL());
                    tRTrackerDHTScraperResponseImpl.setSeedsPeers(nArray[0], nArray[1]);
                    long l = SystemTime.getCurrentTime();
                    tRTrackerDHTScraperResponseImpl.setScrapeStartTime(l);
                    tRTrackerDHTScraperResponseImpl.setNextScrapeStartTime(l + 300000L);
                    tRTrackerDHTScraperResponseImpl.setStatus(2, MessageText.getString("Scrape.status.cached"));
                    this.responses.put(tOTorrent.getHashWrapper(), tRTrackerDHTScraperResponseImpl);
                    this.scraper.scrapeReceived(tRTrackerDHTScraperResponseImpl);
                }
                return tRTrackerDHTScraperResponseImpl;
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
        }
        return null;
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tRTrackerAnnouncer) {
        return this.scrape(tRTrackerAnnouncer.getTorrent(), null, false);
    }

    public void remove(TOTorrent tOTorrent) {
        try {
            this.responses.remove(tOTorrent.getHashWrapper());
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
    }

    static {
        class_mon = new AEMonitor("TRTrackerDHTScraper");
    }
}

