/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.net.InetAddress;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.plugins.network.Connection;

public interface PEPeer {
    public static final int CONNECTING = 10;
    public static final int HANDSHAKING = 20;
    public static final int TRANSFERING = 30;
    public static final int CLOSING = 40;
    public static final int DISCONNECTED = 50;
    public static final String[] StateNames = new String[]{"Twinkle", "Connecting", "Handshaking", "Transfering", "Closing", "Disconnected"};
    public static final int MESSAGING_BT_ONLY = 1;
    public static final int MESSAGING_AZMP = 2;
    public static final int MESSAGING_LTEP = 3;
    public static final int MESSAGING_EXTERN = 4;

    public void addListener(PEPeerListener var1);

    public void removeListener(PEPeerListener var1);

    public int getPeerState();

    public PEPeerManager getManager();

    public String getPeerSource();

    public byte[] getId();

    public String getIp();

    public InetAddress getAlternativeIPv6();

    public int getPort();

    public String getIPHostName();

    public int getTCPListenPort();

    public int getUDPListenPort();

    public int getUDPNonDataListenPort();

    public BitFlags getAvailable();

    public boolean isPieceAvailable(int var1);

    public boolean transferAvailable();

    public void setSnubbed(boolean var1);

    public boolean isChokingMe();

    public boolean isUnchokeOverride();

    public boolean isChokedByMe();

    public void sendChoke();

    public void sendUnChoke();

    public boolean isInteresting();

    public boolean isInterested();

    public boolean isDownloadPossible();

    public boolean isSeed();

    public boolean isRelativeSeed();

    public boolean isSnubbed();

    public long getSnubbedTime();

    public PEPeerStats getStats();

    public boolean isIncoming();

    public boolean hasReceivedBitField();

    public int getPercentDoneInThousandNotation();

    public String getClient();

    public boolean isOptimisticUnchoke();

    public void setOptimisticUnchoke(boolean var1);

    public void setUploadHint(int var1);

    public int getUploadHint();

    public void setUniqueAnnounce(int var1);

    public int getUniqueAnnounce();

    public int getConsecutiveNoRequestCount();

    public void setConsecutiveNoRequestCount(int var1);

    public void setUploadRateLimitBytesPerSecond(int var1);

    public void setDownloadRateLimitBytesPerSecond(int var1);

    public int getUploadRateLimitBytesPerSecond();

    public int getDownloadRateLimitBytesPerSecond();

    public void addRateLimiter(LimitedRateGroup var1, boolean var2);

    public void removeRateLimiter(LimitedRateGroup var1, boolean var2);

    public Object getData(String var1);

    public void setData(String var1, Object var2);

    public Object getUserData(Object var1);

    public void setUserData(Object var1, Object var2);

    public Connection getPluginConnection();

    public boolean supportsMessaging();

    public int getMessagingMode();

    public String getEncryption();

    public Message[] getSupportedMessages();

    public void addReservedPieceNumber(int var1);

    public void removeReservedPieceNumber(int var1);

    public int[] getReservedPieceNumbers();

    public int getIncomingRequestCount();

    public int getOutgoingRequestCount();

    public int getOutboundDataQueueSize();

    public int[] getIncomingRequestedPieceNumbers();

    public int[] getOutgoingRequestedPieceNumbers();

    public int getPercentDoneOfCurrentIncomingRequest();

    public int getPercentDoneOfCurrentOutgoingRequest();

    public long getBytesRemaining();

    public void setSuspendedLazyBitFieldEnabled(boolean var1);

    public long getTimeSinceConnectionEstablished();

    public void setLastPiece(int var1);

    public int getLastPiece();

    public boolean isLANLocal();

    public boolean sendRequestHint(int var1, int var2, int var3, int var4);

    public int[] getRequestHint();

    public void clearRequestHint();

    public void sendStatsRequest(Map var1);

    public void sendRejectRequest(DiskManagerReadRequest var1);

    public void setHaveAggregationEnabled(boolean var1);

    public byte[] getHandshakeReservedBytes();

    public String getClientNameFromPeerID();

    public String getClientNameFromExtensionHandshake();

    public boolean isPriorityConnection();

    public void setPriorityConnection(boolean var1);
}

