/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class DownloadManagerRateController {
    private static AzureusCore core;
    private static SpeedManager speed_manager;
    private static Map<PEPeerManager, PMState> pm_map;
    private static TimerEventPeriodic timer;
    private static AsyncDispatcher dispatcher;
    private static boolean enable;
    private static boolean enable_limit_handling;
    private static int slack_bytes_per_sec;
    private static volatile int rate_limit;
    private static LimitedRateGroup limiter;
    private static final int TIMER_MILLIS = 1000;
    private static final int WAIT_AFTER_CHOKE_PERIOD = 10000;
    private static final int WAIT_AFTER_CHOKE_TICKS = 10;
    private static final int DEFAULT_UP_LIMIT = 256000;
    private static final int MAX_UP_DIFF = 15360;
    private static final int MAX_DOWN_DIFF = 10240;
    private static final int MIN_DIFF = 2048;
    private static final int SAMPLE_COUNT = 5;
    private static int sample_num;
    private static double incomplete_samples;
    private static double complete_samples;
    private static int ticks_to_sample_start;
    private static int last_rate_limit;
    private static double last_incomplete_average;
    private static double last_complete_average;
    private static double last_overall_average;
    private static int tick_count;
    private static int last_tick_processed;
    private static long pm_last_bad_limit;
    private static int latest_choke;
    private static int wait_until_tick;

    public static String getString() {
        if (enable) {
            String string = "reserved=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(slack_bytes_per_sec);
            if (enable_limit_handling) {
                string = string + ", limit=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(rate_limit);
                string = string + ", last[choke=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(latest_choke) + ", ratio=" + DisplayFormatters.formatDecimal(last_incomplete_average / last_complete_average, 2) + "]";
                return string;
            }
            return string;
        }
        return "Disabled";
    }

    public static void addPeerManager(final PEPeerManager pEPeerManager) {
        dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (core == null) {
                    core = AzureusCoreFactory.getSingleton();
                    speed_manager = core.getSpeedManager();
                }
                boolean bl = !pEPeerManager.hasDownloadablePiece();
                PEPeerManagerStats pEPeerManagerStats = pEPeerManager.getStats();
                long l = pEPeerManagerStats.getTotalDataBytesSentNoLan() + pEPeerManagerStats.getTotalProtocolBytesSentNoLan();
                if (bl) {
                    pEPeerManager.addRateLimiter(limiter, true);
                }
                pm_map.put(pEPeerManager, new PMState(bl, l));
                if (timer == null) {
                    timer = SimpleTimer.addPeriodicEvent("DMRC", 1000L, new TimerEventPerformer(){

                        public void perform(TimerEvent timerEvent2) {
                            dispatcher.dispatch(new AERunnable(){

                                public void runSupport() {
                                    DownloadManagerRateController.update();
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    public static void removePeerManager(final PEPeerManager pEPeerManager) {
        dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                pm_map.remove(pEPeerManager);
                if (pm_map.size() == 0) {
                    timer.cancel();
                    timer = null;
                    rate_limit = 0;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update() {
        block45: {
            Object object;
            ++tick_count;
            if (!enable_limit_handling || pm_map.size() == 0 || NetworkManager.isSeedingOnlyUploadRate() || NetworkManager.getMaxUploadRateBPSNormal() != 0 || core == null || speed_manager == null || speed_manager.getSpeedTester() == null) {
                rate_limit = 0;
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (Map.Entry<PEPeerManager, PMState> entry : pm_map.entrySet()) {
                PEPeerManager pEPeerManager = entry.getKey();
                object = entry.getValue();
                boolean bl = !pEPeerManager.hasDownloadablePiece();
                PEPeerManagerStats pEPeerManagerStats = pEPeerManager.getStats();
                long l = pEPeerManagerStats.getTotalDataBytesSentNoLan() + pEPeerManagerStats.getTotalProtocolBytesSentNoLan();
                long l2 = ((PMState)object).setBytesUp(l);
                if (bl) {
                    ++n;
                    n4 = (int)((long)n4 + l2);
                } else {
                    ++n2;
                    n3 = (int)((long)n3 + l2);
                }
                if (((PMState)object).isComplete() == bl) continue;
                if (bl) {
                    pEPeerManager.addRateLimiter(limiter, true);
                } else {
                    pEPeerManager.removeRateLimiter(limiter, true);
                }
                ((PMState)object).setComplete(bl);
            }
            if (n2 == 0 || n == 0) {
                rate_limit = 0;
                return;
            }
            boolean bl = false;
            if (last_tick_processed != tick_count - 1) {
                pm_last_bad_limit = 0L;
                latest_choke = 0;
                wait_until_tick = 0;
                ticks_to_sample_start = 0;
                sample_num = 0;
                incomplete_samples = 0.0;
                complete_samples = 0.0;
                bl = true;
            }
            last_tick_processed = tick_count;
            if (bl || tick_count < wait_until_tick) {
                return;
            }
            try {
                int n5;
                double d;
                double d2;
                double d3;
                block47: {
                    int n6;
                    block46: {
                        int n7;
                        SpeedManagerLimitEstimate speedManagerLimitEstimate;
                        long l = SystemTime.getCurrentTime();
                        object = speed_manager.getActiveMapper();
                        if (rate_limit == 0 && (rate_limit = speed_manager.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec()) == 0) {
                            rate_limit = 256000;
                        }
                        if ((speedManagerLimitEstimate = object.getLastBadUploadLimit()) != null && (long)(n7 = speedManagerLimitEstimate.getBytesPerSec()) != pm_last_bad_limit) {
                            pm_last_bad_limit = n7;
                            SpeedManagerLimitEstimate[] speedManagerLimitEstimateArray = object.getBadUploadHistory();
                            int n8 = speedManagerLimitEstimate.getBytesPerSec();
                            int n9 = 1;
                            for (SpeedManagerLimitEstimate speedManagerLimitEstimate2 : speedManagerLimitEstimateArray) {
                                long l3 = speedManagerLimitEstimate2.getWhen();
                                if (l - l3 > 30000L || speedManagerLimitEstimate2.getBytesPerSec() == n7) continue;
                                n8 += speedManagerLimitEstimate2.getBytesPerSec();
                                ++n9;
                            }
                            latest_choke = n8 / n9;
                            int n10 = rate_limit == 0 ? latest_choke / 2 : rate_limit / 2;
                            if (n10 < slack_bytes_per_sec) {
                                n10 = slack_bytes_per_sec;
                            }
                            rate_limit = n10;
                            wait_until_tick = tick_count + 10;
                            ticks_to_sample_start = 0;
                            sample_num = 0;
                            complete_samples = 0.0;
                            incomplete_samples = 0.0;
                            last_rate_limit = 0;
                            Object var30_30 = null;
                            return;
                        }
                        if (ticks_to_sample_start > 0) {
                            --ticks_to_sample_start;
                            break block45;
                        }
                        if (sample_num < 5) {
                            complete_samples += (double)n4;
                            incomplete_samples += (double)n3;
                            ++sample_num;
                            break block45;
                        }
                        d3 = incomplete_samples / 5.0;
                        d2 = complete_samples / 5.0;
                        d = (complete_samples + incomplete_samples) / 5.0;
                        n6 = -1;
                        try {
                            if (last_rate_limit == 0) {
                                n6 = 1;
                            } else {
                                double d4 = d - last_overall_average;
                                if (d4 < 0.0) {
                                    n6 = rate_limit < last_rate_limit ? 1 : 0;
                                } else {
                                    double d5;
                                    double d6 = last_incomplete_average / last_complete_average;
                                    double d7 = d3 / d2;
                                    n6 = rate_limit < last_rate_limit && d7 >= d6 ? -1 : (rate_limit > last_rate_limit && d7 <= d6 ? ((d5 = d3 - last_incomplete_average) >= 1024.0 ? -1 : 1) : 1);
                                }
                            }
                            Object var25_36 = null;
                            if (n6 <= 0) break block46;
                        }
                        catch (Throwable throwable) {
                            int n11;
                            Object var25_37 = null;
                            if (n6 > 0) {
                                int n12 = latest_choke == 0 ? 256000 : latest_choke;
                                int n13 = (n12 - rate_limit) / 4;
                                if (n13 > 15360) {
                                    n13 = 15360;
                                } else if (n13 < 2048) {
                                    n13 = 2048;
                                }
                                n11 = rate_limit + n13;
                                if (n11 > 0x6400000) {
                                    n11 = 0x6400000;
                                }
                            } else if (n6 < 0) {
                                int n14 = rate_limit / 5;
                                if (n14 > 10240) {
                                    n14 = 10240;
                                } else if (n14 < 2048) {
                                    n14 = 2048;
                                }
                                n11 = rate_limit - n14;
                                if (n11 < slack_bytes_per_sec) {
                                    n11 = slack_bytes_per_sec;
                                }
                            } else {
                                n11 = rate_limit;
                            }
                            last_rate_limit = rate_limit;
                            last_overall_average = d;
                            last_complete_average = d2;
                            last_incomplete_average = d3;
                            rate_limit = n11;
                            sample_num = 0;
                            complete_samples = 0.0;
                            incomplete_samples = 0.0;
                            throw throwable;
                        }
                        int n15 = latest_choke == 0 ? 256000 : latest_choke;
                        int n16 = (n15 - rate_limit) / 4;
                        if (n16 > 15360) {
                            n16 = 15360;
                        } else if (n16 < 2048) {
                            n16 = 2048;
                        }
                        n5 = rate_limit + n16;
                        if (n5 > 0x6400000) {
                            n5 = 0x6400000;
                        }
                        break block47;
                    }
                    if (n6 < 0) {
                        int n17 = rate_limit / 5;
                        if (n17 > 10240) {
                            n17 = 10240;
                        } else if (n17 < 2048) {
                            n17 = 2048;
                        }
                        n5 = rate_limit - n17;
                        if (n5 < slack_bytes_per_sec) {
                            n5 = slack_bytes_per_sec;
                        }
                    } else {
                        n5 = rate_limit;
                    }
                }
                last_rate_limit = rate_limit;
                last_overall_average = d;
                last_complete_average = d2;
                last_incomplete_average = d3;
                rate_limit = n5;
                sample_num = 0;
                complete_samples = 0.0;
                incomplete_samples = 0.0;
                {
                }
            }
            catch (Throwable throwable) {
                Object var30_32 = null;
                throw throwable;
            }
        }
        Object var30_31 = null;
    }

    static {
        pm_map = new HashMap<PEPeerManager, PMState>();
        dispatcher = new AsyncDispatcher();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Bias Upload Enable", "Bias Upload Handle No Limit", "Bias Upload Slack KBs"}, new ParameterListener(){

            public void parameterChanged(String string) {
                enable = COConfigurationManager.getBooleanParameter("Bias Upload Enable");
                enable_limit_handling = COConfigurationManager.getBooleanParameter("Bias Upload Handle No Limit") && enable;
                slack_bytes_per_sec = COConfigurationManager.getIntParameter("Bias Upload Slack KBs") * 1024;
            }
        });
        rate_limit = 0;
        limiter = new LimitedRateGroup(){

            public String getName() {
                return "DMRC";
            }

            public int getRateLimitBytesPerSecond() {
                return rate_limit;
            }
        };
        tick_count = 0;
        last_tick_processed = -1;
    }

    private static class PMState {
        private boolean complete;
        private long bytes_up;

        private PMState(boolean bl, long l) {
            this.complete = bl;
            this.bytes_up = l;
        }

        private boolean isComplete() {
            return this.complete;
        }

        private void setComplete(boolean bl) {
            this.complete = bl;
        }

        private long setBytesUp(long l) {
            long l2 = l - this.bytes_up;
            this.bytes_up = l;
            return l2;
        }
    }
}

