/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import java.io.File;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandlerUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class DownloadManagerMoveHandler
extends DownloadManagerMoveHandlerUtils {
    public static SaveLocationManager CURRENT_HANDLER = DownloadManagerDefaultPaths.DEFAULT_HANDLER;

    private static boolean isApplicableDownload(DownloadManager downloadManager) {
        if (!downloadManager.isPersistent()) {
            DownloadManagerMoveHandler.logInfo(DownloadManagerMoveHandler.describe(downloadManager) + " is not persistent.", downloadManager);
            return false;
        }
        if (downloadManager.getDownloadState().getFlag(4L)) {
            DownloadManagerMoveHandler.logInfo(DownloadManagerMoveHandler.describe(downloadManager) + " has exclusion flag set.", downloadManager);
            return false;
        }
        return true;
    }

    public static SaveLocationChange onInitialisation(DownloadManager downloadManager) {
        if (!DownloadManagerMoveHandler.isApplicableDownload(downloadManager)) {
            return null;
        }
        try {
            return CURRENT_HANDLER.onInitialization(PluginCoreUtils.wrap(downloadManager), true, true);
        }
        catch (Exception exception) {
            DownloadManagerMoveHandler.logError("Error trying to determine initial download location.", downloadManager, exception);
            return null;
        }
    }

    public static SaveLocationChange onRemoval(DownloadManager downloadManager) {
        if (!DownloadManagerMoveHandler.isApplicableDownload(downloadManager)) {
            return null;
        }
        try {
            return CURRENT_HANDLER.onRemoval(PluginCoreUtils.wrap(downloadManager), true, true);
        }
        catch (Exception exception) {
            DownloadManagerMoveHandler.logError("Error trying to determine on-removal location.", downloadManager, exception);
            return null;
        }
    }

    public static SaveLocationChange onCompletion(DownloadManager downloadManager, MoveCallback moveCallback) {
        SaveLocationChange saveLocationChange;
        if (!DownloadManagerMoveHandler.isApplicableDownload(downloadManager)) {
            return null;
        }
        if (downloadManager.getDownloadState().getFlag(8L)) {
            DownloadManagerMoveHandler.logInfo("Completion flag already set on " + DownloadManagerMoveHandler.describe(downloadManager) + ", skip move-on-completion behaviour.", downloadManager);
            return null;
        }
        try {
            saveLocationChange = CURRENT_HANDLER.onCompletion(PluginCoreUtils.wrap(downloadManager), true, true);
        }
        catch (Exception exception) {
            DownloadManagerMoveHandler.logError("Error trying to determine on-completion location.", downloadManager, exception);
            return null;
        }
        if (moveCallback != null && saveLocationChange != null) {
            moveCallback.perform(saveLocationChange);
        }
        DownloadManagerMoveHandler.logInfo("Setting completion flag on " + DownloadManagerMoveHandler.describe(downloadManager) + ", may have been set before.", downloadManager);
        downloadManager.getDownloadState().setFlag(8L, true);
        return saveLocationChange;
    }

    public static boolean canGoToCompleteDir(DownloadManager downloadManager) {
        return downloadManager.isDownloadComplete(false) && DownloadManagerMoveHandler.isOnCompleteEnabled();
    }

    public static boolean isOnCompleteEnabled() {
        return COConfigurationManager.getBooleanParameter("Move Completed When Done");
    }

    public static boolean isOnRemovalEnabled() {
        return COConfigurationManager.getBooleanParameter("File.move.download.removed.enabled");
    }

    public static SaveLocationChange recalculatePath(DownloadManager downloadManager) {
        Download download = PluginCoreUtils.wrap(downloadManager);
        SaveLocationChange saveLocationChange = null;
        if (DownloadManagerMoveHandler.canGoToCompleteDir(downloadManager)) {
            saveLocationChange = CURRENT_HANDLER.onCompletion(download, true, false);
        }
        if (saveLocationChange == null) {
            saveLocationChange = CURRENT_HANDLER.onInitialization(download, true, false);
        }
        return saveLocationChange;
    }

    public static File[] getRelatedDirs(DownloadManager downloadManager) {
        ArrayList arrayList = new ArrayList();
        Download download = PluginCoreUtils.wrap(downloadManager);
        if (DownloadManagerMoveHandler.isOnCompleteEnabled()) {
            DownloadManagerMoveHandler.addFile(arrayList, COConfigurationManager.getStringParameter("Completed Files Directory"));
            DownloadManagerMoveHandler.addFile(arrayList, CURRENT_HANDLER.onCompletion(download, false, false));
            DownloadManagerMoveHandler.addFile(arrayList, DownloadManagerDefaultPaths.DEFAULT_HANDLER.onCompletion(download, false, false));
        }
        if (DownloadManagerMoveHandler.isOnRemovalEnabled()) {
            DownloadManagerMoveHandler.addFile(arrayList, COConfigurationManager.getStringParameter("File.move.download.removed.path"));
            DownloadManagerMoveHandler.addFile(arrayList, CURRENT_HANDLER.onRemoval(download, false, false));
            DownloadManagerMoveHandler.addFile(arrayList, DownloadManagerDefaultPaths.DEFAULT_HANDLER.onRemoval(download, false, false));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static void addFile(ArrayList arrayList, SaveLocationChange saveLocationChange) {
        if (saveLocationChange != null) {
            DownloadManagerMoveHandler.addFile(arrayList, saveLocationChange.download_location);
        }
    }

    private static void addFile(ArrayList arrayList, File file) {
        if (file != null && !arrayList.contains(file)) {
            arrayList.add(file);
        }
    }

    private static void addFile(ArrayList arrayList, String string) {
        if (string != null && string.trim().length() != 0) {
            DownloadManagerMoveHandler.addFile(arrayList, new File(string));
        }
    }

    public static interface MoveCallback {
        public void perform(SaveLocationChange var1);
    }
}

