/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import com.aelitis.azureus.plugins.tracker.local.LocalTrackerPlugin;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerActivationListener;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPieceListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.DownloadManagerTPSListener;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerController;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStateImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadManagerImpl
extends LogRelation
implements DownloadManager {
    private static final long SCRAPE_DELAY_ERROR_TORRENTS = 0x6DDD00L;
    private static final long SCRAPE_DELAY_STOPPED_TORRENTS = 3600000L;
    private static final long SCRAPE_INITDELAY_ERROR_TORRENTS = 600000L;
    private static final long SCRAPE_INITDELAY_STOPPED_TORRENTS = 180000L;
    private static int upload_when_busy_min_secs;
    private static final String CFG_MOVE_COMPLETED_TOP = "Newly Seeding Torrents Get First Priority";
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_DOWNLOADCOMPLETE = 2;
    private static final int LDT_COMPLETIONCHANGED = 3;
    private static final int LDT_POSITIONCHANGED = 4;
    private static final int LDT_FILEPRIORITYCHANGED = 5;
    private AEMonitor listeners_mon = new AEMonitor("DM:DownloadManager:L");
    private static ListenerManager listeners_aggregator;
    private ListenerManager listeners = ListenerManager.createManager("DM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            listeners_aggregator.dispatch(object, n, object2);
        }
    });
    private static final int LDT_TL_ANNOUNCERESULT = 1;
    private static final int LDT_TL_SCRAPERESULT = 2;
    private ListenerManager tracker_listeners = ListenerManager.createManager("DM:TrackerListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            DownloadManagerTrackerListener downloadManagerTrackerListener = (DownloadManagerTrackerListener)object;
            if (n == 1) {
                downloadManagerTrackerListener.announceResult((TRTrackerAnnouncerResponse)object2);
            } else if (n == 2) {
                downloadManagerTrackerListener.scrapeResult((TRTrackerScraperResponse)object2);
            }
        }
    });
    private static final int LDT_PE_PEER_ADDED = 1;
    private static final int LDT_PE_PEER_REMOVED = 2;
    private static final int LDT_PE_PM_ADDED = 5;
    private static final int LDT_PE_PM_REMOVED = 6;
    private static ListenerManager<DownloadManagerPeerListener> peer_listeners_aggregator;
    private static Object TPS_Key;
    private ListenerManager<DownloadManagerPeerListener> peer_listeners = ListenerManager.createManager("DM:PeerListenDispatcher", new ListenerManagerDispatcher<DownloadManagerPeerListener>(){

        @Override
        public void dispatch(DownloadManagerPeerListener downloadManagerPeerListener, int n, Object object) {
            peer_listeners_aggregator.dispatch(downloadManagerPeerListener, n, object);
        }
    });
    private AEMonitor peer_listeners_mon = new AEMonitor("DM:DownloadManager:PeerL");
    private List current_peers = new ArrayList();
    private static final int LDT_PE_PIECE_ADDED = 3;
    private static final int LDT_PE_PIECE_REMOVED = 4;
    private static ListenerManager piece_listeners_aggregator;
    private ListenerManager piece_listeners = ListenerManager.createManager("DM:PieceListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            piece_listeners_aggregator.dispatch(object, n, object2);
        }
    });
    private List<DownloadManagerTPSListener> tps_listeners;
    private AEMonitor piece_listeners_mon = new AEMonitor("DM:DownloadManager:PeiceL");
    private List current_pieces = new ArrayList();
    private DownloadManagerController controller;
    private DownloadManagerStatsImpl stats;
    protected AEMonitor this_mon = new AEMonitor("DM:DownloadManager");
    private boolean persistent;
    private boolean assumedComplete;
    private int last_informed_state = -1;
    private boolean latest_informed_force_start;
    private GlobalManager globalManager;
    private String torrentFileName;
    private boolean open_for_seeding;
    private String display_name = "";
    private String internal_name = "";
    private File torrent_save_location;
    private int position = -1;
    private Object[] read_torrent_state;
    private DownloadManagerState download_manager_state;
    private TOTorrent torrent;
    private String torrent_comment;
    private String torrent_created_by;
    private TRTrackerAnnouncer tracker_client;
    private TRTrackerAnnouncerListener tracker_client_listener = new TRTrackerAnnouncerListener(){

        public void receivedTrackerResponse(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
            PEPeerManager pEPeerManager = DownloadManagerImpl.this.controller.getPeerManager();
            if (pEPeerManager != null) {
                pEPeerManager.processTrackerResponse(tRTrackerAnnouncerResponse);
            }
            DownloadManagerImpl.this.tracker_listeners.dispatch(1, tRTrackerAnnouncerResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void urlChanged(TRTrackerAnnouncer tRTrackerAnnouncer, URL uRL, URL uRL2, boolean bl) {
            if (bl) {
                if (DownloadManagerImpl.this.torrent.getPrivate()) {
                    ArrayList arrayList;
                    try {
                        DownloadManagerImpl.this.peer_listeners_mon.enter();
                        arrayList = new ArrayList(DownloadManagerImpl.this.current_peers);
                        Object var7_6 = null;
                        DownloadManagerImpl.this.peer_listeners_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        DownloadManagerImpl.this.peer_listeners_mon.exit();
                        throw throwable;
                    }
                    new AEThread2("DM:torrentChangeFlusher", true){

                        public void run() {
                            for (int i = 0; i < arrayList.size(); ++i) {
                                PEPeer pEPeer = (PEPeer)arrayList.get(i);
                                pEPeer.getManager().removePeer(pEPeer, "Private torrent: tracker changed");
                            }
                        }
                    }.start();
                }
                DownloadManagerImpl.this.requestTrackerAnnounce(true);
            }
        }

        public void urlRefresh() {
            DownloadManagerImpl.this.requestTrackerAnnounce(true);
        }
    };
    private TRTrackerAnnouncerListener stopping_tracker_client_listener = new TRTrackerAnnouncerListener(){

        public void receivedTrackerResponse(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
            if (DownloadManagerImpl.this.tracker_client == null) {
                tRTrackerAnnouncerResponse.setPeers(new TRTrackerAnnouncerResponsePeer[0]);
            }
            DownloadManagerImpl.this.tracker_listeners.dispatch(1, tRTrackerAnnouncerResponse);
        }

        public void urlChanged(TRTrackerAnnouncer tRTrackerAnnouncer, URL uRL, URL uRL2, boolean bl) {
        }

        public void urlRefresh() {
        }
    };
    private CopyOnWriteList activation_listeners = new CopyOnWriteList();
    private long scrape_random_seed = SystemTime.getCurrentTime();
    private Map data;
    private boolean data_already_allocated = false;
    private long creation_time = SystemTime.getCurrentTime();
    private int iSeedingRank;
    private boolean az_messaging_enabled = true;
    private boolean dl_identity_obtained;
    private byte[] dl_identity;
    private int dl_identity_hashcode;
    private int max_uploads = 2;
    private int max_connections;
    private int max_connections_when_seeding;
    private boolean max_connections_when_seeding_enabled;
    private int max_seed_connections;
    private int max_uploads_when_seeding = 2;
    private boolean max_uploads_when_seeding_enabled;
    private int max_upload_when_busy_bps;
    private int current_upload_when_busy_bps;
    private long last_upload_when_busy_update;
    private long last_upload_when_busy_dec_time;
    private int crypto_level = 0;
    private volatile boolean destroyed;
    private File cached_save_location;
    private File cached_save_location_result;

    public DownloadManagerImpl(GlobalManager globalManager, byte[] byArray, String string, String string2, String string3, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, List list, DownloadManagerInitialisationAdapter downloadManagerInitialisationAdapter) {
        if (n != 0 && n != 70 && n != 75) {
            Debug.out("DownloadManagerImpl: Illegal start state, " + n);
        }
        this.persistent = bl;
        this.globalManager = globalManager;
        this.open_for_seeding = bl3;
        if (list != null) {
            this.setData("file_priorities", list);
        }
        this.stats = new DownloadManagerStatsImpl(this);
        this.controller = new DownloadManagerController(this);
        this.torrentFileName = string;
        while (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.readTorrent(string2, string3, byArray, this.persistent && !bl2, bl3, bl4, n);
        if (this.torrent != null && downloadManagerInitialisationAdapter != null) {
            try {
                downloadManagerInitialisationAdapter.initialised(this);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTorrent(String string, String string2, byte[] byArray, boolean bl, boolean bl2, boolean bl3, int n) {
        block52: {
            try {
                DownloadManagerStateAttributeListener downloadManagerStateAttributeListener;
                block51: {
                    this.display_name = this.torrentFileName;
                    this.internal_name = "";
                    this.torrent_comment = "";
                    this.torrent_created_by = "";
                    try {
                        block50: {
                            try {
                                this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this, this.torrentFileName, byArray, n == 70 || n == 75);
                                this.readParameters();
                                downloadManagerStateAttributeListener = new DownloadManagerStateAttributeListener(){

                                    public void attributeEventOccurred(DownloadManager downloadManager, String string, int n) {
                                        if (string.equals("filelinks")) {
                                            DownloadManagerImpl.this.setFileLinks();
                                        } else if (string.equals("parameters")) {
                                            DownloadManagerImpl.this.readParameters();
                                        }
                                    }
                                };
                                this.download_manager_state.addListener(downloadManagerStateAttributeListener, "filelinks", 1);
                                this.download_manager_state.addListener(downloadManagerStateAttributeListener, "parameters", 1);
                                this.torrent = this.download_manager_state.getTorrent();
                                this.setFileLinks();
                                if (!this.dl_identity_obtained) {
                                    this.dl_identity = byArray == null ? this.torrent.getHash() : byArray;
                                    this.dl_identity_hashcode = new String(this.dl_identity).hashCode();
                                }
                                if (!Arrays.equals(this.dl_identity, this.torrent.getHash())) {
                                    this.torrent = null;
                                    this.torrent_save_location = new File(string, this.torrentFileName);
                                    throw new NoStackException("Download identity changed - please remove and re-add the download");
                                }
                                this.read_torrent_state = null;
                                LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
                                this.display_name = FileUtil.convertOSSpecificChars(TorrentUtils.getLocalisedName(this.torrent), false);
                                this.internal_name = ByteFormatter.nicePrint(this.torrent.getHash(), true);
                                File file = new File(string);
                                if (string2 == null) {
                                    try {
                                        if (file.exists()) {
                                            file = file.getCanonicalFile();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Debug.printStackTrace(throwable);
                                    }
                                    if (this.torrent.isSimpleTorrent()) {
                                        if (file.exists()) {
                                            if (file.isDirectory()) {
                                                string2 = this.display_name;
                                            } else {
                                                string = file.getParent().toString();
                                                string2 = file.getName();
                                            }
                                        } else {
                                            if (file.getParent() == null) {
                                                throw new NoStackException("Data location '" + string + "' is invalid");
                                            }
                                            string = file.getParent().toString();
                                            string2 = file.getName();
                                        }
                                    } else {
                                        if (file.exists()) {
                                            if (!file.isDirectory()) {
                                                throw new NoStackException("'" + string + "' is not a directory");
                                            }
                                            if (file.getName().equals(this.display_name)) {
                                                string = file.getParent().toString();
                                            }
                                        }
                                        string2 = this.display_name;
                                    }
                                }
                                this.torrent_save_location = new File(string, string2);
                                File file2 = this.getSaveLocation();
                                if (!file2.exists() && !bl && !Constants.isWindows && bl3) {
                                    throw new NoStackException(MessageText.getString("DownloadManager.error.datamissing") + " " + Debug.secretFileName(file2.toString()));
                                }
                                if (bl) {
                                    Map map;
                                    this.download_manager_state.setLongParameter("stats.download.added.time", SystemTime.getCurrentTime());
                                    boolean bl4 = TorrentUtils.getFlag(this.torrent, 1);
                                    if (bl4) {
                                        this.download_manager_state.setFlag(16L, true);
                                    }
                                    if ((map = TorrentUtils.getPeerCache(this.torrent)) != null) {
                                        try {
                                            this.download_manager_state.setTrackerResponseCache(map);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                            this.download_manager_state.setTrackerResponseCache(new HashMap());
                                        }
                                    } else {
                                        this.download_manager_state.setTrackerResponseCache(new HashMap());
                                    }
                                    if (bl2) {
                                        DiskManagerFactory.setTorrentResumeDataNearlyComplete(this.download_manager_state);
                                        this.download_manager_state.setFlag(8L, true);
                                    } else {
                                        this.download_manager_state.clearResumeData();
                                    }
                                } else {
                                    long l = this.download_manager_state.getLongParameter("stats.download.added.time");
                                    if (l == 0L) {
                                        try {
                                            l = new File(this.torrentFileName).lastModified();
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        if (l == 0L) {
                                            l = SystemTime.getCurrentTime();
                                        }
                                        this.download_manager_state.setLongParameter("stats.download.added.time", l);
                                    }
                                }
                                this.torrent_comment = StringInterner.intern(localeUtilDecoder.decodeString(this.torrent.getComment()));
                                if (this.torrent_comment == null) {
                                    this.torrent_comment = "";
                                }
                                this.torrent_created_by = localeUtilDecoder.decodeString(this.torrent.getCreatedBy());
                                if (this.torrent_created_by == null) {
                                    this.torrent_created_by = "";
                                }
                                if (this.download_manager_state.isResumeDataComplete() || bl2) {
                                    this.stats.setDownloadCompleted(1000);
                                    this.setAssumedComplete(true);
                                    break block50;
                                }
                                this.setAssumedComplete(false);
                            }
                            catch (TOTorrentException tOTorrentException) {
                                this.setFailed(TorrentUtils.exceptionToText(tOTorrentException));
                                Object var16_23 = null;
                                this.dl_identity_obtained = true;
                                break block51;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                Debug.printStackTrace(unsupportedEncodingException);
                                this.setFailed(MessageText.getString("DownloadManager.error.unsupportedencoding"));
                                Object var16_24 = null;
                                this.dl_identity_obtained = true;
                                break block51;
                            }
                            catch (NoStackException noStackException) {
                                Debug.outNoStack(noStackException.getMessage());
                                Object var16_25 = null;
                                this.dl_identity_obtained = true;
                                break block51;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                                this.setFailed(throwable);
                                Object var16_26 = null;
                                this.dl_identity_obtained = true;
                            }
                        }
                        Object var16_22 = null;
                        this.dl_identity_obtained = true;
                    }
                    catch (Throwable throwable) {
                        Object var16_27 = null;
                        this.dl_identity_obtained = true;
                        throw throwable;
                    }
                }
                if (this.download_manager_state == null) {
                    this.read_torrent_state = new Object[]{string, string2, byArray, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), new Integer(n)};
                    this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this);
                    this.torrent_save_location = string2 == null ? new File(string) : new File(string, string2);
                } else {
                    if (string2 == null) {
                        this.torrent_save_location = new File(string);
                    }
                    if (this.download_manager_state.getNetworks().length == 0 && this.torrent != null) {
                        downloadManagerStateAttributeListener = AENetworkClassifier.getNetworks(this.torrent, this.display_name);
                        this.download_manager_state.setNetworks((String[])downloadManagerStateAttributeListener);
                    }
                }
                Object var18_29 = null;
                if (this.torrent_save_location == null) break block52;
            }
            catch (Throwable throwable) {
                Object var18_30 = null;
                if (this.torrent_save_location != null) {
                    try {
                        this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
                    }
                    catch (Throwable throwable2) {
                        this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
                    }
                    this.getSaveLocation();
                }
                this.controller.setInitialState(n);
                throw throwable;
            }
            try {
                this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
            }
            catch (Throwable throwable) {
                this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
            }
            this.getSaveLocation();
            {
            }
        }
        this.controller.setInitialState(n);
    }

    protected void readTorrent() {
        if (this.read_torrent_state == null) {
            return;
        }
        this.readTorrent((String)this.read_torrent_state[0], (String)this.read_torrent_state[1], (byte[])this.read_torrent_state[2], (Boolean)this.read_torrent_state[3], (Boolean)this.read_torrent_state[4], (Boolean)this.read_torrent_state[5], (Integer)this.read_torrent_state[6]);
    }

    protected void readParameters() {
        this.max_connections = this.getDownloadState().getIntParameter("max.peers");
        this.max_connections_when_seeding_enabled = this.getDownloadState().getBooleanParameter("max.peers.when.seeding.enabled");
        this.max_connections_when_seeding = this.getDownloadState().getIntParameter("max.peers.when.seeding");
        this.max_seed_connections = this.getDownloadState().getIntParameter("max.seeds");
        this.max_uploads = this.getDownloadState().getIntParameter("max.uploads");
        this.max_uploads_when_seeding_enabled = this.getDownloadState().getBooleanParameter("max.uploads.when.seeding.enabled");
        this.max_uploads_when_seeding = this.getDownloadState().getIntParameter("max.uploads.when.seeding");
        this.max_upload_when_busy_bps = this.getDownloadState().getIntParameter("max.upload.when.busy") * 1024;
        this.max_uploads = Math.max(this.max_uploads, 2);
        this.max_uploads_when_seeding = Math.max(this.max_uploads_when_seeding, 2);
    }

    protected int getMaxConnections() {
        return this.max_connections;
    }

    protected int getMaxConnectionsWhenSeeding() {
        return this.max_connections_when_seeding;
    }

    protected boolean isMaxConnectionsWhenSeedingEnabled() {
        return this.max_connections_when_seeding_enabled;
    }

    protected int getMaxSeedConnections() {
        return this.max_seed_connections;
    }

    protected boolean isMaxUploadsWhenSeedingEnabled() {
        return this.max_uploads_when_seeding_enabled;
    }

    protected int getMaxUploadsWhenSeeding() {
        return this.max_uploads_when_seeding;
    }

    @Override
    public int getMaxUploads() {
        return this.max_uploads;
    }

    @Override
    public void setMaxUploads(int n) {
        this.download_manager_state.setIntParameter("max.uploads", n);
    }

    @Override
    public int getEffectiveMaxUploads() {
        if (this.isMaxUploadsWhenSeedingEnabled() && this.getState() == 60) {
            return this.getMaxUploadsWhenSeeding();
        }
        return this.max_uploads;
    }

    @Override
    public int getEffectiveUploadRateLimitBytesPerSecond() {
        int n;
        int n2 = n = this.stats.getUploadRateLimitBytesPerSecond();
        if (this.max_upload_when_busy_bps != 0) {
            long l = SystemTime.getCurrentTime();
            if (l < this.last_upload_when_busy_update || l - this.last_upload_when_busy_update > 5000L) {
                this.last_upload_when_busy_update = l;
                String string = TransferSpeedValidator.getActiveUploadParameter(this.globalManager);
                int n3 = COConfigurationManager.getIntParameter(string) * 1024;
                if (n3 > 0 && this.max_upload_when_busy_bps < n3) {
                    n = n == 0 ? n3 : n;
                    GlobalManagerStats globalManagerStats = this.globalManager.getStats();
                    int n4 = globalManagerStats.getDataSendRateNoLAN() + globalManagerStats.getProtocolSendRateNoLAN();
                    int n5 = (n - this.max_upload_when_busy_bps) / 10;
                    if (n5 < 1024) {
                        n5 = 1024;
                    }
                    if (n3 - n4 <= 2048) {
                        if (this.current_upload_when_busy_bps == 0) {
                            this.current_upload_when_busy_bps = n;
                        }
                        int n6 = this.current_upload_when_busy_bps;
                        this.current_upload_when_busy_bps -= n5;
                        if (this.current_upload_when_busy_bps < this.max_upload_when_busy_bps) {
                            this.current_upload_when_busy_bps = this.max_upload_when_busy_bps;
                        }
                        if (this.current_upload_when_busy_bps < n6) {
                            this.last_upload_when_busy_dec_time = l;
                        }
                    } else if (this.current_upload_when_busy_bps != 0 && (upload_when_busy_min_secs == 0 || l < this.last_upload_when_busy_dec_time || l - this.last_upload_when_busy_dec_time >= (long)(upload_when_busy_min_secs * 1000))) {
                        this.current_upload_when_busy_bps += n5;
                        if (this.current_upload_when_busy_bps >= n) {
                            this.current_upload_when_busy_bps = 0;
                        }
                    }
                    if (this.current_upload_when_busy_bps > 0) {
                        n2 = this.current_upload_when_busy_bps;
                    }
                } else {
                    this.current_upload_when_busy_bps = 0;
                }
            } else if (this.current_upload_when_busy_bps > 0) {
                n2 = this.current_upload_when_busy_bps;
            }
        }
        return n2;
    }

    protected void setFileLinks() {
        this.cached_save_location = null;
        DiskManagerFactory.setFileLinks(this, this.download_manager_state.getFileLinks());
        this.controller.fileInfoChanged();
    }

    protected void clearFileLinks() {
        this.download_manager_state.clearFileLinks();
    }

    protected void updateFileLinks(File file, File file2) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = file2.getAbsoluteFile();
        }
        String string = file.getPath();
        String string2 = file2.getPath();
        CaseSensitiveFileMap caseSensitiveFileMap = this.download_manager_state.getFileLinks();
        Iterator iterator = caseSensitiveFileMap.keySetIterator();
        while (iterator.hasNext()) {
            File file3 = (File)iterator.next();
            File file4 = caseSensitiveFileMap.get(file3);
            String string3 = file3 == null ? null : file3.getAbsolutePath();
            String string4 = file4 == null ? null : file4.getAbsolutePath();
            try {
                this.updateFileLink(string, string2, string3, string4);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
        }
    }

    protected void updateFileLink(String string, String string2, String string3, String string4) {
        if (string4 == null) {
            return;
        }
        if (this.torrent.isSimpleTorrent()) {
            if (!string.equals(string3)) {
                throw new RuntimeException("assert failure: old_path=" + string + ", from_loc=" + string3);
            }
            this.download_manager_state.setFileLink(new File(string), null);
            this.download_manager_state.setFileLink(new File(string2), new File(string2));
            return;
        }
        String string5 = FileUtil.translateMoveFilePath(string, string2, string3);
        if (string5 == null) {
            return;
        }
        String string6 = FileUtil.translateMoveFilePath(string, string2, string4);
        if (string6 == null) {
            string6 = string4;
        }
        this.download_manager_state.setFileLink(new File(string3), null);
        this.download_manager_state.setFileLink(new File(string5), new File(string6));
    }

    @Override
    public boolean filesExist() {
        return this.filesExist(true);
    }

    @Override
    public boolean filesExist(boolean bl) {
        return this.controller.filesExist(bl);
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public String getDisplayName() {
        String string;
        DownloadManagerState downloadManagerState = this.getDownloadState();
        if (downloadManagerState != null && (string = downloadManagerState.getDisplayName()) != null) {
            return string;
        }
        return this.display_name;
    }

    @Override
    public String getInternalName() {
        return this.internal_name;
    }

    @Override
    public String getErrorDetails() {
        return this.controller.getErrorDetail();
    }

    @Override
    public long getSize() {
        if (this.torrent != null) {
            return this.torrent.getSize();
        }
        return 0L;
    }

    protected void setFailed() {
        this.setFailed((String)null);
    }

    protected void setFailed(Throwable throwable) {
        this.setFailed(Debug.getNestedExceptionMessage(throwable));
    }

    protected void setFailed(String string) {
        this.controller.setFailed(string);
    }

    protected void setTorrentInvalid(String string) {
        this.setFailed(string);
        this.torrent = null;
    }

    @Override
    public void saveResumeData() {
        if (this.getState() == 50) {
            try {
                this.getDiskManager().saveResumeData(true);
            }
            catch (Exception exception) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(exception));
            }
        }
        if (!this.assumedComplete) {
            this.download_manager_state.save();
        }
    }

    @Override
    public void saveDownload() {
        DiskManager diskManager = this.controller.getDiskManager();
        if (diskManager != null) {
            diskManager.saveState();
        }
        this.download_manager_state.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (this.torrent == null) {
            this.readTorrent();
        }
        if (this.torrent == null) {
            this.setFailed();
            return;
        }
        if (this.assumedComplete && !this.filesExist(true)) {
            return;
        }
        this.download_manager_state.setActive(true);
        try {
            try {
                this.this_mon.enter();
                if (this.tracker_client != null) {
                    Debug.out("DownloadManager: initialize called with tracker client still available");
                    this.tracker_client.destroy();
                }
                this.tracker_client = TRTrackerAnnouncerFactory.create(this.torrent, this.download_manager_state.getNetworks());
                this.tracker_client.setTrackerResponseCache(this.download_manager_state.getTrackerResponseCache());
                this.tracker_client.addListener(this.tracker_client_listener);
                Object var2_1 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.this_mon.exit();
                throw throwable;
            }
            try {
                this.controller.initializeDiskManager(this.open_for_seeding);
                Object var4_5 = null;
                this.open_for_seeding = false;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.open_for_seeding = false;
                throw throwable;
            }
        }
        catch (TRTrackerAnnouncerException tRTrackerAnnouncerException) {
            this.setFailed(tRTrackerAnnouncerException);
        }
    }

    @Override
    public void setStateWaiting() {
        this.controller.setStateWaiting();
    }

    public void setStateFinishing() {
        this.controller.setStateFinishing();
    }

    @Override
    public void setStateQueued() {
        this.controller.setStateQueued();
    }

    @Override
    public int getState() {
        return this.controller.getState();
    }

    @Override
    public int getSubState() {
        return this.controller.getSubState();
    }

    @Override
    public boolean canForceRecheck() {
        if (this.getTorrent() == null) {
            return false;
        }
        return this.controller.canForceRecheck();
    }

    @Override
    public void forceRecheck() {
        this.controller.forceRecheck(null);
    }

    @Override
    public void forceRecheck(ForceRecheckListener forceRecheckListener) {
        this.controller.forceRecheck(forceRecheckListener);
    }

    @Override
    public void setPieceCheckingEnabled(boolean bl) {
        this.controller.setPieceCheckingEnabled(bl);
    }

    @Override
    public void resetFile(DiskManagerFileInfo diskManagerFileInfo) {
        int n = this.getState();
        if (n == 70 || n == 100) {
            DiskManagerFactory.clearResumeData(this, diskManagerFileInfo);
        } else {
            Debug.out("Download not stopped");
        }
    }

    @Override
    public void recheckFile(DiskManagerFileInfo diskManagerFileInfo) {
        int n = this.getState();
        if (n == 70 || n == 100) {
            DiskManagerFactory.recheckFile(this, diskManagerFileInfo);
        } else {
            Debug.out("Download not stopped");
        }
    }

    @Override
    public void startDownload() {
        this.controller.startDownload(this.getTrackerClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopIt(int n, boolean bl, boolean bl2) {
        try {
            this.download_manager_state.setLongAttribute("timestopped", SystemTime.getCurrentTime());
            this.controller.stopIt(n, bl, bl2);
            Object var5_4 = null;
            this.download_manager_state.setActive(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.download_manager_state.setActive(false);
            throw throwable;
        }
    }

    @Override
    public boolean pause() {
        return this.globalManager.pauseDownload(this);
    }

    @Override
    public boolean isPaused() {
        return this.globalManager.isPaused(this);
    }

    @Override
    public void resume() {
        this.globalManager.resumeDownload(this);
    }

    @Override
    public boolean getAssumedComplete() {
        return this.assumedComplete;
    }

    @Override
    public boolean requestAssumedCompleteMode() {
        boolean bl = this.controller.isDownloadComplete(false);
        this.setAssumedComplete(bl);
        return bl;
    }

    protected void setAssumedComplete(boolean bl) {
        long l;
        if (bl && (l = this.download_manager_state.getLongParameter("stats.download.completed.time")) <= 0L) {
            this.download_manager_state.setLongParameter("stats.download.completed.time", SystemTime.getCurrentTime());
        }
        if (this.assumedComplete == bl) {
            return;
        }
        this.assumedComplete = bl;
        if (!this.assumedComplete) {
            this.controller.setStateDownloading();
        }
        if (this.position != -1) {
            DownloadManager[] downloadManagerArray = new DownloadManager[]{this};
            this.position = this.globalManager.getDownloadManagers().size() + 1;
            if (COConfigurationManager.getBooleanParameter(CFG_MOVE_COMPLETED_TOP)) {
                this.globalManager.moveTop(downloadManagerArray);
            } else {
                this.globalManager.moveEnd(downloadManagerArray);
            }
            this.globalManager.fixUpDownloadManagerPositions();
        }
        this.listeners.dispatch(3, new Object[]{this, new Boolean(bl)});
    }

    @Override
    public int getNbSeeds() {
        PEPeerManager pEPeerManager = this.controller.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getNbSeeds();
        }
        return 0;
    }

    @Override
    public int getNbPeers() {
        PEPeerManager pEPeerManager = this.controller.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getNbPeers();
        }
        return 0;
    }

    @Override
    public String getTrackerStatus() {
        TRTrackerScraperResponse tRTrackerScraperResponse;
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            return tRTrackerAnnouncer.getStatusString();
        }
        if (this.torrent != null && (tRTrackerScraperResponse = this.getTrackerScrapeResponse()) != null) {
            return tRTrackerScraperResponse.getStatusString();
        }
        return "";
    }

    @Override
    public TRTrackerAnnouncer getTrackerClient() {
        return this.tracker_client;
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer == null) {
            return;
        }
        tRTrackerAnnouncer.setAnnounceResult(downloadAnnounceResult);
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult downloadScrapeResult) {
        if (this.torrent != null && downloadScrapeResult != null) {
            TRTrackerScraper tRTrackerScraper = this.globalManager.getTrackerScraper();
            TRTrackerScraperResponse tRTrackerScraperResponse = this.getTrackerScrapeResponse();
            URL uRL = tRTrackerScraperResponse != null ? tRTrackerScraperResponse.getURL() : this.torrent.getAnnounceURL();
            tRTrackerScraper.setScrape(this.torrent, uRL, downloadScrapeResult);
        }
    }

    @Override
    public int getNbPieces() {
        if (this.torrent == null) {
            return 0;
        }
        return this.torrent.getNumberOfPieces();
    }

    @Override
    public int getTrackerTime() {
        TRTrackerScraperResponse tRTrackerScraperResponse;
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            return tRTrackerAnnouncer.getTimeUntilNextUpdate();
        }
        if (this.torrent != null && (tRTrackerScraperResponse = this.getTrackerScrapeResponse()) != null) {
            if (tRTrackerScraperResponse.getStatus() == 3) {
                return -1;
            }
            return (int)((tRTrackerScraperResponse.getNextScrapeStartTime() - SystemTime.getCurrentTime()) / 1000L);
        }
        return 60;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public File getSaveLocation() {
        File file = this.torrent_save_location;
        if (file == this.cached_save_location) {
            return this.cached_save_location_result;
        }
        File file2 = this.download_manager_state.getFileLink(file);
        if (file2 == null || file2.equals(file)) {
            file2 = file;
        } else {
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (Throwable throwable) {
                file2 = file2.getAbsoluteFile();
            }
        }
        this.cached_save_location = file;
        this.cached_save_location_result = file2;
        return file2;
    }

    @Override
    public File getAbsoluteSaveLocation() {
        return this.torrent_save_location;
    }

    @Override
    public void setTorrentSaveDir(String string) {
        this.setTorrentSaveDir(string, this.getAbsoluteSaveLocation().getName());
    }

    @Override
    public void setTorrentSaveDir(String string, String string2) {
        File file = new File(string, string2);
        File file2 = this.torrent_save_location;
        if (file.equals(file2)) {
            return;
        }
        this.updateFileLinks(file2, file);
        this.torrent_save_location = file;
        try {
            this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
        }
        catch (Throwable throwable) {
            this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
        }
        Logger.log(new LogEvent(this, LogIDs.CORE, "Torrent save directory changing from \"" + file2.getPath() + "\" to \"" + file.getPath()));
        this.controller.fileInfoChanged();
    }

    @Override
    public String getPieceLength() {
        if (this.torrent != null) {
            return DisplayFormatters.formatByteCountToKiBEtc(this.torrent.getPieceLength());
        }
        return "";
    }

    @Override
    public String getTorrentFileName() {
        return this.torrentFileName;
    }

    @Override
    public void setTorrentFileName(String string) {
        this.torrentFileName = string;
    }

    @Override
    public void setTrackerScrapeResponse(TRTrackerScraperResponse tRTrackerScraperResponse) {
        Object[] objectArray = this.getActiveScrapeResponse();
        URL uRL = (URL)objectArray[1];
        if (uRL != null && this.torrent != null) {
            this.torrent.setAnnounceURL(uRL);
        }
        if (tRTrackerScraperResponse != null) {
            long l;
            int n = this.getState();
            if (n == 100 || n == 70) {
                l = tRTrackerScraperResponse.getStatus() == 0 ? SystemTime.getCurrentTime() + (n == 100 ? 600000L : 180000L) : SystemTime.getCurrentTime() + (n == 100 ? 0x6DDD00L : 3600000L);
                if (tRTrackerScraperResponse.getNextScrapeStartTime() < l) {
                    tRTrackerScraperResponse.setNextScrapeStartTime(l);
                }
            } else if (!tRTrackerScraperResponse.isValid() && tRTrackerScraperResponse.getStatus() == 0) {
                int n2 = this.getStats().getShareRatio();
                l = SystemTime.getCurrentTime() + (long)((n2 > 10000 ? 10000 : n2 + 1000) * 60);
                if (tRTrackerScraperResponse.getNextScrapeStartTime() < l) {
                    tRTrackerScraperResponse.setNextScrapeStartTime(l);
                }
            }
            if (tRTrackerScraperResponse.isValid() && tRTrackerScraperResponse.getStatus() == 2) {
                l = ((long)tRTrackerScraperResponse.getSeeds() & 0xFFFFFFL) << 32 | (long)tRTrackerScraperResponse.getPeers() & 0xFFFFFFL;
                this.download_manager_state.setLongAttribute("scrapecache", l);
            }
            this.tracker_listeners.dispatch(2, tRTrackerScraperResponse);
        }
    }

    @Override
    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        Object[] objectArray = this.getActiveScrapeResponse();
        return (TRTrackerScraperResponse)objectArray[0];
    }

    protected Object[] getActiveScrapeResponse() {
        TRTrackerScraperResponse tRTrackerScraperResponse = null;
        URL uRL = null;
        TRTrackerScraper tRTrackerScraper = this.globalManager.getTrackerScraper();
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            tRTrackerScraperResponse = tRTrackerScraper.scrape(tRTrackerAnnouncer);
        }
        if (tRTrackerScraperResponse == null && this.torrent != null) {
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray;
            TRTrackerScraperResponse tRTrackerScraperResponse2 = null;
            try {
                tOTorrentAnnounceURLSetArray = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            }
            catch (Exception exception) {
                return new Object[]{tRTrackerScraper.scrape(this.torrent), uRL};
            }
            if (tOTorrentAnnounceURLSetArray.length == 0) {
                tRTrackerScraperResponse = tRTrackerScraper.scrape(this.torrent);
            } else {
                Random random = new Random(this.scrape_random_seed);
                block2: for (int i = 0; tRTrackerScraperResponse == null && i < tOTorrentAnnounceURLSetArray.length; ++i) {
                    int n;
                    URL uRL2;
                    int n2;
                    TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLSetArray[i];
                    URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    for (n2 = 0; n2 < uRLArray.length; ++n2) {
                        uRL2 = uRLArray[n2];
                        n = (int)(random.nextDouble() * (double)(arrayList.size() + 1));
                        arrayList.add(n, uRL2);
                    }
                    for (n2 = 0; tRTrackerScraperResponse == null && n2 < arrayList.size(); ++n2) {
                        uRL2 = (URL)arrayList.get(n2);
                        tRTrackerScraperResponse = tRTrackerScraper.scrape(this.torrent, uRL2);
                        if (tRTrackerScraperResponse == null) continue;
                        n = tRTrackerScraperResponse.getStatus();
                        if (n == 2) {
                            uRL = uRL2;
                            continue block2;
                        }
                        if (n == 0 || n == 3) continue block2;
                        if (tRTrackerScraperResponse.isValid() && n != 1) continue;
                        if (tRTrackerScraperResponse2 == null) {
                            tRTrackerScraperResponse2 = tRTrackerScraperResponse;
                        }
                        tRTrackerScraperResponse = null;
                    }
                }
                if (tRTrackerScraperResponse == null) {
                    tRTrackerScraperResponse = tRTrackerScraperResponse2;
                }
            }
        }
        return new Object[]{tRTrackerScraperResponse, uRL};
    }

    @Override
    public void requestTrackerAnnounce(boolean bl) {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            tRTrackerAnnouncer.update(bl);
        }
    }

    @Override
    public void requestTrackerScrape(boolean bl) {
        if (this.torrent != null) {
            TRTrackerScraper tRTrackerScraper = this.globalManager.getTrackerScraper();
            tRTrackerScraper.scrape(this.torrent, bl);
        }
    }

    protected void setTrackerRefreshDelayOverrides(int n) {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            tRTrackerAnnouncer.setRefreshDelayOverrides(n);
        }
    }

    protected boolean activateRequest(int n) {
        for (DownloadManagerActivationListener downloadManagerActivationListener : this.activation_listeners) {
            try {
                if (!downloadManagerActivationListener.activateRequest(n)) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return false;
    }

    @Override
    public int getActivationCount() {
        return this.controller.getActivationCount();
    }

    @Override
    public String getTorrentComment() {
        return this.torrent_comment;
    }

    @Override
    public String getTorrentCreatedBy() {
        return this.torrent_created_by;
    }

    @Override
    public long getTorrentCreationDate() {
        if (this.torrent == null) {
            return 0L;
        }
        return this.torrent.getCreationDate();
    }

    @Override
    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    @Override
    public DiskManager getDiskManager() {
        return this.controller.getDiskManager();
    }

    @Override
    public DiskManagerFileInfoSet getDiskManagerFileInfoSet() {
        return this.controller.getDiskManagerFileInfoSet();
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return this.controller.getDiskManagerFileInfo();
    }

    @Override
    public int getNumFileInfos() {
        return this.torrent == null ? 0 : (this.torrent.isSimpleTorrent() ? 1 : this.torrent.getFiles().length);
    }

    @Override
    public PEPeerManager getPeerManager() {
        return this.controller.getPeerManager();
    }

    @Override
    public boolean isDownloadComplete(boolean bl) {
        if (!bl) {
            return this.assumedComplete;
        }
        return this.controller.isDownloadComplete(bl);
    }

    @Override
    public void addListener(DownloadManagerListener downloadManagerListener) {
        this.addListener(downloadManagerListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DownloadManagerListener downloadManagerListener, boolean bl) {
        if (downloadManagerListener == null) {
            Debug.out("Warning: null listener");
            return;
        }
        try {
            block5: {
                try {
                    this.listeners_mon.enter();
                    this.listeners.addListener(downloadManagerListener);
                    if (!bl) break block5;
                    downloadManagerListener.stateChanged(this, this.getState());
                }
                catch (Throwable throwable) {
                    Debug.out("adding listener", throwable);
                    Object var5_4 = null;
                    this.listeners_mon.exit();
                }
            }
            Object var5_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DownloadManagerListener downloadManagerListener) {
        try {
            this.listeners_mon.enter();
            this.listeners.removeListener(downloadManagerListener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStateChanged() {
        try {
            this.listeners_mon.enter();
            int n = this.controller.getState();
            boolean bl = this.controller.isForceStart();
            if (n != this.last_informed_state || bl != this.latest_informed_force_start) {
                this.last_informed_state = n;
                this.latest_informed_force_start = bl;
                this.listeners.dispatch(1, new Object[]{this, new Integer(n)});
            }
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informDownloadEnded() {
        try {
            this.listeners_mon.enter();
            this.listeners.dispatch(2, new Object[]{this});
            Object var2_1 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informPrioritiesChange(List list) {
        this.controller.filePrioritiesChanged(list);
        try {
            this.listeners_mon.enter();
            for (int i = 0; i < list.size(); ++i) {
                this.listeners.dispatch(5, new Object[]{this, (DiskManagerFileInfo)list.get(i)});
            }
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        this.requestAssumedCompleteMode();
    }

    protected void informPriorityChange(DiskManagerFileInfo diskManagerFileInfo) {
        this.informPrioritiesChange(Collections.singletonList(diskManagerFileInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informPositionChanged(int n) {
        try {
            this.listeners_mon.enter();
            int n2 = this.position;
            if (n != n2) {
                this.position = n;
                this.listeners.dispatch(4, new Object[]{this, new Integer(n2), new Integer(n)});
                if (this.getState() == 60 || this.getState() == 50) {
                    PeerControlSchedulerFactory.updateScheduleOrdering();
                }
            }
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void addPeerListener(DownloadManagerPeerListener downloadManagerPeerListener) {
        this.addPeerListener(downloadManagerPeerListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPeerListener(DownloadManagerPeerListener downloadManagerPeerListener, boolean bl) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.addListener(downloadManagerPeerListener);
            if (!bl) {
                Object var5_3 = null;
                this.peer_listeners_mon.exit();
                return;
            }
            for (int i = 0; i < this.current_peers.size(); ++i) {
                this.peer_listeners.dispatch(downloadManagerPeerListener, 1, this.current_peers.get(i));
            }
            PEPeerManager pEPeerManager = this.controller.getPeerManager();
            if (pEPeerManager != null) {
                this.peer_listeners.dispatch(downloadManagerPeerListener, 5, pEPeerManager);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
        Object var5_4 = null;
        this.peer_listeners_mon.exit();
    }

    @Override
    public void removePeerListener(DownloadManagerPeerListener downloadManagerPeerListener) {
        this.peer_listeners.removeListener(downloadManagerPeerListener);
    }

    @Override
    public void addPieceListener(DownloadManagerPieceListener downloadManagerPieceListener) {
        this.addPieceListener(downloadManagerPieceListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPieceListener(DownloadManagerPieceListener downloadManagerPieceListener, boolean bl) {
        try {
            this.piece_listeners_mon.enter();
            this.piece_listeners.addListener(downloadManagerPieceListener);
            if (!bl) {
                Object var5_3 = null;
                this.piece_listeners_mon.exit();
                return;
            }
            for (int i = 0; i < this.current_pieces.size(); ++i) {
                this.piece_listeners.dispatch(downloadManagerPieceListener, 3, this.current_pieces.get(i));
            }
            Object var5_4 = null;
            this.piece_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.piece_listeners_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void removePieceListener(DownloadManagerPieceListener downloadManagerPieceListener) {
        this.piece_listeners.removeListener(downloadManagerPieceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeer(PEPeer pEPeer) {
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.add(pEPeer);
            this.peer_listeners.dispatch(1, pEPeer);
            Object var3_2 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(PEPeer pEPeer) {
        TRTrackerAnnouncer tRTrackerAnnouncer;
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.remove(pEPeer);
            this.peer_listeners.dispatch(2, pEPeer);
            Object var3_2 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
        if ((pEPeer.isSeed() || pEPeer.isRelativeSeed()) && this.isDownloadComplete(false) && (tRTrackerAnnouncer = this.tracker_client) != null) {
            tRTrackerAnnouncer.removeFromTrackerResponseCache(pEPeer.getIp(), pEPeer.getTCPListenPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PEPeer[] getCurrentPeers() {
        try {
            this.peer_listeners_mon.enter();
            PEPeer[] pEPeerArray = this.current_peers.toArray(new PEPeer[this.current_peers.size()]);
            Object var3_2 = null;
            this.peer_listeners_mon.exit();
            return pEPeerArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPiece(PEPiece pEPiece) {
        try {
            this.piece_listeners_mon.enter();
            this.current_pieces.add(pEPiece);
            this.piece_listeners.dispatch(3, pEPiece);
            Object var3_2 = null;
            this.piece_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.piece_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePiece(PEPiece pEPiece) {
        try {
            this.piece_listeners_mon.enter();
            this.current_pieces.remove(pEPiece);
            this.piece_listeners.dispatch(4, pEPiece);
            Object var3_2 = null;
            this.piece_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.piece_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PEPiece[] getCurrentPieces() {
        try {
            this.piece_listeners_mon.enter();
            PEPiece[] pEPieceArray = this.current_pieces.toArray(new PEPiece[this.current_pieces.size()]);
            Object var3_2 = null;
            this.piece_listeners_mon.exit();
            return pEPieceArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.piece_listeners_mon.exit();
            throw throwable;
        }
    }

    protected void informWillBeStarted(PEPeerManager pEPeerManager) {
        List<DownloadManagerPeerListener> list = this.peer_listeners.getListenersCopy();
        for (int i = 0; i < list.size(); ++i) {
            try {
                list.get(i).peerManagerWillBeAdded(pEPeerManager);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStarted(PEPeerManager pEPeerManager) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.dispatch(5, pEPeerManager);
            Object var3_2 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null) {
            tRTrackerAnnouncer.update(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStopped(PEPeerManager pEPeerManager, boolean bl) {
        if (pEPeerManager != null) {
            try {
                this.peer_listeners_mon.enter();
                this.peer_listeners.dispatch(6, pEPeerManager);
                Object var4_3 = null;
                this.peer_listeners_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.peer_listeners_mon.exit();
                throw throwable;
            }
        }
        try {
            this.this_mon.enter();
            if (this.tracker_client != null) {
                this.tracker_client.addListener(this.stopping_tracker_client_listener);
                this.tracker_client.removeListener(this.tracker_client_listener);
                this.download_manager_state.setTrackerResponseCache(this.tracker_client.getTrackerResponseCache());
                this.tracker_client.getLastResponse().setPeers(new TRTrackerAnnouncerResponsePeer[0]);
                this.tracker_client.stop(bl && this.isDownloadComplete(false));
                this.tracker_client.destroy();
                this.tracker_client = null;
            }
            Object var6_6 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public DownloadManagerStats getStats() {
        return this.stats;
    }

    @Override
    public boolean isForceStart() {
        return this.controller.isForceStart();
    }

    @Override
    public void setForceStart(boolean bl) {
        this.controller.setForceStart(bl);
    }

    protected void downloadEnded(boolean bl) {
        DiskManager diskManager;
        TRTrackerAnnouncer tRTrackerAnnouncer;
        if (!bl) {
            if (this.isForceStart()) {
                this.setForceStart(false);
            }
            this.setAssumedComplete(true);
            this.informDownloadEnded();
        }
        if ((tRTrackerAnnouncer = this.tracker_client) != null && (diskManager = this.getDiskManager()) != null && diskManager.getRemaining() == 0L) {
            tRTrackerAnnouncer.complete(bl);
        }
    }

    @Override
    public void addDiskListener(DownloadManagerDiskListener downloadManagerDiskListener) {
        this.controller.addDiskListener(downloadManagerDiskListener);
    }

    @Override
    public void removeDiskListener(DownloadManagerDiskListener downloadManagerDiskListener) {
        this.controller.removeDiskListener(downloadManagerDiskListener);
    }

    @Override
    public void addActivationListener(DownloadManagerActivationListener downloadManagerActivationListener) {
        this.activation_listeners.add(downloadManagerActivationListener);
    }

    @Override
    public void removeActivationListener(DownloadManagerActivationListener downloadManagerActivationListener) {
        this.activation_listeners.remove(downloadManagerActivationListener);
    }

    @Override
    public int getHealthStatus() {
        int n = this.getState();
        PEPeerManager pEPeerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null && pEPeerManager != null && (n == 50 || n == 60)) {
            boolean bl;
            int n2 = this.getNbSeeds();
            int n3 = this.getNbPeers();
            int n4 = pEPeerManager.getNbRemoteTCPConnections();
            TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse = tRTrackerAnnouncer.getLastResponse();
            int n5 = tRTrackerAnnouncerResponse.getStatus();
            boolean bl2 = bl = n == 60;
            if (n2 + n3 == 0) {
                if (bl) {
                    return 2;
                }
                return 5;
            }
            if (!(bl || n5 != 0 && n5 != 1)) {
                return 2;
            }
            if (n4 == 0) {
                TRTrackerScraperResponse tRTrackerScraperResponse = this.getTrackerScrapeResponse();
                if (tRTrackerScraperResponse != null && tRTrackerScraperResponse.isValid() && n2 == tRTrackerScraperResponse.getSeeds() && n3 == tRTrackerScraperResponse.getPeers()) {
                    return 4;
                }
                return 3;
            }
            return 4;
        }
        if (n == 100) {
            return 6;
        }
        return 1;
    }

    @Override
    public int getNATStatus() {
        int n = this.getState();
        PEPeerManager pEPeerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        if (tRTrackerAnnouncer != null && pEPeerManager != null && (n == 50 || n == 60)) {
            if (pEPeerManager.getNbRemoteTCPConnections() > 0) {
                return 1;
            }
            long l = pEPeerManager.getLastRemoteConnectionTime();
            if (l > 0L) {
                if (SystemTime.getCurrentTime() - l < 1800000L) {
                    return 1;
                }
                return 2;
            }
            TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse = tRTrackerAnnouncer.getLastResponse();
            int n2 = tRTrackerAnnouncerResponse.getStatus();
            if (n2 == 0 || n2 == 1) {
                return 0;
            }
            if (SystemTime.getCurrentTime() - pEPeerManager.getTimeStarted() < 180000L) {
                return 0;
            }
            TRTrackerScraperResponse tRTrackerScraperResponse = this.getTrackerScrapeResponse();
            if (tRTrackerScraperResponse != null && tRTrackerScraperResponse.isValid() && pEPeerManager.getNbSeeds() == tRTrackerScraperResponse.getSeeds() && pEPeerManager.getNbPeers() == tRTrackerScraperResponse.getPeers()) {
                return 0;
            }
            return 3;
        }
        return 0;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int n) {
        this.informPositionChanged(n);
    }

    @Override
    public void addTrackerListener(DownloadManagerTrackerListener downloadManagerTrackerListener) {
        this.tracker_listeners.addListener(downloadManagerTrackerListener);
    }

    @Override
    public void removeTrackerListener(DownloadManagerTrackerListener downloadManagerTrackerListener) {
        this.tracker_listeners.removeListener(downloadManagerTrackerListener);
    }

    protected void deleteDataFiles() {
        DownloadManagerState downloadManagerState = this.getDownloadState();
        DiskManagerFactory.deleteDataFiles(this.torrent, this.torrent_save_location.getParent(), this.torrent_save_location.getName(), downloadManagerState.getFlag(16L) || downloadManagerState.getFlag(128L));
        downloadManagerState.setFlag(4L, true);
    }

    protected void deleteTorrentFile() {
        if (this.torrentFileName != null) {
            TorrentUtils.delete(new File(this.torrentFileName), this.getDownloadState().getFlag(16L));
        }
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_manager_state;
    }

    @Override
    public Object getData(String string) {
        return this.getUserData(string);
    }

    @Override
    public void setData(String string, Object object) {
        this.setUserData(string, object);
    }

    @Override
    public Object getUserData(Object object) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object object, Object object2) {
        try {
            this.peer_listeners_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (object2 == null) {
                if (this.data.containsKey(object)) {
                    this.data.remove(object);
                }
            } else {
                this.data.put(object, object2);
            }
            Object var4_3 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
    }

    @Override
    public boolean isDataAlreadyAllocated() {
        return this.data_already_allocated;
    }

    @Override
    public void setDataAlreadyAllocated(boolean bl) {
        this.data_already_allocated = bl;
    }

    @Override
    public void setSeedingRank(int n) {
        this.iSeedingRank = n;
    }

    @Override
    public int getSeedingRank() {
        return this.iSeedingRank;
    }

    @Override
    public long getCreationTime() {
        return this.creation_time;
    }

    @Override
    public void setCreationTime(long l) {
        this.creation_time = l;
    }

    @Override
    public boolean isExtendedMessagingEnabled() {
        return this.az_messaging_enabled;
    }

    @Override
    public void setAZMessagingEnabled(boolean bl) {
        this.az_messaging_enabled = bl;
    }

    @Override
    public void setCryptoLevel(int n) {
        this.crypto_level = n;
    }

    @Override
    public int getCryptoLevel() {
        return this.crypto_level;
    }

    @Override
    public void moveDataFiles(File file) throws DownloadManagerException {
        this.moveDataFiles(file, null);
    }

    @Override
    public void renameDownload(String string) throws DownloadManagerException {
        this.moveDataFiles(null, string);
    }

    @Override
    public void moveDataFiles(final File file, final String string) throws DownloadManagerException {
        if (file == null && string == null) {
            throw new NullPointerException("destination and new name are both null");
        }
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("canMoveDataFiles is false!");
        }
        SaveLocationChange saveLocationChange = new SaveLocationChange();
        saveLocationChange.download_location = file;
        saveLocationChange.download_name = string;
        File file2 = this.getSaveLocation();
        if (saveLocationChange.normaliseDownloadLocation(file2).equals(file2)) {
            return;
        }
        try {
            FileUtil.runAsTask(new AzureusCoreOperationTask(){

                public void run(AzureusCoreOperation azureusCoreOperation) {
                    try {
                        DownloadManagerImpl.this.moveDataFilesSupport(file, string);
                    }
                    catch (DownloadManagerException downloadManagerException) {
                        throw new RuntimeException(downloadManagerException);
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof DownloadManagerException) {
                throw (DownloadManagerException)throwable;
            }
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDataFilesSupport(File file, String string) throws DownloadManagerException {
        boolean bl = this.pause();
        try {
            this.moveDataFilesSupport0(file, string);
            Object var5_4 = null;
            if (bl) {
                this.resume();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl) {
                this.resume();
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveDataFilesSupport0(File file, String string) throws DownloadManagerException {
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("canMoveDataFiles is false!");
        }
        if (string != null) {
            string = FileUtil.convertOSSpecificChars(string, false);
        }
        File file2 = this.getSaveLocation();
        try {
            file2 = file2.getCanonicalFile();
            if (file != null) {
                file = file.getCanonicalFile();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            throw new DownloadManagerException("Failed to get canonical paths", throwable);
        }
        File file3 = file2;
        File file4 = new File(file == null ? file2.getParentFile() : file, string == null ? file2.getName() : string);
        if (file3.equals(file4)) {
            return;
        }
        DiskManager diskManager = this.getDiskManager();
        if (diskManager == null || diskManager.getFiles() == null) {
            if (!file2.exists()) {
                FileUtil.mkdirs(file4.getParentFile());
                this.setTorrentSaveDir(file4.getParent().toString(), file4.getName());
                return;
            }
            try {
                file4 = file4.getCanonicalFile();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            if (file2.equals(file4)) return;
            if (this.torrent.isSimpleTorrent()) {
                if (!this.controller.getDiskManagerFileInfo()[0].setLinkAtomic(file4)) throw new DownloadManagerException("rename operation failed");
                this.setTorrentSaveDir(file4.getParentFile().toString(), file4.getName());
                return;
            }
            if (FileUtil.isAncestorOf(file2, file4)) {
                Logger.logTextResource(new LogAlert((Object)this, true, 3, "DiskManager.alert.movefilefails"), new String[]{file2.toString(), "Target is sub-directory of files"});
                throw new DownloadManagerException("rename operation failed");
            }
            final HashSet<File> hashSet = new HashSet<File>();
            hashSet.add(null);
            DiskManagerFileInfo[] diskManagerFileInfoArray = this.controller.getDiskManagerFileInfo();
            for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
                File file5 = diskManagerFileInfoArray[i].getFile(true);
                try {
                    file5 = file5.getCanonicalFile();
                }
                catch (IOException iOException) {
                    file5 = file5.getAbsoluteFile();
                }
                boolean bl = hashSet.add(file5);
                while (bl) {
                    file5 = file5.getParentFile();
                    bl = hashSet.add(file5);
                }
            }
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return hashSet.contains(file);
                }
            };
            if (!FileUtil.renameFile(file2, file4, false, fileFilter)) throw new DownloadManagerException("rename operation failed");
            this.setTorrentSaveDir(file4.getParentFile().toString(), file4.getName());
            return;
        }
        diskManager.moveDataFiles(file4.getParentFile(), file4.getName());
    }

    @Override
    public void moveTorrentFile(File file) throws DownloadManagerException {
        this.moveTorrentFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTorrentFile(File file, String string) throws DownloadManagerException {
        SaveLocationChange saveLocationChange = new SaveLocationChange();
        saveLocationChange.torrent_location = file;
        saveLocationChange.torrent_name = string;
        File file2 = new File(this.getTorrentFileName());
        if (!saveLocationChange.isDifferentTorrentLocation(file2)) {
            return;
        }
        boolean bl = this.pause();
        try {
            this.moveTorrentFile0(file, string);
            Object var7_6 = null;
            if (bl) {
                this.resume();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bl) {
                this.resume();
            }
            throw throwable;
        }
    }

    private void moveTorrentFile0(File file, String string) throws DownloadManagerException {
        if (!this.canMoveDataFiles()) {
            throw new DownloadManagerException("Cannot move torrent file");
        }
        this.setTorrentFile(file, string);
    }

    @Override
    public void setTorrentFile(File file, String string) throws DownloadManagerException {
        File file2 = new File(this.getTorrentFileName());
        if (!file2.exists()) {
            Debug.out("torrent file doesn't exist!");
            return;
        }
        if (file == null) {
            file = file2.getParentFile();
        }
        if (string == null) {
            string = file2.getName();
        }
        File file3 = new File(file, string);
        try {
            file2 = file2.getCanonicalFile();
            file3 = file3.getCanonicalFile();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            throw new DownloadManagerException("Failed to get canonical paths", throwable);
        }
        if (file3.equals(file2)) {
            return;
        }
        if (!TorrentUtils.move(file2, file3)) {
            throw new DownloadManagerException("rename operation failed");
        }
        this.setTorrentFileName(file3.toString());
    }

    @Override
    public boolean isInDefaultSaveDir() {
        return DownloadManagerDefaultPaths.isInDefaultDownloadDir(this);
    }

    @Override
    public boolean seedPieceRecheck() {
        PEPeerManager pEPeerManager = this.controller.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.seedPieceRecheck();
        }
        return false;
    }

    @Override
    public void addRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.controller.addRateLimiter(limitedRateGroup, bl);
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.controller.removeRateLimiter(limitedRateGroup, bl);
    }

    @Override
    public boolean isTrackerError() {
        TRTrackerScraperResponse tRTrackerScraperResponse;
        TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse;
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        return tRTrackerAnnouncer != null ? (tRTrackerAnnouncerResponse = tRTrackerAnnouncer.getLastResponse()) != null && tRTrackerAnnouncerResponse.getStatus() == 1 : (tRTrackerScraperResponse = this.getTrackerScrapeResponse()) != null && tRTrackerScraperResponse.getStatus() == 1;
    }

    @Override
    public boolean isUnauthorisedOnTracker() {
        TRTrackerAnnouncer tRTrackerAnnouncer = this.getTrackerClient();
        String string = null;
        if (tRTrackerAnnouncer != null) {
            TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse = tRTrackerAnnouncer.getLastResponse();
            if (tRTrackerAnnouncerResponse != null && tRTrackerAnnouncerResponse.getStatus() == 1) {
                string = tRTrackerAnnouncerResponse.getStatusString();
            }
        } else {
            TRTrackerScraperResponse tRTrackerScraperResponse = this.getTrackerScrapeResponse();
            if (tRTrackerScraperResponse != null && tRTrackerScraperResponse.getStatus() == 1) {
                string = tRTrackerScraperResponse.getStatusString();
            }
        }
        return string != null && ((string = string.toLowerCase()).contains("not authorised") || string.contains("not authorized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TrackerPeerSource> getTrackerPeerSources() {
        try {
            List<TrackerPeerSource> list;
            List<TrackerPeerSource> list2;
            this.this_mon.enter();
            Object[] objectArray = (Object[])this.getUserData(TPS_Key);
            if (objectArray == null) {
                list2 = new ArrayList();
                list = new TOTorrentListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void torrentChanged(TOTorrent tOTorrent, int n) {
                        if (n == 1) {
                            ArrayList arrayList = null;
                            try {
                                DownloadManagerImpl.this.this_mon.enter();
                                tOTorrent.removeListener(this);
                                DownloadManagerImpl.this.setUserData(TPS_Key, null);
                                if (DownloadManagerImpl.this.tps_listeners != null) {
                                    arrayList = new ArrayList(DownloadManagerImpl.this.tps_listeners);
                                }
                                DownloadManagerTPSListener downloadManagerTPSListener = null;
                                DownloadManagerImpl.this.this_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                DownloadManagerImpl.this.this_mon.exit();
                                throw throwable;
                            }
                            if (arrayList != null) {
                                for (DownloadManagerTPSListener downloadManagerTPSListener : arrayList) {
                                    try {
                                        downloadManagerTPSListener.trackerPeerSourcesChanged();
                                    }
                                    catch (Throwable throwable) {
                                        Debug.out(throwable);
                                    }
                                }
                            }
                        }
                    }
                };
                this.setUserData(TPS_Key, new Object[]{list2, list});
                TOTorrent tOTorrent = this.getTorrent();
                if (tOTorrent != null) {
                    tOTorrent.addListener((TOTorrentListener)((Object)list));
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrent.getAnnounceURLGroup().getAnnounceURLSets();
                    if (tOTorrentAnnounceURLSetArray.length == 0) {
                        tOTorrentAnnounceURLSetArray = new TOTorrentAnnounceURLSet[]{tOTorrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{this.torrent.getAnnounceURL()})};
                    }
                    for (final TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet : tOTorrentAnnounceURLSetArray) {
                        final URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                        if (uRLArray.length == 0 || TorrentUtils.isDecentralised(uRLArray[0])) continue;
                        list2.add(new TrackerPeerSource(){
                            private TrackerPeerSource _delegate;
                            private TRTrackerAnnouncer ta;
                            private long ta_fixup;

                            private TrackerPeerSource fixup() {
                                long l = SystemTime.getMonotonousTime();
                                if (l - this.ta_fixup > 1000L) {
                                    TRTrackerAnnouncer tRTrackerAnnouncer = DownloadManagerImpl.this.getTrackerClient();
                                    if (tRTrackerAnnouncer == this.ta) {
                                        if (tRTrackerAnnouncer != null && this._delegate == null) {
                                            this._delegate = tRTrackerAnnouncer.getTrackerPeerSource(tOTorrentAnnounceURLSet);
                                        }
                                    } else {
                                        this._delegate = tRTrackerAnnouncer == null ? null : tRTrackerAnnouncer.getTrackerPeerSource(tOTorrentAnnounceURLSet);
                                        this.ta = tRTrackerAnnouncer;
                                    }
                                    this.ta_fixup = l;
                                }
                                return this._delegate;
                            }

                            public int getType() {
                                return 1;
                            }

                            public String getName() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return uRLArray[0].toExternalForm();
                                }
                                return trackerPeerSource.getName();
                            }

                            public int getStatus() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return 2;
                                }
                                return trackerPeerSource.getStatus();
                            }

                            public String getStatusString() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return null;
                                }
                                return trackerPeerSource.getStatusString();
                            }

                            public int getSeedCount() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return -1;
                                }
                                return trackerPeerSource.getSeedCount();
                            }

                            public int getLeecherCount() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return -1;
                                }
                                return trackerPeerSource.getLeecherCount();
                            }

                            public int getPeers() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return -1;
                                }
                                return trackerPeerSource.getPeers();
                            }

                            public int getInterval() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return -1;
                                }
                                return trackerPeerSource.getInterval();
                            }

                            public int getMinInterval() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return -1;
                                }
                                return trackerPeerSource.getMinInterval();
                            }

                            public boolean isUpdating() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return false;
                                }
                                return trackerPeerSource.isUpdating();
                            }

                            public int getSecondsToUpdate() {
                                TrackerPeerSource trackerPeerSource = this.fixup();
                                if (trackerPeerSource == null) {
                                    return -1;
                                }
                                return trackerPeerSource.getSecondsToUpdate();
                            }
                        });
                    }
                    list2.add(new TrackerPeerSourceAdapter(){
                        private TrackerPeerSource _delegate;
                        private TRTrackerAnnouncer ta;
                        private boolean enabled;
                        private long ta_fixup;

                        private TrackerPeerSource fixup() {
                            long l = SystemTime.getMonotonousTime();
                            if (l - this.ta_fixup > 1000L) {
                                TRTrackerAnnouncer tRTrackerAnnouncer = DownloadManagerImpl.this.getTrackerClient();
                                if (tRTrackerAnnouncer == this.ta) {
                                    if (tRTrackerAnnouncer != null && this._delegate == null) {
                                        this._delegate = tRTrackerAnnouncer.getCacheTrackerPeerSource();
                                    }
                                } else {
                                    this._delegate = tRTrackerAnnouncer == null ? null : tRTrackerAnnouncer.getCacheTrackerPeerSource();
                                    this.ta = tRTrackerAnnouncer;
                                }
                                this.enabled = DownloadManagerImpl.this.controller.isPeerSourceEnabled("Tracker");
                                this.ta_fixup = l;
                            }
                            return this._delegate;
                        }

                        public int getType() {
                            return 1;
                        }

                        public String getName() {
                            TrackerPeerSource trackerPeerSource = this.fixup();
                            if (trackerPeerSource == null) {
                                return MessageText.getString("tps.tracker.cache");
                            }
                            return trackerPeerSource.getName();
                        }

                        public int getStatus() {
                            TrackerPeerSource trackerPeerSource = this.fixup();
                            if (!this.enabled) {
                                return 1;
                            }
                            if (trackerPeerSource == null) {
                                return 2;
                            }
                            return 5;
                        }

                        public int getPeers() {
                            TrackerPeerSource trackerPeerSource = this.fixup();
                            if (trackerPeerSource == null || !this.enabled) {
                                return -1;
                            }
                            return trackerPeerSource.getPeers();
                        }
                    });
                }
            } else {
                list2 = (List)objectArray[0];
            }
            try {
                list = DownloadManagerController.getExternalSeedPlugin();
                if (list != null) {
                    list2.add(((ExternalSeedPlugin)((Object)list)).getTrackerPeerSource(PluginCoreUtils.wrap(this)));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                list = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTTrackerPlugin.class);
                if (list != null) {
                    list2.add(((DHTTrackerPlugin)list.getPlugin()).getTrackerPeerSource(PluginCoreUtils.wrap(this)));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                list = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(LocalTrackerPlugin.class);
                if (list != null) {
                    list2.add(((LocalTrackerPlugin)list.getPlugin()).getTrackerPeerSource(PluginCoreUtils.wrap(this)));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                list2.add(((DownloadImpl)PluginCoreUtils.wrap(this)).getTrackerPeerSource());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list2.add(new TrackerPeerSourceAdapter(){
                private PEPeerManager _pm;
                private TrackerPeerSource _delegate;

                private TrackerPeerSource fixup() {
                    PEPeerManager pEPeerManager = DownloadManagerImpl.this.getPeerManager();
                    if (pEPeerManager == null) {
                        this._delegate = null;
                        this._pm = null;
                    } else if (pEPeerManager != this._pm) {
                        this._pm = pEPeerManager;
                        this._delegate = pEPeerManager.getTrackerPeerSource();
                    }
                    return this._delegate;
                }

                public int getType() {
                    return 5;
                }

                public int getStatus() {
                    TrackerPeerSource trackerPeerSource = this.fixup();
                    if (trackerPeerSource == null) {
                        return 2;
                    }
                    return trackerPeerSource.getStatus();
                }

                public String getName() {
                    TrackerPeerSource trackerPeerSource = this.fixup();
                    if (trackerPeerSource == null) {
                        return "";
                    }
                    return trackerPeerSource.getName();
                }

                public int getPeers() {
                    TrackerPeerSource trackerPeerSource = this.fixup();
                    if (trackerPeerSource == null) {
                        return -1;
                    }
                    return trackerPeerSource.getPeers();
                }
            });
            list2.add(new TrackerPeerSourceAdapter(){
                private long fixup_time;
                private PEPeerManager _pm;
                private int tcp;
                private int udp;
                private int total;
                private boolean enabled;

                private PEPeerManager fixup() {
                    long l = SystemTime.getMonotonousTime();
                    if (l - this.fixup_time > 1000L) {
                        this._pm = DownloadManagerImpl.this.getPeerManager();
                        PEPeerManager pEPeerManager = this._pm;
                        if (pEPeerManager != null) {
                            this.tcp = pEPeerManager.getNbRemoteTCPConnections();
                            this.udp = pEPeerManager.getNbRemoteUDPConnections();
                            this.total = pEPeerManager.getStats().getTotalIncomingConnections();
                        }
                        this.enabled = DownloadManagerImpl.this.controller.isPeerSourceEnabled("Incoming");
                        this.fixup_time = l;
                    }
                    return this._pm;
                }

                public int getType() {
                    return 6;
                }

                public int getStatus() {
                    PEPeerManager pEPeerManager = this.fixup();
                    if (pEPeerManager == null) {
                        return 2;
                    }
                    if (!this.enabled) {
                        return 1;
                    }
                    return 5;
                }

                public String getName() {
                    PEPeerManager pEPeerManager = this.fixup();
                    if (pEPeerManager == null || !this.enabled) {
                        return "";
                    }
                    return MessageText.getString("tps.incoming.details", new String[]{String.valueOf(this.tcp), String.valueOf(this.udp), String.valueOf(this.total)});
                }

                public int getPeers() {
                    PEPeerManager pEPeerManager = this.fixup();
                    if (pEPeerManager == null || !this.enabled) {
                        return -1;
                    }
                    return this.tcp + this.udp;
                }
            });
            list = list2;
            Object var12_15 = null;
            this.this_mon.exit();
            return list;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTPSListener(DownloadManagerTPSListener downloadManagerTPSListener) {
        try {
            this.this_mon.enter();
            if (this.tps_listeners == null) {
                this.tps_listeners = new ArrayList<DownloadManagerTPSListener>(1);
            }
            this.tps_listeners.add(downloadManagerTPSListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTPSListener(DownloadManagerTPSListener downloadManagerTPSListener) {
        try {
            this.this_mon.enter();
            if (this.tps_listeners != null) {
                this.tps_listeners.remove(downloadManagerTPSListener);
                if (this.tps_listeners.size() == 0) {
                    this.tps_listeners = null;
                    Object[] objectArray = (Object[])this.getUserData(TPS_Key);
                    if (objectArray != null) {
                        TOTorrent tOTorrent = this.getTorrent();
                        if (tOTorrent != null) {
                            tOTorrent.removeListener((TOTorrentListener)objectArray[1]);
                        }
                        this.setUserData(TPS_Key, null);
                    }
                }
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    private byte[] getIdentity() {
        return this.dl_identity;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DownloadManagerImpl) {
            DownloadManagerImpl downloadManagerImpl = (DownloadManagerImpl)object;
            byte[] byArray = this.getIdentity();
            byte[] byArray2 = downloadManagerImpl.getIdentity();
            if (byArray == null || byArray2 == null) {
                return false;
            }
            return Arrays.equals(byArray, byArray2);
        }
        return false;
    }

    public int hashCode() {
        return this.dl_identity_hashcode;
    }

    @Override
    public String getRelationText() {
        return "TorrentDLM: '" + this.getDisplayName() + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.tracker_client};
    }

    public String toString() {
        String string = "<unknown>";
        try {
            string = ByteFormatter.encodeString(this.torrent.getHash());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string2 = DisplayFormatters.formatDownloadStatus(this);
        if (string2.length() > 10) {
            string2 = string2.substring(0, 10);
        }
        return "DownloadManagerImpl#" + this.getPosition() + (this.getAssumedComplete() ? "s" : "d") + "@" + Integer.toHexString(this.hashCode()) + "/" + string2 + "/" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println(this.toString());
        PEPeerManager pEPeerManager = this.getPeerManager();
        try {
            TRTrackerScraperResponse tRTrackerScraperResponse;
            indentWriter.indent();
            indentWriter.println("Save Dir: " + Debug.secretFileName(this.getSaveLocation().toString()));
            if (this.current_peers.size() > 0) {
                indentWriter.println("# Peers: " + this.current_peers.size());
            }
            if (this.current_pieces.size() > 0) {
                indentWriter.println("# Pieces: " + this.current_pieces.size());
            }
            indentWriter.println("Listeners: DownloadManager=" + this.listeners.size() + "; Disk=" + this.controller.getDiskListenerCount() + "; Peer=" + this.peer_listeners.size() + "; Tracker=" + this.tracker_listeners.size());
            indentWriter.println("SR: " + this.iSeedingRank);
            String string = "";
            if (this.open_for_seeding) {
                string = string + "Opened for Seeding; ";
            }
            if (this.data_already_allocated) {
                string = string + "Data Already Allocated; ";
            }
            if (this.assumedComplete) {
                string = string + "onlySeeding; ";
            }
            if (this.persistent) {
                string = string + "persistent; ";
            }
            if (string.length() > 0) {
                indentWriter.println("Flags: " + string);
            }
            this.stats.generateEvidence(indentWriter);
            this.download_manager_state.generateEvidence(indentWriter);
            if (pEPeerManager != null) {
                pEPeerManager.generateEvidence(indentWriter);
            }
            this.controller.generateEvidence(indentWriter);
            TRTrackerAnnouncer tRTrackerAnnouncer = this.tracker_client;
            if (tRTrackerAnnouncer != null) {
                tRTrackerAnnouncer.generateEvidence(indentWriter);
            }
            if ((tRTrackerScraperResponse = this.getTrackerScrapeResponse()) == null) {
                indentWriter.println("Scrape: null");
            } else {
                indentWriter.println("Scrape: " + tRTrackerScraperResponse.getString());
            }
            Object var7_6 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy(boolean bl) {
        block14: {
            block13: {
                block12: {
                    this.destroyed = true;
                    if (bl) {
                        this.controller.destroy();
                        return;
                    }
                    try {
                        if (!this.getSaveLocation().exists()) {
                            Object var7_2 = null;
                            this.clearFileLinks();
                            this.controller.destroy();
                            return;
                        }
                        DiskManager diskManager = this.getDiskManager();
                        if (diskManager != null) {
                            diskManager.downloadRemoved();
                            break block12;
                        }
                        SaveLocationChange saveLocationChange = DownloadManagerMoveHandler.onRemoval(this);
                        if (saveLocationChange == null) {
                            break block13;
                        }
                        boolean bl2 = saveLocationChange.hasTorrentChange();
                        try {
                            if (saveLocationChange.hasDownloadChange()) {
                                this.moveDataFiles(saveLocationChange.download_location, saveLocationChange.download_name);
                            }
                        }
                        catch (Exception exception) {
                            bl2 = false;
                            Logger.log(new LogAlert((Object)this, true, "Problem moving files to removed download directory", (Throwable)exception));
                        }
                        if (bl2) {
                            try {
                                this.moveTorrentFile(saveLocationChange.torrent_location, saveLocationChange.torrent_name);
                            }
                            catch (Exception exception) {
                                Logger.log(new LogAlert((Object)this, true, "Problem moving torrent to removed download directory", (Throwable)exception));
                            }
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        this.clearFileLinks();
                        this.controller.destroy();
                        throw throwable;
                    }
                }
                Object var7_3 = null;
                this.clearFileLinks();
                this.controller.destroy();
                return;
            }
            Object var7_4 = null;
            this.clearFileLinks();
            this.controller.destroy();
            return;
        }
        Object var7_5 = null;
        this.clearFileLinks();
        this.controller.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public int[] getStorageType(DiskManagerFileInfo[] diskManagerFileInfoArray) {
        String[] stringArray = DiskManagerImpl.getStorageTypes(this);
        int[] nArray = new int[diskManagerFileInfoArray.length];
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            nArray[i] = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[diskManagerFileInfoArray[i].getIndex()]);
        }
        return nArray;
    }

    @Override
    public boolean canMoveDataFiles() {
        return this.isPersistent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String string) throws DownloadManagerException {
        boolean bl = this.pause();
        try {
            this.renameDownload(string);
            this.getDownloadState().setAttribute("displayname", string);
            this.renameTorrentSafe(string);
            Object var4_3 = null;
            if (bl) {
                this.resume();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bl) {
                this.resume();
            }
            throw throwable;
        }
    }

    @Override
    public void renameTorrent(String string) throws DownloadManagerException {
        this.moveTorrentFile(null, string);
    }

    @Override
    public void renameTorrentSafe(String string) throws DownloadManagerException {
        String string2;
        String string3 = new File(this.getTorrentFileName()).getParent();
        File file = new File(string3, (string2 = string) + ".torrent");
        if (file.exists()) {
            file = null;
        }
        for (int i = 1; i < 10 && file == null; ++i) {
            file = new File(string3, string2 + "(" + i + ").torrent");
            if (!file.exists()) continue;
            file = null;
        }
        if (file == null) {
            throw new DownloadManagerException("cannot rename torrent file - file already exists");
        }
        this.renameTorrent(file.getName());
    }

    static {
        COConfigurationManager.addAndFireParameterListener("max.uploads.when.busy.inc.min.secs", new ParameterListener(){

            public void parameterChanged(String string) {
                upload_when_busy_min_secs = COConfigurationManager.getIntParameter(string);
            }
        });
        listeners_aggregator = ListenerManager.createAsyncManager("DM:ListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object object, int n, Object object2) {
                DownloadManagerListener downloadManagerListener = (DownloadManagerListener)object;
                Object[] objectArray = (Object[])object2;
                DownloadManagerImpl downloadManagerImpl = (DownloadManagerImpl)objectArray[0];
                if (n == 1) {
                    downloadManagerListener.stateChanged(downloadManagerImpl, (Integer)objectArray[1]);
                } else if (n == 2) {
                    downloadManagerListener.downloadComplete(downloadManagerImpl);
                } else if (n == 3) {
                    downloadManagerListener.completionChanged(downloadManagerImpl, (Boolean)objectArray[1]);
                } else if (n == 5) {
                    downloadManagerListener.filePriorityChanged(downloadManagerImpl, (DiskManagerFileInfo)objectArray[1]);
                } else if (n == 4) {
                    downloadManagerListener.positionChanged(downloadManagerImpl, (Integer)objectArray[1], (Integer)objectArray[2]);
                }
            }
        });
        peer_listeners_aggregator = ListenerManager.createAsyncManager("DM:PeerListenAggregatorDispatcher", new ListenerManagerDispatcher<DownloadManagerPeerListener>(){

            @Override
            public void dispatch(DownloadManagerPeerListener downloadManagerPeerListener, int n, Object object) {
                if (n == 1) {
                    downloadManagerPeerListener.peerAdded((PEPeer)object);
                } else if (n == 2) {
                    downloadManagerPeerListener.peerRemoved((PEPeer)object);
                } else if (n == 5) {
                    downloadManagerPeerListener.peerManagerAdded((PEPeerManager)object);
                } else if (n == 6) {
                    downloadManagerPeerListener.peerManagerRemoved((PEPeerManager)object);
                }
            }
        });
        TPS_Key = new Object();
        piece_listeners_aggregator = ListenerManager.createAsyncManager("DM:PieceListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object object, int n, Object object2) {
                DownloadManagerPieceListener downloadManagerPieceListener = (DownloadManagerPieceListener)object;
                if (n == 3) {
                    downloadManagerPieceListener.pieceAdded((PEPiece)object2);
                } else if (n == 4) {
                    downloadManagerPieceListener.pieceRemoved((PEPiece)object2);
                }
            }
        });
    }

    protected static class NoStackException
    extends Exception {
        protected NoStackException(String string) {
            super(string);
        }
    }
}

