/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandlerUtils;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.savelocation.DefaultSaveLocationManager;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

public class DownloadManagerDefaultPaths
extends DownloadManagerMoveHandlerUtils {
    public static final DefaultSaveLocationManager DEFAULT_HANDLER;
    private static final MovementInformation COMPLETION_DETAILS;
    private static final MovementInformation REMOVAL_DETAILS;
    private static final MovementInformation[] UPDATE_FOR_MOVE_DETAILS;
    private static final TargetSpecification[] DEFAULT_DIRS;
    private static final String SUBDIR_PARAM = "File.move.subdir_is_default";

    private static String normaliseRelativePathPart(String string) {
        if ((string = string.trim()).length() == 0) {
            return "";
        }
        if (string.equals(".") || string.equals("..")) {
            return null;
        }
        return FileUtil.convertOSSpecificChars(string, false).trim();
    }

    public static File normaliseRelativePath(File file) {
        File file2;
        if (file.isAbsolute()) {
            return null;
        }
        String string = DownloadManagerDefaultPaths.normaliseRelativePathPart(file.getName());
        if (string == null) {
            return null;
        }
        if (file2 == null) {
            return new File(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        String string2 = null;
        for (file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            string2 = DownloadManagerDefaultPaths.normaliseRelativePathPart(file2.getName());
            if (string2 == null) {
                return null;
            }
            if (string2.length() == 0) continue;
            arrayList.add(0, string2);
        }
        StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(0));
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(arrayList.get(i));
        }
        return new File(stringBuffer.toString());
    }

    private static File[] getDefaultDirs() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = null;
        TargetSpecification targetSpecification = null;
        for (int i = 0; i < DEFAULT_DIRS.length; ++i) {
            targetSpecification = DEFAULT_DIRS[i];
            file = targetSpecification.getTarget(null, targetSpecification);
            if (file == null) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static SaveLocationChange determinePaths(DownloadManager downloadManager, MovementInformation movementInformation, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = !bl || movementInformation.source.matchesDownload(downloadManager, movementInformation, bl2);
        if (!bl3) {
            DownloadManagerDefaultPaths.logInfo("Cannot consider " + DownloadManagerDefaultPaths.describe(downloadManager, movementInformation) + " - does not match source criteria.", downloadManager);
            return null;
        }
        File file = movementInformation.target.getTarget(downloadManager, movementInformation);
        if (file == null) {
            DownloadManagerDefaultPaths.logInfo("Unable to determine an appropriate target for " + DownloadManagerDefaultPaths.describe(downloadManager, movementInformation) + ".", downloadManager);
            return null;
        }
        DownloadManagerDefaultPaths.logInfo("Determined path for " + DownloadManagerDefaultPaths.describe(downloadManager, movementInformation) + ".", downloadManager);
        return movementInformation.transfer.getTransferDetails(downloadManager, movementInformation, file);
    }

    static boolean isInDefaultDownloadDir(DownloadManager downloadManager) {
        SourceSpecification sourceSpecification = new SourceSpecification();
        sourceSpecification.setBoolean("default subdir", SUBDIR_PARAM);
        return sourceSpecification.checkDefaultDir(downloadManager.getSaveLocation().getParentFile(), DownloadManagerDefaultPaths.getDefaultDirs());
    }

    public static File getCompletionDirectory(DownloadManager downloadManager) {
        return DownloadManagerDefaultPaths.COMPLETION_DETAILS.target.getTarget(downloadManager, null);
    }

    static String describe(DownloadManager downloadManager, ContextDescriptor contextDescriptor) {
        if (contextDescriptor == null) {
            return DownloadManagerDefaultPaths.describe(downloadManager);
        }
        if (downloadManager == null) {
            return "\"" + contextDescriptor.getContext() + "\"";
        }
        return "\"" + downloadManager.getDisplayName() + "\" with regard to \"" + contextDescriptor.getContext() + "\"";
    }

    static {
        MovementInformation movementInformation;
        DEFAULT_HANDLER = new DefaultSaveLocationManager(){

            public SaveLocationChange onInitialization(Download download, boolean bl, boolean bl2) {
                if (bl2) {
                    return null;
                }
                DownloadManager downloadManager = ((DownloadImpl)download).getDownload();
                return DownloadManagerDefaultPaths.determinePaths(downloadManager, UPDATE_FOR_MOVE_DETAILS[1], bl, false);
            }

            public SaveLocationChange onCompletion(Download download, boolean bl, boolean bl2) {
                DownloadManager downloadManager = ((DownloadImpl)download).getDownload();
                return DownloadManagerDefaultPaths.determinePaths(downloadManager, COMPLETION_DETAILS, bl, false);
            }

            public SaveLocationChange testOnCompletion(Download download, boolean bl, boolean bl2) {
                DownloadManager downloadManager = ((DownloadImpl)download).getDownload();
                return DownloadManagerDefaultPaths.determinePaths(downloadManager, COMPLETION_DETAILS, bl, true);
            }

            public SaveLocationChange onRemoval(Download download, boolean bl, boolean bl2) {
                DownloadManager downloadManager = ((DownloadImpl)download).getDownload();
                return DownloadManagerDefaultPaths.determinePaths(downloadManager, REMOVAL_DETAILS, bl, false);
            }

            public boolean isInDefaultSaveDir(Download download) {
                DownloadManager downloadManager = ((DownloadImpl)download).getDownload();
                return DownloadManagerDefaultPaths.isInDefaultDownloadDir(downloadManager);
            }
        };
        DEFAULT_DIRS = new TargetSpecification[3];
        TargetSpecification targetSpecification = new TargetSpecification();
        targetSpecification.setBoolean("enabled", true);
        targetSpecification.setString("target", "Default save path");
        targetSpecification.setContext("default save dir");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[0] = targetSpecification;
        SourceSpecification sourceSpecification = new SourceSpecification();
        sourceSpecification.setBoolean("default dir", "Move Only When In Default Save Dir");
        sourceSpecification.setBoolean("default subdir", SUBDIR_PARAM);
        sourceSpecification.setBoolean("incomplete dl", false);
        targetSpecification = new TargetSpecification();
        targetSpecification.setBoolean("enabled", "Move Completed When Done");
        targetSpecification.setString("target", "Completed Files Directory");
        targetSpecification.setContext("completed files dir");
        TransferSpecification transferSpecification = new TransferSpecification();
        transferSpecification.setBoolean("torrent", "Move Torrent When Done");
        COMPLETION_DETAILS = movementInformation = new MovementInformation(sourceSpecification, targetSpecification, transferSpecification, "Move on completion");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[1] = targetSpecification;
        sourceSpecification = new SourceSpecification();
        sourceSpecification.setBoolean("default dir", "File.move.download.removed.only_in_default");
        sourceSpecification.setBoolean("default subdir", SUBDIR_PARAM);
        sourceSpecification.setBoolean("incomplete dl", false);
        targetSpecification = new TargetSpecification();
        targetSpecification.setBoolean("enabled", "File.move.download.removed.enabled");
        targetSpecification.setString("target", "File.move.download.removed.path");
        targetSpecification.setContext("removed files dir");
        transferSpecification = new TransferSpecification();
        transferSpecification.setBoolean("torrent", "File.move.download.removed.move_torrent");
        REMOVAL_DETAILS = movementInformation = new MovementInformation(sourceSpecification, targetSpecification, transferSpecification, "Move on removal");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[2] = targetSpecification;
        sourceSpecification = new SourceSpecification();
        sourceSpecification.updateSettings(DownloadManagerDefaultPaths.COMPLETION_DETAILS.source.getSettings());
        sourceSpecification.setBoolean("default dir", true);
        movementInformation = new MovementInformation(sourceSpecification, DownloadManagerDefaultPaths.COMPLETION_DETAILS.target, DownloadManagerDefaultPaths.COMPLETION_DETAILS.transfer, "Update completed download");
        sourceSpecification = new SourceSpecification();
        sourceSpecification.setBoolean("default dir", true);
        sourceSpecification.setBoolean("default subdir", SUBDIR_PARAM);
        sourceSpecification.setBoolean("incomplete dl", true);
        targetSpecification = new TargetSpecification();
        targetSpecification.setBoolean("enabled", true);
        targetSpecification.setString("target", "Default save path");
        transferSpecification = new TransferSpecification();
        transferSpecification.setBoolean("torrent", false);
        MovementInformation movementInformation2 = new MovementInformation(sourceSpecification, targetSpecification, transferSpecification, "Update incomplete download");
        UPDATE_FOR_MOVE_DETAILS = new MovementInformation[]{movementInformation, movementInformation2};
    }

    private static class TransferSpecification
    extends ParameterHelper {
        private TransferSpecification() {
        }

        public SaveLocationChange getTransferDetails(DownloadManager downloadManager, ContextDescriptor contextDescriptor, File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            SaveLocationChange saveLocationChange = new SaveLocationChange();
            saveLocationChange.download_location = file;
            if (this.getBoolean("torrent")) {
                saveLocationChange.torrent_location = file;
            }
            return saveLocationChange;
        }
    }

    private static class TargetSpecification
    extends ParameterHelper {
        private TargetSpecification() {
        }

        public File getTarget(DownloadManager downloadManager, ContextDescriptor contextDescriptor) {
            if (!this.getBoolean("enabled")) {
                DownloadManagerMoveHandlerUtils.logInfo("Target for " + DownloadManagerDefaultPaths.describe(downloadManager, contextDescriptor) + " is not enabled.", downloadManager);
                return null;
            }
            String string = this.getString("target").trim();
            if (string.length() == 0) {
                DownloadManagerMoveHandlerUtils.logInfo("No explicit target for " + DownloadManagerDefaultPaths.describe(downloadManager, contextDescriptor) + ".", downloadManager);
                return null;
            }
            File file = new File(FileUtil.getCanonicalFileName(string));
            String string2 = null;
            if (downloadManager != null && downloadManager.getDownloadState() != null) {
                string2 = downloadManager.getDownloadState().getRelativeSavePath();
            }
            if (string2 != null && string2.length() > 0) {
                DownloadManagerMoveHandlerUtils.logInfo("Consider relative save path: " + string2, downloadManager);
                file = new File(file.getPath() + File.separator + string2);
            }
            return file;
        }
    }

    private static class SourceSpecification
    extends ParameterHelper {
        private SourceSpecification() {
        }

        public boolean matchesDownload(DownloadManager downloadManager, ContextDescriptor contextDescriptor, boolean bl) {
            Object object;
            if (this.getBoolean("default dir")) {
                DownloadManagerMoveHandlerUtils.logInfo("Checking if " + DownloadManagerDefaultPaths.describe(downloadManager, contextDescriptor) + " is inside default dirs.", downloadManager);
                File[] fileArray = DownloadManagerDefaultPaths.getDefaultDirs();
                object = downloadManager.getSaveLocation().getParentFile();
                if (object == null) {
                    DownloadManagerMoveHandlerUtils.logWarn(DownloadManagerDefaultPaths.describe(downloadManager, contextDescriptor) + " appears to have a malformed save directory, skipping.", downloadManager);
                    return false;
                }
                if (!this.checkDefaultDir((File)object, fileArray)) {
                    DownloadManagerMoveHandlerUtils.logWarn(DownloadManagerDefaultPaths.describe(downloadManager, contextDescriptor) + " doesn't exist in any of the following default directories" + " (current dir: " + object + ", subdirectories checked: " + this.getBoolean("default subdir") + ") - " + Arrays.asList(fileArray), downloadManager);
                    return false;
                }
                DownloadManagerMoveHandlerUtils.logInfo(DownloadManagerDefaultPaths.describe(downloadManager, contextDescriptor) + " does exist inside default dirs.", downloadManager);
            }
            if (!downloadManager.isDownloadComplete(false)) {
                boolean bl2 = bl || this.getBoolean("incomplete dl");
                object = DownloadManagerDefaultPaths.describe(downloadManager, contextDescriptor) + " is incomplete which is " + (bl2 ? "" : "not ") + "an appropriate state.";
                if (!bl2) {
                    DownloadManagerMoveHandlerUtils.logInfo((String)object, downloadManager);
                    return false;
                }
            }
            return true;
        }

        public boolean checkDefaultDir(File file, File[] fileArray) {
            file = FileUtil.canonise(file);
            boolean bl = this.getBoolean("default subdir");
            for (int i = 0; i < fileArray.length; ++i) {
                if (!(bl ? FileUtil.isAncestorOf(fileArray[i], file) : fileArray[i].equals(file))) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class ParameterHelper
    implements ContextDescriptor {
        private Map settings = new HashMap();
        private String context = null;

        private ParameterHelper() {
        }

        protected boolean getBoolean(String string) {
            Object v = this.settings.get(string);
            if (v == null) {
                throw new RuntimeException("bad key: " + string);
            }
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            return COConfigurationManager.getBooleanParameter((String)v);
        }

        protected void setBoolean(String string, boolean bl) {
            this.settings.put(string, bl);
        }

        protected void setBoolean(String string, String string2) {
            this.settings.put(string, string2);
        }

        protected void setString(String string, String string2) {
            this.settings.put(string, string2);
        }

        protected String getString(String string) {
            String string2 = (String)this.settings.get(string);
            if (string2 == null) {
                throw new RuntimeException("bad key: " + string);
            }
            return COConfigurationManager.getStringParameter(string2);
        }

        public Map getSettings() {
            return this.settings;
        }

        public void updateSettings(Map map) {
            this.settings.putAll(map);
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String string) {
            this.context = string;
        }
    }

    private static class MovementInformation
    implements ContextDescriptor {
        final SourceSpecification source;
        final TargetSpecification target;
        final TransferSpecification transfer;
        final String title;

        MovementInformation(SourceSpecification sourceSpecification, TargetSpecification targetSpecification, TransferSpecification transferSpecification, String string) {
            this.source = sourceSpecification;
            this.target = targetSpecification;
            this.transfer = transferSpecification;
            this.title = string;
        }

        public String getContext() {
            return this.title;
        }
    }

    private static interface ContextDescriptor {
        public String getContext();
    }
}

