/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoSetImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.StringInterner;

public class DiskManagerUtil {
    private static final LogIDs LOGID = LogIDs.DISK;
    protected static int max_read_block_size;
    private static AEMonitor cache_read_mon;

    public static boolean checkBlockConsistencyForHint(DiskManager diskManager, String string, int n, int n2, int n3) {
        if (n3 <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " length=" + n3 + " <= 0"));
            }
            return false;
        }
        if (n < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " pieceNumber=" + n + " < 0"));
            }
            return false;
        }
        if (n >= diskManager.getNbPieces()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " pieceNumber=" + n + " >= this.nbPieces=" + diskManager.getNbPieces()));
            }
            return false;
        }
        int n4 = diskManager.getPieceLength(n);
        if (n2 < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " offset=" + n2 + " < 0"));
            }
            return false;
        }
        if (n2 > n4) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " offset=" + n2 + " > pLength=" + n4));
            }
            return false;
        }
        if (n2 + n3 > n4) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " offset=" + n2 + " + length=" + n3 + " > pLength=" + n4));
            }
            return false;
        }
        return true;
    }

    public static boolean checkBlockConsistencyForRead(DiskManager diskManager, String string, boolean bl, int n, int n2, int n3) {
        if (!DiskManagerUtil.checkBlockConsistencyForHint(diskManager, string, n, n2, n3)) {
            return false;
        }
        if (n3 > max_read_block_size && bl) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Read invalid: " + string + " length=" + n3 + " > " + max_read_block_size));
            }
            return false;
        }
        if (!diskManager.getPiece(n).isDone()) {
            Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Read invalid: " + string + " piece #" + n + " not done"));
            return false;
        }
        return true;
    }

    public static void doFileExistenceChecks(DiskManagerFileInfoSet diskManagerFileInfoSet, boolean[] blArray, DownloadManager downloadManager, boolean bl) {
        DiskManagerFileInfo[] diskManagerFileInfoArray = diskManagerFileInfoSet.getFiles();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String[] stringArray = DiskManagerImpl.getStorageTypes(downloadManager);
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            int n4 = diskManagerFileInfoArray[i].getFirstPieceNumber();
            int n5 = diskManagerFileInfoArray[i].getLastPieceNumber();
            if (blArray[i]) {
                if (n < n4) {
                    n2 = n4;
                    while (i > 0 && diskManagerFileInfoArray[i - 1].getLastPieceNumber() >= n2) {
                        --i;
                    }
                }
                if (n3 < n5) {
                    n3 = n5;
                }
            }
            if ((n2 > n4 || n4 > n3) && (n2 > n5 || n5 > n3)) continue;
            File file = diskManagerFileInfoArray[i].getFile(true);
            if (!RDResumeHandler.fileMustExist(downloadManager, diskManagerFileInfoArray[i])) {
                int n6 = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[i]);
                if (n6 == 2 || n6 == 4) {
                    file.delete();
                }
            } else if (bl && !file.exists()) {
                downloadManager.setDataAlreadyAllocated(false);
            }
            n = n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean setFileLink(DownloadManager downloadManager, DiskManagerFileInfo[] diskManagerFileInfoArray, DiskManagerFileInfo diskManagerFileInfo, File file, File file2) {
        File file3 = FMFileManagerFactory.getSingleton().getFileLink(downloadManager.getTorrent(), file2);
        if (!file3.equals(file2) && !file.equals(file2)) {
            Logger.log(new LogAlert((Object)downloadManager, true, 3, "Attempt to link to existing link '" + file3.toString() + "'"));
            return false;
        }
        File file4 = diskManagerFileInfo.getFile(true);
        if (file2.equals(file4)) {
            return true;
        }
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            if (!file2.equals(diskManagerFileInfoArray[i].getFile(true))) continue;
            Logger.log(new LogAlert((Object)downloadManager, true, 3, "Attempt to link to existing file '" + diskManagerFileInfoArray[i].getFile(true) + "'"));
            return false;
        }
        if (file2.exists()) {
            if (!file4.exists()) {
                downloadManager.recheckFile(diskManagerFileInfo);
            } else {
                if (!FileUtil.deleteWithRecycle(file4, downloadManager.getDownloadState().getFlag(16L))) {
                    Logger.log(new LogAlert((Object)downloadManager, true, 3, "Failed to delete '" + file4.toString() + "'"));
                    return false;
                }
                downloadManager.recheckFile(diskManagerFileInfo);
            }
        } else if (file4.exists() && !FileUtil.renameFile(file4, file2)) {
            Logger.log(new LogAlert((Object)downloadManager, true, 3, "Failed to rename '" + file4.toString() + "'"));
            return false;
        }
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        downloadManagerState.setFileLink(file, file2);
        downloadManagerState.save();
        return true;
    }

    public static DiskManagerFileInfoSet getFileInfoSkeleton(final DownloadManager downloadManager, DiskManagerListener diskManagerListener) {
        TOTorrent tOTorrent = downloadManager.getTorrent();
        if (tOTorrent == null) {
            return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
        }
        String string = downloadManager.getAbsoluteSaveLocation().getParent();
        if (string == null) {
            string = downloadManager.getAbsoluteSaveLocation().getPath();
        }
        if (!tOTorrent.isSimpleTorrent()) {
            string = string + File.separator + downloadManager.getAbsoluteSaveLocation().getName();
        }
        string = string + File.separator;
        String string2 = StringInterner.intern(string);
        try {
            LocaleUtilDecoder localeUtilDecoder = LocaleTorrentUtil.getTorrentEncoding(tOTorrent);
            TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            DiskManagerFileInfoHelper[] diskManagerFileInfoHelperArray = new FileSkeleton[tOTorrentFileArray.length];
            String string3 = downloadManager.getDownloadState().getAttribute("incompfilesuffix");
            DiskManagerFileInfoSet diskManagerFileInfoSet = new DiskManagerFileInfoSet((FileSkeleton[])diskManagerFileInfoHelperArray, downloadManager, diskManagerListener){
                final /* synthetic */ FileSkeleton[] val$res;
                final /* synthetic */ DownloadManager val$download_manager;
                final /* synthetic */ DiskManagerListener val$listener;
                {
                    this.val$res = fileSkeletonArray;
                    this.val$download_manager = downloadManager;
                    this.val$listener = diskManagerListener;
                }

                public DiskManagerFileInfo[] getFiles() {
                    return this.val$res;
                }

                public int nbFiles() {
                    return this.val$res.length;
                }

                public void setPriority(int[] nArray) {
                    int n;
                    if (nArray.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    for (n = 0; n < this.val$res.length; ++n) {
                        this.val$res[n].priority = nArray[n];
                    }
                    DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    for (n = 0; n < this.val$res.length; ++n) {
                        if (nArray[n] <= 0) continue;
                        this.val$listener.filePriorityChanged(this.val$res[n]);
                    }
                }

                public void setSkipped(boolean[] blArray, boolean bl) {
                    int n;
                    if (blArray.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    if (!bl) {
                        String[] stringArray = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                        boolean[] blArray2 = new boolean[blArray.length];
                        boolean[] blArray3 = new boolean[blArray.length];
                        int n2 = 0;
                        int n3 = 0;
                        for (int i = 0; i < blArray.length; ++i) {
                            if (!blArray[i]) continue;
                            int n4 = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[i]);
                            if (n4 == 2) {
                                blArray2[i] = true;
                                ++n2;
                                continue;
                            }
                            if (n4 != 4) continue;
                            blArray3[i] = true;
                            ++n3;
                        }
                        if (n2 > 0 && !Arrays.equals(blArray2, this.setStorageTypes(blArray2, 1))) {
                            return;
                        }
                        if (n3 > 0 && !Arrays.equals(blArray3, this.setStorageTypes(blArray3, 3))) {
                            return;
                        }
                    }
                    for (n = 0; n < this.val$res.length; ++n) {
                        if (!blArray[n]) continue;
                        this.val$res[n].skipped = bl;
                    }
                    if (!bl) {
                        DiskManagerUtil.doFileExistenceChecks(this, blArray, this.val$download_manager, true);
                    }
                    DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    for (n = 0; n < this.val$res.length; ++n) {
                        if (!blArray[n]) continue;
                        this.val$listener.filePriorityChanged(this.val$res[n]);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean[] setStorageTypes(boolean[] blArray, int n) {
                    if (blArray.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    String[] stringArray = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                    boolean[] blArray2 = new boolean[this.val$res.length];
                    boolean[] blArray3 = new boolean[this.val$res.length];
                    int n2 = 0;
                    DownloadManagerState downloadManagerState = this.val$download_manager.getDownloadState();
                    try {
                        int n3;
                        int n4;
                        downloadManagerState.suppressStateSave(true);
                        for (n4 = 0; n4 < this.val$res.length; ++n4) {
                            if (!blArray[n4]) continue;
                            n3 = n4;
                            int n5 = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[n4]);
                            if (n == n5) {
                                blArray2[n4] = true;
                                continue;
                            }
                            try {
                                File file = this.val$res[n4].getFile(true);
                                if (file.exists()) {
                                    CacheFile cacheFile = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        public String getCacheFileOwnerName() {
                                            return val$download_manager.getInternalName();
                                        }

                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$res[n3].getTorrentFile();
                                        }

                                        public File getCacheFileControlFileDir() {
                                            return val$download_manager.getDownloadState().getStateFile();
                                        }

                                        public int getCacheMode() {
                                            return 1;
                                        }
                                    }, file, DiskManagerUtil.convertDMStorageTypeToCache(n));
                                    cacheFile.close();
                                    boolean bl = blArray3[n4] = (n == 2 || n == 4) && !this.val$res[n4].isSkipped();
                                    if (blArray3[n4]) {
                                        ++n2;
                                    }
                                }
                                blArray2[n4] = true;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                                Logger.log(new LogAlert((Object)this.val$download_manager, true, 3, "Failed to change storage type for '" + this.val$res[n4].getFile(true) + "': " + Debug.getNestedExceptionMessage(throwable)));
                                RDResumeHandler.recheckFile(this.val$download_manager, this.val$res[n4]);
                            }
                            stringArray[n4] = DiskManagerUtil.convertDMStorageTypeToString(n);
                        }
                        downloadManagerState.setListAttribute("storetypes", stringArray);
                        if (n2 > 0) {
                            this.setSkipped(blArray3, true);
                        }
                        for (n4 = 0; n4 < this.val$res.length; ++n4) {
                            if (!blArray[n4] || (n3 = RDResumeHandler.storageTypeChanged(this.val$download_manager, this.val$res[n4])) <= 0) continue;
                            this.val$res[n4].downloaded -= (long)n3 * this.val$res[n4].getTorrentFile().getTorrent().getPieceLength();
                            if (this.val$res[n4].downloaded >= 0L) continue;
                            this.val$res[n4].downloaded = 0L;
                        }
                        DiskManagerImpl.storeFileDownloaded(this.val$download_manager, this.val$res, true);
                        DiskManagerUtil.doFileExistenceChecks(this, blArray, this.val$download_manager, n == 1 || n == 3);
                        Object var14_14 = null;
                        downloadManagerState.suppressStateSave(false);
                        downloadManagerState.save();
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        downloadManagerState.suppressStateSave(false);
                        downloadManagerState.save();
                        throw throwable;
                    }
                    return blArray2;
                }
            };
            for (int i = 0; i < diskManagerFileInfoHelperArray.length; ++i) {
                TOTorrentFile tOTorrentFile = tOTorrentFileArray[i];
                int n = i;
                FileSkeleton fileSkeleton = new FileSkeleton((FileSkeleton[])diskManagerFileInfoHelperArray, diskManagerListener, diskManagerFileInfoSet, n, string3, tOTorrentFile, string2, localeUtilDecoder){
                    private CacheFile read_cache_file;
                    private WeakReference dataFile = new WeakReference<Object>(null);
                    final /* synthetic */ FileSkeleton[] val$res;
                    final /* synthetic */ DiskManagerListener val$listener;
                    final /* synthetic */ DiskManagerFileInfoSet val$fileSetSkeleton;
                    final /* synthetic */ int val$file_index;
                    final /* synthetic */ String val$incomplete_suffix;
                    final /* synthetic */ TOTorrentFile val$torrent_file;
                    final /* synthetic */ String val$root_dir;
                    final /* synthetic */ LocaleUtilDecoder val$locale_decoder;
                    {
                        this.val$res = fileSkeletonArray;
                        this.val$listener = diskManagerListener;
                        this.val$fileSetSkeleton = diskManagerFileInfoSet;
                        this.val$file_index = n;
                        this.val$incomplete_suffix = string;
                        this.val$torrent_file = tOTorrentFile;
                        this.val$root_dir = string2;
                        this.val$locale_decoder = localeUtilDecoder;
                    }

                    public void setPriority(int n) {
                        this.priority = n;
                        DiskManagerImpl.storeFilePriorities(downloadManager, this.val$res);
                        this.val$listener.filePriorityChanged(this);
                    }

                    public void setSkipped(boolean bl) {
                        if (!bl && this.getStorageType() == 2 && !this.setStorageType(1)) {
                            return;
                        }
                        if (!bl && this.getStorageType() == 4 && !this.setStorageType(3)) {
                            return;
                        }
                        this.skipped = bl;
                        DiskManagerImpl.storeFilePriorities(downloadManager, this.val$res);
                        if (!bl) {
                            boolean[] blArray = new boolean[this.val$fileSetSkeleton.nbFiles()];
                            blArray[this.val$file_index] = true;
                            DiskManagerUtil.doFileExistenceChecks(this.val$fileSetSkeleton, blArray, downloadManager, true);
                        }
                        this.val$listener.filePriorityChanged(this);
                    }

                    public int getAccessMode() {
                        return 1;
                    }

                    public long getDownloaded() {
                        return this.downloaded;
                    }

                    public void setDownloaded(long l) {
                        this.downloaded = l;
                    }

                    public String getExtension() {
                        int n;
                        String string = this.lazyGetFile().getName();
                        if (this.val$incomplete_suffix != null && string.endsWith(this.val$incomplete_suffix)) {
                            string = string.substring(0, string.length() - this.val$incomplete_suffix.length());
                        }
                        if ((n = string.lastIndexOf(".")) == -1) {
                            n = 0;
                        }
                        return string.substring(n);
                    }

                    public int getFirstPieceNumber() {
                        return this.val$torrent_file.getFirstPieceNumber();
                    }

                    public int getLastPieceNumber() {
                        return this.val$torrent_file.getLastPieceNumber();
                    }

                    public long getLength() {
                        return this.val$torrent_file.getLength();
                    }

                    public int getIndex() {
                        return this.val$file_index;
                    }

                    public int getNbPieces() {
                        return this.val$torrent_file.getNumberOfPieces();
                    }

                    public int getPriority() {
                        return this.priority;
                    }

                    public boolean isSkipped() {
                        return this.skipped;
                    }

                    public DiskManager getDiskManager() {
                        return null;
                    }

                    public DownloadManager getDownloadManager() {
                        return downloadManager;
                    }

                    public File getFile(boolean bl) {
                        File file;
                        if (bl && (file = this.getLink()) != null) {
                            return file;
                        }
                        return this.lazyGetFile();
                    }

                    private File lazyGetFile() {
                        File file = (File)this.dataFile.get();
                        if (file != null) {
                            return file;
                        }
                        TOTorrent tOTorrent = downloadManager.getTorrent();
                        String string = this.val$root_dir;
                        File file2 = null;
                        if (tOTorrent.isSimpleTorrent()) {
                            file2 = downloadManager.getAbsoluteSaveLocation();
                        } else {
                            byte[][] byArray = this.val$torrent_file.getPathComponents();
                            for (int i = 0; i < byArray.length; ++i) {
                                String string2;
                                try {
                                    string2 = this.val$locale_decoder.decodeString(byArray[i]);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    Debug.printStackTrace(unsupportedEncodingException);
                                    string2 = "undecodableFileName" + this.val$file_index;
                                }
                                string2 = FileUtil.convertOSSpecificChars(string2, i != byArray.length - 1);
                                string = string + (i == 0 ? "" : File.separator) + string2;
                            }
                        }
                        file = file2 != null ? file2 : new File(string);
                        this.dataFile = new WeakReference<File>(file);
                        return file;
                    }

                    public TOTorrentFile getTorrentFile() {
                        return this.val$torrent_file;
                    }

                    public boolean setLink(File file) {
                        if (downloadManager.getTorrent().isSimpleTorrent()) {
                            try {
                                downloadManager.moveDataFiles(file.getParentFile(), file.getName());
                                return true;
                            }
                            catch (DownloadManagerException downloadManagerException) {
                                return false;
                            }
                        }
                        return this.setLinkAtomic(file);
                    }

                    public boolean setLinkAtomic(File file) {
                        return DiskManagerUtil.setFileLink(downloadManager, this.val$res, this, this.lazyGetFile(), file);
                    }

                    public File getLink() {
                        return downloadManager.getDownloadState().getFileLink(this.lazyGetFile());
                    }

                    public boolean setStorageType(int n) {
                        boolean[] blArray = new boolean[this.val$res.length];
                        blArray[this.val$file_index] = true;
                        return this.val$fileSetSkeleton.setStorageTypes(blArray, n)[this.val$file_index];
                    }

                    public int getStorageType() {
                        return DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(downloadManager, this.val$file_index));
                    }

                    public void flushCache() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public DirectByteBuffer read(long l, int n) throws IOException {
                        CacheFile cacheFile;
                        try {
                            cache_read_mon.enter();
                            if (this.read_cache_file == null) {
                                try {
                                    int n2 = DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(downloadManager, this.val$file_index));
                                    this.read_cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        public String getCacheFileOwnerName() {
                                            return downloadManager.getInternalName();
                                        }

                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$torrent_file;
                                        }

                                        public File getCacheFileControlFileDir() {
                                            return downloadManager.getDownloadState().getStateFile();
                                        }

                                        public int getCacheMode() {
                                            return 1;
                                        }
                                    }, this.getFile(true), DiskManagerUtil.convertDMStorageTypeToCache(n2));
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                    throw new IOException(throwable.getMessage());
                                }
                            }
                            cacheFile = this.read_cache_file;
                            Object var7_7 = null;
                            cache_read_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            cache_read_mon.exit();
                            throw throwable;
                        }
                        DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)6, n);
                        try {
                            cacheFile.read(directByteBuffer, l, (short)1);
                        }
                        catch (Throwable throwable) {
                            directByteBuffer.returnToPool();
                            Debug.printStackTrace(throwable);
                            throw new IOException(throwable.getMessage());
                        }
                        return directByteBuffer;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() {
                        CacheFile cacheFile;
                        try {
                            cache_read_mon.enter();
                            cacheFile = this.read_cache_file;
                            this.read_cache_file = null;
                            Object var3_2 = null;
                            cache_read_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            cache_read_mon.exit();
                            throw throwable;
                        }
                        if (cacheFile != null) {
                            try {
                                cacheFile.close();
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }

                    public void addListener(DiskManagerFileInfoListener diskManagerFileInfoListener) {
                        if (this.getDownloaded() == this.getLength()) {
                            try {
                                diskManagerFileInfoListener.dataWritten(0L, this.getLength());
                                diskManagerFileInfoListener.dataChecked(0L, this.getLength());
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }

                    public void removeListener(DiskManagerFileInfoListener diskManagerFileInfoListener) {
                    }
                };
                diskManagerFileInfoHelperArray[i] = fileSkeleton;
            }
            DiskManagerUtil.loadFilePriorities(downloadManager, diskManagerFileInfoSet);
            DiskManagerUtil.loadFileDownloaded(downloadManager, diskManagerFileInfoHelperArray);
            return diskManagerFileInfoSet;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
        }
    }

    public static int convertDMStorageTypeFromString(String string) {
        char c = string.charAt(0);
        switch (c) {
            case 'L': {
                return 1;
            }
            case 'C': {
                return 2;
            }
            case 'R': {
                return 3;
            }
            case 'X': {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    public static String convertDMStorageTypeToString(int n) {
        switch (n) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static String convertCacheStorageTypeToString(int n) {
        switch (n) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static int convertDMStorageTypeToCache(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    static void loadFilePriorities(DownloadManager downloadManager, DiskManagerFileInfoSet diskManagerFileInfoSet) {
        try {
            DiskManagerFileInfo[] diskManagerFileInfoArray = diskManagerFileInfoSet.getFiles();
            if (diskManagerFileInfoArray == null) {
                return;
            }
            List list = (List)downloadManager.getData("file_priorities");
            if (list == null) {
                return;
            }
            boolean[] blArray = new boolean[diskManagerFileInfoArray.length];
            int[] nArray = new int[diskManagerFileInfoArray.length];
            for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
                DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
                if (diskManagerFileInfo == null) {
                    return;
                }
                int n = ((Long)list.get(i)).intValue();
                if (n == 0) {
                    blArray[i] = true;
                    continue;
                }
                if (n < 1) continue;
                nArray[i] = n;
            }
            diskManagerFileInfoSet.setPriority(nArray);
            diskManagerFileInfoSet.setSkipped(blArray, true);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected static void loadFileDownloaded(DownloadManager downloadManager, DiskManagerFileInfoHelper[] diskManagerFileInfoHelperArray) {
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        Map map = downloadManagerState.getMapAttribute("filedownloaded");
        if (map == null) {
            return;
        }
        List list = (List)map.get("downloaded");
        if (list == null) {
            return;
        }
        try {
            for (int i = 0; i < diskManagerFileInfoHelperArray.length; ++i) {
                diskManagerFileInfoHelperArray[i].setDownloaded((Long)list.get(i));
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    static {
        ParameterListener parameterListener = new ParameterListener(){

            public void parameterChanged(String string) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", parameterListener);
        cache_read_mon = new AEMonitor("DiskManager:cacheRead");
    }

    static abstract class FileSkeleton
    implements DiskManagerFileInfoHelper {
        protected int priority;
        protected boolean skipped;
        protected long downloaded;

        FileSkeleton() {
        }
    }
}

