/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;

public abstract class JDKKeyFactory
extends KeyFactorySpi {
    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
        }
        if (clazz.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }
        throw new RuntimeException("not implemented yet " + key + " " + clazz);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return new JCERSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey || key instanceof RSAPrivateKey || key instanceof DHPublicKey || key instanceof DHPrivateKey || key instanceof DSAPublicKey || key instanceof DSAPrivateKey || key instanceof ElGamalPublicKey || key instanceof ElGamalPrivateKey) {
            // empty if block
        }
        throw new InvalidKeyException("key type unknown");
    }

    static PublicKey createPublicKeyFromDERStream(InputStream inputStream) throws IOException {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream(inputStream).readObject()));
    }

    static PublicKey createPublicKeyFromPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithmId();
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algorithmIdentifier.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            return new JCERSAPublicKey(subjectPublicKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPublicKey(subjectPublicKeyInfo);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }

    static PrivateKey createPrivateKeyFromDERStream(InputStream inputStream) throws IOException {
        return JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo(new PrivateKeyInfo((ASN1Sequence)new DERInputStream(inputStream).readObject()));
    }

    static PrivateKey createPrivateKeyFromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getAlgorithmId();
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPrivateKey(privateKeyInfo);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class EC
    extends JDKKeyFactory {
        String algorithm;

        public EC() {
            this("EC");
        }

        public EC(String string) {
            this.algorithm = string;
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPrivateKeyFromDERStream(new ByteArrayInputStream(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(exception.toString());
                }
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                return new JCEECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type.");
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPublicKeyFromDERStream(new ByteArrayInputStream(((X509EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(exception.toString());
                }
            }
            if (keySpec instanceof ECPublicKeySpec) {
                return new JCEECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type.");
        }
    }
}

