/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.ssdp;

import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPSSDPListener;
import com.aelitis.net.upnp.impl.SSDPIGD;
import com.aelitis.net.upnp.impl.SSDPIGDListener;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.ssdp.SSDPCore;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class SSDPIGDImpl
implements SSDPIGD,
UPnPSSDPListener {
    private UPnPImpl upnp;
    private SSDPCore ssdp_core;
    private boolean first_result = true;
    private long last_explicit_search = 0L;
    private List listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("SSDP");

    public SSDPIGDImpl(UPnPImpl uPnPImpl, String[] stringArray) throws UPnPException {
        this.upnp = uPnPImpl;
        this.ssdp_core = SSDPCore.getSingleton(this.upnp.getAdapter(), "239.255.255.250", 1900, 0, stringArray);
        this.ssdp_core.addListener(this);
    }

    public void start() throws UPnPException {
        try {
            this.upnp.getAdapter().createThread("SSDP:queryLoop", new AERunnable(){

                public void runSupport() {
                    SSDPIGDImpl.this.queryLoop();
                }
            });
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            throw new UPnPException("Failed to initialise SSDP", throwable);
        }
    }

    public void searchNow() {
        long l = SystemTime.getCurrentTime();
        if (l - this.last_explicit_search < 10000L) {
            return;
        }
        this.last_explicit_search = l;
        this.search();
    }

    public void searchNow(String[] stringArray) {
        this.ssdp_core.search(stringArray);
    }

    protected void queryLoop() {
        while (true) {
            try {
                while (true) {
                    this.search();
                    Thread.sleep(60000L);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                continue;
            }
            break;
        }
    }

    protected void search() {
        this.ssdp_core.search(new String[]{"upnp:rootdevice"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedResult(NetworkInterface networkInterface2, InetAddress inetAddress, InetAddress inetAddress2, String string, URL uRL, String string2, String string3) {
        try {
            this.this_mon.enter();
            if (string2.equalsIgnoreCase("upnp:rootdevice")) {
                this.gotRoot(networkInterface2, inetAddress, string, uRL);
            }
            Object var9_8 = null;
            this.first_result = false;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.first_result = false;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedNotify(NetworkInterface networkInterface2, InetAddress inetAddress, InetAddress inetAddress2, String string, URL uRL, String string2, String string3) {
        try {
            block13: {
                this.this_mon.enter();
                if (string2.indexOf("upnp:rootdevice") != -1) {
                    if (string3.indexOf("alive") != -1) {
                        try {
                            InetAddress inetAddress3 = InetAddress.getByName(uRL.getHost());
                            byte[] byArray = inetAddress3.getAddress();
                            boolean[] blArray = this.bytesToBits(byArray);
                            NetworkInterface networkInterface3 = null;
                            InetAddress inetAddress4 = null;
                            int n = 0;
                            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                            while (enumeration.hasMoreElements()) {
                                NetworkInterface networkInterface4 = enumeration.nextElement();
                                Enumeration<InetAddress> enumeration2 = networkInterface4.getInetAddresses();
                                while (enumeration2.hasMoreElements()) {
                                    InetAddress inetAddress5 = enumeration2.nextElement();
                                    byte[] byArray2 = inetAddress5.getAddress();
                                    if (byArray.length != byArray2.length) continue;
                                    boolean[] blArray2 = this.bytesToBits(byArray2);
                                    for (int i = 0; i < blArray2.length && blArray[i] == blArray2[i]; ++i) {
                                        if (i <= n) continue;
                                        n = i;
                                        networkInterface3 = networkInterface4;
                                        inetAddress4 = inetAddress5;
                                    }
                                }
                            }
                            if (networkInterface3 != null) {
                                if (this.first_result) {
                                    this.upnp.log(uRL + " -> " + networkInterface3.getDisplayName() + "/" + inetAddress4 + " (prefix=" + (n + 1) + ")");
                                }
                                this.gotRoot(networkInterface3, inetAddress4, string, uRL);
                                break block13;
                            }
                            this.gotAlive(string, uRL);
                        }
                        catch (Throwable throwable) {
                            this.gotAlive(string, uRL);
                        }
                    } else if (string3.indexOf("byebye") != -1) {
                        this.lostRoot(inetAddress, string);
                    }
                }
            }
            Object var22_22 = null;
            this.first_result = false;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var22_23 = null;
            this.first_result = false;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public String[] receivedSearch(NetworkInterface networkInterface2, InetAddress inetAddress, InetAddress inetAddress2, String string) {
        return null;
    }

    protected boolean[] bytesToBits(byte[] byArray) {
        boolean[] blArray = new boolean[byArray.length * 8];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            for (int j = 0; j < 8; ++j) {
                blArray[i * 8 + j] = (by & (byte)(1 << 7 - j)) != 0;
            }
        }
        return blArray;
    }

    protected void gotRoot(NetworkInterface networkInterface2, InetAddress inetAddress, String string, URL uRL) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).rootDiscovered(networkInterface2, inetAddress, string, uRL);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void gotAlive(String string, URL uRL) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).rootAlive(string, uRL);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void lostRoot(InetAddress inetAddress, String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).rootLost(inetAddress, string);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void interfaceChanged(NetworkInterface networkInterface2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).interfaceChanged(networkInterface2);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void addListener(SSDPIGDListener sSDPIGDListener) {
        this.listeners.add(sSDPIGDListener);
    }

    public void removeListener(SSDPIGDListener sSDPIGDListener) {
        this.listeners.remove(sSDPIGDListener);
    }
}

