/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.aelitis.net.upnp.impl.services.UPnPServiceImpl;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPDeviceImpl
implements UPnPDevice {
    private UPnPRootDeviceImpl root_device;
    private String device_type;
    private String friendly_name;
    private String manufacturer;
    private String manufacturer_url;
    private String model_description;
    private String model_name;
    private String model_number;
    private String model_url;
    private String presentation_url;
    private List devices = new ArrayList();
    private List services = new ArrayList();

    protected UPnPDeviceImpl(UPnPRootDeviceImpl uPnPRootDeviceImpl, String string, SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) {
        Object object;
        this.root_device = uPnPRootDeviceImpl;
        this.device_type = this.getMandatoryField(simpleXMLParserDocumentNode, "DeviceType");
        this.friendly_name = this.getMandatoryField(simpleXMLParserDocumentNode, "FriendlyName");
        this.manufacturer = this.getOptionalField(simpleXMLParserDocumentNode, "manufacturer");
        this.manufacturer_url = this.getOptionalField(simpleXMLParserDocumentNode, "manufacturerURL");
        this.model_description = this.getOptionalField(simpleXMLParserDocumentNode, "modelDescription");
        this.model_name = this.getOptionalField(simpleXMLParserDocumentNode, "modelName");
        this.model_number = this.getOptionalField(simpleXMLParserDocumentNode, "modelNumber");
        this.model_url = this.getOptionalField(simpleXMLParserDocumentNode, "modelURL");
        this.presentation_url = this.getOptionalField(simpleXMLParserDocumentNode, "presentationURL");
        boolean bl = this.device_type.equalsIgnoreCase("urn:schemas-upnp-org:device:WANConnectionDevice:1");
        this.root_device.getUPnP().log(string + this.friendly_name + (bl ? " *" : ""));
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode2 = simpleXMLParserDocumentNode.getChild("ServiceList");
        if (simpleXMLParserDocumentNode2 != null) {
            object = simpleXMLParserDocumentNode2.getChildren();
            for (int i = 0; i < ((SimpleXMLParserDocumentNode[])object).length; ++i) {
                this.services.add(new UPnPServiceImpl(this, string + "  ", (SimpleXMLParserDocumentNode)object[i]));
            }
        }
        if ((object = simpleXMLParserDocumentNode.getChild("DeviceList")) != null) {
            SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = object.getChildren();
            for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
                this.devices.add(new UPnPDeviceImpl(this.root_device, string + "  ", simpleXMLParserDocumentNodeArray[i]));
            }
        }
    }

    public String getAbsoluteURL(String string) {
        return this.root_device.getAbsoluteURL(string);
    }

    public InetAddress getLocalAddress() {
        return this.root_device.getLocalAddress();
    }

    public synchronized void clearRelativeBaseURL() {
        this.root_device.clearRelativeBaseURL();
    }

    public synchronized void restoreRelativeBaseURL() {
        this.root_device.restoreRelativeBaseURL();
    }

    public UPnPImpl getUPnP() {
        return (UPnPImpl)this.root_device.getUPnP();
    }

    public UPnPRootDevice getRootDevice() {
        return this.root_device;
    }

    public String getDeviceType() {
        return this.device_type;
    }

    public String getFriendlyName() {
        return this.friendly_name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getManufacturerURL() {
        return this.manufacturer_url;
    }

    public String getModelDescription() {
        return this.model_description;
    }

    public String getModelName() {
        return this.model_name;
    }

    public String getModelNumber() {
        return this.model_number;
    }

    public String getModelURL() {
        return this.model_url;
    }

    public String getPresentation() {
        return this.presentation_url == null ? null : this.getAbsoluteURL(this.presentation_url);
    }

    public UPnPDevice[] getSubDevices() {
        UPnPDevice[] uPnPDeviceArray = new UPnPDevice[this.devices.size()];
        this.devices.toArray(uPnPDeviceArray);
        return uPnPDeviceArray;
    }

    public UPnPService[] getServices() {
        UPnPService[] uPnPServiceArray = new UPnPService[this.services.size()];
        this.services.toArray(uPnPServiceArray);
        return uPnPServiceArray;
    }

    protected String getOptionalField(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode, String string) {
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode2 = simpleXMLParserDocumentNode.getChild(string);
        if (simpleXMLParserDocumentNode2 == null) {
            return null;
        }
        return simpleXMLParserDocumentNode2.getValue().trim();
    }

    protected String getMandatoryField(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode, String string) {
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode2 = simpleXMLParserDocumentNode.getChild(string);
        if (simpleXMLParserDocumentNode2 == null) {
            this.root_device.getUPnP().log("Mandatory field '" + string + "' is missing");
            return "<missing field '" + string + "'>";
        }
        return simpleXMLParserDocumentNode2.getValue().trim();
    }
}

