/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.upnp.impl;

import com.aelitis.net.natpmp.NatPMPDevice;
import com.aelitis.net.natpmp.upnp.NatPMPUPnP;
import com.aelitis.net.natpmp.upnp.impl.NatPMPUPnPRootDeviceImpl;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPListener;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class NatPMPUPnPImpl
implements NatPMPUPnP {
    private UPnP upnp;
    private NatPMPDevice nat_device;
    private NatPMPUPnPRootDeviceImpl root_device;
    private List listeners = new ArrayList();
    private boolean enabled = true;
    private boolean started;

    public NatPMPUPnPImpl(UPnP uPnP, NatPMPDevice natPMPDevice) {
        this.upnp = uPnP;
        this.nat_device = natPMPDevice;
    }

    protected void start() {
        SimpleTimer.addPeriodicEvent("NATPMP:search", 60000L, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                NatPMPUPnPImpl.this.search();
            }
        });
        this.search();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void search() {
        if (!this.enabled) {
            return;
        }
        if (this.root_device != null) {
            return;
        }
        try {
            boolean bl = this.nat_device.connect();
            if (bl) {
                this.root_device = new NatPMPUPnPRootDeviceImpl(this.upnp, this.nat_device);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        ((UPnPListener)this.listeners.get(i)).rootDeviceFound(this.root_device);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public synchronized void addListener(UPnPListener uPnPListener) {
        this.listeners.add(uPnPListener);
        if (this.root_device == null) {
            if (this.listeners.size() == 1 && !this.started) {
                this.started = true;
                this.start();
            }
        } else {
            uPnPListener.rootDeviceFound(this.root_device);
        }
    }

    public synchronized void removeListener(UPnPListener uPnPListener) {
        this.listeners.remove(uPnPListener);
    }
}

