/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;

public class UPnPPluginService {
    protected UPnPWANConnection connection;
    protected BooleanParameter alert_success;
    protected BooleanParameter grab_ports;
    protected BooleanParameter alert_other_port_param;
    protected BooleanParameter release_mappings;
    protected List<serviceMapping> service_mappings = new ArrayList<serviceMapping>();
    protected AEMonitor this_mon = new AEMonitor("UPnPPluginService");

    protected UPnPPluginService(UPnPWANConnection uPnPWANConnection, UPnPWANConnectionPortMapping[] uPnPWANConnectionPortMappingArray, BooleanParameter booleanParameter, BooleanParameter booleanParameter2, BooleanParameter booleanParameter3, BooleanParameter booleanParameter4) {
        this.connection = uPnPWANConnection;
        this.alert_success = booleanParameter;
        this.grab_ports = booleanParameter2;
        this.alert_other_port_param = booleanParameter3;
        this.release_mappings = booleanParameter4;
        for (int i = 0; i < uPnPWANConnectionPortMappingArray.length; ++i) {
            this.service_mappings.add(new serviceMapping(uPnPWANConnectionPortMappingArray[i]));
        }
    }

    public String getName() {
        return this.connection.getGenericService().getDevice().getRootDevice().getDevice().getFriendlyName();
    }

    public String getInfo() {
        return this.connection.getGenericService().getDevice().getRootDevice().getInfo();
    }

    public String getAddress() {
        return this.connection.getGenericService().getDevice().getRootDevice().getLocation().getHost();
    }

    public int getPort() {
        URL uRL = this.connection.getGenericService().getDevice().getRootDevice().getLocation();
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        return n;
    }

    public String getExternalAddress() {
        try {
            return this.connection.getExternalIPAddress();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public UPnPWANConnection getService() {
        return this.connection;
    }

    protected String getOldDescriptionForPort(int n) {
        return "Azureus UPnP " + n;
    }

    protected String getDescriptionForPort(boolean bl, int n) {
        return "Azureus UPnP " + n + " " + (bl ? "TCP" : "UDP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkMapping(LoggerChannel loggerChannel, UPnPMapping uPnPMapping) {
        block16: {
            Object object;
            Object object2;
            block17: {
                Object object3;
                Object object4;
                block15: {
                    try {
                        this.this_mon.enter();
                        if (uPnPMapping.isEnabled()) {
                            for (int i = 0; i < this.service_mappings.size(); ++i) {
                                object4 = this.service_mappings.get(i);
                                if (!((serviceMapping)object4).getMappings().contains(uPnPMapping) || ((serviceMapping)object4).getPort() == uPnPMapping.getPort()) continue;
                                this.removeMapping(loggerChannel, uPnPMapping, (serviceMapping)object4, false);
                            }
                            object2 = null;
                            object4 = this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
                            break block15;
                        }
                        this.removeMapping(loggerChannel, uPnPMapping, false);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                for (int i = 0; i < this.service_mappings.size(); ++i) {
                    object3 = this.service_mappings.get(i);
                    if (((serviceMapping)object3).isTCP() != uPnPMapping.isTCP() || ((serviceMapping)object3).getPort() != uPnPMapping.getPort()) continue;
                    if (((serviceMapping)object3).getInternalHost().equals(object4)) {
                        ((serviceMapping)object3).addMapping(uPnPMapping);
                        if (!((serviceMapping)object3).getLogged(uPnPMapping)) {
                            ((serviceMapping)object3).setLogged(uPnPMapping);
                            loggerChannel.log("Mapping " + uPnPMapping.getString() + " already established");
                        }
                        Object var9_10 = null;
                        this.this_mon.exit();
                        return;
                    }
                    if (!this.grab_ports.getValue()) {
                        if (!((serviceMapping)object3).getLogged(uPnPMapping)) {
                            ((serviceMapping)object3).setLogged(uPnPMapping);
                            String string = MessageText.getString("upnp.alert.differenthost", new String[]{uPnPMapping.getString(), ((serviceMapping)object3).getInternalHost()});
                            if (this.alert_other_port_param.getValue()) {
                                loggerChannel.logAlertRepeatable(2, string);
                            } else {
                                loggerChannel.log(string);
                            }
                        }
                        Object var9_11 = null;
                        this.this_mon.exit();
                        return;
                    }
                    ((serviceMapping)object3).addMapping(uPnPMapping);
                    object2 = object3;
                }
                try {
                    this.connection.addPortMapping(uPnPMapping.isTCP(), uPnPMapping.getPort(), this.getDescriptionForPort(uPnPMapping.isTCP(), uPnPMapping.getPort()));
                    object = object2 != null ? MessageText.getString("upnp.alert.mappinggrabbed", new String[]{uPnPMapping.getString(), ((serviceMapping)object2).getInternalHost()}) : MessageText.getString("upnp.alert.mappingok", new String[]{uPnPMapping.getString()});
                    loggerChannel.log((String)object);
                    if (this.alert_success.getValue()) {
                        loggerChannel.logAlertRepeatable(1, (String)object);
                    }
                }
                catch (Throwable throwable) {
                    object3 = MessageText.getString("upnp.alert.mappingfailed", new String[]{uPnPMapping.getString()});
                    loggerChannel.log((String)object3, throwable);
                    if (!this.alert_other_port_param.getValue()) break block17;
                    loggerChannel.logAlertRepeatable(3, (String)object3);
                }
            }
            if (object2 == null) {
                object = new serviceMapping(uPnPMapping);
                this.service_mappings.add((serviceMapping)object);
            }
        }
        Object var9_12 = null;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMapping(LoggerChannel loggerChannel, UPnPMapping uPnPMapping, boolean bl) {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.service_mappings.size(); ++i) {
                serviceMapping serviceMapping2 = this.service_mappings.get(i);
                if (serviceMapping2.isTCP() != uPnPMapping.isTCP() || serviceMapping2.getPort() != uPnPMapping.getPort() || !serviceMapping2.getMappings().contains(uPnPMapping)) continue;
                this.removeMapping(loggerChannel, uPnPMapping, serviceMapping2, bl);
                Object var7_6 = null;
                this.this_mon.exit();
                return;
            }
            Object var7_7 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void removeMapping(LoggerChannel loggerChannel, UPnPMapping uPnPMapping, serviceMapping serviceMapping2, boolean bl) {
        if (serviceMapping2.isExternal()) {
            loggerChannel.log("Mapping " + serviceMapping2.getString() + " not removed as not created by Azureus");
        } else {
            int n = 1;
            List list = serviceMapping2.getMappings();
            for (int i = 0; i < list.size(); ++i) {
                UPnPMapping uPnPMapping2 = (UPnPMapping)list.get(i);
                int n2 = uPnPMapping2.getPersistent();
                if (n2 == 1) continue;
                if (n2 == 3) {
                    if (n != 1) continue;
                    n = n2;
                    continue;
                }
                n = 2;
            }
            if (n == 1) {
                int n3 = n = this.release_mappings.getValue() ? 3 : 2;
            }
            if (bl && n == 2) {
                loggerChannel.log("Mapping " + serviceMapping2.getString() + " not removed as mapping is persistent");
            } else {
                String string = serviceMapping2.getString();
                serviceMapping2.removeMapping(uPnPMapping);
                if (serviceMapping2.getMappings().size() == 0) {
                    try {
                        this.connection.deletePortMapping(serviceMapping2.isTCP(), serviceMapping2.getPort());
                        loggerChannel.log("Mapping " + string + " removed");
                    }
                    catch (Throwable throwable) {
                        loggerChannel.log("Mapping " + string + " failed to delete", throwable);
                    }
                    this.service_mappings.remove(serviceMapping2);
                } else {
                    loggerChannel.log("Mapping " + serviceMapping2.getString() + " not removed as interest remains");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public serviceMapping[] getMappings() {
        try {
            this.this_mon.enter();
            serviceMapping[] serviceMappingArray = this.service_mappings.toArray(new serviceMapping[this.service_mappings.size()]);
            Object var3_2 = null;
            this.this_mon.exit();
            return serviceMappingArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public class serviceMapping {
        private List mappings = new ArrayList();
        private boolean tcp;
        private int port;
        private String internal_host;
        private boolean external;
        private List logged_mappings = new ArrayList();

        protected serviceMapping(UPnPWANConnectionPortMapping uPnPWANConnectionPortMapping) {
            this.tcp = uPnPWANConnectionPortMapping.isTCP();
            this.port = uPnPWANConnectionPortMapping.getExternalPort();
            this.internal_host = uPnPWANConnectionPortMapping.getInternalHost();
            String string = uPnPWANConnectionPortMapping.getDescription();
            if (string == null || !string.equalsIgnoreCase(UPnPPluginService.this.getOldDescriptionForPort(this.port)) && !string.equalsIgnoreCase(UPnPPluginService.this.getDescriptionForPort(this.tcp, this.port))) {
                this.external = true;
            }
        }

        protected serviceMapping(UPnPMapping uPnPMapping) {
            this.mappings.add(uPnPMapping);
            this.tcp = uPnPMapping.isTCP();
            this.port = uPnPMapping.getPort();
            this.internal_host = UPnPPluginService.this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
        }

        public boolean isExternal() {
            return this.external;
        }

        protected List getMappings() {
            return this.mappings;
        }

        protected void addMapping(UPnPMapping uPnPMapping) {
            if (!this.mappings.contains(uPnPMapping)) {
                this.mappings.add(uPnPMapping);
            }
        }

        protected void removeMapping(UPnPMapping uPnPMapping) {
            this.mappings.remove(uPnPMapping);
        }

        protected boolean getLogged(UPnPMapping uPnPMapping) {
            return this.logged_mappings.contains(uPnPMapping);
        }

        protected void setLogged(UPnPMapping uPnPMapping) {
            if (!this.logged_mappings.contains(uPnPMapping)) {
                this.logged_mappings.add(uPnPMapping);
            }
        }

        public boolean isTCP() {
            return this.tcp;
        }

        public int getPort() {
            return this.port;
        }

        public String getInternalHost() {
            return this.internal_host;
        }

        public String getString() {
            if (this.mappings.size() == 0) {
                return "<external> (" + (this.isTCP() ? "TCP" : "UDP") + "/" + this.getPort() + ")";
            }
            String string = "";
            for (int i = 0; i < this.mappings.size(); ++i) {
                string = string + (i == 0 ? "" : ",") + ((UPnPMapping)this.mappings.get(i)).getString(this.getPort());
            }
            return string;
        }
    }
}

