/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessageHandler;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyReplyListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginTimeoutException;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginBuddy {
    private static final boolean TRACE = false;
    private static final int CONNECTION_IDLE_TIMEOUT = 300000;
    private static final int CONNECTION_KEEP_ALIVE = 60000;
    private static final int MAX_ACTIVE_CONNECTIONS = 5;
    private static final int MAX_QUEUED_MESSAGES = 256;
    private static final int RT_REQUEST_DATA = 1;
    private static final int RT_REPLY_DATA = 2;
    private static final int RT_REPLY_ERROR = 99;
    private BuddyPlugin plugin;
    private long created_time;
    private int subsystem;
    private boolean authorised;
    private String public_key;
    private String nick_name;
    private List<Long> recent_ygm;
    private int last_status_seq;
    private long post_time;
    private InetAddress ip;
    private int tcp_port;
    private int udp_port;
    private int online_status = 0;
    private int version = 2;
    private boolean online;
    private long last_time_online;
    private long status_check_count;
    private long last_status_check_time;
    private boolean check_active;
    private List<buddyConnection> connections = new ArrayList<buddyConnection>();
    private List<buddyMessage> messages = new ArrayList<buddyMessage>();
    private buddyMessage current_message;
    private int next_connection_id;
    private int next_message_id;
    private boolean ygm_active;
    private boolean ygm_pending;
    private long latest_ygm_time;
    private String last_message_received;
    private Set<Long> offline_seq_set;
    private int message_out_count;
    private int message_in_count;
    private int message_out_bytes;
    private int message_in_bytes;
    private String received_frag_details = "";
    private BuddyPluginBuddyMessageHandler persistent_msg_handler;
    private Map<Object, Object> user_data = new LightHashMap<Object, Object>();
    private boolean keep_alive_outstanding;
    private volatile long last_connect_attempt = SystemTime.getCurrentTime();
    private volatile int consec_connect_fails;
    private long last_auto_reconnect = -1L;
    private Object rss_lock = new Object();
    private Set<String> rss_local_cats;
    private Set<String> rss_remote_cats;
    private Set<String> rss_cats_read;
    private AESemaphore outgoing_connect_sem = new AESemaphore("BPB:outcon", 1);
    private volatile boolean closing;
    private volatile boolean destroyed;

    protected BuddyPluginBuddy(BuddyPlugin buddyPlugin, long l, int n, boolean bl, String string, String string2, int n2, String string3, String string4, int n3, long l2, List<Long> list) {
        this.plugin = buddyPlugin;
        this.created_time = l;
        this.subsystem = n;
        this.authorised = bl;
        this.public_key = string;
        this.nick_name = string2;
        this.version = Math.max(this.version, n2);
        this.rss_local_cats = this.stringToCats(string3);
        this.rss_remote_cats = this.stringToCats(string4);
        this.last_status_seq = n3;
        this.last_time_online = l2;
        this.recent_ygm = list;
        this.persistent_msg_handler = new BuddyPluginBuddyMessageHandler(this, new File(this.plugin.getBuddyConfigDir(), this.public_key));
    }

    protected void setInitialStatus(long l, int n) {
        if (this.last_time_online == 0L && l - this.created_time > 604800000L) {
            this.last_status_check_time = l + (long)RandomUtils.nextInt(300000 * n);
        }
    }

    protected BuddyPlugin getPlugin() {
        return this.plugin;
    }

    public BuddyPluginBuddyMessageHandler getMessageHandler() {
        return this.persistent_msg_handler;
    }

    protected void persistentDispatchPending() {
        this.plugin.persistentDispatchPending(this);
    }

    protected void checkPersistentDispatch() {
        this.persistent_msg_handler.checkPersistentDispatch();
    }

    protected void persistentDispatch() {
        this.persistent_msg_handler.persistentDispatch();
    }

    public Map readConfigFile(File file) {
        return this.plugin.readConfigFile(file);
    }

    public boolean writeConfigFile(File file, Map map) {
        return this.plugin.writeConfigFile(file, map);
    }

    protected long getCreatedTime() {
        return this.created_time;
    }

    public int getSubsystem() {
        return this.subsystem;
    }

    protected void setSubsystem(int n) {
        this.subsystem = n;
    }

    public boolean isAuthorised() {
        return this.authorised;
    }

    protected void setAuthorised(boolean bl) {
        this.authorised = bl;
    }

    public String getPublicKey() {
        return this.public_key;
    }

    protected byte[] getRawPublicKey() {
        return Base32.decode(this.public_key);
    }

    protected String getShortString() {
        return this.public_key.substring(0, 16) + "...";
    }

    public String getNickName() {
        return this.nick_name;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int n) {
        if (this.version < n) {
            this.version = n;
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalAuthorisedRSSCategoriesAsString() {
        Object object = this.rss_lock;
        synchronized (object) {
            return this.catsToString(this.rss_local_cats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLocalAuthorisedRSSCategories() {
        Object object = this.rss_lock;
        synchronized (object) {
            return this.rss_local_cats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalAuthorisedRSSCategory(String string) {
        boolean bl;
        string = this.plugin.normaliseCat(string);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_local_cats == null) {
                this.rss_local_cats = new HashSet<String>();
            }
            if (bl = !this.rss_local_cats.contains(string)) {
                this.rss_local_cats.add(string);
            }
        }
        if (bl) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
            if (this.isConnected()) {
                this.sendKeepAlive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalAuthorisedRSSCategory(String string) {
        boolean bl;
        string = this.plugin.normaliseCat(string);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_local_cats == null) {
                return;
            }
            bl = this.rss_local_cats.remove(string);
        }
        if (bl) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
            if (this.isConnected()) {
                this.sendKeepAlive();
            }
        }
    }

    public void setLocalAuthorisedRSSCategories(String string) {
        this.setLocalAuthorisedRSSCategories(this.stringToCats(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalAuthorisedRSSCategories(Set<String> set) {
        boolean bl;
        this.plugin.normaliseCats(set);
        Object object = this.rss_lock;
        synchronized (object) {
            bl = !this.catsIdentical(set, this.rss_local_cats);
            if (bl) {
                this.rss_local_cats = set;
            }
        }
        if (bl) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
            if (this.isConnected()) {
                this.sendKeepAlive();
            }
        }
    }

    public Set<String> getRemoteAuthorisedRSSCategories() {
        return this.rss_remote_cats;
    }

    public String getRemoteAuthorisedRSSCategoriesAsString() {
        return this.catsToString(this.rss_remote_cats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteAuthorisedRSSCategories(Set<String> set) {
        boolean bl;
        this.plugin.normaliseCats(set);
        Object object = this.rss_lock;
        synchronized (object) {
            bl = !this.catsIdentical(set, this.rss_remote_cats);
            if (bl) {
                this.rss_remote_cats = set;
            }
        }
        if (bl) {
            this.plugin.setConfigDirty();
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalRSSCategoryAuthorised(String string) {
        string = this.plugin.normaliseCat(string);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_local_cats != null) {
                return this.rss_local_cats.contains(string);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteRSSCategoryAuthorised(String string) {
        string = this.plugin.normaliseCat(string);
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_remote_cats != null) {
                return this.rss_remote_cats.contains(string);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localRSSCategoryRead(String string) {
        boolean bl;
        Object object = this.rss_lock;
        synchronized (object) {
            if (this.rss_cats_read == null) {
                this.rss_cats_read = new HashSet<String>();
            }
            bl = this.rss_cats_read.add(string);
        }
        if (bl) {
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalReadCategoriesAsString() {
        Object object = this.rss_lock;
        synchronized (object) {
            return this.catsToString(this.rss_cats_read);
        }
    }

    public URL getSubscriptionURL(String string) {
        String string2 = "azplug:?id=azbuddy&name=Friends&arg=";
        String string3 = "pk=" + this.getPublicKey() + "&cat=" + string;
        try {
            string2 = string2 + URLEncoder.encode(string3, "UTF-8");
            return new URL(string2);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return null;
        }
    }

    public void subscribeToCategory(String string) throws BuddyPluginException {
        AZ3Functions.provider provider2 = AZ3Functions.getProvider();
        if (provider2 == null) {
            throw new BuddyPluginException("AZ3 subsystem not available");
        }
        try {
            provider2.subscribeToRSS(this.getName() + ": " + string, this.getSubscriptionURL(string), 15, false, this.getPublicKey() + ":" + string);
        }
        catch (Throwable throwable) {
            throw new BuddyPluginException("Failed to add subscription", throwable);
        }
    }

    public boolean isSubscribedToCategory(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return string2.equals(this.getPublicKey() + ":" + string);
    }

    protected String catsToString(Set<String> set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        String string = "";
        for (String string2 : set) {
            string = string + (string.length() == 0 ? "" : ",") + string2;
        }
        return string;
    }

    protected boolean catsIdentical(Set<String> set, Set<String> set2) {
        if (set == null && set2 == null) {
            return true;
        }
        if (set == null || set2 == null) {
            return false;
        }
        return ((Object)set).equals(set2);
    }

    protected Set<String> stringToCats(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string2 : stringArray) {
            if ((string2 = string2.trim()).length() <= 0) continue;
            hashSet.add(string2);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    public int getOnlineStatus() {
        return this.online_status;
    }

    protected void setOnlineStatus(int n) {
        if (this.online_status != n) {
            this.online_status = n;
            this.plugin.fireDetailsChanged(this);
        }
    }

    public String getName() {
        if (this.nick_name != null) {
            return this.nick_name;
        }
        return this.getShortString();
    }

    public void remove() {
        this.persistent_msg_handler.destroy();
        this.plugin.removeBuddy(this);
    }

    public InetAddress getIP() {
        return this.ip;
    }

    public InetAddress getAdjustedIP() {
        if (this.ip == null) {
            return null;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.ip, this.tcp_port);
        InetSocketAddress inetSocketAddress2 = AddressUtils.adjustTCPAddress(inetSocketAddress, true);
        if (inetSocketAddress2 != inetSocketAddress) {
            return inetSocketAddress2.getAddress();
        }
        inetSocketAddress = new InetSocketAddress(this.ip, this.udp_port);
        inetSocketAddress2 = AddressUtils.adjustUDPAddress(inetSocketAddress, true);
        if (inetSocketAddress2 != inetSocketAddress) {
            return inetSocketAddress2.getAddress();
        }
        return this.ip;
    }

    public List getAdjustedIPs() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        if (this.ip == null) {
            return arrayList;
        }
        InetAddress inetAddress = this.getAdjustedIP();
        if (inetAddress == this.ip) {
            arrayList.add(this.ip);
        } else {
            List list = AddressUtils.getLANAddresses(inetAddress.getHostAddress());
            for (int i = 0; i < list.size(); ++i) {
                try {
                    arrayList.add(InetAddress.getByName((String)list.get(i)));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    public int getTCPPort() {
        return this.tcp_port;
    }

    public int getUDPPort() {
        return this.udp_port;
    }

    public boolean isOnline(boolean bl) {
        boolean bl2 = this.isConnected();
        if (bl2) {
            return true;
        }
        if (!this.online) {
            return false;
        }
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isIdle() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            return this.connections.size() == 0;
        }
    }

    public long getLastTimeOnline() {
        return this.last_time_online;
    }

    public BuddyPlugin.cryptoResult encrypt(byte[] byArray) throws BuddyPluginException {
        return this.plugin.encrypt(this, byArray);
    }

    public BuddyPlugin.cryptoResult decrypt(byte[] byArray) throws BuddyPluginException {
        return this.plugin.decrypt(this, byArray, this.getName());
    }

    public boolean verify(byte[] byArray, byte[] byArray2) throws BuddyPluginException {
        return this.plugin.verify(this, byArray, byArray2);
    }

    public BuddyPluginBuddyMessage storeMessage(int n, Map map) {
        return this.persistent_msg_handler.storeExplicitMessage(n, map);
    }

    public List<BuddyPluginBuddyMessage> retrieveMessages(int n) {
        return this.persistent_msg_handler.retrieveExplicitMessages(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessagePending() throws BuddyPluginException {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.ygm_active) {
                this.ygm_pending = true;
                return;
            }
            this.ygm_active = true;
        }
        this.plugin.setMessagePending(this, new BuddyPlugin.operationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete() {
                boolean bl;
                BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                synchronized (buddyPluginBuddy) {
                    BuddyPluginBuddy.this.ygm_active = false;
                    bl = BuddyPluginBuddy.this.ygm_pending;
                    BuddyPluginBuddy.this.ygm_pending = false;
                }
                if (bl) {
                    try {
                        BuddyPluginBuddy.this.setMessagePending();
                    }
                    catch (BuddyPluginException buddyPluginException) {
                        BuddyPluginBuddy.this.log("Failed to send YGM", buddyPluginException);
                    }
                }
            }
        });
    }

    public long getLastMessagePending() {
        return this.latest_ygm_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addYGMMarker(long l) {
        Long l2 = new Long(l);
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.recent_ygm == null) {
                this.recent_ygm = new ArrayList<Long>();
            }
            if (this.recent_ygm.contains(l2)) {
                return false;
            }
            this.recent_ygm.add(l2);
            if (this.recent_ygm.size() > 16) {
                this.recent_ygm.remove(0);
            }
            this.latest_ygm_time = SystemTime.getCurrentTime();
        }
        this.plugin.setConfigDirty();
        this.plugin.fireDetailsChanged(this);
        return true;
    }

    protected void setLastMessageReceived(String string) {
        this.last_message_received = string;
        this.plugin.fireDetailsChanged(this);
    }

    public String getLastMessageReceived() {
        return this.last_message_received == null ? "" : this.last_message_received;
    }

    protected List getYGMMarkers() {
        return this.recent_ygm;
    }

    protected int getLastStatusSeq() {
        return this.last_status_seq;
    }

    protected void buddyConnectionEstablished(boolean bl) {
        this.buddyActive();
    }

    protected void buddyMessageSent(int n, boolean bl) {
        ++this.message_out_count;
        this.message_out_bytes += n;
        if (bl) {
            this.buddyActive();
        }
    }

    protected void buddyMessageReceived(int n) {
        ++this.message_in_count;
        this.message_in_bytes += n;
        this.received_frag_details = "";
        this.buddyActive();
    }

    protected void buddyMessageFragmentReceived(int n, int n2) {
        this.received_frag_details = n + "/" + n2;
        this.plugin.fireDetailsChanged(this);
    }

    public String getMessageInFragmentDetails() {
        return this.received_frag_details;
    }

    public int getMessageInCount() {
        return this.message_in_count;
    }

    public int getMessageOutCount() {
        return this.message_out_count;
    }

    public int getBytesInCount() {
        return this.message_in_bytes;
    }

    public int getBytesOutCount() {
        return this.message_out_bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        boolean bl = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            for (int i = 0; i < this.connections.size(); ++i) {
                buddyConnection buddyConnection2 = this.connections.get(i);
                if (!buddyConnection2.isConnected() || buddyConnection2.hasFailed()) continue;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buddyActive() {
        long l = SystemTime.getCurrentTime();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.last_time_online = l;
            this.online = true;
        }
        this.persistentDispatchPending();
        this.plugin.fireDetailsChanged(this);
    }

    public void ping() throws BuddyPluginException {
        this.plugin.checkAvailable();
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("type", new Long(1L));
            this.sendMessage(0, hashMap, 60000, new BuddyPluginBuddyReplyListener(){

                public void replyReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                    BuddyPluginBuddy.this.log("Ping reply received:" + map);
                }

                public void sendFailed(BuddyPluginBuddy buddyPluginBuddy, BuddyPluginException buddyPluginException) {
                    BuddyPluginBuddy.this.log("Ping failed to " + BuddyPluginBuddy.this.getString(), buddyPluginException);
                }
            });
        }
        catch (Throwable throwable) {
            throw new BuddyPluginException("Ping failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCloseRequest(boolean bl) {
        Object object;
        ArrayList<buddyConnection> arrayList = new ArrayList<buddyConnection>();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.closing = true;
            for (int i = 0; i < this.connections.size(); ++i) {
                object = this.connections.get(i);
                if (!((buddyConnection)object).isConnected() || ((buddyConnection)object).hasFailed() || ((buddyConnection)object).isActive()) continue;
                arrayList.add((buddyConnection)object);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            buddyConnection buddyConnection2 = (buddyConnection)arrayList.get(i);
            try {
                object = new HashMap();
                object.put("type", new Long(3L));
                object.put("r", new Long(bl ? 1L : 0L));
                object.put("os", new Long(this.plugin.getCurrentStatusSeq()));
                buddyMessage buddyMessage2 = new buddyMessage(0, (Map)object, 60000);
                buddyMessage2.setListener(new BuddyPluginBuddyReplyListener(){

                    public void replyReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                        BuddyPluginBuddy.this.log("Close reply received:" + map);
                    }

                    public void sendFailed(BuddyPluginBuddy buddyPluginBuddy, BuddyPluginException buddyPluginException) {
                        BuddyPluginBuddy.this.log("Close failed to " + BuddyPluginBuddy.this.getString(), buddyPluginException);
                    }
                });
                buddyConnection2.sendCloseMessage(buddyMessage2);
                continue;
            }
            catch (Throwable throwable) {
                this.log("Close request failed", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivedCloseRequest(Map map) {
        block13: {
            int n;
            ArrayList<buddyConnection> arrayList = new ArrayList<buddyConnection>();
            BuddyPluginBuddy buddyPluginBuddy = this;
            synchronized (buddyPluginBuddy) {
                arrayList.addAll(this.connections);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                ((buddyConnection)arrayList.get(n)).remoteClosing();
            }
            try {
                int n2 = n = (Long)map.get("r") == 1L ? 1 : 0;
                if (n != 0) {
                    this.logMessage("restarting");
                    break block13;
                }
                this.logMessage("going offline");
                boolean bl = false;
                BuddyPluginBuddy buddyPluginBuddy2 = this;
                synchronized (buddyPluginBuddy2) {
                    if (this.offline_seq_set == null) {
                        this.offline_seq_set = new HashSet<Long>();
                    }
                    this.offline_seq_set.add(new Long(this.last_status_seq));
                    this.offline_seq_set.add((Long)map.get("os"));
                    if (this.online) {
                        this.online = false;
                        this.consec_connect_fails = 0;
                        bl = true;
                    }
                }
                if (bl) {
                    this.plugin.fireDetailsChanged(this);
                }
            }
            catch (Throwable throwable) {
                Debug.out("Failed to decode close request", throwable);
            }
        }
    }

    public void sendMessage(final int n, final Map map, final int n2, final BuddyPluginBuddyReplyListener buddyPluginBuddyReplyListener) throws BuddyPluginException {
        this.plugin.checkAvailable();
        boolean bl = false;
        if (this.ip == null) {
            if (this.check_active) {
                bl = true;
            } else if (SystemTime.getCurrentTime() - this.last_status_check_time > 30000L) {
                this.plugin.updateBuddyStatus(this);
                bl = true;
            }
        }
        if (bl) {
            new AEThread2("BuddyPluginBuddy:sendWait", true){

                public void run() {
                    try {
                        long l = SystemTime.getCurrentTime();
                        for (int i = 0; i < 20 && BuddyPluginBuddy.this.ip == null; ++i) {
                            Thread.sleep(1000L);
                        }
                        long l2 = SystemTime.getCurrentTime() - l;
                        int n3 = n2;
                        if (l2 > 0L && n2 > 0 && (n3 = (int)((long)n3 - l2)) <= 0) {
                            buddyPluginBuddyReplyListener.sendFailed(BuddyPluginBuddy.this, new BuddyPluginException("Timeout"));
                            return;
                        }
                        BuddyPluginBuddy.this.sendMessageSupport(map, n, n3, buddyPluginBuddyReplyListener);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof BuddyPluginException) {
                            buddyPluginBuddyReplyListener.sendFailed(BuddyPluginBuddy.this, (BuddyPluginException)throwable);
                        }
                        buddyPluginBuddyReplyListener.sendFailed(BuddyPluginBuddy.this, new BuddyPluginException("Send failed", throwable));
                    }
                }
            }.start();
        } else {
            this.sendMessageSupport(map, n, n2, buddyPluginBuddyReplyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessageSupport(Map map, int n, int n2, BuddyPluginBuddyReplyListener buddyPluginBuddyReplyListener) throws BuddyPluginException {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            bl = this.messages.size() >= 256;
        }
        if (bl) {
            throw new BuddyPluginException("Too many messages queued");
        }
        object = new buddyMessage(n, map, n2);
        BuddyPluginBuddyReplyListener buddyPluginBuddyReplyListener2 = new BuddyPluginBuddyReplyListener((buddyMessage)object, buddyPluginBuddyReplyListener){
            final /* synthetic */ buddyMessage val$message;
            final /* synthetic */ BuddyPluginBuddyReplyListener val$original_listener;
            {
                this.val$message = buddyMessage2;
                this.val$original_listener = buddyPluginBuddyReplyListener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replyReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                try {
                    BuddyPluginBuddy buddyPluginBuddy2 = BuddyPluginBuddy.this;
                    synchronized (buddyPluginBuddy2) {
                        if (BuddyPluginBuddy.this.current_message != this.val$message) {
                            Debug.out("Inconsistent: reply received not for current message");
                        }
                        BuddyPluginBuddy.this.current_message = null;
                    }
                    this.val$original_listener.replyReceived(buddyPluginBuddy, map);
                    Object var6_5 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendFailed(BuddyPluginBuddy buddyPluginBuddy, BuddyPluginException buddyPluginException) {
                BuddyPluginBuddy.this.logMessage("Msg " + this.val$message.getString() + " failed: " + Debug.getNestedExceptionMessage(buddyPluginException));
                try {
                    boolean bl = buddyPluginException instanceof BuddyPluginTimeoutException ? ((BuddyPluginTimeoutException)buddyPluginException).wasActive() : true;
                    if (bl) {
                        BuddyPluginBuddy buddyPluginBuddy2 = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy2) {
                            if (BuddyPluginBuddy.this.current_message != this.val$message) {
                                Debug.out("Inconsistent: error received not for current message");
                            }
                            BuddyPluginBuddy.this.current_message = null;
                        }
                    }
                    long l = SystemTime.getCurrentTime();
                    int n = this.val$message.getRetryCount();
                    if (n < 1 && !this.val$message.timedOut(l)) {
                        this.val$message.setRetry();
                        BuddyPluginBuddy buddyPluginBuddy3 = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy3) {
                            BuddyPluginBuddy.this.messages.add(0, this.val$message);
                        }
                    } else {
                        this.val$original_listener.sendFailed(buddyPluginBuddy, buddyPluginException);
                    }
                    Object var10_10 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    BuddyPluginBuddy.this.dispatchMessage();
                    throw throwable;
                }
            }
        };
        ((buddyMessage)object).setListener(buddyPluginBuddyReplyListener2);
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.messages.add((buddyMessage)object);
            int n3 = this.messages.size();
        }
        this.dispatchMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void dispatchMessage() {
        void var3_15;
        void var3_6;
        buddyConnection buddyConnection2;
        int n;
        buddyConnection buddyConnection3 = null;
        buddyMessage buddyMessage2 = null;
        Object var3_3 = null;
        boolean bl = false;
        Object object = this;
        // MONITORENTER : object
        if (this.current_message != null || this.messages.size() == 0 || this.closing) {
            // MONITOREXIT : object
            return;
        }
        buddyMessage2 = this.current_message = this.messages.remove(0);
        for (n = 0; n < this.connections.size(); ++n) {
            buddyConnection2 = this.connections.get(n);
            if (buddyConnection2.hasFailed()) continue;
            buddyConnection3 = buddyConnection2;
        }
        if (buddyConnection3 == null) {
            if (this.destroyed) {
                BuddyPluginException buddyPluginException = new BuddyPluginException("Friend destroyed");
            } else if (this.connections.size() >= 5) {
                BuddyPluginException buddyPluginException = new BuddyPluginException("Too many active connections");
            }
        }
        // MONITOREXIT : object
        if (var3_6 != null) {
            buddyMessage2.reportFailed((Throwable)var3_6);
            return;
        }
        if (buddyConnection3 == null) {
            try {
                void var3_11;
                void var3_8;
                this.outgoing_connect_sem.reserve();
                object = this;
                // MONITORENTER : object
                if (this.current_message != buddyMessage2) {
                    BuddyPluginException buddyPluginException = new BuddyPluginException("current message no longer active");
                } else if (this.closing) {
                    // MONITOREXIT : object
                    Object var12_23 = null;
                    this.outgoing_connect_sem.release();
                    return;
                }
                if (var3_8 == null) {
                    for (n = 0; n < this.connections.size(); ++n) {
                        buddyConnection2 = this.connections.get(n);
                        if (buddyConnection2.hasFailed()) continue;
                        buddyConnection3 = buddyConnection2;
                    }
                    if (buddyConnection3 == null) {
                        if (this.destroyed) {
                            BuddyPluginException buddyPluginException = new BuddyPluginException("Friend destroyed");
                        } else if (this.connections.size() >= 5) {
                            BuddyPluginException buddyPluginException = new BuddyPluginException("Too many active connections");
                        }
                    }
                }
                // MONITOREXIT : object
                if (buddyConnection3 == null && var3_11 == null) {
                    try {
                        object = this.outgoingConnection();
                        BuddyPluginBuddy buddyPluginBuddy = this;
                        // MONITORENTER : buddyPluginBuddy
                        if (this.current_message != buddyMessage2) {
                            BuddyPluginException buddyPluginException = new BuddyPluginException("current message no longer active");
                            object.close();
                        } else {
                            buddyConnection3 = new buddyConnection((GenericMessageConnection)object, true);
                            bl = this.connections.size() == 0;
                            this.connections.add(buddyConnection3);
                        }
                        // MONITOREXIT : buddyPluginBuddy
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                    }
                }
                Object var12_24 = null;
                this.outgoing_connect_sem.release();
            }
            catch (Throwable throwable) {
                Object var12_25 = null;
                this.outgoing_connect_sem.release();
                throw throwable;
            }
        }
        if (var3_15 != null) {
            buddyMessage2.reportFailed((Throwable)var3_15);
            return;
        }
        try {
            buddyConnection3.sendMessage(buddyMessage2);
        }
        catch (BuddyPluginException buddyPluginException) {
            buddyMessage2.reportFailed(buddyPluginException);
        }
        if (!bl) return;
        this.plugin.setConfigDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(buddyConnection buddyConnection2) {
        int n;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.connections.remove(buddyConnection2);
            n = this.connections.size();
        }
        if (n == 0) {
            this.plugin.setConfigDirty();
        }
        if (n == 0 && buddyConnection2.isConnected() && !buddyConnection2.isClosing() && !buddyConnection2.isRemoteClosing() && this.consec_connect_fails < 3) {
            if (this.consec_connect_fails == 0) {
                long l = SystemTime.getMonotonousTime();
                boolean bl = false;
                BuddyPluginBuddy buddyPluginBuddy2 = this;
                synchronized (buddyPluginBuddy2) {
                    if (this.last_auto_reconnect == -1L || l - this.last_auto_reconnect > 30000L) {
                        this.last_auto_reconnect = l;
                        bl = true;
                    }
                }
                if (bl) {
                    new DelayedEvent("BuddyPluginBuddy:recon", new Random().nextInt(3000), new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            int n;
                            BuddyPluginBuddy buddyPluginBuddy = BuddyPluginBuddy.this;
                            synchronized (buddyPluginBuddy) {
                                n = BuddyPluginBuddy.this.connections.size();
                            }
                            if (BuddyPluginBuddy.this.consec_connect_fails == 0 && n == 0) {
                                BuddyPluginBuddy.this.log("Attempting reconnect after dropped connection");
                                BuddyPluginBuddy.this.sendKeepAlive();
                            }
                        }
                    });
                }
            } else {
                long l = 60000L;
                if (SystemTime.getCurrentTime() - this.last_connect_attempt >= (l <<= Math.min(3, this.consec_connect_fails))) {
                    this.sendKeepAlive();
                }
            }
        }
        this.plugin.fireDetailsChanged(this);
        this.dispatchMessage();
    }

    protected long getLastStatusCheckTime() {
        return this.last_status_check_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean statusCheckActive() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            return this.check_active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean statusCheckStarts() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.check_active) {
                return false;
            }
            this.last_status_check_time = SystemTime.getCurrentTime();
            this.check_active = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statusCheckFailed() {
        boolean bl = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            try {
                if (this.online) {
                    this.online = false;
                    this.consec_connect_fails = 0;
                    bl = true;
                }
                Object var4_3 = null;
                ++this.status_check_count;
                this.check_active = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ++this.status_check_count;
                this.check_active = false;
                throw throwable;
            }
        }
        if (bl) {
            this.plugin.fireDetailsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCachedStatus(InetAddress inetAddress, int n, int n2) {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.ip == null) {
                this.ip = inetAddress;
                this.tcp_port = n;
                this.udp_port = n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statusCheckComplete(long l, InetAddress inetAddress, int n, int n2, String string, int n3, int n4, int n5) {
        boolean bl = false;
        boolean bl2 = false;
        long l2 = SystemTime.getCurrentTime();
        if (l2 < this.last_time_online) {
            this.last_time_online = l2;
        }
        boolean bl3 = this.isConnected();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            block20: {
                try {
                    boolean bl4;
                    boolean bl5;
                    if (this.offline_seq_set != null) {
                        if (this.offline_seq_set.contains(new Long(n4))) {
                            Object var19_14 = null;
                            ++this.status_check_count;
                            this.check_active = false;
                            return;
                        }
                        this.offline_seq_set = null;
                    }
                    boolean bl6 = bl5 = n4 != this.last_status_seq;
                    if (bl5) {
                        this.last_status_seq = n4;
                        this.last_time_online = l2;
                        bl4 = false;
                        bl = true;
                    } else {
                        boolean bl7 = bl4 = l2 - this.last_time_online >= 1800000L;
                    }
                    if (this.online) {
                        if (bl4) {
                            this.online = false;
                            this.consec_connect_fails = 0;
                            bl = true;
                        }
                    } else if (bl5 || !bl4) {
                        this.online = true;
                        bl = true;
                    }
                    this.post_time = l;
                    if (!this.addressesEqual(this.ip, inetAddress) || this.tcp_port != n || this.udp_port != n2 || this.version < n5) {
                        this.ip = inetAddress;
                        this.tcp_port = n;
                        this.udp_port = n2;
                        if (this.version < n5) {
                            this.version = n5;
                        }
                        bl = true;
                    }
                    if (!bl3 && this.online_status != n3) {
                        this.online_status = n3;
                        bl = true;
                    }
                    if (this.plugin.stringsEqual(this.nick_name, string)) break block20;
                    this.nick_name = string;
                    bl2 = true;
                    bl = true;
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    ++this.status_check_count;
                    this.check_active = false;
                    throw throwable;
                }
            }
            Object var19_15 = null;
            ++this.status_check_count;
            {
            }
            this.check_active = false;
        }
        if (bl2) {
            this.plugin.setConfigDirty();
        }
        if (bl) {
            if (this.online) {
                this.persistentDispatchPending();
            }
            this.plugin.fireDetailsChanged(this);
        }
        this.plugin.logMessage(this.getString());
    }

    protected boolean addressesEqual(InetAddress inetAddress, InetAddress inetAddress2) {
        if (inetAddress == null && inetAddress2 == null) {
            return true;
        }
        if (inetAddress == null || inetAddress2 == null) {
            return false;
        }
        return inetAddress.equals(inetAddress2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        Object object;
        boolean bl;
        long l = SystemTime.getCurrentTime();
        ArrayList<buddyMessage> arrayList = null;
        ArrayList<buddyConnection> arrayList2 = null;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            boolean bl2 = bl = this.messages.size() > 0;
            if (bl) {
                Iterator<buddyMessage> iterator = this.messages.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!((buddyMessage)object).timedOut(l)) continue;
                    iterator.remove();
                    if (arrayList == null) {
                        arrayList = new ArrayList<buddyMessage>();
                    }
                    arrayList.add((buddyMessage)object);
                }
            }
            if (this.connections.size() > 0) {
                arrayList2 = new ArrayList<buddyConnection>(this.connections);
            }
        }
        boolean bl3 = false;
        if (arrayList2 == null) {
            if (this.online && this.ip != null && !bl && this.consec_connect_fails < 3) {
                long l2 = 60000L;
                bl3 = l - this.last_connect_attempt >= (l2 <<= Math.min(3, this.consec_connect_fails));
            }
        } else {
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (buddyConnection)arrayList2.get(i);
                boolean bl4 = ((buddyConnection)object).checkTimeout(l);
                if (this.ip == null || bl4 || bl || !((buddyConnection)object).isConnected() || ((buddyConnection)object).isActive() || l - ((buddyConnection)object).getLastActive(l) <= 60000L) continue;
                bl3 = true;
            }
        }
        if (bl3) {
            this.sendKeepAlive();
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ((buddyMessage)arrayList.get(i)).reportFailed(new BuddyPluginTimeoutException("Timeout", false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendKeepAlive() {
        boolean bl = true;
        Object object = this;
        synchronized (object) {
            if (this.keep_alive_outstanding) {
                bl = false;
            } else {
                this.keep_alive_outstanding = true;
            }
        }
        if (bl) {
            try {
                object = new HashMap();
                object.put("type", new Long(1L));
                this.sendMessageSupport((Map)object, 0, 60000, new BuddyPluginBuddyReplyListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void replyReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                        BuddyPluginBuddy buddyPluginBuddy2 = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy2) {
                            BuddyPluginBuddy.this.keep_alive_outstanding = false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void sendFailed(BuddyPluginBuddy buddyPluginBuddy, BuddyPluginException buddyPluginException) {
                        BuddyPluginBuddy buddyPluginBuddy2 = BuddyPluginBuddy.this;
                        synchronized (buddyPluginBuddy2) {
                            BuddyPluginBuddy.this.keep_alive_outstanding = false;
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                BuddyPluginBuddy buddyPluginBuddy = this;
                synchronized (buddyPluginBuddy) {
                    this.keep_alive_outstanding = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionsString() {
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            String string = "";
            for (int i = 0; i < this.connections.size(); ++i) {
                string = string + (string.length() == 0 ? "" : ",") + this.connections.get(i).getString(true);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ArrayList<buddyConnection> arrayList = new ArrayList<buddyConnection>();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            arrayList.addAll(this.connections);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((buddyConnection)arrayList.get(i)).disconnect();
        }
    }

    protected boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        ArrayList<buddyConnection> arrayList = new ArrayList<buddyConnection>();
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            this.destroyed = true;
            arrayList.addAll(this.connections);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((buddyConnection)arrayList.get(i)).close();
        }
    }

    protected void logMessage(String string) {
        this.plugin.logMessage(this.getShortString() + ": " + string);
    }

    protected GenericMessageConnection outgoingConnection() throws BuddyPluginException {
        InetSocketAddress inetSocketAddress;
        int n;
        GenericMessageRegistration genericMessageRegistration = this.plugin.getMessageRegistration();
        if (genericMessageRegistration == null) {
            throw new BuddyPluginException("Messaging system unavailable");
        }
        InetAddress inetAddress = this.getIP();
        if (inetAddress == null) {
            throw new BuddyPluginException("Friend offline (no usable IP address)");
        }
        InetSocketAddress inetSocketAddress2 = null;
        InetSocketAddress inetSocketAddress3 = null;
        int n2 = this.getTCPPort();
        if (n2 > 0) {
            inetSocketAddress2 = new InetSocketAddress(inetAddress, n2);
        }
        if ((n = this.getUDPPort()) > 0) {
            inetSocketAddress3 = new InetSocketAddress(inetAddress, n);
        }
        if ((inetSocketAddress = inetSocketAddress2) == null) {
            inetSocketAddress = inetSocketAddress3;
        }
        if (inetSocketAddress == null) {
            throw new BuddyPluginException("Friend offline (no usable protocols)");
        }
        GenericMessageEndpoint genericMessageEndpoint = genericMessageRegistration.createEndpoint(inetSocketAddress);
        if (inetSocketAddress2 != null) {
            genericMessageEndpoint.addTCP(inetSocketAddress2);
        }
        if (inetSocketAddress3 != null) {
            genericMessageEndpoint.addUDP(inetSocketAddress3);
        }
        GenericMessageConnection genericMessageConnection = null;
        try {
            this.last_connect_attempt = SystemTime.getCurrentTime();
            genericMessageConnection = genericMessageRegistration.createConnection(genericMessageEndpoint);
            this.plugin.addRateLimiters(genericMessageConnection);
            String string = "Friend: Outgoing connection establishment";
            SESecurityManager sESecurityManager = this.plugin.getSecurityManager();
            genericMessageConnection = sESecurityManager.getSTSConnection(genericMessageConnection, sESecurityManager.getPublicKey(1, string), new SEPublicKeyLocator(){

                public boolean accept(Object object, SEPublicKey sEPublicKey) {
                    String string = Base32.encode(sEPublicKey.encodeRawPublicKey());
                    if (string.equals(BuddyPluginBuddy.this.public_key)) {
                        BuddyPluginBuddy.this.consec_connect_fails = 0;
                        return true;
                    }
                    BuddyPluginBuddy.this.log(BuddyPluginBuddy.this.getString() + ": connection failed due to pk mismatch");
                    return false;
                }
            }, string, 2);
            genericMessageConnection.connect();
            return genericMessageConnection;
        }
        catch (Throwable throwable) {
            if (genericMessageConnection != null) {
                ++this.consec_connect_fails;
                try {
                    genericMessageConnection.close();
                }
                catch (Throwable throwable2) {
                    this.log("Failed to close connection", throwable2);
                }
            }
            throw new BuddyPluginException("Failed to send message", throwable);
        }
    }

    protected void incomingConnection(GenericMessageConnection genericMessageConnection) throws BuddyPluginException {
        this.addConnection(genericMessageConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(GenericMessageConnection genericMessageConnection) throws BuddyPluginException {
        buddyConnection buddyConnection2 = new buddyConnection(genericMessageConnection, false);
        boolean bl = false;
        BuddyPluginBuddy buddyPluginBuddy = this;
        synchronized (buddyPluginBuddy) {
            if (this.destroyed) {
                throw new BuddyPluginException("Friend has been destroyed");
            }
            bl = this.connections.size() == 0;
            this.connections.add(buddyConnection2);
        }
        if (bl) {
            this.plugin.setConfigDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object object, Object object2) {
        Map<Object, Object> map = this.user_data;
        synchronized (map) {
            this.user_data.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object object) {
        Map<Object, Object> map = this.user_data;
        synchronized (map) {
            return this.user_data.get(object);
        }
    }

    protected void log(String string) {
        this.plugin.log(string);
    }

    protected void log(String string, Throwable throwable) {
        this.plugin.log(string, throwable);
    }

    public String getString() {
        return "pk=" + this.getShortString() + (this.nick_name == null ? "" : ",nick=" + this.nick_name) + ",ip=" + this.ip + ",tcp=" + this.tcp_port + ",udp=" + this.udp_port + ",online=" + this.online + ",age=" + (SystemTime.getCurrentTime() - this.post_time);
    }

    static interface fragmentHandlerReceiver {
        public void connected();

        public void receive(Map var1);

        public void failed(Throwable var1);
    }

    protected class fragmentHandler
    implements GenericMessageConnectionListener {
        private GenericMessageConnection connection;
        private fragmentHandlerReceiver receiver;
        private int next_fragment_id = 0;
        private fragmentAssembly current_request_frag;
        private fragmentAssembly current_reply_frag;
        private int send_count;
        private int recv_count;

        protected fragmentHandler(GenericMessageConnection genericMessageConnection, fragmentHandlerReceiver fragmentHandlerReceiver2) {
            this.connection = genericMessageConnection;
            this.receiver = fragmentHandlerReceiver2;
        }

        public void start() {
            this.connection.addListener(this);
        }

        public void connected(GenericMessageConnection genericMessageConnection) {
            this.receiver.connected();
        }

        public void failed(GenericMessageConnection genericMessageConnection, Throwable throwable) throws MessageException {
            this.receiver.failed(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void send(Map map, boolean bl, boolean bl2) throws BuddyPluginException {
            byte[] byArray;
            block12: {
                int n;
                int n2;
                int n3;
                int n4;
                block11: {
                    try {
                        byArray = BEncoder.encode(map);
                        n4 = byArray.length;
                        BuddyPluginBuddy.this.plugin.checkMaxMessageSize(n4);
                        n3 = this.connection.getMaximumMessageSize() - 1024;
                        if (n4 > n3) {
                            fragmentHandler fragmentHandler2 = this;
                            synchronized (fragmentHandler2) {
                                n2 = this.next_fragment_id++;
                            }
                            n = 0;
                            break block11;
                        }
                        PooledByteBuffer pooledByteBuffer = BuddyPluginBuddy.this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(byArray);
                        try {
                            this.connection.send(pooledByteBuffer);
                            pooledByteBuffer = null;
                            Object var18_20 = null;
                            if (pooledByteBuffer != null) {
                                pooledByteBuffer.returnToPool();
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var18_21 = null;
                            if (pooledByteBuffer == null) throw throwable;
                            pooledByteBuffer.returnToPool();
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new BuddyPluginException("Send failed", throwable);
                    }
                }
                for (int i = 0; i < n4; ++n, i += n3) {
                    Object var16_18;
                    int n5 = Math.min(n4, i + n3);
                    if (n5 <= i) continue;
                    byte[] byArray2 = new byte[n5 - i];
                    System.arraycopy(byArray, i, byArray2, 0, byArray2.length);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("type", new Long(5L));
                    hashMap.put("f", new Long(n2));
                    hashMap.put("l", new Long(n4));
                    hashMap.put("c", new Long(n3));
                    hashMap.put("i", new Long(n));
                    hashMap.put("q", new Long(bl ? 1L : 0L));
                    hashMap.put("d", byArray2);
                    byte[] byArray3 = BEncoder.encode(hashMap);
                    PooledByteBuffer pooledByteBuffer = BuddyPluginBuddy.this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(byArray3);
                    try {
                        this.connection.send(pooledByteBuffer);
                        pooledByteBuffer = null;
                        var16_18 = null;
                        if (pooledByteBuffer == null) continue;
                        pooledByteBuffer.returnToPool();
                        continue;
                    }
                    catch (Throwable throwable) {
                        var16_18 = null;
                        if (pooledByteBuffer == null) throw throwable;
                        pooledByteBuffer.returnToPool();
                        throw throwable;
                    }
                }
            }
            BuddyPluginBuddy.this.buddyMessageSent(byArray.length, bl2);
            ++this.send_count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(GenericMessageConnection genericMessageConnection, PooledByteBuffer pooledByteBuffer) throws MessageException {
            try {
                block15: {
                    try {
                        if (this.recv_count >= 4 && !BuddyPluginBuddy.this.isAuthorised()) {
                            throw new MessageException("Too many messages received while in unauthorised state");
                        }
                        byte[] byArray = pooledByteBuffer.toByteArray();
                        Map map = BDecoder.decode(byArray);
                        if (((Long)map.get("type")).intValue() == 5) {
                            fragmentAssembly fragmentAssembly2;
                            Map map2 = map;
                            int n = ((Long)map2.get("f")).intValue();
                            int n2 = ((Long)map2.get("l")).intValue();
                            int n3 = ((Long)map2.get("c")).intValue();
                            int n4 = ((Long)map2.get("i")).intValue();
                            boolean bl = ((Long)map2.get("q")).intValue() == 1;
                            byte[] byArray2 = (byte[])map2.get("d");
                            BuddyPluginBuddy.this.plugin.checkMaxMessageSize(n2);
                            if (bl) {
                                if (this.current_request_frag == null) {
                                    this.current_request_frag = new fragmentAssembly(n, n2, n3);
                                }
                                fragmentAssembly2 = this.current_request_frag;
                            } else {
                                if (this.current_reply_frag == null) {
                                    this.current_reply_frag = new fragmentAssembly(n, n2, n3);
                                }
                                fragmentAssembly2 = this.current_reply_frag;
                            }
                            if (fragmentAssembly2.getID() != n) {
                                throw new BuddyPluginException("Fragment receive error: concurrent decode not supported");
                            }
                            if (fragmentAssembly2.receive(n4, byArray2)) {
                                if (bl) {
                                    this.current_request_frag = null;
                                } else {
                                    this.current_reply_frag = null;
                                }
                                BuddyPluginBuddy.this.buddyMessageReceived(n2);
                                ++this.recv_count;
                                this.receiver.receive(BDecoder.decode(fragmentAssembly2.getData()));
                            } else {
                                BuddyPluginBuddy.this.buddyMessageFragmentReceived(fragmentAssembly2.getChunksReceived(), fragmentAssembly2.getTotalChunks());
                            }
                            break block15;
                        }
                        BuddyPluginBuddy.this.buddyMessageReceived(byArray.length);
                        ++this.recv_count;
                        this.receiver.receive(map);
                    }
                    catch (Throwable throwable) {
                        this.receiver.failed(throwable);
                        Object var14_15 = null;
                        pooledByteBuffer.returnToPool();
                    }
                }
                Object var14_14 = null;
                pooledByteBuffer.returnToPool();
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                pooledByteBuffer.returnToPool();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.receiver.failed(new Exception("Connection closed"));
                throw throwable;
            }
        }

        protected String getString() {
            return this.connection.getType();
        }

        protected class fragmentAssembly {
            private int id;
            private byte[] data;
            private int chunk_size;
            private int num_chunks;
            private Set chunks_received = new HashSet();

            protected fragmentAssembly(int n, int n2, int n3) {
                this.id = n;
                this.chunk_size = n3;
                this.data = new byte[n2];
                this.num_chunks = (n2 + this.chunk_size - 1) / this.chunk_size;
            }

            protected int getID() {
                return this.id;
            }

            protected int getChunksReceived() {
                return this.chunks_received.size();
            }

            protected int getTotalChunks() {
                return this.num_chunks;
            }

            protected boolean receive(int n, byte[] byArray) {
                Integer n2 = new Integer(n);
                if (this.chunks_received.contains(n2)) {
                    return false;
                }
                this.chunks_received.add(n2);
                System.arraycopy(byArray, 0, this.data, n * this.chunk_size, byArray.length);
                return this.chunks_received.size() == this.num_chunks;
            }

            protected byte[] getData() {
                return this.data;
            }
        }
    }

    protected class buddyConnection
    implements fragmentHandlerReceiver {
        private fragmentHandler fragment_handler;
        private int connection_id;
        private boolean outgoing;
        private String dir_str;
        private volatile buddyMessage active_message;
        private volatile boolean connected;
        private volatile boolean closing;
        private volatile boolean remote_closing;
        private volatile boolean failed;
        private long last_active = SystemTime.getCurrentTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected buddyConnection(GenericMessageConnection genericMessageConnection, boolean bl) {
            this.fragment_handler = new fragmentHandler(genericMessageConnection, this);
            this.outgoing = bl;
            BuddyPluginBuddy buddyPluginBuddy2 = BuddyPluginBuddy.this;
            synchronized (buddyPluginBuddy2) {
                this.connection_id = BuddyPluginBuddy.this.next_connection_id++;
            }
            String string = this.dir_str = this.outgoing ? "Outgoing" : "Incoming";
            if (!this.outgoing) {
                this.connected = true;
                BuddyPluginBuddy.this.buddyConnectionEstablished(false);
            }
            this.fragment_handler.start();
        }

        protected boolean isConnected() {
            return this.connected;
        }

        protected boolean hasFailed() {
            return this.failed;
        }

        protected boolean isOutgoing() {
            return this.outgoing;
        }

        protected long getLastActive(long l) {
            if (l < this.last_active) {
                this.last_active = l;
            }
            return this.last_active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendMessage(buddyMessage buddyMessage2) throws BuddyPluginException {
            BuddyPluginException buddyPluginException = null;
            buddyMessage buddyMessage3 = null;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                if (BuddyPluginBuddy.this.isClosing()) {
                    throw new BuddyPluginException("Close in progress");
                }
                if (this.active_message != null) {
                    Debug.out("Inconsistent: active message already set");
                    buddyPluginException = new BuddyPluginException("Inconsistent state");
                } else {
                    if (this.failed || this.closing) {
                        throw new BuddyPluginException("Connection failed");
                    }
                    this.active_message = buddyMessage2;
                    if (this.connected) {
                        buddyMessage3 = this.active_message;
                    }
                }
            }
            if (buddyPluginException != null) {
                this.failed(buddyPluginException);
                throw buddyPluginException;
            }
            if (buddyMessage3 != null) {
                this.send(buddyMessage3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendCloseMessage(buddyMessage buddyMessage2) {
            boolean bl;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                bl = this.active_message == null && this.connected && !this.failed && !this.closing;
            }
            if (bl) {
                this.send(buddyMessage2);
            }
        }

        public boolean isActive() {
            return this.active_message != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connected() {
            buddyMessage buddyMessage2 = null;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                this.last_active = SystemTime.getCurrentTime();
                this.connected = true;
                buddyMessage2 = this.active_message;
            }
            BuddyPluginBuddy.this.buddyConnectionEstablished(true);
            if (buddyMessage2 != null) {
                this.send(buddyMessage2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkTimeout(long l) {
            buddyMessage buddyMessage2 = null;
            boolean bl = false;
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                if (this.active_message != null && this.active_message.timedOut(l)) {
                    buddyMessage2 = this.active_message;
                    this.active_message = null;
                }
                if (l < this.last_active) {
                    this.last_active = l;
                }
                if (l - this.last_active > 300000L) {
                    bl = true;
                }
            }
            if (buddyMessage2 != null) {
                buddyMessage2.reportFailed(new BuddyPluginTimeoutException("Timeout", true));
            }
            if (bl) {
                this.close();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void send(buddyMessage buddyMessage2) {
            Map map = buddyMessage2.getRequest();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(1L));
            hashMap.put("req", map);
            hashMap.put("ss", new Long(buddyMessage2.getSubsystem()));
            hashMap.put("id", new Long(buddyMessage2.getID()));
            hashMap.put("oz", new Long(BuddyPluginBuddy.this.plugin.getOnlineStatus()));
            hashMap.put("v", new Long(2L));
            String string = BuddyPluginBuddy.this.getLocalAuthorisedRSSCategoriesAsString();
            if (string != null) {
                hashMap.put("cat", string);
            }
            try {
                this.fragment_handler.send(hashMap, true, true);
                buddyConnection buddyConnection2 = this;
                synchronized (buddyConnection2) {
                    this.last_active = SystemTime.getCurrentTime();
                }
            }
            catch (BuddyPluginException buddyPluginException) {
                try {
                    this.failed(buddyPluginException);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Map map) {
            block26: {
                buddyConnection buddyConnection2 = this;
                synchronized (buddyConnection2) {
                    this.last_active = SystemTime.getCurrentTime();
                }
                try {
                    buddyMessage buddyMessage2;
                    byte[] byArray;
                    Long l;
                    int n = ((Long)map.get("type")).intValue();
                    Long l2 = (Long)map.get("oz");
                    if (l2 != null) {
                        BuddyPluginBuddy.this.setOnlineStatus(l2.intValue());
                    }
                    if ((l = (Long)map.get("v")) != null) {
                        BuddyPluginBuddy.this.setVersion(l.intValue());
                    }
                    if ((byArray = (byte[])map.get("cat")) == null) {
                        BuddyPluginBuddy.this.setRemoteAuthorisedRSSCategories(null);
                    } else {
                        BuddyPluginBuddy.this.setRemoteAuthorisedRSSCategories(BuddyPluginBuddy.this.stringToCats(new String(byArray, "UTF-8")));
                    }
                    if (n == 1) {
                        int n2;
                        Map<String, String> map2;
                        Long l3 = (Long)map.get("ss");
                        Map map3 = (Map)map.get("req");
                        String string = null;
                        if (map3 == null || l3 == null) {
                            map2 = null;
                        } else {
                            try {
                                map2 = BuddyPluginBuddy.this.plugin.requestReceived(BuddyPluginBuddy.this, l3.intValue(), map3);
                            }
                            catch (Throwable throwable) {
                                string = Debug.getNestedExceptionMessage(throwable);
                                map2 = null;
                            }
                        }
                        if (map2 == null) {
                            n2 = 99;
                            map2 = new HashMap<String, String>();
                            map2.put("error", string == null ? "No handlers available to process request" : string);
                        } else {
                            n2 = 2;
                        }
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("ss", l3);
                        hashMap.put("type", new Long(n2));
                        hashMap.put("id", map.get("id"));
                        hashMap.put("oz", new Long(BuddyPluginBuddy.this.plugin.getOnlineStatus()));
                        String string2 = BuddyPluginBuddy.this.getLocalAuthorisedRSSCategoriesAsString();
                        if (string2 != null) {
                            hashMap.put("cat", string2);
                        }
                        hashMap.put("rep", map2);
                        this.fragment_handler.send(hashMap, false, false);
                        break block26;
                    }
                    if (n != 2 && n != 99) break block26;
                    long l4 = (Long)map.get("id");
                    Object object = this;
                    synchronized (object) {
                        if (this.active_message != null && (long)this.active_message.getID() == l4) {
                            buddyMessage2 = this.active_message;
                            this.active_message = null;
                        } else {
                            buddyMessage2 = null;
                        }
                    }
                    object = (Map)map.get("rep");
                    if (buddyMessage2 == null) {
                        BuddyPluginBuddy.this.logMessage("reply discarded as no matching request: " + object);
                    } else if (n == 99) {
                        buddyMessage2.setDontRetry();
                        buddyMessage2.reportFailed(new BuddyPluginException(new String((byte[])object.get("error"))));
                    } else {
                        buddyMessage2.reportComplete((Map)object);
                    }
                }
                catch (Throwable throwable) {
                    this.failed(throwable);
                }
            }
        }

        protected void close() {
            this.closing = true;
            this.failed(new BuddyPluginException("Closing"));
        }

        protected boolean isClosing() {
            return this.closing;
        }

        protected void remoteClosing() {
            this.remote_closing = true;
        }

        protected boolean isRemoteClosing() {
            return this.remote_closing;
        }

        protected void disconnect() {
            this.fragment_handler.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable throwable) {
            buddyMessage buddyMessage2 = null;
            if (!this.connected && this.outgoing) {
                BuddyPluginBuddy.this.consec_connect_fails++;
            }
            buddyConnection buddyConnection2 = this;
            synchronized (buddyConnection2) {
                if (this.failed) {
                    return;
                }
                this.failed = true;
                buddyMessage2 = this.active_message;
                this.active_message = null;
            }
            BuddyPluginBuddy.this.logMessage("Con " + this.getString() + " failed: " + Debug.getNestedExceptionMessage(throwable));
            try {
                if (!this.closing) {
                    // empty if block
                }
                this.fragment_handler.close();
                Object var6_5 = null;
                BuddyPluginBuddy.this.removeConnection(this);
                if (buddyMessage2 != null) {
                    buddyMessage2.reportFailed(throwable);
                }
            }
            catch (Throwable throwable2) {
                Object var6_6 = null;
                BuddyPluginBuddy.this.removeConnection(this);
                if (buddyMessage2 != null) {
                    buddyMessage2.reportFailed(throwable);
                }
                throw throwable2;
            }
        }

        protected String getString() {
            return this.getString(false);
        }

        protected String getString(boolean bl) {
            if (bl) {
                return this.fragment_handler.getString();
            }
            return "id=" + this.connection_id + ",dir=" + (this.outgoing ? "out" : "in");
        }
    }

    protected class buddyMessage {
        private int message_id;
        private Map request;
        private int subsystem;
        private BuddyPluginBuddyReplyListener listener;
        private int timeout_millis;
        private long queue_time = SystemTime.getCurrentTime();
        private boolean timed_out;
        private int retry_count;
        private boolean complete;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected buddyMessage(int n, Map map, int n2) {
            BuddyPluginBuddy buddyPluginBuddy2 = BuddyPluginBuddy.this;
            synchronized (buddyPluginBuddy2) {
                this.message_id = BuddyPluginBuddy.this.next_message_id++;
            }
            this.request = map;
            this.subsystem = n;
            this.timeout_millis = n2;
        }

        protected void setListener(BuddyPluginBuddyReplyListener buddyPluginBuddyReplyListener) {
            this.listener = buddyPluginBuddyReplyListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int getRetryCount() {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                return this.retry_count;
            }
        }

        protected void setDontRetry() {
            this.retry_count = 99;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setRetry() {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                ++this.retry_count;
                this.complete = false;
                this.timed_out = false;
            }
        }

        protected boolean timedOut(long l) {
            if (this.timed_out) {
                return true;
            }
            if (l < this.queue_time) {
                this.queue_time = l;
                return false;
            }
            this.timed_out = l - this.queue_time >= (long)this.timeout_millis;
            return this.timed_out;
        }

        protected Map getRequest() {
            return this.request;
        }

        protected int getSubsystem() {
            return this.subsystem;
        }

        protected int getID() {
            return this.message_id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reportComplete(Map map) {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                if (this.complete) {
                    return;
                }
                this.complete = true;
            }
            try {
                this.listener.replyReceived(BuddyPluginBuddy.this, map);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reportFailed(Throwable throwable) {
            buddyMessage buddyMessage2 = this;
            synchronized (buddyMessage2) {
                if (this.complete) {
                    return;
                }
                this.complete = true;
            }
            try {
                if (throwable instanceof BuddyPluginException) {
                    this.listener.sendFailed(BuddyPluginBuddy.this, (BuddyPluginException)throwable);
                } else {
                    this.listener.sendFailed(BuddyPluginBuddy.this, new BuddyPluginException("", throwable));
                }
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
            }
        }

        protected String getString() {
            return "id=" + this.message_id + ",ss=" + this.subsystem + (this.retry_count == 0 ? "" : ",retry=" + this.retry_count);
        }
    }
}

