/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.webseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderRange;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderWebSeed
extends ExternalSeedReaderImpl {
    private URL url;
    private int port;
    private String url_prefix;
    private boolean supports_503;

    protected ExternalSeedReaderWebSeed(ExternalSeedPlugin externalSeedPlugin, Torrent torrent, URL uRL, Map map) {
        super(externalSeedPlugin, torrent, uRL.getHost(), map);
        this.supports_503 = this.getBooleanParam(map, "supports_503", true);
        this.url = uRL;
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        try {
            String string = URLEncoder.encode(new String(torrent.getHash(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            this.url_prefix = this.url.toString() + "?info_hash=" + string;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public boolean sameAs(ExternalSeedReader externalSeedReader) {
        if (externalSeedReader instanceof ExternalSeedReaderWebSeed) {
            return this.url.toString().equals(((ExternalSeedReaderWebSeed)externalSeedReader).url.toString());
        }
        return false;
    }

    public String getName() {
        return "WS: " + this.url;
    }

    public URL getURL() {
        return this.url;
    }

    public int getPort() {
        return this.port;
    }

    protected int getPieceGroupSize() {
        return 1;
    }

    protected boolean getRequestCanSpanPieces() {
        return false;
    }

    protected void readData(int n, int n2, int n3, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener) throws ExternalSeedException {
        long l = n2 + n3 - 1;
        String string = this.url_prefix + "&piece=" + n + "&ranges=" + n2 + "-" + l;
        this.setReconnectDelay(30000, false);
        ExternalSeedHTTPDownloader externalSeedHTTPDownloader = null;
        try {
            externalSeedHTTPDownloader = new ExternalSeedHTTPDownloaderRange(new URL(string), this.getUserAgent());
            if (this.supports_503) {
                externalSeedHTTPDownloader.downloadSocket(n3, externalSeedHTTPDownloaderListener, this.isTransient());
            } else {
                externalSeedHTTPDownloader.download(n3, externalSeedHTTPDownloaderListener, this.isTransient());
            }
        }
        catch (ExternalSeedException externalSeedException) {
            if (externalSeedHTTPDownloader.getLastResponse() == 503 && externalSeedHTTPDownloader.getLast503RetrySecs() >= 0) {
                int n4 = externalSeedHTTPDownloader.getLast503RetrySecs();
                this.setReconnectDelay(n4 * 1000, true);
                throw new ExternalSeedException("Server temporarily unavailable, retrying in " + n4 + " seconds");
            }
            throw externalSeedException;
        }
        catch (MalformedURLException malformedURLException) {
            throw new ExternalSeedException("URL encode fails", malformedURLException);
        }
    }
}

