/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTPluginStorageManager
implements DHTStorageAdapter {
    private static final String pub_exp = "10001";
    private static final String modulus = "b8a440c76405b2175a24c86d70f2c71929673a31045791d8bd84220a48729998900d227b560e88357074fa534ccccc6944729bfdda5413622f068e7926176a8afc8b75d4ba6cde760096624415b544f73677e8093ddba46723cb973b4d55f61c2003b73f52582894c018e141e8d010bb615cdbbfaeb97a7af6ce1a5a20a62994da81bde6487e8a39e66c8df0cfd9d763c2da4729cbf54278ea4912169edb0a33";
    private static final long ADDRESS_EXPIRY = 604800000L;
    private static final int DIV_WIDTH = 10;
    private static final int DIV_FRAG_GET_SIZE = 2;
    private static final long DIV_EXPIRY_MIN = 172800000L;
    private static final long DIV_EXPIRY_RAND = 86400000L;
    private static final long KEY_BLOCK_TIMEOUT_SECS = 604800L;
    public static final int LOCAL_DIVERSIFICATION_SIZE_LIMIT = 16384;
    public static final int LOCAL_DIVERSIFICATION_ENTRIES_LIMIT = 2048;
    public static final int LOCAL_DIVERSIFICATION_READS_PER_MIN_SAMPLES = 3;
    public static final int LOCAL_DIVERSIFICATION_READS_PER_MIN = 30;
    public static final int MAX_STORAGE_KEYS = 65536;
    private int network;
    private DHTLogger log;
    private File data_dir;
    private AEMonitor address_mon = new AEMonitor("DHTPluginStorageManager:address");
    private AEMonitor contact_mon = new AEMonitor("DHTPluginStorageManager:contact");
    private AEMonitor storage_mon = new AEMonitor("DHTPluginStorageManager:storage");
    private AEMonitor version_mon = new AEMonitor("DHTPluginStorageManager:version");
    private AEMonitor key_block_mon = new AEMonitor("DHTPluginStorageManager:block");
    private Map version_map = new HashMap();
    private Map recent_addresses = new HashMap();
    private Map remote_diversifications = new HashMap();
    private Map local_storage_keys = new HashMap();
    private int remote_freq_div_count;
    private int remote_size_div_count;
    private volatile ByteArrayHashMap key_block_map_cow = new ByteArrayHashMap();
    private volatile DHTStorageBlock[] key_blocks_direct_cow = new DHTStorageBlock[0];
    private BloomFilter kb_verify_fail_bloom;
    private long kb_verify_fail_bloom_create_time;
    private long suspend_divs_until;
    private static RSAPublicKey key_block_public_key;

    public DHTPluginStorageManager(int n, DHTLogger dHTLogger, File file) {
        this.network = n;
        this.log = dHTLogger;
        this.data_dir = file;
        if (this.network == 1) {
            long l;
            String string = "dht.plugin.sm.hack.kill.div.2.v";
            String string2 = "dht.plugin.sm.hack.kill.div.2";
            long l2 = COConfigurationManager.getLongParameter(string, 0L);
            if (l2 < 6L) {
                l = 0L;
                COConfigurationManager.setParameter(string, 6);
            } else {
                l = COConfigurationManager.getLongParameter(string2, 0L);
            }
            long l3 = SystemTime.getCurrentTime();
            if (l == 0L) {
                l = l3;
                COConfigurationManager.setParameter(string2, l);
            }
            this.suspend_divs_until = l + 259200000L;
            if (this.suspendDivs()) {
                this.writeMapToFile(new HashMap(), "diverse");
            } else {
                this.suspend_divs_until = 0L;
            }
        }
        FileUtil.mkdirs(this.data_dir);
        this.readRecentAddresses();
        this.readDiversifications();
        this.readVersionData();
        this.readKeyBlocks();
    }

    public int getNetwork() {
        return this.network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importContacts(DHT dHT) {
        try {
            try {
                this.contact_mon.enter();
                File file = new File(this.data_dir, "contacts.dat");
                if (!file.exists()) {
                    file = new File(this.data_dir, "contacts.saving");
                }
                if (file.exists()) {
                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                    try {
                        dHT.importState(dataInputStream);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        dataInputStream.close();
                        throw throwable;
                    }
                    dataInputStream.close();
                    {
                    }
                }
                Object var7_8 = null;
                this.contact_mon.exit();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var7_9 = null;
                this.contact_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.contact_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportContacts(DHT dHT) {
        try {
            try {
                block9: {
                    this.contact_mon.enter();
                    File file = new File(this.data_dir, "contacts.saving");
                    File file2 = new File(this.data_dir, "contacts.dat");
                    file.delete();
                    FilterOutputStream filterOutputStream = null;
                    boolean bl = false;
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        filterOutputStream = new DataOutputStream(fileOutputStream);
                        dHT.exportState((DataOutputStream)filterOutputStream, 32);
                        ((DataOutputStream)filterOutputStream).flush();
                        fileOutputStream.getFD().sync();
                        bl = true;
                        Object var8_8 = null;
                        if (filterOutputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                            if (bl) {
                                file2.delete();
                                file.renameTo(file2);
                            }
                        }
                        throw throwable;
                    }
                    filterOutputStream.close();
                    if (bl) {
                        file2.delete();
                        file.renameTo(file2);
                    }
                }
                Object var10_11 = null;
                this.contact_mon.exit();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var10_12 = null;
                this.contact_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.contact_mon.exit();
            throw throwable;
        }
        this.writeDiversifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecentAddresses() {
        try {
            this.address_mon.enter();
            this.recent_addresses = this.readMapFromFile("addresses");
            Object var2_1 = null;
            this.address_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.address_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRecentAddresses() {
        try {
            try {
                this.address_mon.enter();
                Iterator iterator = this.recent_addresses.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (string.equals("most_recent")) continue;
                    Long l = (Long)this.recent_addresses.get(string);
                    if (SystemTime.getCurrentTime() - l <= 604800000L) continue;
                    iterator.remove();
                }
                this.writeMapToFile(this.recent_addresses, "addresses");
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var5_6 = null;
                this.address_mon.exit();
            }
            Object var5_5 = null;
            this.address_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.address_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordCurrentAddress(String string) {
        try {
            this.address_mon.enter();
            this.recent_addresses.put(string, new Long(SystemTime.getCurrentTime()));
            this.recent_addresses.put("most_recent", string.getBytes());
            this.writeRecentAddresses();
            Object var3_2 = null;
            this.address_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.address_mon.exit();
            throw throwable;
        }
    }

    protected String getMostRecentAddress() {
        byte[] byArray = (byte[])this.recent_addresses.get("most_recent");
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRecentAddress(String string) {
        block3: {
            try {
                this.address_mon.enter();
                if (!this.recent_addresses.containsKey(string)) break block3;
                boolean bl = true;
                Object var5_4 = null;
                this.address_mon.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.address_mon.exit();
                throw throwable;
            }
        }
        String string2 = this.getMostRecentAddress();
        boolean bl = string2 != null && string2.equals(string);
        Object var5_5 = null;
        this.address_mon.exit();
        return bl;
    }

    protected void localContactChanged(DHTTransportContact dHTTransportContact) {
        this.purgeDirectKeyBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map readMapFromFile(String string) {
        try {
            Map map;
            File file = new File(this.data_dir, string + ".dat");
            if (!file.exists()) {
                file = new File(this.data_dir, string + ".saving");
            }
            if (!file.exists()) return new HashMap();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                map = BDecoder.decode(bufferedInputStream);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                bufferedInputStream.close();
                throw throwable;
            }
            bufferedInputStream.close();
            return map;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMapToFile(Map map, String string) {
        block8: {
            try {
                File file = new File(this.data_dir, string + ".saving");
                File file2 = new File(this.data_dir, string + ".dat");
                file.delete();
                if (map.size() == 0) {
                    file2.delete();
                    break block8;
                }
                FileOutputStream fileOutputStream = null;
                boolean bl = false;
                try {
                    byte[] byArray = BEncoder.encode(map);
                    fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                    fileOutputStream.flush();
                    fileOutputStream.getFD().sync();
                    fileOutputStream.close();
                    bl = true;
                    Object var9_9 = null;
                    if (fileOutputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        if (bl) {
                            file2.delete();
                            file.renameTo(file2);
                        }
                    }
                    throw throwable;
                }
                fileOutputStream.close();
                if (bl) {
                    file2.delete();
                    file.renameTo(file2);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readVersionData() {
        try {
            this.version_mon.enter();
            this.version_map = this.readMapFromFile("version");
            Object var2_1 = null;
            this.version_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.version_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeVersionData() {
        try {
            this.version_mon.enter();
            this.writeMapToFile(this.version_map, "version");
            Object var2_1 = null;
            this.version_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.version_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextValueVersions(int n) {
        try {
            int n2;
            this.version_mon.enter();
            Long l = (Long)this.version_map.get("next");
            int n3 = (int)(SystemTime.getCurrentTime() / 1000L);
            if (l == null) {
                n2 = n3;
            } else {
                n2 = l.intValue();
                if (n2 < n3) {
                    n2 = n3;
                }
            }
            this.version_map.put("next", new Long(n2 + n));
            this.writeVersionData();
            int n4 = n2;
            Object var7_6 = null;
            this.version_mon.exit();
            return n4;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.version_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTStorageKey keyCreated(HashWrapper hashWrapper, boolean bl) {
        try {
            this.storage_mon.enter();
            storageKey storageKey2 = this.getStorageKey(hashWrapper);
            Object var5_4 = null;
            this.storage_mon.exit();
            return storageKey2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyDeleted(DHTStorageKey dHTStorageKey) {
        try {
            this.storage_mon.enter();
            this.deleteStorageKey((storageKey)dHTStorageKey);
            Object var3_2 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyCount() {
        try {
            this.storage_mon.enter();
            int n = this.local_storage_keys.size();
            Object var3_2 = null;
            this.storage_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyRead(DHTStorageKey dHTStorageKey, DHTTransportContact dHTTransportContact) {
        try {
            this.storage_mon.enter();
            ((storageKey)dHTStorageKey).read(dHTTransportContact);
            Object var4_3 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    public void serialiseStats(storageKey storageKey2, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(storageKey2.getEntryCount());
        dataOutputStream.writeInt(storageKey2.getSize());
        dataOutputStream.writeInt(storageKey2.getReadsPerMinute());
        dataOutputStream.writeByte(storageKey2.getDiversificationType());
    }

    public DHTStorageKeyStats deserialiseStats(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        final int n = dataInputStream.readInt();
        final int n2 = dataInputStream.readInt();
        final int n3 = dataInputStream.readInt();
        final byte by2 = dataInputStream.readByte();
        return new DHTStorageKeyStats(){

            public int getEntryCount() {
                return n;
            }

            public int getSize() {
                return n2;
            }

            public int getReadsPerMinute() {
                return n3;
            }

            public byte getDiversification() {
                return by2;
            }

            public String getString() {
                return "entries=" + this.getEntryCount() + ",size=" + this.getSize() + ",rpm=" + this.getReadsPerMinute() + ",div=" + this.getDiversification();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueAdded(DHTStorageKey dHTStorageKey, DHTTransportValue dHTTransportValue) {
        try {
            this.storage_mon.enter();
            ((storageKey)dHTStorageKey).valueChanged(1, dHTTransportValue.getValue().length);
            Object var4_3 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUpdated(DHTStorageKey dHTStorageKey, DHTTransportValue dHTTransportValue, DHTTransportValue dHTTransportValue2) {
        try {
            this.storage_mon.enter();
            ((storageKey)dHTStorageKey).valueChanged(0, dHTTransportValue2.getValue().length - dHTTransportValue.getValue().length);
            Object var5_4 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueDeleted(DHTStorageKey dHTStorageKey, DHTTransportValue dHTTransportValue) {
        try {
            this.storage_mon.enter();
            ((storageKey)dHTStorageKey).valueChanged(-1, -dHTTransportValue.getValue().length);
            Object var4_3 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDiversified(byte[] byArray) {
        HashWrapper hashWrapper = new HashWrapper(byArray);
        try {
            this.storage_mon.enter();
            boolean bl = this.lookupDiversification(hashWrapper) != null;
            Object var5_4 = null;
            this.storage_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getExistingDiversification(byte[] byArray, boolean bl, boolean bl2, int n) {
        if (this.suspendDivs()) {
            return new byte[][]{byArray};
        }
        HashWrapper hashWrapper = new HashWrapper(byArray);
        try {
            Object object;
            this.storage_mon.enter();
            byte[][] byArray2 = this.followDivChain(hashWrapper, bl, bl2, n);
            if (byArray2.length > 0 && !Arrays.equals(byArray2[0], byArray)) {
                object = "";
                for (int i = 0; i < byArray2.length; ++i) {
                    object = (String)object + (i == 0 ? "" : ",") + DHTLog.getString2(byArray2[i]);
                }
                this.log.log("SM: get div: " + DHTLog.getString2(byArray) + ", put = " + bl + ", exh = " + bl2 + " -> " + (String)object);
            }
            object = byArray2;
            Object var10_9 = null;
            this.storage_mon.exit();
            return object;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] createNewDiversification(String string, DHTTransportContact dHTTransportContact, byte[] byArray, boolean bl, byte by, boolean bl2, int n) {
        if (this.suspendDivs() && bl) {
            return new byte[0][];
        }
        HashWrapper hashWrapper = new HashWrapper(byArray);
        try {
            this.storage_mon.enter();
            diversification diversification2 = this.lookupDiversification(hashWrapper);
            boolean bl3 = false;
            if (diversification2 == null) {
                diversification2 = this.createDiversification(hashWrapper, by);
                bl3 = true;
            }
            byte[][] byArray2 = this.followDivChain(hashWrapper, bl, bl2, n);
            String string2 = "";
            for (int i = 0; i < byArray2.length; ++i) {
                string2 = string2 + (i == 0 ? "" : ",") + DHTLog.getString2(byArray2[i]);
            }
            this.log.log("SM: create div: " + DHTLog.getString2(byArray) + ", new=" + bl3 + ", put = " + bl + ", exh=" + bl2 + ", type=" + DHT.DT_STRINGS[by] + " -> " + string2 + ", cause=" + (dHTTransportContact == null ? "<unknown>" : dHTTransportContact.getString()) + ", desc=" + string);
            byte[][] byArray3 = byArray2;
            Object var15_15 = null;
            this.storage_mon.exit();
            return byArray3;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    protected byte[][] followDivChain(HashWrapper hashWrapper, boolean bl, boolean bl2, int n) {
        List list = new ArrayList<HashWrapper>();
        list.add(hashWrapper);
        list = this.followDivChainSupport(list, bl, 0, bl2, new ArrayList(), n);
        byte[][] byArrayArray = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            byArrayArray[i] = ((HashWrapper)list.get(i)).getBytes();
        }
        return byArrayArray;
    }

    protected List followDivChainSupport(List list, boolean bl, int n, boolean bl2, List list2, int n2) {
        ArrayList<HashWrapper> arrayList = new ArrayList<HashWrapper>();
        if (n < n2) {
            for (int i = 0; i < list.size(); ++i) {
                HashWrapper hashWrapper = (HashWrapper)list.get(i);
                diversification diversification2 = this.lookupDiversification(hashWrapper);
                if (diversification2 == null) {
                    if (arrayList.contains(hashWrapper)) continue;
                    arrayList.add(hashWrapper);
                    continue;
                }
                if (list2.contains(hashWrapper)) {
                    if (arrayList.contains(hashWrapper)) continue;
                    arrayList.add(hashWrapper);
                    continue;
                }
                list2.add(hashWrapper);
                List list3 = this.followDivChainSupport(diversification2.getKeys(bl, bl2), bl, n + 1, bl2, list2, n2);
                for (int j = 0; j < list3.size(); ++j) {
                    Object e = list3.get(j);
                    if (arrayList.contains(e)) continue;
                    arrayList.add((HashWrapper)e);
                }
            }
        } else if (Constants.isCVSVersion()) {
            Debug.out("Terminated div chain lookup (max depth=" + n2 + ") - net=" + this.network);
        }
        return arrayList;
    }

    protected storageKey getStorageKey(HashWrapper hashWrapper) {
        storageKey storageKey2 = (storageKey)this.local_storage_keys.get(hashWrapper);
        if (storageKey2 == null) {
            if (this.local_storage_keys.size() >= 65536) {
                storageKey2 = new storageKey(this, this.suspendDivs() ? (byte)1 : 3, hashWrapper);
                Debug.out("DHTStorageManager: max key limit exceeded");
                this.log.log("SM: max storage key limit exceeded - " + DHTLog.getString2(hashWrapper.getBytes()));
            } else {
                storageKey2 = new storageKey(this, 1, hashWrapper);
                this.local_storage_keys.put(hashWrapper, storageKey2);
            }
        }
        return storageKey2;
    }

    protected void deleteStorageKey(storageKey storageKey2) {
        if (this.local_storage_keys.remove(storageKey2.getKey()) != null && storageKey2.getDiversificationType() != 1) {
            this.writeDiversifications();
        }
    }

    protected boolean suspendDivs() {
        return this.suspend_divs_until > 0L && this.suspend_divs_until > SystemTime.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readDiversifications() {
        if (this.suspendDivs()) {
            return;
        }
        try {
            List list;
            this.storage_mon.enter();
            Map map = this.readMapFromFile("diverse");
            List list2 = (List)map.get("local");
            if (list2 != null) {
                long l = SystemTime.getCurrentTime();
                for (int i = 0; i < list2.size(); ++i) {
                    storageKey storageKey2 = storageKey.deserialise(this, (Map)list2.get(i));
                    long l2 = storageKey2.getExpiry() - l;
                    if (l2 > 0L) {
                        this.local_storage_keys.put(storageKey2.getKey(), storageKey2);
                        continue;
                    }
                    this.log.log("SM: serialised sk: " + DHTLog.getString2(storageKey2.getKey().getBytes()) + " expired");
                }
            }
            if ((list = (List)map.get("remote")) != null) {
                long l = SystemTime.getCurrentTime();
                for (int i = 0; i < list.size(); ++i) {
                    diversification diversification2 = diversification.deserialise(this, (Map)list.get(i));
                    long l3 = diversification2.getExpiry() - l;
                    if (l3 > 0L) {
                        diversification diversification3 = this.remote_diversifications.put(diversification2.getKey(), diversification2);
                        if (diversification3 != null) {
                            this.divRemoved(diversification3);
                        }
                        this.divAdded(diversification2);
                        continue;
                    }
                    this.log.log("SM: serialised div: " + DHTLog.getString2(diversification2.getKey().getBytes()) + " expired");
                }
            }
            Object var12_13 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDiversifications() {
        if (this.suspendDivs()) {
            return;
        }
        try {
            try {
                Object object2;
                this.storage_mon.enter();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                ArrayList<Map> arrayList = new ArrayList<Map>();
                hashMap.put("local", arrayList);
                for (Object object2 : this.local_storage_keys.values()) {
                    if (((storageKey)object2).getDiversificationType() == 1) continue;
                    arrayList.add(((storageKey)object2).serialise());
                }
                object2 = new ArrayList();
                hashMap.put("remote", object2);
                Iterator iterator = this.remote_diversifications.values().iterator();
                while (iterator.hasNext()) {
                    object2.add(((diversification)iterator.next()).serialise());
                }
                this.writeMapToFile(hashMap, "diverse");
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var6_7 = null;
                this.storage_mon.exit();
            }
            Object var6_6 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    protected diversification lookupDiversification(HashWrapper hashWrapper) {
        diversification diversification2 = (diversification)this.remote_diversifications.get(hashWrapper);
        if (diversification2 != null && diversification2.getExpiry() < SystemTime.getCurrentTime()) {
            this.log.log("SM: div: " + DHTLog.getString2(diversification2.getKey().getBytes()) + " expired");
            this.remote_diversifications.remove(hashWrapper);
            this.divRemoved(diversification2);
            diversification2 = null;
        }
        return diversification2;
    }

    protected diversification createDiversification(HashWrapper hashWrapper, byte by) {
        diversification diversification2 = new diversification(this, hashWrapper, by);
        diversification diversification3 = this.remote_diversifications.put(hashWrapper, diversification2);
        if (diversification3 != null) {
            this.divRemoved(diversification3);
        }
        this.divAdded(diversification2);
        this.writeDiversifications();
        return diversification2;
    }

    protected void divAdded(diversification diversification2) {
        if (diversification2.getType() == 2) {
            ++this.remote_freq_div_count;
        } else {
            ++this.remote_size_div_count;
        }
    }

    protected void divRemoved(diversification diversification2) {
        if (diversification2.getType() == 2) {
            --this.remote_freq_div_count;
        } else {
            --this.remote_size_div_count;
        }
    }

    public int getRemoteFreqDivCount() {
        return this.remote_freq_div_count;
    }

    public int getRemoteSizeDivCount() {
        return this.remote_size_div_count;
    }

    protected static String formatExpiry(long l) {
        long l2 = l - SystemTime.getCurrentTime();
        return (l2 < 0L ? "-" : "") + DisplayFormatters.formatTime(Math.abs(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readKeyBlocks() {
        try {
            this.key_block_mon.enter();
            Map map = this.readMapFromFile("block");
            List list = (List)map.get("entries");
            int n = (int)(SystemTime.getCurrentTime() / 1000L);
            ByteArrayHashMap<keyBlock> byteArrayHashMap = new ByteArrayHashMap<keyBlock>();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        boolean bl;
                        Map map2 = (Map)list.get(i);
                        byte[] byArray = (byte[])map2.get("req");
                        byte[] byArray2 = (byte[])map2.get("cert");
                        int n2 = ((Long)map2.get("received")).intValue();
                        boolean bl2 = bl = (Long)map2.get("direct") == 1L;
                        if (n2 > n) {
                            n2 = n;
                        }
                        keyBlock keyBlock2 = new keyBlock(byArray, byArray2, n2, bl);
                        if ((!bl || !keyBlock2.isAdd()) && (long)(n - n2) >= 604800L || !DHTPluginStorageManager.verifyKeyBlock(byArray, byArray2)) continue;
                        this.log.log("KB: deserialised " + DHTLog.getString2(keyBlock2.getKey()) + ",add=" + keyBlock2.isAdd() + ",dir=" + keyBlock2.isDirect());
                        byteArrayHashMap.put(keyBlock2.getKey(), keyBlock2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
            this.key_block_map_cow = byteArrayHashMap;
            this.key_blocks_direct_cow = this.buildKeyBlockDetails(byteArrayHashMap);
            Object var13_13 = null;
            this.key_block_mon.exit();
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.key_block_mon.exit();
            throw throwable;
        }
    }

    protected DHTStorageBlock[] buildKeyBlockDetails(ByteArrayHashMap byteArrayHashMap) {
        DHTStorageBlock[] dHTStorageBlockArray;
        List<DHTStorageBlock> list = byteArrayHashMap.values();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            dHTStorageBlockArray = (DHTStorageBlock[])iterator.next();
            if (dHTStorageBlockArray.isDirect()) continue;
            iterator.remove();
        }
        dHTStorageBlockArray = new DHTStorageBlock[list.size()];
        list.toArray(dHTStorageBlockArray);
        return dHTStorageBlockArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeKeyBlocks() {
        try {
            try {
                this.key_block_mon.enter();
                HashMap hashMap = new HashMap();
                ArrayList arrayList = new ArrayList();
                hashMap.put("entries", arrayList);
                List list = this.key_block_map_cow.values();
                for (int i = 0; i < list.size(); ++i) {
                    keyBlock keyBlock2 = (keyBlock)list.get(i);
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    hashMap2.put("req", keyBlock2.getRequest());
                    hashMap2.put("cert", keyBlock2.getCertificate());
                    hashMap2.put("received", new Long(keyBlock2.getReceived()));
                    hashMap2.put("direct", new Long(keyBlock2.isDirect() ? 1L : 0L));
                    arrayList.add(hashMap2);
                }
                this.writeMapToFile(hashMap, "block");
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var8_9 = null;
                this.key_block_mon.exit();
            }
            Object var8_8 = null;
            this.key_block_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.key_block_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DHTStorageBlock keyBlockRequest(DHTTransportContact var1_1, byte[] var2_2, byte[] var3_3) {
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            if (var2_2.length <= 8) {
                                return null;
                            }
                            var4_4 = new keyBlock(var2_2, var3_3, (int)(SystemTime.getCurrentTime() / 1000L), var1_1 != null);
                            try {
                                block23: {
                                    this.key_block_mon.enter();
                                    var5_5 = false;
                                    try {
                                        var6_6 = (keyBlock)this.key_block_map_cow.get(var4_4.getKey());
                                        if (var6_6 == null) ** GOTO lbl-1000
                                        if (var6_6.isDirect() && !var4_4.isDirect()) {
                                            var7_7 = null;
                                            var9_13 = null;
                                            if (!var5_5) break block23;
                                            var10_20 = this.key_block_map_cow.duplicate();
                                            var10_20.put(var4_4.getKey(), var4_4);
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var8_34) {
                                        var9_19 = null;
                                        if (var5_5 == false) throw var8_34;
                                        var10_26 = this.key_block_map_cow.duplicate();
                                        var10_26.put(var4_4.getKey(), var4_4);
                                        if (var1_1 != null) {
                                            var4_4.sentTo(var1_1);
                                        }
                                        this.key_block_map_cow = var10_26;
                                        this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                                        this.writeKeyBlocks();
                                        throw var8_34;
                                    }
                                    if (var1_1 != null) {
                                        var4_4.sentTo(var1_1);
                                    }
                                    this.key_block_map_cow = var10_20;
                                    this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                                    this.writeKeyBlocks();
                                }
                                var12_27 = null;
                                this.key_block_mon.exit();
                                return var7_7;
lbl-1000:
                                // 1 sources

                                {
                                    if (var6_6.getCreated() <= var4_4.getCreated()) ** GOTO lbl-1000
                                    var7_8 = null;
                                    var9_14 = null;
                                    if (!var5_5) break block24;
                                    var10_21 = this.key_block_map_cow.duplicate();
                                    var10_21.put(var4_4.getKey(), var4_4);
                                }
                                if (var1_1 != null) {
                                    var4_4.sentTo(var1_1);
                                }
                                this.key_block_map_cow = var10_21;
                                this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                                this.writeKeyBlocks();
                                break block24;
lbl-1000:
                                // 2 sources

                                {
                                    if (!var4_4.isAdd()) ** GOTO lbl-1000
                                    if (var6_6 != null && var6_6.isAdd()) ** GOTO lbl75
                                    if (this.verifyKeyBlock(var4_4, var1_1)) ** GOTO lbl-1000
                                    var7_9 = null;
                                    var9_15 = null;
                                    if (!var5_5) break block25;
                                    var10_22 = this.key_block_map_cow.duplicate();
                                    var10_22.put(var4_4.getKey(), var4_4);
                                }
                                if (var1_1 != null) {
                                    var4_4.sentTo(var1_1);
                                }
                                this.key_block_map_cow = var10_22;
                                this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                                this.writeKeyBlocks();
                                break block25;
lbl-1000:
                                // 1 sources

                                {
                                    var5_5 = true;
lbl75:
                                    // 2 sources

                                    var7_10 = var4_4;
                                    var9_16 = null;
                                    if (!var5_5) break block26;
                                    var10_23 = this.key_block_map_cow.duplicate();
                                    var10_23.put(var4_4.getKey(), var4_4);
                                }
                                if (var1_1 != null) {
                                    var4_4.sentTo(var1_1);
                                }
                                this.key_block_map_cow = var10_23;
                                this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                                this.writeKeyBlocks();
                                break block26;
lbl-1000:
                                // 1 sources

                                {
                                    if (!var4_4.isDirect() || var6_6 != null && !var6_6.isAdd()) ** GOTO lbl106
                                    if (this.verifyKeyBlock(var4_4, var1_1)) ** GOTO lbl-1000
                                    var7_11 = null;
                                    var9_17 = null;
                                    if (!var5_5) break block27;
                                    var10_24 = this.key_block_map_cow.duplicate();
                                    var10_24.put(var4_4.getKey(), var4_4);
                                }
                                if (var1_1 != null) {
                                    var4_4.sentTo(var1_1);
                                }
                                this.key_block_map_cow = var10_24;
                                this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                                this.writeKeyBlocks();
                                break block27;
lbl-1000:
                                // 1 sources

                                {
                                    var5_5 = true;
lbl106:
                                    // 2 sources

                                    var7_12 = null;
                                    var9_18 = null;
                                    if (!var5_5) break block28;
                                    var10_25 = this.key_block_map_cow.duplicate();
                                    var10_25.put(var4_4.getKey(), var4_4);
                                }
                                if (var1_1 != null) {
                                    var4_4.sentTo(var1_1);
                                }
                                this.key_block_map_cow = var10_25;
                                this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                                this.writeKeyBlocks();
                                break block28;
                            }
                            catch (Throwable var11_35) {
                                var12_33 = null;
                                this.key_block_mon.exit();
                                throw var11_35;
                            }
                        }
                        var12_28 = null;
                        this.key_block_mon.exit();
                        return var7_8;
                    }
                    var12_29 = null;
                    this.key_block_mon.exit();
                    return var7_9;
                }
                var12_30 = null;
                this.key_block_mon.exit();
                return var7_10;
            }
            var12_31 = null;
            this.key_block_mon.exit();
            return var7_11;
        }
        var12_32 = null;
        this.key_block_mon.exit();
        return var7_12;
    }

    protected boolean verifyKeyBlock(keyBlock keyBlock2, DHTTransportContact dHTTransportContact) {
        byte[] byArray = dHTTransportContact == null ? new byte[20] : dHTTransportContact.getID();
        BloomFilter bloomFilter = this.kb_verify_fail_bloom;
        long l = SystemTime.getCurrentTime();
        if (bloomFilter == null || this.kb_verify_fail_bloom_create_time > l || l - this.kb_verify_fail_bloom_create_time > 1800000L) {
            this.kb_verify_fail_bloom_create_time = l;
            this.kb_verify_fail_bloom = bloomFilter = BloomFilterFactory.createAddOnly(4000);
        }
        if (bloomFilter.contains(byArray)) {
            this.log.log("KB: request verify denied");
            return false;
        }
        try {
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(key_block_public_key);
            signature.update(keyBlock2.getRequest());
            if (!signature.verify(keyBlock2.getCertificate())) {
                this.log.log("KB: request verify failed for " + DHTLog.getString2(keyBlock2.getKey()));
                bloomFilter.add(byArray);
                return false;
            }
            this.log.log("KB: request verify ok " + DHTLog.getString2(keyBlock2.getKey()) + ", add = " + keyBlock2.isAdd() + ", direct = " + keyBlock2.isDirect());
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean verifyKeyBlock(byte[] byArray, byte[] byArray2) {
        try {
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(key_block_public_key);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public DHTStorageBlock getKeyBlockDetails(byte[] byArray) {
        keyBlock keyBlock2 = (keyBlock)this.key_block_map_cow.get(byArray);
        if (keyBlock2 == null || !keyBlock2.isAdd()) {
            return null;
        }
        if (!keyBlock2.getLogged()) {
            keyBlock2.setLogged();
            this.log.log("KB: Access to key '" + DHTLog.getFullString(keyBlock2.getKey()) + "' denied as it is blocked");
        }
        return keyBlock2;
    }

    public DHTStorageBlock[] getDirectKeyBlocks() {
        return this.key_blocks_direct_cow;
    }

    public byte[] getKeyForKeyBlock(byte[] byArray) {
        if (byArray.length <= 8) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[byArray.length - 8];
        System.arraycopy(byArray, 8, byArray2, 0, byArray2.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeDirectKeyBlocks() {
        try {
            this.key_block_mon.enter();
            ByteArrayHashMap<keyBlock> byteArrayHashMap = new ByteArrayHashMap<keyBlock>();
            Iterator iterator = this.key_block_map_cow.values().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                keyBlock keyBlock2 = (keyBlock)iterator.next();
                if (keyBlock2.isDirect()) {
                    bl = true;
                    continue;
                }
                byteArrayHashMap.put(keyBlock2.getKey(), keyBlock2);
            }
            if (bl) {
                this.log.log("KB: Purged direct entries on ID change");
                this.key_block_map_cow = byteArrayHashMap;
                this.key_blocks_direct_cow = this.buildKeyBlockDetails(this.key_block_map_cow);
                this.writeKeyBlocks();
            }
            Object var6_5 = null;
            this.key_block_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.key_block_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageForKey(String string, byte[] byArray) {
        try {
            this.storage_mon.enter();
            Map map = this.readMapFromFile("general");
            map.put(string, byArray);
            this.writeMapToFile(map, "general");
            Object var5_4 = null;
            this.storage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStorageForKey(String string) {
        try {
            this.storage_mon.enter();
            Map map = this.readMapFromFile("general");
            byte[] byArray = (byte[])map.get(string);
            Object var5_4 = null;
            this.storage_mon.exit();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.storage_mon.exit();
            throw throwable;
        }
    }

    public static HashWrapper diversifyKey(HashWrapper hashWrapper, int n) {
        return new HashWrapper(DHTPluginStorageManager.diversifyKey(hashWrapper.getBytes(), n));
    }

    public static byte[] diversifyKey(byte[] byArray, int n) {
        return new SHA1Simple().calculateHash(DHTPluginStorageManager.diversifyKeyLocal(byArray, n));
    }

    public static byte[] diversifyKeyLocal(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = (byte)n;
        return byArray2;
    }

    static {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(pub_exp, 16));
            key_block_public_key = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected static class storageKey
    implements DHTStorageKey {
        private DHTPluginStorageManager manager;
        private HashWrapper key;
        private byte type;
        private int size;
        private int entries;
        private long expiry;
        private long read_count_start;
        private short reads_per_min;
        private BloomFilter ip_bloom_filter;

        protected storageKey(DHTPluginStorageManager dHTPluginStorageManager, byte by, HashWrapper hashWrapper) {
            this.manager = dHTPluginStorageManager;
            this.type = by;
            this.key = hashWrapper;
            this.expiry = SystemTime.getCurrentTime() + 172800000L + (long)(Math.random() * 8.64E7);
        }

        protected storageKey(DHTPluginStorageManager dHTPluginStorageManager, byte by, HashWrapper hashWrapper, long l) {
            this.manager = dHTPluginStorageManager;
            this.type = by;
            this.key = hashWrapper;
            this.expiry = l;
        }

        protected Map serialise() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("key", this.key.getBytes());
            hashMap.put("type", new Long(this.type));
            hashMap.put("exp", new Long(this.expiry));
            this.manager.log.log("SM: serialised sk: " + DHTLog.getString2(this.key.getBytes()) + ", " + DHT.DT_STRINGS[this.type] + ", " + DHTPluginStorageManager.formatExpiry(this.expiry));
            return hashMap;
        }

        protected static storageKey deserialise(DHTPluginStorageManager dHTPluginStorageManager, Map map) {
            HashWrapper hashWrapper = new HashWrapper((byte[])map.get("key"));
            int n = ((Long)map.get("type")).intValue();
            long l = (Long)map.get("exp");
            dHTPluginStorageManager.log.log("SM: deserialised sk: " + DHTLog.getString2(hashWrapper.getBytes()) + ", " + DHT.DT_STRINGS[n] + ", " + DHTPluginStorageManager.formatExpiry(l));
            return new storageKey(dHTPluginStorageManager, (byte)n, hashWrapper, l);
        }

        public void serialiseStats(DataOutputStream dataOutputStream) throws IOException {
            this.manager.serialiseStats(this, dataOutputStream);
        }

        protected HashWrapper getKey() {
            return this.key;
        }

        protected long getExpiry() {
            return this.expiry;
        }

        public byte getDiversificationType() {
            if (this.type != 1 && this.expiry < SystemTime.getCurrentTime()) {
                this.type = 1;
                this.manager.log.log("SM: sk: " + DHTLog.getString2(this.getKey().getBytes()) + " expired");
                this.manager.writeDiversifications();
            }
            return this.type;
        }

        public int getReadsPerMinute() {
            return this.reads_per_min;
        }

        public int getSize() {
            return this.size;
        }

        public int getEntryCount() {
            return this.entries;
        }

        protected void read(DHTTransportContact dHTTransportContact) {
            if (this.type == 1) {
                long l = SystemTime.getCurrentTime();
                long l2 = l - this.read_count_start;
                if (l2 > 180000L) {
                    if (this.ip_bloom_filter != null) {
                        int n = this.ip_bloom_filter.getEntryCount();
                        this.reads_per_min = (short)(n / 3);
                        if (this.reads_per_min == 0 && n > 0) {
                            this.reads_per_min = 1;
                        }
                        if (n > 90 && !this.manager.suspendDivs()) {
                            this.type = (byte)2;
                            this.manager.log.log("SM: sk freq created (" + n + "reads ) - " + DHTLog.getString2(this.key.getBytes()));
                            this.manager.writeDiversifications();
                        }
                    }
                    this.read_count_start = l;
                    this.ip_bloom_filter = null;
                } else {
                    if (this.ip_bloom_filter == null) {
                        this.ip_bloom_filter = BloomFilterFactory.createAddOnly(300);
                    }
                    byte[] byArray = dHTTransportContact.getAddress().getAddress().getAddress();
                    this.ip_bloom_filter.add(byArray);
                }
            }
        }

        protected void valueChanged(int n, int n2) {
            this.entries += n;
            this.size += n2;
            if (this.entries < 0) {
                Debug.out("entries negative");
                this.entries = 0;
            }
            if (this.size < 0) {
                Debug.out("size negative");
                this.size = 0;
            }
            if (this.type == 1 && !this.manager.suspendDivs()) {
                if (this.size > 16384) {
                    this.type = (byte)3;
                    this.manager.log.log("SM: sk size total created (size " + this.size + ") - " + DHTLog.getString2(this.key.getBytes()));
                    this.manager.writeDiversifications();
                } else if (this.entries > 2048) {
                    this.type = (byte)3;
                    this.manager.log.log("SM: sk size entries created (" + this.entries + " entries) - " + DHTLog.getString2(this.key.getBytes()));
                    this.manager.writeDiversifications();
                }
            }
        }
    }

    protected static class diversification {
        private DHTPluginStorageManager manager;
        private HashWrapper key;
        private byte type;
        private long expiry;
        private int[] fixed_put_offsets;

        protected diversification(DHTPluginStorageManager dHTPluginStorageManager, HashWrapper hashWrapper, byte by) {
            this.manager = dHTPluginStorageManager;
            this.key = hashWrapper;
            this.type = by;
            this.expiry = SystemTime.getCurrentTime() + 172800000L + (long)(Math.random() * 8.64E7);
            this.fixed_put_offsets = new int[2];
            int n = 0;
            while (n < 2) {
                int n2 = (int)(Math.random() * 10.0);
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    if (n2 != this.fixed_put_offsets[i]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.fixed_put_offsets[n++] = n2;
            }
        }

        protected diversification(DHTPluginStorageManager dHTPluginStorageManager, HashWrapper hashWrapper, byte by, long l, int[] nArray) {
            this.manager = dHTPluginStorageManager;
            this.key = hashWrapper;
            this.type = by;
            this.expiry = l;
            this.fixed_put_offsets = nArray;
        }

        protected Map serialise() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("key", this.key.getBytes());
            hashMap.put("type", new Long(this.type));
            hashMap.put("exp", new Long(this.expiry));
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < this.fixed_put_offsets.length; ++i) {
                arrayList.add(new Long(this.fixed_put_offsets[i]));
            }
            hashMap.put("fpo", arrayList);
            if (Constants.isCVSVersion()) {
                this.manager.log.log("SM: serialised div: " + DHTLog.getString2(this.key.getBytes()) + ", " + DHT.DT_STRINGS[this.type] + ", " + DHTPluginStorageManager.formatExpiry(this.expiry));
            }
            return hashMap;
        }

        protected static diversification deserialise(DHTPluginStorageManager dHTPluginStorageManager, Map map) {
            HashWrapper hashWrapper = new HashWrapper((byte[])map.get("key"));
            int n = ((Long)map.get("type")).intValue();
            long l = (Long)map.get("exp");
            List list = (List)map.get("fpo");
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((Long)list.get(i)).intValue();
            }
            dHTPluginStorageManager.log.log("SM: deserialised div: " + DHTLog.getString2(hashWrapper.getBytes()) + ", " + DHT.DT_STRINGS[n] + ", " + DHTPluginStorageManager.formatExpiry(l));
            return new diversification(dHTPluginStorageManager, hashWrapper, (byte)n, l, nArray);
        }

        protected HashWrapper getKey() {
            return this.key;
        }

        protected long getExpiry() {
            return this.expiry;
        }

        protected byte getType() {
            return this.type;
        }

        protected List getKeys(boolean bl, boolean bl2) {
            ArrayList<HashWrapper> arrayList;
            block11: {
                block9: {
                    block10: {
                        arrayList = new ArrayList<HashWrapper>();
                        if (!bl) break block9;
                        if (this.type != 2) break block10;
                        for (int i = 0; i < 10; ++i) {
                            arrayList.add(DHTPluginStorageManager.diversifyKey(this.key, i));
                        }
                        if (!bl2) break block11;
                        arrayList.add(this.key);
                        break block11;
                    }
                    for (int i = 0; i < this.fixed_put_offsets.length; ++i) {
                        arrayList.add(DHTPluginStorageManager.diversifyKey(this.key, this.fixed_put_offsets[i]));
                    }
                    if (!bl2) break block11;
                    arrayList.add(this.key);
                    break block11;
                }
                if (this.type == 2) {
                    arrayList.add(DHTPluginStorageManager.diversifyKey(this.key, (int)(Math.random() * 10.0)));
                } else if (bl2) {
                    for (int i = 0; i < 10; ++i) {
                        arrayList.add(DHTPluginStorageManager.diversifyKey(this.key, i));
                    }
                } else {
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    while (arrayList2.size() < 2) {
                        Integer n = new Integer((int)(Math.random() * 10.0));
                        if (arrayList2.contains(n)) continue;
                        arrayList2.add(n);
                    }
                    for (int i = 0; i < 2; ++i) {
                        arrayList.add(DHTPluginStorageManager.diversifyKey(this.key, (int)((Integer)arrayList2.get(i))));
                    }
                }
            }
            return arrayList;
        }
    }

    protected static class keyBlock
    implements DHTStorageBlock {
        private byte[] request;
        private byte[] cert;
        private int received;
        private boolean direct;
        private BloomFilter sent_to_bloom;
        private boolean logged;

        protected keyBlock(byte[] byArray, byte[] byArray2, int n, boolean bl) {
            this.request = byArray;
            this.cert = byArray2;
            this.received = n;
            this.direct = bl;
        }

        public byte[] getRequest() {
            return this.request;
        }

        public byte[] getCertificate() {
            return this.cert;
        }

        public byte[] getKey() {
            byte[] byArray = new byte[this.request.length - 8];
            System.arraycopy(this.request, 8, byArray, 0, byArray.length);
            return byArray;
        }

        protected boolean isAdd() {
            return this.request[0] == 1;
        }

        protected boolean getLogged() {
            return this.logged;
        }

        protected void setLogged() {
            this.logged = true;
        }

        protected int getCreated() {
            int n = this.request[4] << 24 & 0xFF000000 | this.request[5] << 16 & 0xFF0000 | this.request[6] << 8 & 0xFF00 | this.request[7] & 0xFF;
            return n;
        }

        protected int getReceived() {
            return this.received;
        }

        protected boolean isDirect() {
            return this.direct;
        }

        public boolean hasBeenSentTo(DHTTransportContact dHTTransportContact) {
            BloomFilter bloomFilter = this.sent_to_bloom;
            if (bloomFilter == null) {
                return false;
            }
            return bloomFilter.contains(dHTTransportContact.getID());
        }

        public void sentTo(DHTTransportContact dHTTransportContact) {
            BloomFilter bloomFilter = this.sent_to_bloom;
            if (bloomFilter == null || bloomFilter.getEntryCount() > 100) {
                this.sent_to_bloom = bloomFilter = BloomFilterFactory.createAddOnly(500);
            }
            bloomFilter.add(dHTTransportContact.getID());
        }
    }
}

