/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTFactory;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.router.DHTRouterStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.DHTPluginTransferHandler;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginContactImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImplAdapter;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginStorageManager;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginValueImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTPluginImpl {
    private static final String SEED_ADDRESS_V4 = "dht.vuze.com";
    private static final String SEED_ADDRESS_V6 = "dht6.vuze.com";
    private static final int SEED_PORT = 6881;
    private static final long MIN_ROOT_SEED_IMPORT_PERIOD = 28800000L;
    private PluginInterface plugin_interface;
    private int status;
    private String status_text;
    private ActionParameter reseed_param;
    private BooleanParameter warn_user_param;
    private DHT dht;
    private int port;
    private byte protocol_version;
    private int network;
    private boolean v6;
    private DHTTransportUDP transport;
    private DHTPluginStorageManager storage_manager;
    private long last_root_seed_import_time;
    private LoggerChannel log;
    private DHTLogger dht_log;
    private int stats_ticks;

    public DHTPluginImpl(PluginInterface pluginInterface, DHTNATPuncherAdapter dHTNATPuncherAdapter, DHTPluginImplAdapter dHTPluginImplAdapter, byte by, int n, boolean bl, String string, int n2, ActionParameter actionParameter, BooleanParameter booleanParameter, boolean bl2, LoggerChannel loggerChannel, DHTLogger dHTLogger) {
        this.plugin_interface = pluginInterface;
        this.protocol_version = by;
        this.network = n;
        this.v6 = bl;
        this.port = n2;
        this.reseed_param = actionParameter;
        this.warn_user_param = booleanParameter;
        this.log = loggerChannel;
        this.dht_log = dHTLogger;
        final DHTPluginImplAdapter dHTPluginImplAdapter2 = dHTPluginImplAdapter;
        try {
            this.storage_manager = new DHTPluginStorageManager(this.network, this.dht_log, this.getDataDir(n));
            PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
            int n3 = pluginConfig.getPluginIntParameter("dht.senddelay", 25);
            int n4 = pluginConfig.getPluginIntParameter("dht.recvdelay", 25);
            boolean bl3 = pluginConfig.getPluginBooleanParameter("dht.bootstrapnode", false);
            boolean bl4 = pluginConfig.getPluginBooleanParameter("dht.reachable." + this.network, true);
            this.transport = DHTTransportFactory.createUDP(by, n, bl, string, this.storage_manager.getMostRecentAddress(), n2, 3, 1, 10000L, n3, n4, bl3, bl4, this.dht_log);
            this.transport.addListener(new DHTTransportListener(){

                public void localContactChanged(DHTTransportContact dHTTransportContact) {
                    DHTPluginImpl.this.storage_manager.localContactChanged(dHTTransportContact);
                    if (dHTPluginImplAdapter2 != null) {
                        dHTPluginImplAdapter2.localContactChanged(DHTPluginImpl.this.getLocalAddress());
                    }
                }

                public void resetNetworkPositions() {
                }

                public void currentAddress(String string) {
                    DHTPluginImpl.this.storage_manager.recordCurrentAddress(string);
                }

                public void reachabilityChanged(boolean bl) {
                }
            });
            Properties properties = new Properties();
            if (n == 1) {
                properties.put("CacheRepublishInterval", new Integer(3600000));
            }
            this.dht = DHTFactory.create(this.transport, properties, this.storage_manager, dHTNATPuncherAdapter, this.dht_log);
            this.plugin_interface.firePluginEvent(new PluginEvent(){

                public int getType() {
                    return 1024;
                }

                public Object getValue() {
                    return DHTPluginImpl.this.dht;
                }
            });
            this.dht.setLogging(bl2);
            DHTTransportContact dHTTransportContact = this.importRootSeed();
            this.storage_manager.importContacts(this.dht);
            this.plugin_interface.getUtilities().createTimer("DHTExport", true).addPeriodicEvent(600000L, new UTTimerEventPerformer(){

                public void perform(UTTimerEvent uTTimerEvent) {
                    DHTPluginImpl.this.checkForReSeed(false);
                    DHTPluginImpl.this.storage_manager.exportContacts(DHTPluginImpl.this.dht);
                }
            });
            this.integrateDHT(true, dHTTransportContact);
            this.status = 3;
            this.status_text = "Running";
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.log.log("DHT integrtion fails", throwable);
            this.status_text = "DHT Integration fails: " + Debug.getNestedExceptionMessage(throwable);
            this.status = 4;
        }
    }

    public void updateStats(int n) {
        ++this.stats_ticks;
        if (this.transport != null) {
            PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
            boolean bl = this.transport.isReachable();
            if (bl != pluginConfig.getPluginBooleanParameter("dht.reachable." + this.network, true)) {
                pluginConfig.setPluginParameter("dht.reachable." + this.network, bl);
                if (!bl) {
                    String string = "If you have a router/firewall, please check that you have port " + this.port + " UDP open.\nDecentralised tracking requires this.";
                    int n2 = this.plugin_interface.getPluginconfig().getPluginIntParameter("udp_warned_port", 0);
                    if (n2 == this.port || !this.warn_user_param.getValue()) {
                        this.log.log(string);
                    } else {
                        this.plugin_interface.getPluginconfig().setPluginParameter("udp_warned_port", this.port);
                        this.log.logAlert(2, string);
                    }
                } else {
                    this.log.log("Reachability changed for the better");
                }
            }
            if (this.stats_ticks % n == 0) {
                this.logStats();
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.status_text;
    }

    public boolean isReachable() {
        return this.transport.isReachable();
    }

    public void setLogging(boolean bl) {
        this.dht.setLogging(bl);
    }

    public void tick() {
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
        try {
            this.transport.setPort(this.port);
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
        }
    }

    public long getClockSkew() {
        return this.transport.getStats().getSkewAverage();
    }

    public void logStats() {
        DHTDBStats dHTDBStats = this.dht.getDataBase().getStats();
        DHTControlStats dHTControlStats = this.dht.getControl().getStats();
        DHTRouterStats dHTRouterStats = this.dht.getRouter().getStats();
        DHTTransportStats dHTTransportStats = this.transport.getStats();
        long[] lArray = dHTRouterStats.getStats();
        this.log.log("DHT:ip=" + this.transport.getLocalContact().getAddress() + ",net=" + this.transport.getNetwork() + ",prot=V" + this.transport.getProtocolVersion() + ",reach=" + this.transport.isReachable());
        this.log.log("Router:nodes=" + lArray[0] + ",leaves=" + lArray[1] + ",contacts=" + lArray[2] + ",replacement=" + lArray[3] + ",live=" + lArray[4] + ",unknown=" + lArray[5] + ",failing=" + lArray[6]);
        this.log.log("Transport:" + dHTTransportStats.getString());
        int[] nArray = dHTDBStats.getValueDetails();
        this.log.log("Control:dht=" + dHTControlStats.getEstimatedDHTSize() + ", Database:keys=" + dHTDBStats.getKeyCount() + ",vals=" + nArray[0] + ",loc=" + nArray[1] + ",dir=" + nArray[2] + ",ind=" + nArray[3] + ",div_f=" + nArray[4] + ",div_s=" + nArray[5]);
    }

    protected File getDataDir(int n) {
        File file = new File(this.plugin_interface.getUtilities().getAzureusUserDir(), "dht");
        if (n != 0) {
            file = new File(file, "net" + n);
        }
        FileUtil.mkdirs(file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrateDHT(boolean bl, DHTTransportContact dHTTransportContact) {
        try {
            this.reseed_param.setEnabled(false);
            this.log.log("DHT " + (bl ? "" : "re-") + "integration starts");
            long l = SystemTime.getCurrentTime();
            this.dht.integrate(false);
            if (dHTTransportContact != null) {
                this.log.log("Removing seed " + dHTTransportContact.getString());
                dHTTransportContact.remove();
            }
            long l2 = SystemTime.getCurrentTime();
            this.log.log("DHT " + (bl ? "" : "re-") + "integration complete: elapsed = " + (l2 - l));
            this.dht.print(false);
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.reseed_param.setEnabled(true);
            throw throwable;
        }
        this.reseed_param.setEnabled(true);
    }

    public void checkForReSeed(boolean bl) {
        int n = 32;
        try {
            long[] lArray = this.dht.getRouter().getStats().getStats();
            if (lArray[4] < (long)n || bl) {
                Object object;
                if (bl) {
                    this.log.log("Reseeding");
                } else {
                    this.log.log("Less than 32 live contacts, reseeding");
                }
                int n2 = 0;
                if (this.network == 0 || this.network == 3) {
                    object = this.plugin_interface.getDownloadManager().getDownloads();
                    block2: for (int i = 0; i < ((Download[])object).length; ++i) {
                        Download download = object[i];
                        PeerManager peerManager = download.getPeerManager();
                        if (peerManager == null) continue;
                        Peer[] peerArray = peerManager.getPeers();
                        for (int j = 0; j < peerArray.length; ++j) {
                            Peer peer = peerArray[j];
                            int n3 = peer.getUDPNonDataListenPort();
                            if (n3 != 0 && this.importSeed(peer.getIp(), n3) != null && ++n2 > n) break block2;
                        }
                    }
                }
                object = null;
                if (n2 == 0 && (object = this.importRootSeed()) != null) {
                    ++n2;
                }
                if (n2 > 0) {
                    this.integrateDHT(false, (DHTTransportContact)object);
                } else {
                    this.log.log("No valid peers found to reseed from");
                }
            }
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
        }
    }

    protected DHTTransportContact importRootSeed() {
        try {
            long l = SystemTime.getCurrentTime();
            if (l - this.last_root_seed_import_time > 28800000L) {
                this.last_root_seed_import_time = l;
                return this.importSeed(this.getSeedAddress(), 6881);
            }
            this.log.log("    root seed imported too recently, ignoring");
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
        }
        return null;
    }

    public DHTTransportContact importSeed(String string, int n) {
        try {
            return this.importSeed(InetAddress.getByName(string), n);
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
            return null;
        }
    }

    protected DHTTransportContact importSeed(InetAddress inetAddress, int n) {
        try {
            return this.transport.importContact(new InetSocketAddress(inetAddress, n), this.protocol_version);
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
            return null;
        }
    }

    protected InetAddress getSeedAddress() {
        try {
            return InetAddress.getByName(this.v6 ? SEED_ADDRESS_V6 : SEED_ADDRESS_V4);
        }
        catch (UnknownHostException unknownHostException) {
            Debug.out("Could not get DHT seed address: " + unknownHostException);
            return null;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public boolean isDiversified(byte[] byArray) {
        return this.dht.isDiversified(byArray);
    }

    public void put(byte[] byArray, String string, byte[] byArray2, byte by, DHTPluginOperationListener dHTPluginOperationListener) {
        this.put(byArray, string, byArray2, by, true, dHTPluginOperationListener);
    }

    public void put(final byte[] byArray, String string, byte[] byArray2, byte by, boolean bl, final DHTPluginOperationListener dHTPluginOperationListener) {
        this.dht.put(byArray, string, byArray2, by, bl, new DHTOperationListener(){
            private boolean started;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                if (dHTPluginOperationListener != null) {
                    4 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    dHTPluginOperationListener.starts(byArray);
                }
            }

            public void diversified(String string) {
            }

            public void found(DHTTransportContact dHTTransportContact, boolean bl) {
            }

            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                Debug.out("read operation not supported for puts");
            }

            public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.valueWritten(new DHTPluginContactImpl(DHTPluginImpl.this, dHTTransportContact), DHTPluginImpl.this.mapValue(dHTTransportValue));
                }
            }

            public void complete(boolean bl) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.complete(byArray, bl);
                }
            }
        });
    }

    public DHTPluginValue getLocalValue(byte[] byArray) {
        DHTTransportValue dHTTransportValue = this.dht.getLocalValue(byArray);
        if (dHTTransportValue == null) {
            return null;
        }
        return this.mapValue(dHTTransportValue);
    }

    public void get(final byte[] byArray, String string, byte by, int n, long l, boolean bl, boolean bl2, final DHTPluginOperationListener dHTPluginOperationListener) {
        this.dht.get(byArray, string, by, n, l, bl, bl2, new DHTOperationListener(){
            private boolean started = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                if (dHTPluginOperationListener != null) {
                    5 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    dHTPluginOperationListener.starts(byArray);
                }
            }

            public void diversified(String string) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.diversified();
                }
            }

            public void found(DHTTransportContact dHTTransportContact, boolean bl) {
            }

            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.valueRead(new DHTPluginContactImpl(DHTPluginImpl.this, dHTTransportValue.getOriginator()), DHTPluginImpl.this.mapValue(dHTTransportValue));
                }
            }

            public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
            }

            public void complete(boolean bl) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.complete(byArray, bl);
                }
            }
        });
    }

    public void remove(final byte[] byArray, String string, final DHTPluginOperationListener dHTPluginOperationListener) {
        this.dht.remove(byArray, string, new DHTOperationListener(){
            private boolean started;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                if (dHTPluginOperationListener != null) {
                    6 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    dHTPluginOperationListener.starts(byArray);
                }
            }

            public void found(DHTTransportContact dHTTransportContact, boolean bl) {
            }

            public void diversified(String string) {
            }

            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
            }

            public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.valueWritten(new DHTPluginContactImpl(DHTPluginImpl.this, dHTTransportContact), DHTPluginImpl.this.mapValue(dHTTransportValue));
                }
            }

            public void complete(boolean bl) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.complete(byArray, bl);
                }
            }
        });
    }

    public void remove(DHTPluginContact[] dHTPluginContactArray, final byte[] byArray, String string, final DHTPluginOperationListener dHTPluginOperationListener) {
        DHTTransportContact[] dHTTransportContactArray = new DHTTransportContact[dHTPluginContactArray.length];
        for (int i = 0; i < dHTPluginContactArray.length; ++i) {
            dHTTransportContactArray[i] = ((DHTPluginContactImpl)dHTPluginContactArray[i]).getContact();
        }
        this.dht.remove(dHTTransportContactArray, byArray, string, new DHTOperationListener(){
            private boolean started;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                if (dHTPluginOperationListener != null) {
                    7 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.started) {
                            return;
                        }
                        this.started = true;
                    }
                    dHTPluginOperationListener.starts(byArray);
                }
            }

            public void found(DHTTransportContact dHTTransportContact, boolean bl) {
            }

            public void diversified(String string) {
            }

            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
            }

            public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.valueWritten(new DHTPluginContactImpl(DHTPluginImpl.this, dHTTransportContact), DHTPluginImpl.this.mapValue(dHTTransportValue));
                }
            }

            public void complete(boolean bl) {
                if (dHTPluginOperationListener != null) {
                    dHTPluginOperationListener.complete(byArray, bl);
                }
            }
        });
    }

    public DHTPluginContact getLocalAddress() {
        return new DHTPluginContactImpl(this, this.transport.getLocalContact());
    }

    public DHTPluginContact importContact(InetSocketAddress inetSocketAddress) {
        try {
            return new DHTPluginContactImpl(this, this.transport.importContact(inetSocketAddress, this.protocol_version));
        }
        catch (DHTTransportException dHTTransportException) {
            Debug.printStackTrace(dHTTransportException);
            return null;
        }
    }

    public DHTPluginContact importContact(InetSocketAddress inetSocketAddress, byte by) {
        try {
            return new DHTPluginContactImpl(this, this.transport.importContact(inetSocketAddress, by));
        }
        catch (DHTTransportException dHTTransportException) {
            Debug.printStackTrace(dHTTransportException);
            return null;
        }
    }

    public void registerHandler(byte[] byArray, final DHTPluginTransferHandler dHTPluginTransferHandler) {
        this.dht.getTransport().registerTransferHandler(byArray, new DHTTransportTransferHandler(){

            public String getName() {
                return dHTPluginTransferHandler.getName();
            }

            public byte[] handleRead(DHTTransportContact dHTTransportContact, byte[] byArray) {
                return dHTPluginTransferHandler.handleRead(new DHTPluginContactImpl(DHTPluginImpl.this, dHTTransportContact), byArray);
            }

            public byte[] handleWrite(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
                dHTPluginTransferHandler.handleWrite(new DHTPluginContactImpl(DHTPluginImpl.this, dHTTransportContact), byArray, byArray2);
                return null;
            }
        });
    }

    public byte[] read(final DHTPluginProgressListener dHTPluginProgressListener, DHTPluginContact dHTPluginContact, byte[] byArray, byte[] byArray2, long l) {
        try {
            return this.dht.getTransport().readTransfer(new DHTTransportProgressListener(){

                public void reportSize(long l) {
                    dHTPluginProgressListener.reportSize(l);
                }

                public void reportActivity(String string) {
                    dHTPluginProgressListener.reportActivity(string);
                }

                public void reportCompleteness(int n) {
                    dHTPluginProgressListener.reportCompleteness(n);
                }
            }, ((DHTPluginContactImpl)dHTPluginContact).getContact(), byArray, byArray2, l);
        }
        catch (DHTTransportException dHTTransportException) {
            throw new RuntimeException(dHTTransportException);
        }
    }

    public DHT getDHT() {
        return this.dht;
    }

    public void closedownInitiated() {
        this.storage_manager.exportContacts(this.dht);
        this.dht.destroy();
    }

    public boolean isRecentAddress(String string) {
        return this.storage_manager.isRecentAddress(string);
    }

    protected DHTPluginValue mapValue(DHTTransportValue dHTTransportValue) {
        if (dHTTransportValue == null) {
            return null;
        }
        return new DHTPluginValueImpl(dHTTransportValue);
    }

    public DHTPluginKeyStats decodeStats(DHTPluginValue dHTPluginValue) {
        if ((dHTPluginValue.getFlags() & 8) == 0) {
            return null;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(dHTPluginValue.getValue()));
            final DHTStorageKeyStats dHTStorageKeyStats = this.storage_manager.deserialiseStats(dataInputStream);
            return new DHTPluginKeyStats(){

                public int getEntryCount() {
                    return dHTStorageKeyStats.getEntryCount();
                }

                public int getSize() {
                    return dHTStorageKeyStats.getSize();
                }

                public int getReadsPerMinute() {
                    return dHTStorageKeyStats.getReadsPerMinute();
                }

                public byte getDiversification() {
                    return dHTStorageKeyStats.getDiversification();
                }
            };
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }
}

