/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.versioncheck;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageServiceClient;
import com.aelitis.azureus.core.impl.AzureusCoreImpl;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.util.DNSUtils;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientListener;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPCodecs;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPReply;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPRequest;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPReleasablePacketHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStateImpl;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionCheckClient {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String REASON_UPDATE_CHECK_START = "us";
    public static final String REASON_UPDATE_CHECK_PERIODIC = "up";
    public static final String REASON_CHECK_SWT = "sw";
    public static final String REASON_DHT_EXTENDED_ALLOWED = "dx";
    public static final String REASON_DHT_ENABLE_ALLOWED = "de";
    public static final String REASON_EXTERNAL_IP = "ip";
    public static final String REASON_RECOMMENDED_PLUGINS = "rp";
    public static final String REASON_SECONDARY_CHECK = "sc";
    public static final String REASON_PLUGIN_UPDATE = "pu";
    private static final String AZ_MSG_SERVER_ADDRESS_V4 = "version.vuze.com";
    private static final int AZ_MSG_SERVER_PORT = 27001;
    private static final String MESSAGE_TYPE_ID = "AZVER";
    public static final String HTTP_SERVER_ADDRESS_V4 = "version.vuze.com";
    public static final int HTTP_SERVER_PORT = 80;
    public static final String TCP_SERVER_ADDRESS_V4 = "version.vuze.com";
    public static final int TCP_SERVER_PORT = 80;
    public static final String UDP_SERVER_ADDRESS_V4 = "version.vuze.com";
    public static final int UDP_SERVER_PORT = 2080;
    public static final String AZ_MSG_SERVER_ADDRESS_V6 = "version6.vuze.com";
    public static final String HTTP_SERVER_ADDRESS_V6 = "version6.vuze.com";
    public static final String TCP_SERVER_ADDRESS_V6 = "version6.vuze.com";
    public static final String UDP_SERVER_ADDRESS_V6 = "version6.vuze.com";
    private static final long CACHE_PERIOD = 300000L;
    private static boolean secondary_check_done;
    private final List<VersionCheckClientListener> listeners = new ArrayList<VersionCheckClientListener>(1);
    private boolean startCheckRan = false;
    private static final int AT_V4 = 1;
    private static final int AT_V6 = 2;
    private static final int AT_EITHER = 3;
    private static VersionCheckClient instance;
    private boolean enable_v6;
    private boolean prefer_v6;
    private Map last_check_data_v4 = null;
    private Map last_check_data_v6 = null;
    private final AEMonitor check_mon = new AEMonitor("versioncheckclient");
    private long last_check_time_v4 = 0L;
    private long last_check_time_v6 = 0L;
    private long last_feature_flag_cache;
    private long last_feature_flag_cache_time;

    public static synchronized VersionCheckClient getSingleton() {
        if (instance == null) {
            instance = new VersionCheckClient();
        }
        return instance;
    }

    private VersionCheckClient() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"IPV6 Prefer Addresses", "IPV6 Enable Support"}, new ParameterListener(){

            public void parameterChanged(String string) {
                VersionCheckClient.this.enable_v6 = COConfigurationManager.getBooleanParameter("IPV6 Enable Support");
                VersionCheckClient.this.prefer_v6 = COConfigurationManager.getBooleanParameter("IPV6 Prefer Addresses");
            }
        });
    }

    public void initialise() {
        DelayedTask delayedTask = UtilitiesImpl.addDelayedTask("VersionCheck", new Runnable(){

            public void run() {
                final AESemaphore aESemaphore = new AESemaphore("VCC:init");
                new AEThread2("VCC:init", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            VersionCheckClient.this.getVersionCheckInfo(VersionCheckClient.REASON_UPDATE_CHECK_START);
                            Object var2_1 = null;
                            aESemaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            aESemaphore.release();
                            throw throwable;
                        }
                    }
                }.start();
                if (!aESemaphore.reserve(5000L)) {
                    Debug.out("Timeout waiting for version check to complete");
                }
            }
        });
        delayedTask.queue();
    }

    public Map getVersionCheckInfo(String string) {
        return this.getVersionCheckInfo(string, 3);
    }

    public Map getVersionCheckInfo(String string, int n) {
        if (n == 1) {
            return this.getVersionCheckInfoSupport(string, false, false, false);
        }
        if (n == 2) {
            return this.getVersionCheckInfoSupport(string, false, false, true);
        }
        Map map = this.getVersionCheckInfoSupport(string, false, false, this.prefer_v6);
        if (map == null || map.size() == 0) {
            map = this.getVersionCheckInfoSupport(string, false, false, !this.prefer_v6);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getVersionCheckInfoSupport(String string, boolean bl, boolean bl2, boolean bl3) {
        block34: {
            try {
                List<VersionCheckClientListener> list = this.listeners;
                synchronized (list) {
                    if (REASON_UPDATE_CHECK_START.equals(string)) {
                        this.startCheckRan = true;
                    }
                    for (VersionCheckClientListener versionCheckClientListener : this.listeners) {
                        versionCheckClientListener.versionCheckStarted(string);
                    }
                }
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
            if (bl3) {
                if (this.enable_v6) {
                    block33: {
                        try {
                            this.check_mon.enter();
                            long l = SystemTime.getCurrentTime() - this.last_check_time_v6;
                            boolean bl4 = bl2 = bl2 || l > 300000L || l < 0L;
                            if (this.last_check_data_v6 == null || this.last_check_data_v6.size() == 0 || bl2) {
                                if (bl && this.last_check_data_v6 != null) {
                                    HashMap hashMap = new HashMap();
                                    Object var10_21 = null;
                                    this.check_mon.exit();
                                    return hashMap;
                                }
                                try {
                                    this.last_check_data_v6 = this.performVersionCheck(VersionCheckClient.constructVersionCheckMessage(string), true, true, true);
                                    if (this.last_check_data_v6 != null && this.last_check_data_v6.size() > 0) {
                                        COConfigurationManager.setParameter("versioncheck.cache.v6", this.last_check_data_v6);
                                    }
                                    break block33;
                                }
                                catch (SocketException socketException) {
                                }
                                catch (UnknownHostException unknownHostException) {
                                }
                                catch (Throwable throwable) {
                                    Debug.out(throwable);
                                    this.last_check_data_v6 = new HashMap();
                                }
                                break block33;
                            }
                            Logger.log(new LogEvent(LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data_v6.size() + " reply keys."));
                        }
                        catch (Throwable throwable) {
                            Object var10_23 = null;
                            this.check_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var10_22 = null;
                    this.check_mon.exit();
                }
                if (this.last_check_data_v6 == null) {
                    this.last_check_data_v6 = new HashMap();
                }
                return this.last_check_data_v6;
            }
            try {
                this.check_mon.enter();
                long l = SystemTime.getCurrentTime() - this.last_check_time_v4;
                boolean bl5 = bl2 = bl2 || l > 300000L || l < 0L;
                if (this.last_check_data_v4 == null || this.last_check_data_v4.size() == 0 || bl2) {
                    if (bl && this.last_check_data_v4 != null) {
                        HashMap hashMap = new HashMap();
                        Object var12_27 = null;
                        this.check_mon.exit();
                        return hashMap;
                    }
                    try {
                        this.last_check_data_v4 = this.performVersionCheck(VersionCheckClient.constructVersionCheckMessage(string), true, true, false);
                        if (this.last_check_data_v4 != null && this.last_check_data_v4.size() > 0) {
                            COConfigurationManager.setParameter("versioncheck.cache.v4", this.last_check_data_v4);
                        }
                        try {
                            if (AzureusCoreFactory.isCoreAvailable()) {
                                PluginInterface[] pluginInterfaceArray = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                                for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                                    PluginInterface pluginInterface = pluginInterfaceArray[i];
                                    Map map = pluginInterface.getPluginconfig().getPluginMapParameter("plugin.versionserver.data", null);
                                    if (map == null) continue;
                                    pluginInterface.getPluginconfig().setPluginMapParameter("plugin.versionserver.data", new HashMap());
                                }
                            }
                            break block34;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        Debug.outNoStack("VersionCheckClient - " + unknownHostException.getClass().getName() + ": " + unknownHostException.getMessage());
                    }
                    catch (IOException iOException) {
                        Debug.outNoStack("VersionCheckClient - " + iOException.getClass().getName() + ": " + iOException.getMessage());
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                        this.last_check_data_v4 = new HashMap();
                    }
                    break block34;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data_v4.size() + " reply keys."));
                }
            }
            catch (Throwable throwable) {
                Object var12_29 = null;
                this.check_mon.exit();
                throw throwable;
            }
        }
        Object var12_28 = null;
        this.check_mon.exit();
        if (this.last_check_data_v4 == null) {
            this.last_check_data_v4 = new HashMap();
        }
        this.last_feature_flag_cache_time = 0L;
        return this.last_check_data_v4;
    }

    private boolean isVersionCheckDataValid(int n) {
        boolean bl;
        boolean bl2 = this.last_check_data_v6 != null && this.last_check_data_v6.size() > 0;
        boolean bl3 = bl = this.last_check_data_v4 != null && this.last_check_data_v4.size() > 0;
        if (n == 1) {
            return bl;
        }
        if (n == 2) {
            return bl2;
        }
        return bl | bl2;
    }

    public Map getMostRecentVersionCheckData() {
        if (this.last_check_data_v4 != null) {
            return this.last_check_data_v4;
        }
        Map map = COConfigurationManager.getMapParameter("versioncheck.cache.v4", null);
        if (map != null) {
            return map;
        }
        if (this.last_check_data_v6 != null) {
            return this.last_check_data_v6;
        }
        map = COConfigurationManager.getMapParameter("versioncheck.cache.v6", null);
        return map;
    }

    public long getFeatureFlags() {
        long l;
        long l2 = SystemTime.getCurrentTime();
        if (l2 > this.last_feature_flag_cache_time && l2 - this.last_feature_flag_cache_time < 60000L) {
            return this.last_feature_flag_cache;
        }
        Map map = this.getMostRecentVersionCheckData();
        if (map == null) {
            l = 0L;
        } else {
            byte[] byArray = (byte[])map.get("feat_flags");
            if (byArray != null) {
                try {
                    l = Long.parseLong(new String(byArray));
                }
                catch (Throwable throwable) {
                    l = 0L;
                }
            } else {
                l = 0L;
            }
        }
        this.last_feature_flag_cache = l;
        this.last_feature_flag_cache_time = l2;
        return l;
    }

    public Set<String> getDisabledPluginIDs() {
        byte[] byArray;
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.getMostRecentVersionCheckData();
        if (map != null && (byArray = (byte[])map.get("disabled_pids")) != null) {
            Object[] objectArray;
            String string = new String(byArray);
            String string2 = COConfigurationManager.getStringParameter("vc.disabled_pids.latest", "");
            if (!string.equals(string2)) {
                objectArray = (byte[])map.get("disabled_pids_sig");
                if (objectArray == null) {
                    Debug.out("disabled plugins sig missing");
                    return hashSet;
                }
                try {
                    AEVerifier.verifyData(string, (byte[])objectArray);
                    COConfigurationManager.setParameter("vc.disabled_pids.latest", string);
                }
                catch (Throwable throwable) {
                    return hashSet;
                }
            }
            for (String string3 : objectArray = string.split(",")) {
                if ((string3 = string3.trim()).length() <= 0) continue;
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    public Set<String> getAutoInstallPluginIDs() {
        byte[] byArray;
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.getMostRecentVersionCheckData();
        if (map != null && (byArray = (byte[])map.get("autoinstall_pids")) != null) {
            Object[] objectArray;
            String string = new String(byArray);
            String string2 = COConfigurationManager.getStringParameter("vc.autoinstall_pids.latest", "");
            if (!string.equals(string2)) {
                objectArray = (byte[])map.get("autoinstall_pids_sig");
                if (objectArray == null) {
                    Debug.out("autoinstall plugins sig missing");
                    return hashSet;
                }
                try {
                    AEVerifier.verifyData(string, (byte[])objectArray);
                    COConfigurationManager.setParameter("vc.autoinstall_pids.latest", string);
                }
                catch (Throwable throwable) {
                    return hashSet;
                }
            }
            for (String string3 : objectArray = string.split(",")) {
                if ((string3 = string3.trim()).length() <= 0) continue;
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    public long getCacheTime(boolean bl) {
        return bl ? this.last_check_time_v6 : this.last_check_time_v4;
    }

    public void clearCache() {
        this.last_check_time_v6 = 0L;
        this.last_check_time_v4 = 0L;
    }

    public String getExternalIpAddress(boolean bl, boolean bl2) {
        Map map = this.getVersionCheckInfoSupport(REASON_EXTERNAL_IP, bl, false, bl2);
        byte[] byArray = (byte[])map.get("source_ip_address");
        if (byArray != null) {
            return new String(byArray);
        }
        return null;
    }

    public boolean DHTEnableAllowed() {
        Map map = this.getVersionCheckInfo(REASON_DHT_ENABLE_ALLOWED, 3);
        boolean bl = false;
        byte[] byArray = (byte[])map.get("enable_dht");
        if (byArray != null) {
            bl = new String(byArray).equalsIgnoreCase("true");
        }
        if (!bl) {
            bl = !this.isVersionCheckDataValid(3);
        }
        return bl;
    }

    public boolean DHTExtendedUseAllowed() {
        Map map = this.getVersionCheckInfo(REASON_DHT_EXTENDED_ALLOWED, 3);
        boolean bl = false;
        byte[] byArray = (byte[])map.get("enable_dht_extended_use");
        if (byArray != null) {
            bl = new String(byArray).equalsIgnoreCase("true");
        }
        if (!bl) {
            bl = !this.isVersionCheckDataValid(3);
        }
        return bl;
    }

    public String[] getRecommendedPlugins() {
        Map map = this.getVersionCheckInfo(REASON_RECOMMENDED_PLUGINS, 3);
        List list = (List)map.get("recommended_plugins");
        if (list == null) {
            return new String[0];
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = new String((byte[])list.get(i));
        }
        return stringArray;
    }

    public Map<String, Object> getCountryInfo() {
        Map map = this.getVersionCheckInfo(REASON_EXTERNAL_IP, 3);
        Map map2 = (Map)map.get("source_info");
        if (map2 == null) {
            return new HashMap<String, Object>();
        }
        return BDecoder.decodeStrings(map2);
    }

    private Map performVersionCheck(Map map, boolean bl, boolean bl2, boolean bl3) throws Exception {
        Exception exception = null;
        Map map2 = null;
        if (bl2) {
            try {
                map2 = this.executeHTTP(map, bl3);
                map2.put("protocol_used", "HTTP");
                exception = null;
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (Exception exception2) {
                Debug.printStackTrace(exception2);
                exception = exception2;
            }
        }
        if (map2 == null && bl) {
            try {
                map2 = this.executeAZMessage(map, bl3);
                map2.put("protocol_used", "AZMSG");
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (Exception exception3) {
                Debug.printStackTrace(exception3);
                exception = exception3;
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient server version check successful. Received " + map2.size() + " reply keys."));
        }
        if (bl3) {
            this.last_check_time_v6 = SystemTime.getCurrentTime();
        } else {
            this.last_check_time_v4 = SystemTime.getCurrentTime();
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map executeAZMessage(Map map, boolean bl) throws Exception {
        if (bl && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String string = this.getHost(bl, "version6.vuze.com", "version.vuze.com");
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + string + ":" + 27001));
        }
        ClientMessageService clientMessageService = null;
        Map map2 = null;
        try {
            clientMessageService = ClientMessageServiceClient.getServerService(string, 27001, MESSAGE_TYPE_ID);
            clientMessageService.sendMessage(map);
            map2 = clientMessageService.receiveMessage();
            this.preProcessReply(map2, bl);
            Object var7_6 = null;
            if (clientMessageService != null) {
                clientMessageService.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (clientMessageService != null) {
                clientMessageService.close();
            }
            throw throwable;
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map executeHTTP(Map map, boolean bl) throws Exception {
        if (bl && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String string = this.getHost(bl, "version6.vuze.com", "version.vuze.com");
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + string + ":" + 80 + " via HTTP"));
        }
        String string2 = "http://" + (bl ? UrlUtils.convertIPV6Host(string) : string) + "" + "/version?";
        string2 = string2 + URLEncoder.encode(new String(BEncoder.encode(map), "ISO-8859-1"), "ISO-8859-1");
        URL uRL = new URL(string2);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.connect();
        try {
            InputStream inputStream = httpURLConnection.getInputStream();
            Map map2 = BDecoder.decode(new BufferedInputStream(inputStream));
            this.preProcessReply(map2, bl);
            Map map3 = map2;
            Object var11_10 = null;
            httpURLConnection.disconnect();
            return map3;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            httpURLConnection.disconnect();
            throw throwable;
        }
    }

    public String getHTTPGetString(boolean bl, boolean bl2) {
        return this.getHTTPGetString(new HashMap(), bl, bl2);
    }

    private String getHTTPGetString(Map map, boolean bl, boolean bl2) {
        String string = this.getHost(bl2, "version6.vuze.com", "version.vuze.com");
        String string2 = "GET " + (bl ? "http://" + (bl2 ? UrlUtils.convertIPV6Host(string) : string) + ":" + 80 : "") + "/version?";
        try {
            string2 = string2 + URLEncoder.encode(new String(BEncoder.encode(map), "ISO-8859-1"), "ISO-8859-1");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string2 = string2 + " HTTP/1.1\r\n\r\n";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map executeTCP(Map map, InetAddress inetAddress, int n, boolean bl) throws Exception {
        Map map2;
        block15: {
            if (bl && !this.enable_v6) {
                throw new Exception("IPv6 is disabled");
            }
            String string = this.getHost(bl, "version6.vuze.com", "version.vuze.com");
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + string + ":" + 80 + " via TCP"));
            }
            String string2 = this.getHTTPGetString(map, false, bl);
            Socket socket = null;
            try {
                int n2;
                int n3;
                socket = new Socket();
                if (inetAddress != null) {
                    socket.bind(new InetSocketAddress(inetAddress, n));
                } else if (n != 0) {
                    socket.bind(new InetSocketAddress(n));
                }
                socket.setSoTimeout(10000);
                socket.connect(new InetSocketAddress(string, 80), 10000);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(string2.getBytes("ISO-8859-1"));
                outputStream.flush();
                InputStream inputStream = socket.getInputStream();
                byte[] byArray = new byte[1];
                String string3 = "";
                int n4 = -1;
                while ((n3 = inputStream.read(byArray)) > 0) {
                    if ((string3 = string3 + (char)byArray[0]).endsWith("\r\n\r\n")) {
                        n2 = (string3 = string3.toLowerCase(MessageText.LOCALE_ENGLISH)).indexOf("content-length:");
                        if (n2 == -1) {
                            throw new IOException("content length missing");
                        }
                        string3 = string3.substring(n2 + 15);
                        n2 = string3.indexOf(13);
                        n4 = Integer.parseInt(string3 = string3.substring(0, n2).trim());
                        if (n4 <= 10000) break;
                        throw new IOException("content length too large");
                    }
                    if (string3.length() <= 2048) continue;
                    throw new IOException("header too large");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4);
                byArray = new byte[n4];
                while (n4 > 0 && (n2 = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                    n4 -= n2;
                }
                if (n4 != 0) {
                    throw new IOException("error reading reply");
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                Map map3 = BDecoder.decode(new BufferedInputStream(new ByteArrayInputStream(byArray2)));
                this.preProcessReply(map3, bl);
                map2 = map3;
                Object var18_19 = null;
                if (socket == null) break block15;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var18_20 = null;
                    if (socket == null) break block16;
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return map2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map executeUDP(Map map, InetAddress inetAddress, int n, boolean bl) throws Exception {
        if (bl && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String string = this.getHost(bl, "version6.vuze.com", "version.vuze.com");
        PRUDPReleasablePacketHandler pRUDPReleasablePacketHandler = PRUDPPacketHandlerFactory.getReleasableHandler(n);
        PRUDPPacketHandler pRUDPPacketHandler = pRUDPReleasablePacketHandler.getHandler();
        long l = 5L;
        Random random = new Random();
        try {
            Map map2;
            Exception exception = null;
            pRUDPPacketHandler.setExplicitBindAddress(inetAddress);
            int n2 = 0;
            while (true) {
                if (n2 >= 3) {
                    if (exception == null) throw new Exception("Timeout");
                    throw exception;
                }
                try {
                    long l2 = Long.MIN_VALUE | random.nextLong();
                    VersionCheckClientUDPRequest versionCheckClientUDPRequest = new VersionCheckClientUDPRequest(l2);
                    versionCheckClientUDPRequest.setPayload(map);
                    VersionCheckClientUDPReply versionCheckClientUDPReply = (VersionCheckClientUDPReply)pRUDPPacketHandler.sendAndReceive(null, versionCheckClientUDPRequest, new InetSocketAddress(string, 2080), l);
                    Map map3 = versionCheckClientUDPReply.getPayload();
                    this.preProcessReply(map3, bl);
                    map2 = map3;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    l *= 2L;
                    ++n2;
                    continue;
                }
                break;
            }
            Object var20_18 = null;
            pRUDPPacketHandler.setExplicitBindAddress(null);
            pRUDPReleasablePacketHandler.release();
            return map2;
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            pRUDPPacketHandler.setExplicitBindAddress(null);
            pRUDPReleasablePacketHandler.release();
            throw throwable;
        }
    }

    protected void preProcessReply(Map map, final boolean bl) {
        String string;
        long l;
        Object object;
        Object object2;
        Object object3;
        NetworkAdmin networkAdmin = NetworkAdmin.getSingleton();
        try {
            object3 = (byte[])map.get("source_ip_address");
            object2 = InetAddress.getByName(new String((byte[])object3));
            object = networkAdmin.getCurrentASN();
            NetworkAdminASN networkAdminASN = networkAdmin.lookupCurrentASN((InetAddress)object2);
            if (!networkAdminASN.sameAs((NetworkAdminASN)object) && !secondary_check_done) {
                secondary_check_done = true;
                new AEThread("Secondary version check", true){

                    public void runSupport() {
                        VersionCheckClient.this.getVersionCheckInfoSupport(VersionCheckClient.REASON_SECONDARY_CHECK, false, true, bl);
                    }
                }.start();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        object3 = (Long)map.get("as_advice");
        if (object3 != null && (object = (object2 = networkAdmin.getCurrentASN()).getASName()) != null && (l = ((Long)object3).longValue()) != 0L && !(string = COConfigurationManager.getStringParameter("ASN Advice Followed", "")).equals(object)) {
            boolean bl2;
            COConfigurationManager.setParameter("ASN Advice Followed", (String)object);
            boolean bl3 = l == 1L || l == 2L;
            boolean bl4 = bl2 = l == 1L || l == 3L;
            if (!COConfigurationManager.getBooleanParameter("network.transport.encrypted.require")) {
                if (bl3) {
                    COConfigurationManager.setParameter("network.transport.encrypted.require", true);
                }
                if (bl2) {
                    String string2 = MessageText.getString("crypto.alert.as.warning", new String[]{object});
                    Logger.log(new LogAlert(false, 1, string2));
                }
            }
        }
        if ((object2 = (Long)map.get("ui.toolbar.uiswitcher")) != null) {
            COConfigurationManager.setBooleanDefault("ui.toolbar.uiswitcher", (Long)object2 == 1L);
        }
    }

    public InetAddress getExternalIpAddressHTTP(boolean bl) throws Exception {
        Map map = this.executeHTTP(new HashMap(), bl);
        byte[] byArray = (byte[])map.get("source_ip_address");
        return InetAddress.getByName(new String(byArray));
    }

    public InetAddress getExternalIpAddressTCP(InetAddress inetAddress, int n, boolean bl) throws Exception {
        Map map = this.executeTCP(new HashMap(), inetAddress, n, bl);
        byte[] byArray = (byte[])map.get("source_ip_address");
        return InetAddress.getByName(new String(byArray));
    }

    public InetAddress getExternalIpAddressUDP(InetAddress inetAddress, int n, boolean bl) throws Exception {
        Map map = this.executeUDP(new HashMap(), inetAddress, n, bl);
        byte[] byArray = (byte[])map.get("source_ip_address");
        return InetAddress.getByName(new String(byArray));
    }

    protected String getHost(boolean bl, String string, String string2) {
        if (bl) {
            try {
                return InetAddress.getByName(string).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                try {
                    return DNSUtils.getIPV6ByName(string).getHostAddress();
                }
                catch (UnknownHostException unknownHostException2) {
                    return string;
                }
            }
        }
        return string2;
    }

    public static Map constructVersionCheckMessage(String string) {
        Object object;
        boolean bl = COConfigurationManager.getBooleanParameter("Send Version Info");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("appid", SystemProperties.getApplicationIdentifier());
        hashMap.put("appname", SystemProperties.getApplicationName());
        hashMap.put("version", "4.5.0.4");
        String string2 = "";
        if (string2.length() > 0) {
            hashMap.put("subver", string2);
        }
        if (COConfigurationManager.getBooleanParameter("Beta Programme Enabled")) {
            hashMap.put("beta_prog", "true");
        }
        hashMap.put("ui", COConfigurationManager.getStringParameter("ui", "unknown"));
        hashMap.put("os", Constants.OSName);
        hashMap.put("os_version", System.getProperty("os.version"));
        hashMap.put("os_arch", System.getProperty("os.arch"));
        boolean bl2 = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
        hashMap.put("using_phe", bl2 ? new Long(1L) : new Long(0L));
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.SWT");
            String string3 = (String)clazz.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
            hashMap.put("swt_platform", string3);
            object = (Integer)clazz.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
            hashMap.put("swt_version", new Long(((Integer)object).longValue()));
            if (bl && (clazz = Class.forName("org.gudy.azureus2.ui.swt.mainwindow.MainWindow")) != null) {
                clazz.getMethod("addToVersionCheckMessage", Map.class).invoke(null, hashMap);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = COConfigurationManager.getIntParameter("Send Version Info Last Time", -1);
        int n2 = (int)(SystemTime.getCurrentTime() / 1000L);
        COConfigurationManager.setParameter("Send Version Info Last Time", n2);
        object = COConfigurationManager.getStringParameter("ID", null);
        if (object != null && bl) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string4;
            Object object6;
            OverallStats overallStats;
            String string5;
            Object object7;
            hashMap.put("id", object);
            try {
                object7 = CryptoManagerFactory.getSingleton().getSecureID();
                hashMap.put("id2", object7);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n != -1 && n < n2) {
                hashMap.put("tsl", new Long(n2 - n));
            }
            hashMap.put("reason", string);
            object7 = System.getProperty("java.version");
            if (object7 == null) {
                object7 = "unknown";
            }
            hashMap.put("java", object7);
            String string6 = System.getProperty("java.vm.vendor");
            if (string6 == null) {
                string6 = "unknown";
            }
            hashMap.put("javavendor", string6);
            long l = Runtime.getRuntime().maxMemory() / 0x100000L;
            hashMap.put("javamx", new Long(l));
            String string7 = System.getProperty("java.runtime.name");
            if (string7 != null) {
                hashMap.put("java_rt_name", string7);
            }
            if ((string5 = System.getProperty("java.runtime.version")) != null) {
                hashMap.put("java_rt_version", string5);
            }
            if ((overallStats = StatsFactory.getStats()) != null) {
                long l2 = overallStats.getTotalUpTime();
                hashMap.put("total_uptime", new Long(l2));
            }
            try {
                object6 = NetworkAdmin.getSingleton().getCurrentASN();
                string4 = object6.getAS();
                hashMap.put("ip_as", object6.getAS());
                object5 = object6.getASName();
                if (((String)object5).length() > 64) {
                    object5 = ((String)object5).substring(0, 64);
                }
                hashMap.put("ip_asn", object5);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
            hashMap.put("locale", Locale.getDefault().toString());
            object6 = System.getProperty("user.language") + "_" + System.getProperty("user.country");
            string4 = System.getProperty("user.variant");
            if (string4 != null && string4.length() > 0) {
                object6 = (String)object6 + "_" + string4;
            }
            hashMap.put("orig_locale", object6);
            hashMap.put("user_mode", COConfigurationManager.getIntParameter("User Mode", -1));
            object5 = UtilitiesImpl.getFeaturesInstalled();
            if (object5.size() > 0) {
                object4 = "";
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object4 = (String)object4 + (object4.length() == 0 ? "" : ",") + (String)object2;
                }
                hashMap.put("vzfeatures", object4);
            }
            try {
                if (AzureusCoreFactory.isCoreAvailable()) {
                    object4 = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                    object3 = new ArrayList();
                    object2 = new ArrayList();
                    for (int i = 0; i < ((PluginInterface[])object4).length; ++i) {
                        Map map;
                        PluginInterface pluginInterface = object4[i];
                        String string8 = pluginInterface.getPluginID();
                        String string9 = pluginInterface.getPluginconfig().getPluginStringParameter("plugin.info");
                        if (string9 != null && string9.length() > 0 || !string8.startsWith("<") && !string8.startsWith("azbp") && !string8.startsWith("azupdater") && !string8.startsWith("azplatform") && !object3.contains(string8)) {
                            if (string9 != null && string9.length() > 0) {
                                if (string9.length() < 256) {
                                    string8 = string8 + ":" + string9;
                                } else {
                                    Debug.out("Plugin '" + string8 + "' reported excessive info string '" + string9 + "'");
                                }
                            }
                            object3.add(string8);
                        }
                        if ((map = pluginInterface.getPluginconfig().getPluginMapParameter("plugin.versionserver.data", null)) == null) continue;
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        byte[] byArray = BEncoder.encode(map);
                        if (byArray.length > 16384) {
                            Debug.out("Plugin '" + string8 + "' reported excessive version server data (length=" + byArray.length + ")");
                            hashMap2.put("error", "data too long: " + byArray.length);
                        } else {
                            hashMap2.put("data", byArray);
                        }
                        hashMap2.put("id", string8);
                        hashMap2.put("version", pluginInterface.getPluginVersion());
                        object2.add(hashMap2);
                    }
                    hashMap.put("plugins", object3);
                    if (object2.size() > 0) {
                        hashMap.put("plugin_data", object2);
                    }
                }
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVersionCheckClientListener(boolean bl, VersionCheckClientListener versionCheckClientListener) {
        List<VersionCheckClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(versionCheckClientListener);
            if (bl && this.startCheckRan) {
                try {
                    versionCheckClientListener.versionCheckStarted(REASON_UPDATE_CHECK_START);
                }
                catch (Exception exception) {
                    Debug.out(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVersionCheckClientListener(VersionCheckClientListener versionCheckClientListener) {
        List<VersionCheckClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(versionCheckClientListener);
        }
    }

    public static void main(String[] stringArray) {
        try {
            COConfigurationManager.initialise();
            boolean bl = true;
            Map map = VersionCheckClient.constructVersionCheckMessage(REASON_UPDATE_CHECK_START);
            System.out.println("Sending (pre-initialisation):");
            VersionCheckClient.printDataMap(map);
            System.out.println("-----------");
            System.out.println("Receiving (pre-initialisation):");
            VersionCheckClient.printDataMap(VersionCheckClient.getSingleton().getVersionCheckInfo(REASON_UPDATE_CHECK_START));
            System.out.println("-----------");
            System.out.println();
            System.out.print("Initialising core... ");
            AzureusCoreImpl.SUPPRESS_CLASSLOADER_ERRORS = true;
            DownloadManagerStateImpl.SUPPRESS_FIXUP_ERRORS = true;
            AzureusCore azureusCore = AzureusCoreFactory.create();
            azureusCore.start();
            System.out.println("done.");
            System.out.println();
            System.out.println("-----------");
            map = VersionCheckClient.constructVersionCheckMessage(REASON_UPDATE_CHECK_START);
            System.out.println("Sending (post-initialisation):");
            VersionCheckClient.printDataMap(map);
            System.out.println("-----------");
            System.out.println("Receiving (post-initialisation):");
            VersionCheckClient.printDataMap(VersionCheckClient.getSingleton().getVersionCheckInfo(REASON_UPDATE_CHECK_START));
            System.out.println("-----------");
            System.out.println();
            System.out.print("Shutting down core... ");
            azureusCore.stop();
            System.out.println("done.");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void printDataMap(Map map) throws Exception {
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>(map);
        for (Object object : map.keySet()) {
            Object object2 = map.get(object);
            if (!(object2 instanceof byte[])) continue;
            String string = ByteFormatter.nicePrint((byte[])object2);
            String string2 = new String((byte[])object2, "ISO-8859-1");
            treeMap.put(object, string2 + " [" + string + "]");
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            System.out.print("  ");
            System.out.print(entry.getKey());
            System.out.print(": ");
            System.out.print(entry.getValue());
            System.out.println();
        }
    }

    static {
        VersionCheckClientUDPCodecs.registerCodecs();
    }
}

