/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterAddRemove8Bit;
import com.aelitis.azureus.util.MapUtils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BloomFilterImpl
implements BloomFilter {
    protected static final String MY_PACKAGE = "com.aelitis.azureus.core.util.bloom.impl";
    private static final int HASH_NUM = 5;
    private static final int a2 = 2;
    private static final int a3 = 3;
    private static final int a4 = 5;
    private static final int b2 = 51;
    private static final int b3 = 145;
    private static final int b4 = 216;
    private int max_entries;
    private int entry_count;

    public static BloomFilter deserialiseFromMap(Map<String, Object> map) {
        String string = MapUtils.getMapString(map, "_impl", "");
        if (string.startsWith(".")) {
            string = MY_PACKAGE + string;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(Map.class);
            constructor.setAccessible(true);
            return (BloomFilter)constructor.newInstance(map);
        }
        catch (Throwable throwable) {
            Debug.out("Can't construct bloom filter for " + string, throwable);
            return null;
        }
    }

    public BloomFilterImpl(int n) {
        this.max_entries = n / 2 * 2 + 1;
    }

    public BloomFilterImpl(Map<String, Object> map) {
        this.max_entries = ((Long)map.get("_max")).intValue();
        this.entry_count = ((Long)map.get("_count")).intValue();
    }

    protected void serialiseToMap(Map<String, Object> map) {
        String string = this.getClass().getName();
        if (string.startsWith(MY_PACKAGE)) {
            string = string.substring(MY_PACKAGE.length());
        }
        map.put("_impl", string);
        map.put("_max", new Long(this.max_entries));
        map.put("_count", new Long(this.entry_count));
    }

    @Override
    public Map<String, Object> serialiseToMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.serialiseToMap(hashMap);
        return hashMap;
    }

    protected int getMaxEntries() {
        return this.max_entries;
    }

    @Override
    public int add(byte[] byArray) {
        return this.add(this.bytesToInteger(byArray));
    }

    @Override
    public int remove(byte[] byArray) {
        return this.remove(this.bytesToInteger(byArray));
    }

    @Override
    public int count(byte[] byArray) {
        return this.count(this.bytesToInteger(byArray));
    }

    @Override
    public boolean contains(byte[] byArray) {
        return this.contains(this.bytesToInteger(byArray));
    }

    protected int add(int n) {
        int n2 = 65535;
        for (int i = 0; i < 5; ++i) {
            int n3 = this.getHash(i, n);
            int n4 = this.incValue(n3);
            if (n4 >= n2) continue;
            n2 = n4;
        }
        if (n2 == 0) {
            ++this.entry_count;
        }
        return this.trimValue(n2 + 1);
    }

    protected int remove(int n) {
        int n2 = 65535;
        for (int i = 0; i < 5; ++i) {
            int n3 = this.getHash(i, n);
            int n4 = this.decValue(n3);
            if (n4 >= n2) continue;
            n2 = n4;
        }
        if (n2 == 1 && this.entry_count > 0) {
            --this.entry_count;
        }
        return this.trimValue(n2 - 1);
    }

    protected int count(int n) {
        int n2 = 65535;
        for (int i = 0; i < 5; ++i) {
            int n3 = this.getHash(i, n);
            int n4 = this.getValue(n3);
            if (n4 >= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    protected boolean contains(int n) {
        for (int i = 0; i < 5; ++i) {
            int n2 = this.getHash(i, n);
            int n3 = this.getValue(n2);
            if (n3 != 0) continue;
            return false;
        }
        return true;
    }

    protected abstract int getValue(int var1);

    protected abstract int incValue(int var1);

    protected abstract int decValue(int var1);

    protected abstract int trimValue(int var1);

    protected int getHash(int n, int n2) {
        long l;
        switch (n) {
            case 0: {
                l = n2;
                break;
            }
            case 1: {
                l = n2 * n2;
                break;
            }
            case 2: {
                l = n2 * 2 + 51;
                break;
            }
            case 3: {
                l = n2 * 3 + 145;
                break;
            }
            case 4: {
                l = n2 * 5 + 216;
                break;
            }
            default: {
                System.out.println("**** BloomFilter hash function doesn't exist ****");
                l = 0L;
            }
        }
        return Math.abs((int)l % this.max_entries);
    }

    protected int bytesToInteger(byte[] byArray) {
        int n = 1375186049;
        for (int i = 0; i < byArray.length; ++i) {
            n = n * 191 + (byArray[i] & 0xFF);
        }
        return n;
    }

    @Override
    public int getEntryCount() {
        return this.entry_count;
    }

    @Override
    public int getSize() {
        return this.max_entries;
    }

    protected static byte[] getSerialization(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = (byte)(n >> 8);
        byArray2[byArray.length + 1] = (byte)(n & 0xFF);
        return byArray2;
    }

    @Override
    public String getString() {
        return "ent=" + this.entry_count + ",max=" + this.max_entries;
    }

    public static void main(String[] stringArray) {
        Random random = new Random();
        int n = 0;
        for (int i = 0; i < 1000; ++i) {
            long l = System.currentTimeMillis();
            BloomFilterAddRemove8Bit bloomFilterAddRemove8Bit = new BloomFilterAddRemove8Bit(10000);
            int n2 = 0;
            for (int j = 0; j < 1000; ++j) {
                byte[] byArray = new byte[6];
                random.nextBytes(byArray);
                if (j % 2 == 0) {
                    bloomFilterAddRemove8Bit.add(byArray);
                    if (bloomFilterAddRemove8Bit.contains(byArray)) continue;
                    System.out.println("false negative on add!!!!");
                    continue;
                }
                if (!bloomFilterAddRemove8Bit.contains(byArray)) continue;
                ++n2;
            }
            System.out.println("" + (System.currentTimeMillis() - l) + ", fp = " + n2);
            if (n2 <= 0) continue;
            ++n;
        }
        System.out.println(n);
    }
}

