/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloomFilterAddRemove4Bit
extends BloomFilterImpl {
    private byte[] map;

    public BloomFilterAddRemove4Bit(int n) {
        super(n);
        this.map = new byte[(this.getMaxEntries() + 1) / 2];
    }

    public BloomFilterAddRemove4Bit(Map<String, Object> map) {
        super(map);
        this.map = (byte[])map.get("map");
    }

    @Override
    protected void serialiseToMap(Map<String, Object> map) {
        super.serialiseToMap(map);
        map.put("map", this.map.clone());
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterAddRemove4Bit(this.getMaxEntries());
    }

    @Override
    protected int trimValue(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 15) {
            return 15;
        }
        return n;
    }

    @Override
    protected int getValue(int n) {
        byte by = this.map[n / 2];
        if (n % 2 == 0) {
            return by & 0xF & 0xFF;
        }
        return by >> 4 & 0xF & 0xFF;
    }

    @Override
    protected int incValue(int n) {
        int n2 = this.getValue(n);
        if (n2 >= 15) {
            return 15;
        }
        this.setValue(n, (byte)(n2 + 1));
        return n2;
    }

    @Override
    protected int decValue(int n) {
        int n2 = this.getValue(n);
        if (n2 <= 0) {
            return 0;
        }
        this.setValue(n, (byte)(n2 - 1));
        return n2;
    }

    private void setValue(int n, byte by) {
        byte by2 = this.map[n / 2];
        by2 = n % 2 == 0 ? (byte)(by2 & 0xF0 | by) : (byte)(by2 & 0xF | by << 4 & 0xF0);
        this.map[n / 2] = by2;
    }
}

