/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloomFilterAddOnly
extends BloomFilterImpl {
    private byte[] map;

    public BloomFilterAddOnly(int n) {
        super(n);
        this.map = new byte[(this.getMaxEntries() + 7) / 8];
    }

    public BloomFilterAddOnly(Map<String, Object> map) {
        super(map);
        this.map = (byte[])map.get("map");
    }

    @Override
    protected void serialiseToMap(Map<String, Object> map) {
        super.serialiseToMap(map);
        map.put("map", this.map.clone());
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterAddOnly(this.getMaxEntries());
    }

    @Override
    protected int trimValue(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 1) {
            return 1;
        }
        return n;
    }

    @Override
    protected int getValue(int n) {
        byte by = this.map[n / 8];
        return by >> n % 8 & 1;
    }

    @Override
    protected int incValue(int n) {
        int n2 = this.getValue(n);
        if (n2 >= 1) {
            return 1;
        }
        this.setValue(n, (byte)(n2 + 1));
        return n2;
    }

    @Override
    protected int decValue(int n) {
        int n2 = this.getValue(n);
        if (n2 <= 0) {
            return 0;
        }
        this.setValue(n, (byte)(n2 - 1));
        return n2;
    }

    private void setValue(int n, byte by) {
        byte by2 = this.map[n / 8];
        if (by == 0) {
            throw new RuntimeException("remove not supported");
        }
        this.map[n / 8] = by2 = (byte)(by2 | 1 << n % 8);
    }
}

