/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class MovingImmediateAverage
implements Average {
    private final int periods;
    private double[] data;
    private int pos = 0;

    public MovingImmediateAverage(int n) {
        this.periods = n;
        this.data = new double[n];
        for (int i = 0; i < n; ++i) {
            this.data[i] = 0.0;
        }
    }

    public void reset() {
        this.pos = 0;
    }

    public double update(double d) {
        this.data[this.pos++ % this.periods] = d;
        if (this.pos == Integer.MAX_VALUE) {
            this.pos %= this.periods;
        }
        return this.calculateAve();
    }

    public double[] getValues() {
        double[] dArray = new double[this.periods];
        int n = this.pos;
        for (int i = 0; i < this.periods; ++i) {
            dArray[i] = this.data[n++ % this.periods];
        }
        return dArray;
    }

    public double getAverage() {
        return this.calculateAve();
    }

    public int getSampleCount() {
        return this.pos > this.periods ? this.periods : this.pos;
    }

    private double calculateAve() {
        int n;
        int n2 = n = this.pos > this.periods ? this.periods : this.pos;
        if (n == 0) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.data[i];
        }
        return d / (double)n;
    }
}

