/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class ExponentialMovingAverage
implements Average {
    private final float weight;
    private double prevEMA;

    public ExponentialMovingAverage(int n) {
        if (n < 1) {
            System.out.println("ExponentialMovingAverage:: ERROR: bad periods: " + n);
        }
        this.weight = 2.0f / (float)(1 + n);
        this.prevEMA = 0.0;
    }

    public ExponentialMovingAverage(float f) {
        if ((double)f < 0.0 || (double)f > 1.0) {
            System.out.println("ExponentialMovingAverage:: ERROR: bad weight: " + f);
        }
        this.weight = f;
        this.prevEMA = 0.0;
    }

    public void reset() {
        this.prevEMA = 0.0;
    }

    public double update(double d) {
        this.prevEMA = (double)this.weight * (d - this.prevEMA) + this.prevEMA;
        return this.prevEMA;
    }

    public double getAverage() {
        return this.prevEMA;
    }
}

