/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.lws.LightWeightSeedAdapter;
import com.aelitis.azureus.core.lws.LightWeightSeedManager;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionPopularityListener;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.impl.SubscriptionBodyImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultFilter;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.json.simple.JSONObject;

public class SubscriptionImpl
implements Subscription {
    public static final int ADD_TYPE_CREATE = 1;
    public static final int ADD_TYPE_IMPORT = 2;
    public static final int ADD_TYPE_LOOKUP = 3;
    private static final int MAX_ASSOCIATIONS = 256;
    private static final int MIN_RECENT_ASSOC_TO_RETAIN = 16;
    private SubscriptionManagerImpl manager;
    private byte[] public_key;
    private byte[] private_key;
    private String name;
    private String name_ex;
    private int version;
    private int az_version;
    private boolean is_public;
    private Map singleton_details;
    private byte[] hash;
    private byte[] sig;
    private int sig_data_size;
    private int add_type;
    private long add_time;
    private boolean is_subscribed;
    private int highest_prompted_version;
    private byte[] short_id;
    private String id;
    private List associations = new ArrayList();
    private int fixed_random;
    private long popularity = -1L;
    private long last_auto_upgrade_check = -1L;
    private boolean published;
    private boolean server_published;
    private boolean server_publication_outstanding;
    private boolean singleton_sp_attempted;
    private LightWeightSeed lws;
    private int lws_skip_check;
    private boolean destroyed;
    private Map history_map;
    private Map schedule_map;
    private Map user_data = new LightHashMap();
    private final SubscriptionHistoryImpl history;
    private String referer;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private Map verify_cache_details;
    private boolean verify_cache_result;
    private String creator_ref;
    private String category;

    protected static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    protected static int bytesToInt(byte[] byArray) {
        return byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
    }

    protected static String getSkeletonJSON(Engine engine, int n) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("engine_id", new Long(engine.getId()));
        jSONObject.put("search_term", "");
        jSONObject.put("filters", new HashMap());
        jSONObject.put("options", new HashMap());
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("interval", new Long(n));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= 7; ++i) {
            arrayList.add(String.valueOf(i));
        }
        hashMap.put("days", arrayList);
        jSONObject.put("schedule", hashMap);
        SubscriptionImpl.embedEngines(jSONObject, engine);
        return JSONUtils.encodeToJSON(jSONObject);
    }

    protected SubscriptionImpl(SubscriptionManagerImpl subscriptionManagerImpl, String string, boolean bl, Map map, String string2, int n) throws SubscriptionException {
        this.manager = subscriptionManagerImpl;
        this.history_map = new HashMap();
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.name = string;
        this.is_public = bl;
        this.singleton_details = map;
        this.version = 1;
        this.az_version = 1;
        this.add_type = n;
        this.add_time = SystemTime.getCurrentTime();
        this.is_subscribed = true;
        try {
            KeyPair keyPair = CryptoECCUtils.createKeys();
            this.public_key = CryptoECCUtils.keyToRawdata(keyPair.getPublic());
            this.private_key = CryptoECCUtils.keyToRawdata(keyPair.getPrivate());
            this.fixed_random = new Random().nextInt();
            this.init();
            String string3 = this.embedEngines(string2);
            SubscriptionBodyImpl subscriptionBodyImpl = new SubscriptionBodyImpl(this.manager, this.name, this.is_public, string3, this.public_key, this.version, this.az_version, this.singleton_details);
            this.syncToBody(subscriptionBodyImpl);
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Failed to create subscription", throwable);
        }
    }

    protected SubscriptionImpl(SubscriptionManagerImpl subscriptionManagerImpl, Map map) throws IOException {
        this.manager = subscriptionManagerImpl;
        this.fromMap(map);
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.init();
    }

    protected SubscriptionImpl(SubscriptionManagerImpl subscriptionManagerImpl, SubscriptionBodyImpl subscriptionBodyImpl, int n, boolean bl) throws SubscriptionException {
        this.manager = subscriptionManagerImpl;
        this.history_map = new HashMap();
        this.history = new SubscriptionHistoryImpl(this.manager, this);
        this.syncFromBody(subscriptionBodyImpl);
        this.add_type = n;
        this.add_time = SystemTime.getCurrentTime();
        this.is_subscribed = bl;
        this.fixed_random = new Random().nextInt();
        this.init();
        this.syncToBody(subscriptionBodyImpl);
    }

    protected void syncFromBody(SubscriptionBodyImpl subscriptionBodyImpl) throws SubscriptionException {
        this.public_key = subscriptionBodyImpl.getPublicKey();
        this.version = subscriptionBodyImpl.getVersion();
        this.az_version = subscriptionBodyImpl.getAZVersion();
        this.name = subscriptionBodyImpl.getName();
        this.is_public = subscriptionBodyImpl.isPublic();
        this.singleton_details = subscriptionBodyImpl.getSingletonDetails();
        if (this.az_version > 1) {
            throw new SubscriptionException(MessageText.getString("subscription.version.bad", new String[]{this.name}));
        }
    }

    protected void syncToBody(SubscriptionBodyImpl subscriptionBodyImpl) throws SubscriptionException {
        subscriptionBodyImpl.writeVuzeFile(this);
        this.hash = subscriptionBodyImpl.getHash();
        this.sig = subscriptionBodyImpl.getSig();
        this.sig_data_size = subscriptionBodyImpl.getSigDataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map toMap() throws IOException {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", this.name.getBytes("UTF-8"));
            hashMap.put("public_key", this.public_key);
            hashMap.put("version", new Long(this.version));
            hashMap.put("az_version", new Long(this.az_version));
            hashMap.put("is_public", new Long(this.is_public ? 1L : 0L));
            if (this.singleton_details != null) {
                hashMap.put("sin_details", this.singleton_details);
                hashMap.put("spa", new Long(this.singleton_sp_attempted ? 1L : 0L));
            }
            hashMap.put("hash", this.hash);
            hashMap.put("sig", this.sig);
            hashMap.put("sig_data_size", new Long(this.sig_data_size));
            if (this.private_key != null) {
                hashMap.put("private_key", this.private_key);
            }
            hashMap.put("add_type", new Long(this.add_type));
            hashMap.put("add_time", new Long(this.add_time));
            hashMap.put("subscribed", new Long(this.is_subscribed ? 1L : 0L));
            hashMap.put("pop", new Long(this.popularity));
            hashMap.put("rand", new Long(this.fixed_random));
            hashMap.put("hupv", new Long(this.highest_prompted_version));
            hashMap.put("sp", new Long(this.server_published ? 1L : 0L));
            hashMap.put("spo", new Long(this.server_publication_outstanding ? 1L : 0L));
            if (this.associations.size() > 0) {
                ArrayList arrayList = new ArrayList();
                hashMap.put("assoc", arrayList);
                for (int i = 0; i < this.associations.size(); ++i) {
                    association association2 = (association)this.associations.get(i);
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    arrayList.add(hashMap2);
                    hashMap2.put("h", association2.getHash());
                    hashMap2.put("w", new Long(association2.getWhen()));
                }
            }
            hashMap.put("history", this.history_map);
            if (this.creator_ref != null) {
                hashMap.put("cref", this.creator_ref.getBytes("UTF-8"));
            }
            if (this.category != null) {
                hashMap.put("cat", this.category.getBytes("UTF-8"));
            }
            return hashMap;
        }
    }

    protected void fromMap(Map map) throws IOException {
        byte[] byArray;
        Object object;
        List list;
        this.name = new String((byte[])map.get("name"), "UTF-8");
        this.public_key = (byte[])map.get("public_key");
        this.private_key = (byte[])map.get("private_key");
        this.version = ((Long)map.get("version")).intValue();
        this.az_version = (int)ImportExportUtils.importLong(map, "az_version", 1L);
        this.is_public = ((Long)map.get("is_public")).intValue() == 1;
        this.singleton_details = (Map)map.get("sin_details");
        this.hash = (byte[])map.get("hash");
        this.sig = (byte[])map.get("sig");
        this.sig_data_size = ((Long)map.get("sig_data_size")).intValue();
        this.fixed_random = ((Long)map.get("rand")).intValue();
        this.add_type = ((Long)map.get("add_type")).intValue();
        this.add_time = (Long)map.get("add_time");
        this.is_subscribed = ((Long)map.get("subscribed")).intValue() == 1;
        this.popularity = (Long)map.get("pop");
        this.highest_prompted_version = ((Long)map.get("hupv")).intValue();
        this.server_published = ((Long)map.get("sp")).intValue() == 1;
        this.server_publication_outstanding = ((Long)map.get("spo")).intValue() == 1;
        Long l = (Long)map.get("spa");
        if (l != null) {
            boolean bl = this.singleton_sp_attempted = l == 1L;
        }
        if ((list = (List)map.get("assoc")) != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = (Map)list.get(i);
                byte[] byArray2 = (byte[])object.get("h");
                long l2 = (Long)object.get("w");
                this.associations.add(new association(byArray2, l2));
            }
        }
        this.history_map = (Map)map.get("history");
        if (this.history_map == null) {
            this.history_map = new HashMap();
        }
        if ((byArray = (byte[])map.get("cref")) != null) {
            this.creator_ref = new String(byArray, "UTF-8");
        }
        if ((object = (Object)((byte[])map.get("cat"))) != null) {
            this.category = new String((byte[])object, "UTF-8");
        }
    }

    protected Map getScheduleConfig() {
        if (this.schedule_map == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                this.schedule_map = (Map)map.get("schedule");
                if (this.schedule_map == null) {
                    this.schedule_map = new HashMap();
                }
            }
            catch (Throwable throwable) {
                this.log("Failed to load schedule", throwable);
                this.schedule_map = new HashMap();
            }
        }
        return this.schedule_map;
    }

    protected Map getHistoryConfig() {
        return this.history_map;
    }

    protected void updateHistoryConfig(Map map) {
        this.history_map = map;
        this.fireChanged();
    }

    protected void upgrade(SubscriptionBodyImpl subscriptionBodyImpl) throws SubscriptionException {
        this.syncFromBody(subscriptionBodyImpl);
        this.syncToBody(subscriptionBodyImpl);
        this.fireChanged();
    }

    protected void init() {
        this.short_id = SubscriptionBodyImpl.deriveShortID(this.public_key, this.singleton_details);
        this.id = null;
    }

    public boolean isSingleton() {
        return this.singleton_details != null;
    }

    public boolean isShareable() {
        try {
            return this.getEngine().isShareable() && !this.isSingleton();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return false;
        }
    }

    protected Map getSingletonDetails() {
        return this.singleton_details;
    }

    protected boolean getSingletonPublishAttempted() {
        return this.singleton_sp_attempted;
    }

    protected void setSingletonPublishAttempted() {
        if (!this.singleton_sp_attempted) {
            this.singleton_sp_attempted = true;
            this.manager.configDirty(this);
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) throws SubscriptionException {
        if (!this.name.equals(string)) {
            boolean bl = false;
            String string2 = this.name;
            int n = this.version++;
            try {
                this.name = string;
                SubscriptionBodyImpl subscriptionBodyImpl = new SubscriptionBodyImpl(this.manager, this);
                this.syncToBody(subscriptionBodyImpl);
                this.versionUpdated(subscriptionBodyImpl, false);
                bl = true;
                Object var7_6 = null;
                if (!bl) {
                    this.name = string2;
                    this.version = n;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!bl) {
                    this.name = string2;
                    this.version = n;
                }
                throw throwable;
            }
            this.fireChanged();
        }
    }

    public String getNameEx() {
        if (this.name_ex == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                String string = (String)map.get("search_term");
                Map map2 = (Map)map.get("filters");
                Engine engine = this.manager.getEngine(this, map, true);
                String string2 = engine.getNameEx();
                this.name_ex = this.name.startsWith(string2) ? this.name : (string2.startsWith(this.name) ? string2 : this.name + ": " + engine.getNameEx());
                if (string != null && string.length() > 0) {
                    this.name_ex = this.name_ex + ", query=" + string;
                }
                if (map2 != null && map2.size() > 0) {
                    this.name_ex = this.name_ex + ", filters=" + new SubscriptionResultFilter(map2).getString();
                }
            }
            catch (Throwable throwable) {
                this.name_ex = this.name + ": " + Debug.getNestedExceptionMessage(throwable);
            }
        }
        return this.name_ex;
    }

    public long getAddTime() {
        return this.add_time;
    }

    public boolean isPublic() {
        return this.is_public;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublic(boolean bl) throws SubscriptionException {
        if (this.is_public != bl) {
            boolean bl2 = false;
            boolean bl3 = this.is_public;
            int n = this.version++;
            try {
                this.is_public = bl;
                SubscriptionBodyImpl subscriptionBodyImpl = new SubscriptionBodyImpl(this.manager, this);
                this.syncToBody(subscriptionBodyImpl);
                this.versionUpdated(subscriptionBodyImpl, false);
                bl2 = true;
                Object var7_6 = null;
                if (!bl2) {
                    this.version = n;
                    this.is_public = bl3;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!bl2) {
                    this.version = n;
                    this.is_public = bl3;
                }
                throw throwable;
            }
            this.fireChanged();
        }
    }

    protected boolean getServerPublicationOutstanding() {
        return this.server_publication_outstanding;
    }

    protected void setServerPublicationOutstanding() {
        if (!this.server_publication_outstanding) {
            this.server_publication_outstanding = true;
            this.fireChanged();
        }
    }

    protected void setServerPublished() {
        if (this.server_publication_outstanding || !this.server_published) {
            this.server_published = true;
            this.server_publication_outstanding = false;
            this.fireChanged();
        }
    }

    protected boolean getServerPublished() {
        return this.server_published;
    }

    public String getJSON() throws SubscriptionException {
        try {
            SubscriptionBodyImpl subscriptionBodyImpl = new SubscriptionBodyImpl(this.manager, this);
            return subscriptionBodyImpl.getJSON();
        }
        catch (Throwable throwable) {
            this.history.setFatalError(Debug.getNestedExceptionMessage(throwable));
            if (throwable instanceof SubscriptionException) {
                throw (SubscriptionException)throwable;
            }
            throw new SubscriptionException("Failed to read subscription", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setJSON(String string) throws SubscriptionException {
        SubscriptionBodyImpl subscriptionBodyImpl;
        String string2;
        String string3 = this.embedEngines(string);
        if (!string3.equals(string2 = (subscriptionBodyImpl = new SubscriptionBodyImpl(this.manager, this)).getJSON())) {
            boolean bl = false;
            int n = this.version++;
            try {
                subscriptionBodyImpl.setJSON(string3);
                this.syncToBody(subscriptionBodyImpl);
                this.versionUpdated(subscriptionBodyImpl, true);
                this.referer = null;
                bl = true;
                Object var8_7 = null;
                if (!bl) {
                    this.version = n;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!bl) {
                    this.version = n;
                }
                throw throwable;
            }
            this.fireChanged();
            return true;
        }
        return false;
    }

    protected String embedEngines(String string) {
        Map map = JSONUtils.decodeJSON(string);
        long l = (Long)map.get("engine_id");
        String string2 = string;
        if (l >= Integer.MAX_VALUE || l < 0L) {
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngine(l);
            if (engine == null) {
                this.log("Private search template with id '" + l + "' not found!!!!");
            } else {
                try {
                    SubscriptionImpl.embedEngines(map, engine);
                    string2 = JSONUtils.encodeToJSON(map);
                    this.log("Embedded private search template '" + engine.getName() + "'");
                }
                catch (Throwable throwable) {
                    this.log("Failed to embed private search template", throwable);
                }
            }
        }
        return string2;
    }

    protected static void embedEngines(Map map, Engine engine) {
        HashMap hashMap = new HashMap();
        map.put("engines", hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        try {
            String string = new String(Base64.encode(BEncoder.encode(engine.exportToBencodedMap())), "UTF-8");
            hashMap2.put("content", string);
            hashMap.put(String.valueOf(engine.getId()), hashMap2);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    protected Engine extractEngine(Map map, long l) {
        Map map2;
        Map map3 = (Map)map.get("engines");
        if (map3 != null && (map2 = (Map)map3.get(String.valueOf(l))) != null) {
            String string = (String)map2.get("content");
            try {
                Map map4 = BDecoder.decode(Base64.decode(string.getBytes("UTF-8")));
                return MetaSearchManagerFactory.getSingleton().getMetaSearch().importFromBEncodedMap(map4);
            }
            catch (Throwable throwable) {
                this.log("failed to import engine", throwable);
            }
        }
        return null;
    }

    public Engine getEngine() throws SubscriptionException {
        return this.getEngine(true);
    }

    protected Engine getEngine(boolean bl) throws SubscriptionException {
        Map map = JSONUtils.decodeJSON(this.getJSON());
        return this.manager.getEngine(this, map, bl);
    }

    protected void engineUpdated(Engine engine) {
        try {
            String string = this.getJSON();
            Map map = JSONUtils.decodeJSON(string);
            long l = (Long)map.get("engine_id");
            if (l == engine.getId() && this.setJSON(string)) {
                this.log("Engine has been updated, saved");
            }
        }
        catch (Throwable throwable) {
            this.log("Engine update failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDetails(String string, boolean bl, String string2) throws SubscriptionException {
        SubscriptionBodyImpl subscriptionBodyImpl;
        String string3;
        boolean bl2;
        boolean bl3 = bl2 = !(string2 = this.embedEngines(string2)).equals(string3 = (subscriptionBodyImpl = new SubscriptionBodyImpl(this.manager, this)).getJSON());
        if (!string.equals(this.name) || bl != this.is_public || bl2) {
            boolean bl4 = false;
            String string4 = this.name;
            boolean bl5 = this.is_public;
            int n = this.version++;
            try {
                this.is_public = bl;
                this.name = string;
                subscriptionBodyImpl.setJSON(string2);
                this.syncToBody(subscriptionBodyImpl);
                this.versionUpdated(subscriptionBodyImpl, bl2);
                bl4 = true;
                Object var12_11 = null;
                if (!bl4) {
                    this.version = n;
                    this.is_public = bl5;
                    this.name = string4;
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (!bl4) {
                    this.version = n;
                    this.is_public = bl5;
                    this.name = string4;
                }
                throw throwable;
            }
            this.fireChanged();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void versionUpdated(SubscriptionBodyImpl subscriptionBodyImpl, boolean bl) {
        Object object;
        if (bl) {
            try {
                object = JSONUtils.decodeJSON(subscriptionBodyImpl.getJSON());
                this.schedule_map = (Map)object.get("schedule");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.name_ex = null;
        if (this.is_public) {
            this.manager.updatePublicSubscription(this);
            this.setPublished(false);
            object = this;
            synchronized (object) {
                for (int i = 0; i < this.associations.size(); ++i) {
                    ((association)this.associations.get(i)).setPublished(false);
                }
            }
        }
    }

    public byte[] getPublicKey() {
        return this.public_key;
    }

    public byte[] getShortID() {
        return this.short_id;
    }

    public String getID() {
        if (this.id == null) {
            this.id = Base32.encode(this.getShortID());
        }
        return this.id;
    }

    protected byte[] getPrivateKey() {
        return this.private_key;
    }

    protected int getFixedRandom() {
        return this.fixed_random;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAZVersion() {
        return this.az_version;
    }

    protected void setHighestUserPromptedVersion(int n) {
        if (n < this.version) {
            n = this.version;
        }
        if (this.highest_prompted_version != n) {
            this.highest_prompted_version = n;
            this.fireChanged();
        }
    }

    protected int getHighestUserPromptedVersion() {
        return this.highest_prompted_version;
    }

    public int getHighestVersion() {
        return Math.max(this.version, this.highest_prompted_version);
    }

    public void resetHighestVersion() {
        if (this.highest_prompted_version > 0) {
            this.highest_prompted_version = 0;
            this.fireChanged();
            this.manager.checkUpgrade(this);
        }
    }

    public boolean isMine() {
        if (this.private_key == null) {
            return false;
        }
        return !this.isSingleton() || this.add_type == 1;
    }

    public boolean isUpdateable() {
        return this.private_key != null;
    }

    public boolean isSubscribed() {
        return this.is_subscribed;
    }

    public void setSubscribed(boolean bl) {
        if (this.is_subscribed != bl) {
            this.is_subscribed = bl;
            if (this.is_subscribed) {
                this.manager.setSelected(this);
            }
            this.fireChanged();
        }
    }

    public boolean isAutoDownloadSupported() {
        return this.history.isAutoDownloadSupported();
    }

    public void getPopularity(final SubscriptionPopularityListener subscriptionPopularityListener) throws SubscriptionException {
        new AEThread2("subs:popwait", true){

            public void run() {
                try {
                    SubscriptionImpl.this.manager.getPopularity(SubscriptionImpl.this, new SubscriptionPopularityListener(){

                        public void gotPopularity(long l) {
                            if (l != SubscriptionImpl.this.popularity) {
                                SubscriptionImpl.this.popularity = l;
                                SubscriptionImpl.this.fireChanged();
                            }
                            subscriptionPopularityListener.gotPopularity(SubscriptionImpl.this.popularity);
                        }

                        public void failed(SubscriptionException subscriptionException) {
                            if (SubscriptionImpl.this.popularity == -1L) {
                                subscriptionPopularityListener.failed(new SubscriptionException("Failed to read popularity", subscriptionException));
                            } else {
                                subscriptionPopularityListener.gotPopularity(SubscriptionImpl.this.popularity);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (SubscriptionImpl.this.popularity == -1L) {
                        subscriptionPopularityListener.failed(new SubscriptionException("Failed to read popularity", throwable));
                    }
                    subscriptionPopularityListener.gotPopularity(SubscriptionImpl.this.popularity);
                }
            }
        }.start();
    }

    public long getCachedPopularity() {
        return this.popularity;
    }

    protected void setCachedPopularity(long l) {
        if (l != this.popularity) {
            this.popularity = l;
            this.fireChanged();
        }
    }

    public String getReferer() {
        if (this.referer == null) {
            try {
                Map map = JSONUtils.decodeJSON(this.getJSON());
                Engine engine = this.manager.getEngine(this, map, false);
                if (engine != null) {
                    this.referer = engine.getReferer();
                }
            }
            catch (Throwable throwable) {
                this.log("Failed to get referer", throwable);
            }
            if (this.referer == null) {
                this.referer = "";
            }
        }
        return this.referer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPublish() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            if (this.destroyed) {
                return;
            }
            if (this.isSingleton()) {
                return;
            }
            if (!this.isSubscribed()) {
                return;
            }
            if (this.popularity > 100L) {
                if (this.lws_skip_check == 2) {
                    return;
                }
                if (this.lws_skip_check == 0) {
                    if (new Random().nextInt((int)((this.popularity + 99L) / 100L)) == 0) {
                        this.lws_skip_check = 1;
                    } else {
                        this.lws_skip_check = 2;
                        return;
                    }
                }
            }
            if (this.hash != null) {
                boolean bl = false;
                if (this.lws == null) {
                    bl = true;
                } else if (!Arrays.equals(this.lws.getHash().getBytes(), this.hash)) {
                    this.lws.remove();
                    bl = true;
                }
                if (bl) {
                    try {
                        File file = this.manager.getVuzeFile(this);
                        if (file.exists()) {
                            File file2 = new File(file.getParent(), file.getName() + "." + this.getVersion());
                            if (!file2.exists() && !FileUtil.copyFile(file, file2)) {
                                throw new Exception("Failed to copy file to '" + file2 + "'");
                            }
                            this.lws = LightWeightSeedManager.getSingleton().add(this.getName(), new HashWrapper(this.hash), TorrentUtils.getDecentralisedEmptyURL(), file2, new LightWeightSeedAdapter(){

                                public TOTorrent getTorrent(byte[] byArray, URL uRL, File file) throws Exception {
                                    SubscriptionImpl.this.log(" - generating torrent: " + Debug.getCompressedStackTrace());
                                    TOTorrentCreator tOTorrentCreator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file, uRL, 262144L);
                                    TOTorrent tOTorrent = tOTorrentCreator.create();
                                    tOTorrent.setHashOverride(byArray);
                                    return tOTorrent;
                                }
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to create light-weight-seed", throwable);
                    }
                }
            }
        }
    }

    protected synchronized boolean canAutoUpgradeCheck() {
        if (this.isSingleton()) {
            return false;
        }
        long l = SystemTime.getMonotonousTime();
        if (this.last_auto_upgrade_check == -1L || l - this.last_auto_upgrade_check > 14400000L) {
            this.last_auto_upgrade_check = l;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssociation(byte[] byArray) {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            for (int i = 0; i < this.associations.size(); ++i) {
                association association2 = (association)this.associations.get(i);
                if (!Arrays.equals(association2.getHash(), byArray)) continue;
                return;
            }
            this.associations.add(new association(byArray, SystemTime.getCurrentTime()));
            if (this.associations.size() > 256) {
                this.associations.remove(new Random().nextInt(240));
            }
        }
        this.fireChanged();
        this.manager.associationAdded(this, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAssociation(byte[] byArray) {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            for (int i = 0; i < this.associations.size(); ++i) {
                association association2 = (association)this.associations.get(i);
                if (!Arrays.equals(association2.getHash(), byArray)) continue;
                return true;
            }
        }
        return false;
    }

    public void addPotentialAssociation(String string, String string2) {
        this.manager.addPotentialAssociation(this, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssociationCount() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            return this.associations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected association getAssociationForPublish() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            Object object;
            int n;
            int n2 = this.associations.size();
            for (n = n2 - 1; n >= Math.max(0, n2 - 16); --n) {
                object = (association)this.associations.get(n);
                if (((association)object).getPublished()) continue;
                ((association)object).setPublished(true);
                return object;
            }
            n = this.associations.size() - 16;
            if (n > 0) {
                object = new ArrayList(this.associations.subList(0, n));
                Collections.shuffle(object);
                for (int i = 0; i < object.size(); ++i) {
                    association association2 = (association)object.get(i);
                    if (association2.getPublished()) continue;
                    association2.setPublished(true);
                    return association2;
                }
            }
        }
        return null;
    }

    protected boolean getPublished() {
        return this.published;
    }

    protected void setPublished(boolean bl) {
        this.published = bl;
    }

    protected int getVerifiedPublicationVersion(Map map) {
        if (this.isSingleton()) {
            return this.getVersion();
        }
        if (!this.verifyPublicationDetails(map)) {
            return -1;
        }
        return SubscriptionImpl.getPublicationVersion(map);
    }

    protected static int getPublicationVersion(Map map) {
        return ((Long)map.get("v")).intValue();
    }

    protected byte[] getPublicationHash() {
        return this.hash;
    }

    protected static byte[] getPublicationHash(Map map) {
        return (byte[])map.get("h");
    }

    protected static int getPublicationSize(Map map) {
        return ((Long)map.get("z")).intValue();
    }

    protected Map getPublicationDetails() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("h", this.hash);
        hashMap.put("v", new Long(this.version));
        hashMap.put("z", new Long(this.sig_data_size));
        hashMap.put("s", this.sig);
        if (this.singleton_details != null) {
            hashMap.put("x", this.singleton_details);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyPublicationDetails(Map map) {
        Object object = this;
        synchronized (object) {
            if (BEncoder.mapsAreIdentical(this.verify_cache_details, map)) {
                return this.verify_cache_result;
            }
        }
        object = (byte[])map.get("h");
        int n = ((Long)map.get("v")).intValue();
        int n2 = ((Long)map.get("z")).intValue();
        byte[] byArray = (byte[])map.get("s");
        boolean bl = SubscriptionBodyImpl.verify(this.public_key, (byte[])object, n, n2, byArray);
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            this.verify_cache_details = map;
            this.verify_cache_result = bl;
        }
        return bl;
    }

    public void setCreatorRef(String string) {
        this.creator_ref = string;
        this.fireChanged();
    }

    public String getCreatorRef() {
        return this.creator_ref;
    }

    public void setCategory(String string) {
        if (string == null && this.category == null) {
            return;
        }
        if (string != null && this.category != null && string.equals(this.category)) {
            return;
        }
        this.manager.setCategoryOnExisting(this, this.category, string);
        this.category = string;
        this.fireChanged();
    }

    public String getCategory() {
        return this.category;
    }

    protected void fireChanged() {
        this.manager.configDirty(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((SubscriptionListener)iterator.next()).subscriptionChanged(this);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void fireDownloaded(boolean bl) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((SubscriptionListener)iterator.next()).subscriptionDownloaded(this, bl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void addListener(SubscriptionListener subscriptionListener) {
        this.listeners.add(subscriptionListener);
    }

    public void removeListener(SubscriptionListener subscriptionListener) {
        this.listeners.remove(subscriptionListener);
    }

    public SubscriptionHistory getHistory() {
        return this.history;
    }

    public SubscriptionManager getManager() {
        return this.manager;
    }

    public VuzeFile getVuzeFile() throws SubscriptionException {
        try {
            return VuzeFileHandler.getSingleton().loadVuzeFile(this.manager.getVuzeFile(this).getAbsolutePath());
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Failed to get Vuze file", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        LightWeightSeed lightWeightSeed;
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            this.destroyed = true;
            lightWeightSeed = this.lws;
        }
        if (lightWeightSeed != null) {
            lightWeightSeed.remove();
        }
    }

    public void reset() {
        this.getHistory().reset();
        try {
            this.getEngine().reset();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public void remove() {
        this.destroy();
        this.manager.removeSubscription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        SubscriptionImpl subscriptionImpl = this;
        synchronized (subscriptionImpl) {
            return this.destroyed;
        }
    }

    public SubscriptionResult[] getResults(boolean bl) {
        return this.getHistory().getResults(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object object, Object object2) {
        Map map = this.user_data;
        synchronized (map) {
            if (object2 == null) {
                this.user_data.remove(object);
            } else {
                this.user_data.put(object, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object object) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(object);
        }
    }

    protected void log(String string) {
        this.manager.log(this.getString() + ": " + string);
    }

    protected void log(String string, Throwable throwable) {
        this.manager.log(this.getString() + ": " + string, throwable);
    }

    public String getString() {
        return "name=" + this.name + ",sid=" + ByteFormatter.encodeString(this.short_id) + ",ver=" + this.version + ",pub=" + this.is_public + ",mine=" + this.isMine() + ",sub=" + this.is_subscribed + (this.is_subscribed ? ",hist={" + this.history.getString() + "}" : "") + ",pop=" + this.popularity + (this.server_publication_outstanding ? ",spo=true" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(IndentWriter indentWriter) {
        String string;
        try {
            string = "" + this.getEngine().getId();
        }
        catch (Throwable throwable) {
            string = Debug.getNestedExceptionMessage(throwable);
        }
        indentWriter.println(this.getString() + ": engine=" + string);
        try {
            indentWriter.indent();
            SubscriptionImpl subscriptionImpl = this;
            synchronized (subscriptionImpl) {
                for (int i = 0; i < this.associations.size(); ++i) {
                    ((association)this.associations.get(i)).generate(indentWriter);
                }
            }
            Object var7_7 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    protected static class association {
        private byte[] hash;
        private long when;
        private boolean published;

        protected association(byte[] byArray, long l) {
            this.hash = byArray;
            this.when = l;
        }

        protected byte[] getHash() {
            return this.hash;
        }

        protected long getWhen() {
            return this.when;
        }

        protected boolean getPublished() {
            return this.published;
        }

        protected void setPublished(boolean bl) {
            this.published = bl;
        }

        protected String getString() {
            return ByteFormatter.encodeString(this.hash) + ", pub=" + this.published;
        }

        protected void generate(IndentWriter indentWriter) {
            indentWriter.println(this.getString());
        }
    }
}

