/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security.impl;

import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.core.security.CryptoManagerPasswordException;
import com.aelitis.azureus.core.security.CryptoManagerPasswordHandler;
import com.aelitis.azureus.core.security.impl.CryptoHandlerECC;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class CryptoManagerImpl
implements CryptoManager {
    private static final int PBE_ITERATIONS = 100;
    private static final String PBE_ALG = "PBEWithMD5AndDES";
    private static CryptoManagerImpl singleton;
    private byte[] secure_id;
    private CryptoHandler ecc_handler;
    private CopyOnWriteList password_handlers = new CopyOnWriteList();
    private CopyOnWriteList keychange_listeners = new CopyOnWriteList();
    private Map session_passwords = Collections.synchronizedMap(new HashMap());

    public static synchronized CryptoManager getSingleton() {
        if (singleton == null) {
            singleton = new CryptoManagerImpl();
        }
        return singleton;
    }

    protected CryptoManagerImpl() {
        SESecurityManager.initialise();
        long l = SystemTime.getCurrentTime();
        for (int i = 0; i < CryptoManager.HANDLERS.length; ++i) {
            int n = CryptoManager.HANDLERS[i];
            String string = "core.crypto.pw." + n + ".persist_timeout";
            String string2 = "core.crypto.pw." + n + ".persist_value";
            long l2 = COConfigurationManager.getLongParameter(string, 0L);
            if (l > l2) {
                COConfigurationManager.setParameter(string, 0);
                COConfigurationManager.setParameter(string2, "");
                continue;
            }
            this.addPasswordTimer(string, string2, l2);
        }
        this.ecc_handler = new CryptoHandlerECC(this, 1);
    }

    protected void addPasswordTimer(final String string, final String string2, final long l) {
        SimpleTimer.addEvent("CryptoManager:pw_timeout", l, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent timerEvent2) {
                CryptoManagerImpl cryptoManagerImpl = CryptoManagerImpl.this;
                synchronized (cryptoManagerImpl) {
                    if (COConfigurationManager.getLongParameter(string, 0L) == l) {
                        COConfigurationManager.removeParameter(string);
                        COConfigurationManager.removeParameter(string2);
                    }
                }
            }
        });
    }

    public byte[] getSecureID() {
        String string = "core.crypto.id";
        if (this.secure_id == null) {
            this.secure_id = COConfigurationManager.getByteParameter(string, null);
        }
        if (this.secure_id == null) {
            this.secure_id = new byte[20];
            RandomUtils.SECURE_RANDOM.nextBytes(this.secure_id);
            COConfigurationManager.setParameter(string, this.secure_id);
            COConfigurationManager.save();
        }
        return this.secure_id;
    }

    public CryptoHandler getECCHandler() {
        return this.ecc_handler;
    }

    protected byte[] encryptWithPBE(byte[] byArray, char[] cArray) throws CryptoManagerException {
        try {
            byte[] byArray2 = new byte[8];
            RandomUtils.SECURE_RANDOM.nextBytes(byArray2);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBE_ALG);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray2, 100);
            Cipher cipher = Cipher.getInstance(PBE_ALG);
            cipher.init(1, (Key)secretKey, pBEParameterSpec);
            byte[] byArray3 = cipher.doFinal(byArray);
            byte[] byArray4 = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            return byArray4;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("PBE encryption failed", throwable);
        }
    }

    protected byte[] decryptWithPBE(byte[] byArray, char[] cArray) throws CryptoManagerException {
        boolean bl = false;
        try {
            byte[] byArray2 = new byte[8];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBE_ALG);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray2, 100);
            Cipher cipher = Cipher.getInstance(PBE_ALG);
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
            bl = true;
            return cipher.doFinal(byArray, 8, byArray.length - 8);
        }
        catch (Throwable throwable) {
            if (bl) {
                throw new CryptoManagerPasswordException(true, "Password incorrect", throwable);
            }
            throw new CryptoManagerException("PBE decryption failed", throwable);
        }
    }

    public void clearPasswords() {
        this.clearPasswords(3);
    }

    public void clearPasswords(int n) {
        this.session_passwords.clear();
        for (int i = 0; i < CryptoManager.HANDLERS.length; ++i) {
            this.clearPassword(CryptoManager.HANDLERS[i], n);
        }
        this.ecc_handler.lock();
    }

    protected void clearPassword(int n, int n2) {
        String string = "core.crypto.pw." + n + ".persist_timeout";
        String string2 = "core.crypto.pw." + n + ".persist_value";
        String string3 = "core.crypto.pw." + n + ".persist_type";
        int n3 = (int)COConfigurationManager.getLongParameter(string3, 1L);
        if (n2 == 3 || n2 == n3) {
            COConfigurationManager.removeParameter(string);
            COConfigurationManager.removeParameter(string2);
        }
    }

    protected passwordDetails setPassword(int n, int n2, char[] cArray, long l) throws CryptoManagerException {
        try {
            String string = "core.crypto.pw." + n + ".persist_timeout";
            String string2 = "core.crypto.pw." + n + ".persist_value";
            String string3 = "core.crypto.pw." + n + ".persist_type";
            byte[] byArray = this.getPasswordSalt();
            byte[] byArray2 = new String(cArray).getBytes("UTF8");
            SHA1 sHA1 = new SHA1();
            sHA1.update(ByteBuffer.wrap(byArray));
            sHA1.update(ByteBuffer.wrap(byArray2));
            String string4 = ByteFormatter.encodeString(sHA1.digest());
            COConfigurationManager.setParameter(string, l);
            COConfigurationManager.setParameter(string3, n2);
            COConfigurationManager.setParameter(string2, string4);
            passwordDetails passwordDetails2 = new passwordDetails(string4.toCharArray(), n2);
            return passwordDetails2;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("setPassword failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected passwordDetails getPassword(int n, int n2, String string, passwordTester passwordTester2, int n3) throws CryptoManagerException {
        int n4;
        Iterator iterator;
        String string2 = "core.crypto.pw." + n + ".persist_timeout";
        String string3 = "core.crypto.pw." + n + ".persist_value";
        String string4 = "core.crypto.pw." + n + ".persist_type";
        long l = COConfigurationManager.getLongParameter(string2, 0L);
        if (l < 0L && (iterator = (passwordDetails)this.session_passwords.get(string3)) != null && ((passwordDetails)((Object)iterator)).getHandlerType() == n3) {
            return iterator;
        }
        if (l > SystemTime.getCurrentTime() && ((String)((Object)(iterator = COConfigurationManager.getStringParameter(string3, "")))).length() > 0 && (n4 = (int)COConfigurationManager.getLongParameter(string4, 1L)) == n3) {
            return new passwordDetails(((String)((Object)iterator)).toCharArray(), n4);
        }
        iterator = this.password_handlers.iterator();
        block5: while (iterator.hasNext()) {
            n4 = 0;
            char[] cArray = null;
            CryptoManagerPasswordHandler cryptoManagerPasswordHandler = (CryptoManagerPasswordHandler)iterator.next();
            if (n3 != 0 && n3 != cryptoManagerPasswordHandler.getHandlerType()) continue;
            while (n4 < 64) {
                try {
                    CryptoManagerPasswordHandler.passwordDetails passwordDetails2 = cryptoManagerPasswordHandler.getPassword(n, n2, n4 > 0, string);
                    if (passwordDetails2 == null) continue block5;
                    char[] cArray2 = passwordDetails2.getPassword();
                    if (cArray != null && Arrays.equals(cArray, cArray2)) {
                        ++n4;
                        continue;
                    }
                    cArray = cArray2;
                    byte[] byArray = this.getPasswordSalt();
                    byte[] byArray2 = new String(cArray2).getBytes("UTF8");
                    SHA1 sHA1 = new SHA1();
                    sHA1.update(ByteBuffer.wrap(byArray));
                    sHA1.update(ByteBuffer.wrap(byArray2));
                    String string5 = ByteFormatter.encodeString(sHA1.digest());
                    if (passwordTester2 != null && !passwordTester2.testPassword(string5.toCharArray())) {
                        ++n4;
                        continue;
                    }
                    int n5 = passwordDetails2.getPersistForSeconds();
                    long l2 = n5 == 0 ? 0L : (n5 == Integer.MAX_VALUE ? Long.MAX_VALUE : (n5 < 0 ? -1L : SystemTime.getCurrentTime() + (long)n5 * 1000L));
                    passwordDetails passwordDetails3 = new passwordDetails(string5.toCharArray(), cryptoManagerPasswordHandler.getHandlerType());
                    CryptoManagerImpl cryptoManagerImpl = this;
                    synchronized (cryptoManagerImpl) {
                        COConfigurationManager.setParameter(string2, l2);
                        COConfigurationManager.setParameter(string4, cryptoManagerPasswordHandler.getHandlerType());
                        this.session_passwords.remove(string3);
                        COConfigurationManager.removeParameter(string3);
                        if (l2 < 0L) {
                            this.session_passwords.put(string3, passwordDetails3);
                        } else if (l2 > 0L) {
                            COConfigurationManager.setParameter(string3, string5);
                            this.addPasswordTimer(string2, string3, l2);
                        }
                    }
                    cryptoManagerPasswordHandler.passwordOK(n, passwordDetails2);
                    return passwordDetails3;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    continue block5;
                }
            }
        }
        throw new CryptoManagerPasswordException(false, "No password handlers returned a password");
    }

    protected byte[] getPasswordSalt() {
        return this.getSecureID();
    }

    protected void setSecureID(byte[] byArray) {
        String string = "core.crypto.id";
        COConfigurationManager.setParameter(string, byArray);
        COConfigurationManager.save();
        this.secure_id = byArray;
    }

    protected void keyChanged(CryptoHandler cryptoHandler) {
        Iterator iterator = this.keychange_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((CryptoManagerKeyListener)iterator.next()).keyChanged(cryptoHandler);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void lockChanged(CryptoHandler cryptoHandler) {
        Iterator iterator = this.keychange_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((CryptoManagerKeyListener)iterator.next()).keyLockStatusChanged(cryptoHandler);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void addPasswordHandler(CryptoManagerPasswordHandler cryptoManagerPasswordHandler) {
        this.password_handlers.add(cryptoManagerPasswordHandler);
    }

    public void removePasswordHandler(CryptoManagerPasswordHandler cryptoManagerPasswordHandler) {
        this.password_handlers.remove(cryptoManagerPasswordHandler);
    }

    public void addKeyListener(CryptoManagerKeyListener cryptoManagerKeyListener) {
        this.keychange_listeners.add(cryptoManagerKeyListener);
    }

    public void removeKeyListener(CryptoManagerKeyListener cryptoManagerKeyListener) {
        this.keychange_listeners.remove(cryptoManagerKeyListener);
    }

    public static void main(String[] stringArray) {
        try {
            String string = "12345";
            CryptoManagerImpl cryptoManagerImpl = (CryptoManagerImpl)CryptoManagerImpl.getSingleton();
            cryptoManagerImpl.addPasswordHandler(new CryptoManagerPasswordHandler(){

                public int getHandlerType() {
                    return 1;
                }

                public CryptoManagerPasswordHandler.passwordDetails getPassword(int n, int n2, boolean bl, String string) {
                    return new CryptoManagerPasswordHandler.passwordDetails(){

                        public char[] getPassword() {
                            return "trout".toCharArray();
                        }

                        public int getPersistForSeconds() {
                            return 10;
                        }
                    };
                }

                public void passwordOK(int n, CryptoManagerPasswordHandler.passwordDetails passwordDetails2) {
                }
            });
            CryptoHandler cryptoHandler = cryptoManagerImpl.getECCHandler();
            CryptoHandlerECC cryptoHandlerECC = new CryptoHandlerECC(cryptoManagerImpl, 2);
            byte[] byArray = cryptoHandler.sign(string.getBytes(), "h1: sign");
            System.out.println(cryptoHandler.verify(cryptoHandler.getPublicKey("h1: Test verify"), string.getBytes(), byArray));
            cryptoHandler.lock();
            byte[] byArray2 = cryptoHandler.encrypt(cryptoHandlerECC.getPublicKey("h2: getPublic"), string.getBytes(), "h1: encrypt");
            System.out.println("pk1 = " + ByteFormatter.encodeString(cryptoHandler.getPublicKey("h1: getPublic")));
            System.out.println("pk2 = " + ByteFormatter.encodeString(cryptoHandlerECC.getPublicKey("h2: getPublic")));
            System.out.println("dec: " + new String(cryptoHandlerECC.decrypt(cryptoHandler.getPublicKey("h1: getPublic"), byArray2, "h2: decrypt")));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public class passwordDetails {
        private char[] password;
        private int type;

        protected passwordDetails(char[] cArray, int n) {
            this.password = cArray;
            this.type = n;
        }

        public char[] getPassword() {
            return this.password;
        }

        public int getHandlerType() {
            return this.type;
        }
    }

    public static interface passwordTester {
        public boolean testPassword(char[] var1);
    }
}

