/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.proxy.AEProxy;
import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.AEProxyHandler;
import com.aelitis.azureus.core.proxy.impl.AEProxyConnectionImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEProxyImpl
implements AEProxy,
VirtualChannelSelector.VirtualSelectorListener {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final int DEBUG_PERIOD = 60000;
    private long last_debug;
    private int port;
    private long connect_timeout;
    private long read_timeout;
    private AEProxyHandler proxy_handler;
    private VirtualChannelSelector read_selector;
    private VirtualChannelSelector connect_selector;
    private VirtualChannelSelector write_selector;
    private List processors = new ArrayList();
    private final HashMap write_select_regs = new HashMap();
    private boolean allow_external_access;
    private AEMonitor this_mon = new AEMonitor("AEProxyImpl");

    public AEProxyImpl(int n, long l, long l2, AEProxyHandler aEProxyHandler) throws AEProxyException {
        this.port = n;
        this.connect_timeout = l;
        this.read_timeout = l2;
        this.proxy_handler = aEProxyHandler;
        String string = "Proxy:" + this.port;
        this.read_selector = new VirtualChannelSelector(string, 1, false);
        this.connect_selector = new VirtualChannelSelector(string, 8, true);
        this.write_selector = new VirtualChannelSelector(string, 4, true);
        try {
            final ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port), 128);
            if (this.port == 0) {
                this.port = serverSocket.getLocalPort();
            }
            AEThread aEThread = new AEThread("AEProxy:connect.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.connect_selector);
                }
            };
            aEThread.setDaemon(true);
            aEThread.start();
            AEThread aEThread2 = new AEThread("AEProxy:read.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.read_selector);
                }
            };
            aEThread2.setDaemon(true);
            aEThread2.start();
            AEThread aEThread3 = new AEThread("AEProxy:write.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.write_selector);
                }
            };
            aEThread3.setDaemon(true);
            aEThread3.start();
            AEThread aEThread4 = new AEThread("AEProxy:accept.loop"){

                public void runSupport() {
                    AEProxyImpl.this.acceptLoop(serverSocketChannel);
                }
            };
            aEThread4.setDaemon(true);
            aEThread4.start();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxy: listener established on port " + this.port));
            }
        }
        catch (Throwable throwable) {
            Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.port});
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxy: listener failed on port " + this.port, throwable));
            }
            throw new AEProxyException("AEProxy: accept fails: " + throwable.toString());
        }
    }

    public void setAllowExternalConnections(boolean bl) {
        this.allow_external_access = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptLoop(ServerSocketChannel serverSocketChannel) {
        long l = 0L;
        long l2 = 0L;
        while (true) {
            try {
                while (true) {
                    Object var9_7;
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    ++l;
                    if (!this.allow_external_access && !socketChannel.socket().getInetAddress().isLoopbackAddress()) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "AEProxy: incoming connection from '" + socketChannel.socket().getInetAddress() + "' - closed as not local"));
                        }
                        socketChannel.close();
                        continue;
                    }
                    socketChannel.configureBlocking(false);
                    AEProxyConnectionImpl aEProxyConnectionImpl = new AEProxyConnectionImpl(this, socketChannel, this.proxy_handler);
                    if (aEProxyConnectionImpl.isClosed()) continue;
                    try {
                        this.this_mon.enter();
                        this.processors.add(aEProxyConnectionImpl);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "AEProxy: active processors = " + this.processors.size()));
                        }
                        var9_7 = null;
                        this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        var9_7 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                    this.read_selector.register(socketChannel, this, (Object)aEProxyConnectionImpl);
                }
            }
            catch (Throwable throwable) {
                ++l2;
                if (!Logger.isEnabled()) continue;
                Logger.log(new LogEvent(LOGID, "AEProxy: listener failed on port " + this.port, throwable));
                if (l2 <= 100L || l != 0L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "TCP"});
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(AEProxyConnectionImpl aEProxyConnectionImpl) {
        try {
            this.this_mon.enter();
            this.processors.remove(aEProxyConnectionImpl);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void selectLoop(VirtualChannelSelector virtualChannelSelector) {
        long l = 0L;
        while (true) {
            try {
                while (true) {
                    virtualChannelSelector.select(100L);
                    if (virtualChannelSelector != this.read_selector) continue;
                    long l2 = SystemTime.getCurrentTime();
                    if (l2 < l) {
                        l = l2;
                        continue;
                    }
                    if (l2 - l < 5000L) continue;
                    l = l2;
                    this.checkTimeouts();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        long l = SystemTime.getCurrentTime();
        if (l - this.last_debug > 60000L) {
            this.last_debug = l;
            try {
                this.this_mon.enter();
                for (Object object : this.processors) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent(LOGID, "AEProxy: active processor: " + ((AEProxyConnectionImpl)object).getStateString()));
                }
                Object var6_5 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        if (this.connect_timeout <= 0L && this.read_timeout <= 0L) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        try {
            this.this_mon.enter();
            for (AEProxyConnectionImpl aEProxyConnectionImpl : this.processors) {
                long l2 = l - aEProxyConnectionImpl.getTimeStamp();
                if (this.connect_timeout > 0L && l2 >= this.connect_timeout && !aEProxyConnectionImpl.isConnected()) {
                    arrayList.add(aEProxyConnectionImpl);
                    continue;
                }
                if (this.read_timeout <= 0L || l2 < this.read_timeout || !aEProxyConnectionImpl.isConnected()) continue;
                arrayList.add(aEProxyConnectionImpl);
            }
            Object var9_10 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((AEProxyConnectionImpl)arrayList.get(i)).failed(new Throwable("timeout"));
        }
    }

    protected void requestWriteSelect(AEProxyConnectionImpl aEProxyConnectionImpl, SocketChannel socketChannel) {
        if (this.write_select_regs.containsKey(socketChannel)) {
            this.write_selector.resumeSelects(socketChannel);
        } else {
            this.write_select_regs.put(socketChannel, null);
            this.write_selector.register(socketChannel, this, (Object)aEProxyConnectionImpl);
        }
    }

    protected void cancelWriteSelect(SocketChannel socketChannel) {
        this.write_select_regs.remove(socketChannel);
        this.write_selector.cancel(socketChannel);
    }

    protected void requestReadSelect(AEProxyConnectionImpl aEProxyConnectionImpl, SocketChannel socketChannel) {
        this.read_selector.register(socketChannel, this, (Object)aEProxyConnectionImpl);
    }

    protected void cancelReadSelect(SocketChannel socketChannel) {
        this.read_selector.cancel(socketChannel);
    }

    protected void requestConnectSelect(AEProxyConnectionImpl aEProxyConnectionImpl, SocketChannel socketChannel) {
        this.connect_selector.register(socketChannel, this, (Object)aEProxyConnectionImpl);
    }

    protected void cancelConnectSelect(SocketChannel socketChannel) {
        this.connect_selector.cancel(socketChannel);
    }

    public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
        AEProxyConnectionImpl aEProxyConnectionImpl = (AEProxyConnectionImpl)object;
        if (virtualChannelSelector == this.read_selector) {
            return aEProxyConnectionImpl.read(socketChannel);
        }
        if (virtualChannelSelector == this.write_selector) {
            return aEProxyConnectionImpl.write(socketChannel);
        }
        return aEProxyConnectionImpl.connect(socketChannel);
    }

    public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
        AEProxyConnectionImpl aEProxyConnectionImpl = (AEProxyConnectionImpl)object;
        aEProxyConnectionImpl.failed(throwable);
    }

    public int getPort() {
        return this.port;
    }
}

