/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.nat;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.nat.NATTraversal;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.peermanager.nat.PeerNATInitiator;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraversalAdapter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class PeerNATTraverser
implements NATTraversalHandler {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final int OUTCOME_SUCCESS = 0;
    private static final int OUTCOME_FAILED_NO_REND = 1;
    private static final int OUTCOME_FAILED_OTHER = 2;
    private static PeerNATTraverser singleton;
    private static int MAX_ACTIVE_REQUESTS;
    private static final int TIMER_PERIOD = 10000;
    private static final int USAGE_PERIOD = 10000;
    private static final int USAGE_DURATION_SECS = 60;
    private static final int MAX_USAGE_PER_MIN;
    private static final int STATS_TICK_COUNT = 12;
    private NATTraverser nat_traverser;
    private Map initiators = new HashMap();
    private LinkedList pending_requests = new LinkedList();
    private List active_requests = new ArrayList();
    private Average usage_average = Average.getInstance(10000, 60);
    private int attempted_count = 0;
    private int success_count = 0;
    private int failed_no_rendezvous = 0;
    private int failed_negative_bloom = 0;
    private BloomFilter negative_result_bloom = BloomFilterFactory.createAddOnly(BLOOM_SIZE);
    private static final int BLOOM_SIZE;
    private static final int BLOOM_REBUILD_PERIOD = 300000;
    private static final int BLOOM_REBUILD_TICKS = 30;

    public static void initialise(AzureusCore azureusCore) {
        singleton = new PeerNATTraverser(azureusCore);
    }

    public static PeerNATTraverser getSingleton() {
        return singleton;
    }

    public PeerNATTraverser(AzureusCore azureusCore) {
        this.nat_traverser = azureusCore.getNATTraverser();
        this.nat_traverser.registerHandler(this);
        SimpleTimer.addPeriodicEvent("PeerNAT:stats", 10000L, new TimerEventPerformer(){
            private int ticks;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent timerEvent2) {
                Object object;
                int n;
                ++this.ticks;
                ArrayList<PeerNATTraversal> arrayList = null;
                Map map = PeerNATTraverser.this.initiators;
                synchronized (map) {
                    int n2;
                    if (this.ticks % 30 == 0) {
                        n2 = PeerNATTraverser.this.negative_result_bloom.getEntryCount();
                        if (Logger.isEnabled() && n2 > 0) {
                            Logger.log(new LogEvent(LOGID, "PeerNATTraverser: negative bloom size = " + n2));
                        }
                        PeerNATTraverser.this.negative_result_bloom = BloomFilterFactory.createAddOnly(BLOOM_SIZE);
                    }
                    if (this.ticks % 12 == 0) {
                        String string = "NAT traversal stats: active=" + PeerNATTraverser.this.active_requests.size() + ",pending=" + PeerNATTraverser.this.pending_requests.size() + ",attempted=" + PeerNATTraverser.this.attempted_count + ",no rendezvous=" + PeerNATTraverser.this.failed_no_rendezvous + ",negative bloom=" + PeerNATTraverser.this.failed_negative_bloom + ",successful=" + PeerNATTraverser.this.success_count;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, string));
                        }
                    }
                    n2 = 0;
                    for (n = 0; n < PeerNATTraverser.this.active_requests.size(); ++n) {
                        n2 = (int)((long)n2 + ((PeerNATTraversal)PeerNATTraverser.this.active_requests.get(n)).getTimeUsed());
                    }
                    PeerNATTraverser.this.usage_average.addValue(n2);
                    n = (int)PeerNATTraverser.this.usage_average.getAverage();
                    if (n > MAX_USAGE_PER_MIN) {
                        return;
                    }
                    while (PeerNATTraverser.this.pending_requests.size() != 0 && PeerNATTraverser.this.active_requests.size() < MAX_ACTIVE_REQUESTS) {
                        object = (PeerNATTraversal)PeerNATTraverser.this.pending_requests.removeFirst();
                        PeerNATTraverser.this.active_requests.add(object);
                        if (arrayList == null) {
                            arrayList = new ArrayList<PeerNATTraversal>();
                        }
                        arrayList.add((PeerNATTraversal)object);
                        PeerNATTraverser.this.attempted_count++;
                    }
                }
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        PeerNATTraversal peerNATTraversal = (PeerNATTraversal)arrayList.get(i);
                        n = 0;
                        object = PeerNATTraverser.this.initiators;
                        synchronized (object) {
                            if (PeerNATTraverser.this.negative_result_bloom.contains(peerNATTraversal.getTarget().toString().getBytes())) {
                                n = 1;
                                PeerNATTraverser.this.failed_negative_bloom++;
                            }
                        }
                        if (n != 0) {
                            PeerNATTraverser.this.removeRequest(peerNATTraversal, 2);
                            peerNATTraversal.getAdapter().failed();
                            continue;
                        }
                        peerNATTraversal.run();
                    }
                }
            }
        });
    }

    public int getType() {
        return 1;
    }

    public String getName() {
        return "Peer Traversal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(PeerNATInitiator peerNATInitiator) {
        Map map = this.initiators;
        synchronized (map) {
            if (this.initiators.put(peerNATInitiator, new LinkedList()) != null) {
                Debug.out("initiator already present");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PeerNATInitiator peerNATInitiator) {
        LinkedList linkedList;
        Map map = this.initiators;
        synchronized (map) {
            Object object = (LinkedList)this.initiators.remove(peerNATInitiator);
            if (object == null) {
                Debug.out("initiator not present");
                return;
            }
            linkedList = object;
        }
        for (Object object : linkedList) {
            ((PeerNATTraversal)object).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(PeerNATInitiator peerNATInitiator, InetSocketAddress inetSocketAddress, PeerNATTraversalAdapter peerNATTraversalAdapter) {
        boolean bl = false;
        Map map = this.initiators;
        synchronized (map) {
            if (this.negative_result_bloom.contains(inetSocketAddress.toString().getBytes())) {
                bl = true;
                ++this.failed_negative_bloom;
            } else {
                LinkedList linkedList = (LinkedList)this.initiators.get(peerNATInitiator);
                if (linkedList == null) {
                    bl = true;
                } else {
                    PeerNATTraversal peerNATTraversal = new PeerNATTraversal(peerNATInitiator, inetSocketAddress, peerNATTraversalAdapter);
                    linkedList.addLast(peerNATTraversal);
                    this.pending_requests.addLast(peerNATTraversal);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "created NAT traversal for " + peerNATInitiator.getDisplayName() + "/" + inetSocketAddress));
                    }
                }
            }
        }
        if (bl) {
            peerNATTraversalAdapter.failed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTraversals(PeerNATInitiator peerNATInitiator) {
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>();
        Map map = this.initiators;
        synchronized (map) {
            LinkedList linkedList = (LinkedList)this.initiators.get(peerNATInitiator);
            if (linkedList != null) {
                for (PeerNATTraversal peerNATTraversal : linkedList) {
                    arrayList.add(peerNATTraversal.getTarget());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRequest(PeerNATTraversal peerNATTraversal, int n) {
        Map map = this.initiators;
        synchronized (map) {
            LinkedList linkedList = (LinkedList)this.initiators.get(peerNATTraversal.getInitiator());
            if (linkedList != null) {
                linkedList.remove(peerNATTraversal);
            }
            this.pending_requests.remove(peerNATTraversal);
            if (this.active_requests.remove(peerNATTraversal)) {
                this.usage_average.addValue(peerNATTraversal.getTimeUsed());
                if (n == 0) {
                    ++this.success_count;
                } else {
                    InetSocketAddress inetSocketAddress = peerNATTraversal.getTarget();
                    this.negative_result_bloom.add(inetSocketAddress.toString().getBytes());
                    if (n == 1) {
                        ++this.failed_no_rendezvous;
                    }
                }
            }
        }
    }

    public Map process(InetSocketAddress inetSocketAddress, Map map) {
        return null;
    }

    static {
        COConfigurationManager.addAndFireParameterListener("peer.nat.traversal.request.conc.max", new ParameterListener(){

            public void parameterChanged(String string) {
                MAX_ACTIVE_REQUESTS = COConfigurationManager.getIntParameter(string);
            }
        });
        MAX_USAGE_PER_MIN = MAX_ACTIVE_REQUESTS * 5 * 1000;
        BLOOM_SIZE = MAX_ACTIVE_REQUESTS * 1024;
    }

    protected class PeerNATTraversal
    implements NATTraversalObserver {
        private PeerNATInitiator initiator;
        private InetSocketAddress target;
        private PeerNATTraversalAdapter adapter;
        private NATTraversal traversal;
        private boolean cancelled;
        private long time;

        protected PeerNATTraversal(PeerNATInitiator peerNATInitiator, InetSocketAddress inetSocketAddress, PeerNATTraversalAdapter peerNATTraversalAdapter) {
            this.initiator = peerNATInitiator;
            this.target = inetSocketAddress;
            this.adapter = peerNATTraversalAdapter;
        }

        protected PeerNATInitiator getInitiator() {
            return this.initiator;
        }

        protected InetSocketAddress getTarget() {
            return this.target;
        }

        protected PeerNATTraversalAdapter getAdapter() {
            return this.adapter;
        }

        protected long getTimeUsed() {
            long l = SystemTime.getCurrentTime();
            long l2 = l - this.time;
            this.time = l;
            l2 = l2 < 0L ? 0L : Math.min(l2, 10000L);
            return l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run() {
            PeerNATTraversal peerNATTraversal = this;
            synchronized (peerNATTraversal) {
                if (!this.cancelled) {
                    this.time = SystemTime.getCurrentTime();
                    this.traversal = PeerNATTraverser.this.nat_traverser.attemptTraversal(PeerNATTraverser.this, this.target, null, false, this);
                }
            }
        }

        public void succeeded(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, Map map) {
            PeerNATTraverser.this.removeRequest(this, 0);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "NAT traversal for " + this.initiator.getDisplayName() + "/" + inetSocketAddress2 + " succeeded"));
            }
            this.adapter.success(inetSocketAddress2);
        }

        public void failed(int n) {
            PeerNATTraverser.this.removeRequest(this, n == 1 ? 1 : 2);
            this.adapter.failed();
        }

        public void failed(Throwable throwable) {
            PeerNATTraverser.this.removeRequest(this, 2);
            this.adapter.failed();
        }

        public void disabled() {
            PeerNATTraverser.this.removeRequest(this, 2);
            this.adapter.failed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancel() {
            boolean bl = false;
            PeerNATTraversal peerNATTraversal = this;
            synchronized (peerNATTraversal) {
                this.cancelled = true;
                if (this.traversal == null) {
                    bl = true;
                }
            }
            if (bl) {
                PeerNATTraverser.this.removeRequest(this, 2);
            } else {
                this.traversal.cancel();
            }
            this.adapter.failed();
        }
    }
}

