/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStylePeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class UTPeerExchange
implements AZStylePeerExchange,
LTMessage {
    public static final boolean ENABLED = true;
    private static final LogIDs LOGID = LogIDs.NET;
    private static final int IPv4_SIZE_WITH_PORT = 6;
    private static final int IPv6_SIZE_WITH_PORT = 18;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte version;
    private final PeerItem[] peers_added;
    private final PeerItem[] peersAddedNoSeeds;
    private final PeerItem[] peers_dropped;

    public UTPeerExchange(PeerItem[] peerItemArray, PeerItem[] peerItemArray2, PeerItem[] peerItemArray3, byte by) {
        this.peers_added = peerItemArray;
        this.peers_dropped = peerItemArray2;
        this.version = by;
        this.peersAddedNoSeeds = peerItemArray3 != null ? peerItemArray3 : peerItemArray;
    }

    private void insertPeers(String string, Map map, boolean bl, PeerItem[] peerItemArray) {
        if (peerItemArray == null) {
            return;
        }
        if (peerItemArray.length == 0) {
            return;
        }
        List<PeerItem> list = null;
        ArrayList<PeerItem> arrayList = null;
        for (int i = 0; i < peerItemArray.length; ++i) {
            if (!peerItemArray[i].isIPv4()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<PeerItem>();
                    list = new ArrayList<PeerItem>(Arrays.asList(peerItemArray).subList(0, i));
                }
                arrayList.add(peerItemArray[i]);
                continue;
            }
            if (list == null) continue;
            list.add(peerItemArray[i]);
        }
        if (list == null) {
            list = Arrays.asList(peerItemArray);
        }
        this.insertPeers(string, map, bl, list, 6);
        this.insertPeers(string + "6", map, bl, arrayList, 18);
    }

    private void insertPeers(String string, Map map, boolean bl, List list, int n) {
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        byte[] byArray = new byte[list.size() * n];
        byte[] byArray2 = bl ? new byte[list.size()] : null;
        for (int i = 0; i < list.size(); ++i) {
            PeerItem peerItem = (PeerItem)list.get(i);
            byte[] byArray3 = peerItem.getSerialization();
            if (byArray3.length != n) {
                System.out.println("> " + byArray3.length + ":" + n);
            }
            System.arraycopy(byArray3, 0, byArray, i * n, n);
            if (byArray2 == null || !NetworkManager.getCryptoRequired(peerItem.getCryptoLevel())) continue;
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] | 1);
        }
        map.put(string, byArray);
        if (byArray2 != null) {
            map.put(string + ".f", byArray2);
        }
    }

    private List extractPeers(String string, Map map, int n, boolean bl) {
        ArrayList<PeerItem> arrayList = new ArrayList<PeerItem>();
        byte[] byArray = (byte[])map.get(string);
        if (byArray != null) {
            Object v;
            if (byArray.length % n != 0 && Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "PEX (UT): peer data size not multiple of " + n + ": " + byArray.length));
            }
            int n2 = byArray.length / n;
            byte[] byArray2 = null;
            if (map != null && (v = map.get(string + ".f")) instanceof byte[]) {
                byArray2 = (byte[])v;
            }
            if (byArray2 != null && byArray2.length != n2) {
                if (byArray2.length > 0 && Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "PEX (UT): invalid peer flags: peers=" + n2 + ", flags=" + byArray2.length));
                }
                byArray2 = null;
            }
            for (int i = 0; i < n2; ++i) {
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, i * n, byArray3, 0, n);
                byte by = 0;
                if (byArray2 != null && (byArray2[i] & 1) != 0) {
                    by = 1;
                }
                if (byArray2 != null && (byArray2[i] & 2) != 0 && bl) continue;
                try {
                    PeerItem peerItem = PeerItemFactory.createPeerItem(byArray3, (byte)2, by, 0);
                    arrayList.add(peerItem);
                    continue;
                }
                catch (Exception exception) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent(LOGID, 1, "PEX (UT): invalid peer received"));
                }
            }
        }
        return arrayList;
    }

    public PeerItem[] getAddedPeers(boolean bl) {
        return bl ? this.peers_added : this.peersAddedNoSeeds;
    }

    public PeerItem[] getAddedPeers() {
        return this.peers_added;
    }

    public PeerItem[] getDroppedPeers() {
        return this.peers_dropped;
    }

    public String getID() {
        return "ut_pex";
    }

    public byte[] getIDBytes() {
        return LTMessage.ID_UT_PEX_BYTES;
    }

    public String getFeatureID() {
        return "LT1";
    }

    public int getFeatureSubID() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        if (this.description == null) {
            int n = this.peers_added == null ? 0 : this.peers_added.length;
            int n2 = this.peers_dropped == null ? 0 : this.peers_dropped.length;
            this.description = this.getID().toUpperCase() + " with " + n + " added and " + n2 + " dropped peers";
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap hashMap = new HashMap();
            this.insertPeers("added", hashMap, true, this.peers_added);
            this.insertPeers("dropped", hashMap, false, this.peers_dropped);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)29);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        Map map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 2, this.getID());
        List list = this.extractPeers("added", map, 6, false);
        List list2 = this.extractPeers("added", map, 6, true);
        List list3 = this.extractPeers("dropped", map, 6, false);
        list.addAll(this.extractPeers("added6", map, 18, false));
        list2.addAll(this.extractPeers("added6", map, 18, true));
        list3.addAll(this.extractPeers("dropped6", map, 18, false));
        PeerItem[] peerItemArray = list.toArray(new PeerItem[list.size()]);
        PeerItem[] peerItemArray2 = list2.toArray(new PeerItem[list2.size()]);
        PeerItem[] peerItemArray3 = list3.toArray(new PeerItem[list3.size()]);
        return new UTPeerExchange(peerItemArray, peerItemArray3, peerItemArray2, by);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public int getMaxAllowedPeersPerVolley(boolean bl, boolean bl2) {
        return bl && bl2 ? 200 : 100;
    }
}

