/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStylePeerExchange;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZPeerExchange
implements AZMessage,
AZStylePeerExchange {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final byte bss = 11;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte version;
    private final byte[] infohash;
    private final PeerItem[] peers_added;
    private final PeerItem[] peers_dropped;

    public AZPeerExchange(byte[] byArray, PeerItem[] peerItemArray, PeerItem[] peerItemArray2, byte by) {
        this.infohash = byArray;
        this.peers_added = peerItemArray;
        this.peers_dropped = peerItemArray2;
        this.version = by;
    }

    private void insertPeers(String string, Map map, PeerItem[] peerItemArray) {
        if (peerItemArray != null && peerItemArray.length > 0) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            byte[] byArray = new byte[peerItemArray.length];
            byte[] byArray2 = new byte[peerItemArray.length * 2];
            int n = 0;
            for (int i = 0; i < peerItemArray.length; ++i) {
                arrayList.add(peerItemArray[i].getSerialization());
                byArray[i] = peerItemArray[i].getHandshakeType();
                int n2 = peerItemArray[i].getUDPPort();
                if (n2 <= 0) continue;
                ++n;
                byArray2[i * 2] = (byte)(n2 >> 8);
                byArray2[i * 2 + 1] = (byte)n2;
            }
            map.put(string, arrayList);
            map.put(string + "_HST", byArray);
            if (n > 0) {
                map.put(string + "_UDP", byArray2);
            }
        }
    }

    private PeerItem[] extractPeers(String string, Map map) {
        PeerItem[] peerItemArray = null;
        ArrayList<PeerItem> arrayList = new ArrayList<PeerItem>();
        List list = (List)map.get(string);
        if (list != null) {
            int n = list.size();
            byte[] byArray = (byte[])map.get(string + "_HST");
            byte[] byArray2 = (byte[])map.get(string + "_UDP");
            int n2 = 0;
            if (byArray != null && byArray.length != n) {
                Logger.log(new LogEvent(LOGID, 1, "PEX: invalid handshake types received: peers=" + n + ",handshakes=" + byArray.length));
                byArray = null;
            }
            if (byArray2 != null && byArray2.length != n * 2) {
                Logger.log(new LogEvent(LOGID, 1, "PEX: invalid udp ports received: peers=" + n + ",udp_ports=" + byArray2.length));
                byArray2 = null;
            }
            for (byte[] byArray3 : list) {
                byte by = 0;
                if (byArray != null) {
                    by = byArray[n2];
                }
                int n3 = 0;
                if (byArray2 != null) {
                    n3 = (byArray2[n2 * 2] << 8 & 0xFF00) + (byArray2[n2 * 2 + 1] & 0xFF);
                }
                try {
                    PeerItem peerItem = PeerItemFactory.createPeerItem(byArray3, (byte)2, by, n3);
                    arrayList.add(peerItem);
                }
                catch (Exception exception) {
                    Logger.log(new LogEvent(LOGID, 1, "PEX: invalid peer received"));
                }
                ++n2;
            }
        }
        if (!arrayList.isEmpty()) {
            peerItemArray = new PeerItem[arrayList.size()];
            arrayList.toArray(peerItemArray);
        }
        return peerItemArray;
    }

    public byte[] getInfoHash() {
        return this.infohash;
    }

    public PeerItem[] getAddedPeers() {
        return this.peers_added;
    }

    public PeerItem[] getDroppedPeers() {
        return this.peers_dropped;
    }

    public String getID() {
        return "AZ_PEER_EXCHANGE";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_PEER_EXCHANGE_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        if (this.description == null) {
            int n = this.peers_added == null ? 0 : this.peers_added.length;
            int n2 = this.peers_dropped == null ? 0 : this.peers_dropped.length;
            this.description = this.getID() + " for infohash " + ByteFormatter.nicePrint(this.infohash, true) + " with " + n + " added and " + n2 + " dropped peers";
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("infohash", this.infohash);
            this.insertPeers("added", hashMap, this.peers_added);
            this.insertPeers("dropped", hashMap, this.peers_dropped);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)14);
            if (this.buffer.remaining((byte)11) > 2000) {
                System.out.println("Generated AZPeerExchange size = " + this.buffer.remaining((byte)11) + " bytes");
            }
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        Map map;
        byte[] byArray;
        if (directByteBuffer.remaining((byte)11) > 2000) {
            System.out.println("Received PEX msg byte size = " + directByteBuffer.remaining((byte)11));
        }
        if ((byArray = (byte[])(map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 10, this.getID())).get("infohash")) == null) {
            throw new MessageException("hash == null");
        }
        if (byArray.length != 20) {
            throw new MessageException("hash.length != 20: " + byArray.length);
        }
        PeerItem[] peerItemArray = this.extractPeers("added", map);
        PeerItem[] peerItemArray2 = this.extractPeers("dropped", map);
        if (peerItemArray == null && peerItemArray2 == null) {
            throw new MessageException("[" + this.getID() + "] received exchange message without any adds or drops");
        }
        return new AZPeerExchange(byArray, peerItemArray, peerItemArray2, by);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }

    public int getMaxAllowedPeersPerVolley(boolean bl, boolean bl2) {
        return 50;
    }
}

