/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class LightweightTCPTransport
implements Transport {
    private final TransportEndpoint transport_endpoint;
    private final TransportHelperFilter filter;

    public LightweightTCPTransport(ProtocolEndpoint protocolEndpoint, TransportHelperFilter transportHelperFilter) {
        SocketChannel socketChannel = ((TCPTransportHelper)transportHelperFilter.getHelper()).getSocketChannel();
        this.transport_endpoint = new TransportEndpointTCP(protocolEndpoint, socketChannel);
        this.filter = transportHelperFilter;
    }

    public TransportEndpoint getTransportEndpoint() {
        return this.transport_endpoint;
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.filter.write(byteBufferArray, n, n2);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.filter.read(byteBufferArray, n, n2);
    }

    public SocketChannel getSocketChannel() {
        return ((TCPTransportHelper)this.filter.getHelper()).getSocketChannel();
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.getSocketChannel().socket().getInetAddress(), this.getSocketChannel().socket().getPort());
    }

    public String getDescription() {
        return this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    public void close(String string) {
        try {
            this.getSocketChannel().close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    public void setAlreadyRead(ByteBuffer byteBuffer) {
        throw new RuntimeException("not implemented");
    }

    public boolean isReadyForWrite(EventWaiter eventWaiter) {
        throw new RuntimeException("not implemented");
    }

    public long isReadyForRead(EventWaiter eventWaiter) {
        throw new RuntimeException("not implemented");
    }

    public void setReadyForRead() {
        throw new RuntimeException("not implemented");
    }

    public void connectOutbound(ByteBuffer byteBuffer, Transport.ConnectListener connectListener, int n) {
        throw new RuntimeException("not implemented");
    }

    public void connectedInbound() {
        throw new RuntimeException("not implemented");
    }

    public void setTransportMode(int n) {
        throw new RuntimeException("not implemented");
    }

    public int getTransportMode() {
        throw new RuntimeException("not implemented");
    }

    public void setTrace(boolean bl) {
    }

    public String getEncryption(boolean bl) {
        return this.filter.getName(bl);
    }

    public boolean isEncrypted() {
        return this.filter.isEncrypted();
    }

    public boolean isTCP() {
        return true;
    }
}

