/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessage;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;

public class HTTPMessageEncoder
implements MessageStreamEncoder {
    private HTTPNetworkConnection http_connection;

    public void setConnection(HTTPNetworkConnection hTTPNetworkConnection) {
        this.http_connection = hTTPNetworkConnection;
    }

    public RawMessage[] encodeMessage(Message message) {
        String string = message.getID();
        RawMessage rawMessage = null;
        if (string.equals("BT_HANDSHAKE")) {
            rawMessage = this.http_connection.encodeHandShake(message);
        } else if (string.equals("BT_CHOKE")) {
            rawMessage = this.http_connection.encodeChoke();
        } else if (string.equals("BT_UNCHOKE")) {
            rawMessage = this.http_connection.encodeUnchoke();
        } else if (string.equals("BT_BITFIELD")) {
            rawMessage = this.http_connection.encodeBitField();
        } else {
            if (string.equals("BT_PIECE")) {
                return this.http_connection.encodePiece(message);
            }
            if (string.equals("HTTP_DATA")) {
                rawMessage = ((HTTPMessage)message).encode(message);
            }
        }
        if (rawMessage == null) {
            rawMessage = this.http_connection.getEmptyRawMessage(message);
        }
        return new RawMessage[]{rawMessage};
    }
}

