/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportStats;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;

public abstract class TransportImpl
implements Transport {
    private TransportHelperFilter filter;
    private static final TransportStats stats = null;
    private ByteBuffer data_already_read = null;
    private volatile EventWaiter read_waiter;
    private volatile EventWaiter write_waiter;
    private volatile boolean is_ready_for_write = false;
    private volatile boolean is_ready_for_read = false;
    private Throwable write_select_failure = null;
    private Throwable read_select_failure = null;
    private long last_ready_for_read = SystemTime.getSteppedMonotonousTime();
    private boolean trace;

    protected TransportImpl() {
    }

    public void setFilter(TransportHelperFilter transportHelperFilter) {
        this.filter = transportHelperFilter;
        if (this.trace && transportHelperFilter != null) {
            transportHelperFilter.setTrace(true);
        }
    }

    public TransportHelperFilter getFilter() {
        return this.filter;
    }

    public void setAlreadyRead(ByteBuffer byteBuffer) {
        if (byteBuffer != null && byteBuffer.hasRemaining()) {
            if (this.data_already_read != null) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.data_already_read.remaining() + byteBuffer.remaining());
                byteBuffer2.put(byteBuffer);
                byteBuffer2.put(this.data_already_read);
                byteBuffer2.position(0);
                this.data_already_read = byteBuffer2;
            } else {
                this.data_already_read = byteBuffer;
            }
            this.is_ready_for_read = true;
        }
    }

    public String getEncryption(boolean bl) {
        return this.filter == null ? "" : this.filter.getName(bl);
    }

    public boolean isEncrypted() {
        return this.filter == null ? false : this.filter.isEncrypted();
    }

    public boolean isReadyForWrite(EventWaiter eventWaiter) {
        if (eventWaiter != null) {
            this.write_waiter = eventWaiter;
        }
        return this.is_ready_for_write;
    }

    protected boolean readyForWrite(boolean bl) {
        if (this.trace) {
            TimeFormatter.milliTrace("trans: readyForWrite -> " + bl);
        }
        if (bl) {
            boolean bl2 = !this.is_ready_for_write;
            this.is_ready_for_write = true;
            EventWaiter eventWaiter = this.write_waiter;
            if (eventWaiter != null) {
                eventWaiter.eventOccurred();
            }
            return bl2;
        }
        this.is_ready_for_write = false;
        return false;
    }

    protected void writeFailed(Throwable throwable) {
        throwable.fillInStackTrace();
        this.write_select_failure = throwable;
        this.is_ready_for_write = true;
    }

    public long isReadyForRead(EventWaiter eventWaiter) {
        if (eventWaiter != null) {
            this.read_waiter = eventWaiter;
        }
        boolean bl = this.is_ready_for_read || this.data_already_read != null || this.filter != null && this.filter.hasBufferedRead();
        long l = SystemTime.getSteppedMonotonousTime();
        if (bl) {
            this.last_ready_for_read = l;
            return 0L;
        }
        long l2 = l - this.last_ready_for_read + 1L;
        return l2;
    }

    protected boolean readyForRead(boolean bl) {
        if (bl) {
            boolean bl2 = !this.is_ready_for_read;
            this.is_ready_for_read = true;
            EventWaiter eventWaiter = this.read_waiter;
            if (eventWaiter != null) {
                eventWaiter.eventOccurred();
            }
            return bl2;
        }
        this.is_ready_for_read = false;
        return false;
    }

    public void setReadyForRead() {
        this.readyForRead(true);
    }

    protected void readFailed(Throwable throwable) {
        throwable.fillInStackTrace();
        this.read_select_failure = throwable;
        this.is_ready_for_read = true;
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.write_select_failure != null) {
            throw new IOException("write_select_failure: " + this.write_select_failure.getMessage());
        }
        if (this.filter == null) {
            return 0L;
        }
        long l = this.filter.write(byteBufferArray, n, n2);
        if (stats != null) {
            stats.bytesWritten((int)l);
        }
        if (l < 1L) {
            this.requestWriteSelect();
        }
        return l;
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.read_select_failure != null) {
            throw new IOException("read_select_failure: " + this.read_select_failure.getMessage());
        }
        if (this.data_already_read != null) {
            int n3 = 0;
            for (int i = n; i < n + n2; ++i) {
                ByteBuffer byteBuffer = byteBufferArray[i];
                int n4 = this.data_already_read.limit();
                if (this.data_already_read.remaining() > byteBuffer.remaining()) {
                    this.data_already_read.limit(this.data_already_read.position() + byteBuffer.remaining());
                }
                n3 += this.data_already_read.remaining();
                byteBuffer.put(this.data_already_read);
                this.data_already_read.limit(n4);
                if (this.data_already_read.hasRemaining()) continue;
                this.data_already_read = null;
                break;
            }
            if (!byteBufferArray[n + n2 - 1].hasRemaining()) {
                return n3;
            }
        }
        if (this.filter == null) {
            throw new IOException("Transport not ready");
        }
        long l = this.filter.read(byteBufferArray, n, n2);
        if (stats != null) {
            stats.bytesRead((int)l);
        }
        if (l == 0L) {
            this.requestReadSelect();
        }
        return l;
    }

    private void requestWriteSelect() {
        this.is_ready_for_write = false;
        if (this.filter != null) {
            this.filter.getHelper().resumeWriteSelects();
        }
    }

    private void requestReadSelect() {
        this.is_ready_for_read = false;
        if (this.filter != null) {
            this.filter.getHelper().resumeReadSelects();
        }
    }

    public void connectedInbound() {
        this.registerSelectHandling();
    }

    public void connectedOutbound() {
        this.registerSelectHandling();
    }

    private void registerSelectHandling() {
        TransportHelperFilter transportHelperFilter = this.getFilter();
        if (transportHelperFilter == null) {
            Debug.out("ERROR: registerSelectHandling():: filter == null");
            return;
        }
        TransportHelper transportHelper = transportHelperFilter.getHelper();
        transportHelper.registerForReadSelects(new TransportHelper.selectListener(){

            public boolean selectSuccess(TransportHelper transportHelper, Object object) {
                return TransportImpl.this.readyForRead(true);
            }

            public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
                TransportImpl.this.readFailed(throwable);
            }
        }, null);
        transportHelper.registerForWriteSelects(new TransportHelper.selectListener(){

            public boolean selectSuccess(TransportHelper transportHelper, Object object) {
                return TransportImpl.this.readyForWrite(true);
            }

            public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
                TransportImpl.this.writeFailed(throwable);
            }
        }, null);
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
        TransportHelperFilter transportHelperFilter = this.getFilter();
        if (transportHelperFilter != null) {
            transportHelperFilter.setTrace(bl);
        }
    }
}

