/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterSwitcher
implements TransportHelperFilter {
    private TransportHelperFilter current_reader;
    private TransportHelperFilter current_writer;
    private TransportHelperFilter first_filter;
    private TransportHelperFilter second_filter;
    private int read_rem;
    private int write_rem;
    private ByteBuffer read_insert;

    public TransportHelperFilterSwitcher(TransportHelperFilter transportHelperFilter, TransportHelperFilter transportHelperFilter2, int n, int n2) {
        this.first_filter = transportHelperFilter;
        this.second_filter = transportHelperFilter2;
        this.read_rem = n;
        this.write_rem = n2;
        this.current_reader = this.read_rem <= 0 ? this.second_filter : this.first_filter;
        this.current_writer = this.write_rem <= 0 ? this.second_filter : this.first_filter;
    }

    public TransportHelperFilterSwitcher(TransportHelperFilter transportHelperFilter, TransportHelperFilter transportHelperFilter2, ByteBuffer byteBuffer) {
        this.first_filter = transportHelperFilter;
        this.second_filter = transportHelperFilter2;
        this.read_insert = byteBuffer;
        this.current_reader = this.read_rem <= 0 ? this.second_filter : this.first_filter;
        this.current_writer = this.write_rem <= 0 ? this.second_filter : this.first_filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        block12: {
            int[] nArray;
            long l;
            block11: {
                l = 0L;
                if (this.current_writer == this.second_filter) break block12;
                nArray = new int[byteBufferArray.length];
                int n3 = this.write_rem;
                for (int i = n; i < n + n2; ++i) {
                    ByteBuffer byteBuffer = byteBufferArray[i];
                    nArray[i] = byteBuffer.limit();
                    int n4 = byteBuffer.remaining();
                    if (n4 > n3) {
                        byteBuffer.limit(byteBuffer.position() + n3);
                        n3 = 0;
                        continue;
                    }
                    n3 -= n4;
                }
                l = this.current_writer.write(byteBufferArray, n, n2);
                if (l > 0L) break block11;
                long l2 = l;
                Object var12_11 = null;
                for (int i = n; i < n + n2; ++i) {
                    ByteBuffer byteBuffer = byteBufferArray[i];
                    byteBuffer.limit(nArray[i]);
                }
                return l2;
            }
            try {
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                for (int i = n; i < n + n2; ++i) {
                    ByteBuffer byteBuffer = byteBufferArray[i];
                    byteBuffer.limit(nArray[i]);
                }
                throw throwable;
            }
            for (int i = n; i < n + n2; ++i) {
                ByteBuffer byteBuffer = byteBufferArray[i];
                byteBuffer.limit(nArray[i]);
            }
            this.write_rem = (int)((long)this.write_rem - l);
            if (this.write_rem == 0) {
                if (this.current_writer.hasBufferedWrite()) {
                    return l;
                }
                this.current_writer = this.second_filter;
            } else {
                return l;
            }
        }
        return l += this.current_writer.write(byteBufferArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        block16: {
            long l;
            int[] nArray;
            long l2;
            block15: {
                int n3;
                int n4;
                l2 = 0L;
                if (this.read_insert != null) {
                    int n5 = this.read_insert.position();
                    for (n4 = n; n4 < n + n2; ++n4) {
                        ByteBuffer byteBuffer = byteBufferArray[n4];
                        int n6 = byteBuffer.remaining();
                        if (n6 <= 0) continue;
                        if (n6 < this.read_insert.remaining()) {
                            n3 = this.read_insert.limit();
                            this.read_insert.limit(this.read_insert.position() + n6);
                            byteBuffer.put(this.read_insert);
                            this.read_insert.limit(n3);
                        } else {
                            byteBuffer.put(this.read_insert);
                        }
                        if (!this.read_insert.hasRemaining()) break;
                    }
                    l2 = this.read_insert.position() - n5;
                    if (this.read_insert.hasRemaining()) {
                        return l2;
                    }
                    this.read_insert = null;
                }
                if (this.current_reader == this.second_filter) break block16;
                nArray = new int[byteBufferArray.length];
                n4 = this.read_rem;
                for (int i = n; i < n + n2; ++i) {
                    ByteBuffer byteBuffer = byteBufferArray[i];
                    nArray[i] = byteBuffer.limit();
                    n3 = byteBuffer.remaining();
                    if (n3 > n4) {
                        byteBuffer.limit(byteBuffer.position() + n4);
                        n4 = 0;
                        continue;
                    }
                    n4 -= n3;
                }
                l = this.current_reader.read(byteBufferArray, n, n2);
                if (l > 0L) break block15;
                long l3 = l2;
                Object var13_15 = null;
                for (int i = n; i < n + n2; ++i) {
                    ByteBuffer byteBuffer = byteBufferArray[i];
                    byteBuffer.limit(nArray[i]);
                }
                return l3;
            }
            try {
                l2 += l;
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                for (int i = n; i < n + n2; ++i) {
                    ByteBuffer byteBuffer = byteBufferArray[i];
                    byteBuffer.limit(nArray[i]);
                }
                throw throwable;
            }
            for (int i = n; i < n + n2; ++i) {
                ByteBuffer byteBuffer = byteBufferArray[i];
                byteBuffer.limit(nArray[i]);
            }
            this.read_rem = (int)((long)this.read_rem - l);
            if (this.read_rem == 0) {
                this.current_reader = this.second_filter;
            } else {
                return l2;
            }
        }
        return l2 += this.current_reader.read(byteBufferArray, n, n2);
    }

    public boolean hasBufferedWrite() {
        return this.current_writer.hasBufferedWrite();
    }

    public boolean hasBufferedRead() {
        return this.read_insert != null || this.current_reader.hasBufferedRead();
    }

    public TransportHelper getHelper() {
        return this.second_filter.getHelper();
    }

    public void setTrace(boolean bl) {
        this.first_filter.setTrace(bl);
        this.second_filter.setTrace(bl);
    }

    public boolean isEncrypted() {
        return this.current_reader.isEncrypted() || this.current_writer.isEncrypted();
    }

    public String getName(boolean bl) {
        return this.second_filter.getName(bl);
    }
}

