/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterStreamXOR
extends TransportHelperFilterStream {
    private byte[] mask;
    private int read_position;
    private int write_position;

    protected TransportHelperFilterStreamXOR(TransportHelper transportHelper, byte[] byArray) {
        super(transportHelper);
        this.mask = byArray;
    }

    protected void cryptoOut(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        int n = byteBuffer.remaining();
        for (int i = 0; i < n; ++i) {
            byte by = byteBuffer.get();
            by = (byte)(by ^ this.mask[this.write_position++]);
            byteBuffer2.put(by);
            if (this.write_position != this.mask.length) continue;
            this.write_position = 0;
        }
    }

    protected void cryptoIn(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        int n = byteBuffer.remaining();
        for (int i = 0; i < n; ++i) {
            byte by = byteBuffer.get();
            by = (byte)(by ^ this.mask[this.read_position++]);
            byteBuffer2.put(by);
            if (this.read_position != this.mask.length) continue;
            this.read_position = 0;
        }
    }

    public boolean isEncrypted() {
        return true;
    }

    public String getName(boolean bl) {
        String string = this.getHelper().getName(bl);
        if (string.length() > 0) {
            string = " (" + string + ")";
        }
        return "XOR-" + this.mask.length * 8 + string;
    }
}

