/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.TransportCipher;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterInserter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStreamCipher;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStreamXOR;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterTransparent;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Map;
import java.util.Random;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class ProtocolDecoderPHE
extends ProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final byte CRYPTO_PLAIN = 1;
    private static final byte CRYPTO_RC4 = 2;
    private static final byte CRYPTO_XOR = 4;
    private static final byte CRYPTO_AES = 8;
    private static final String DH_P = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A36210000000000090563";
    private static final String DH_G = "02";
    private static final int DH_L = 160;
    private static final int DH_SIZE_BYTES;
    public static final int MIN_INCOMING_INITIAL_PACKET_SIZE;
    private static final BigInteger DH_P_BI;
    private static final BigInteger DH_G_BI;
    private static KeyPairGenerator dh_key_generator;
    private static long last_dh_incoming_key_generate;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 1000;
    private static BloomFilter generate_bloom;
    private static long generate_bloom_create_time;
    private static boolean crypto_setup_done;
    private static boolean crypto_ok;
    private static final String RC4_STREAM_ALG = "RC4";
    private static final String RC4_STREAM_CIPHER = "RC4";
    private static final int RC4_STREAM_KEY_SIZE = 128;
    private static final int RC4_STREAM_KEY_SIZE_BYTES = 16;
    private static final int PADDING_MAX = 512;
    private static final int PADDING_MAX_NORMAL = 512;
    private static final int PADDING_MAX_LIMITED = 128;
    private static Random random;
    private static Map global_shared_secrets;
    private static final byte SUPPORTED_PROTOCOLS = 3;
    private static byte MIN_CRYPTO;
    private static final int PS_OUTBOUND_1 = 0;
    private static final int PS_OUTBOUND_2 = 1;
    private static final int PS_OUTBOUND_3 = 2;
    private static final int PS_OUTBOUND_4 = 3;
    private static final int PS_INBOUND_1 = 10;
    private static final int PS_INBOUND_2 = 11;
    private static final int PS_INBOUND_3 = 12;
    private static final int PS_INBOUND_4 = 13;
    public static final byte[] KEYA_IV;
    public static final byte[] KEYB_IV;
    public static final byte[] REQ1_IV;
    public static final byte[] REQ2_IV;
    public static final byte[] REQ3_IV;
    public static final byte[] VC;
    private TransportHelper transport;
    private ByteBuffer write_buffer;
    private ByteBuffer read_buffer;
    private ProtocolDecoderAdapter adapter;
    private KeyAgreement key_agreement;
    private byte[] dh_public_key_bytes;
    private byte[] shared_secret;
    private byte[] secret_bytes;
    private ByteBuffer initial_data_out;
    private ByteBuffer initial_data_in;
    private TransportCipher write_cipher;
    private TransportCipher read_cipher;
    private byte[] padding_skip_marker;
    private byte my_supported_protocols;
    private byte selected_protocol;
    private boolean outbound;
    private int protocol_state;
    private int protocol_substate;
    private boolean handshake_complete;
    private int bytes_read;
    private int bytes_written;
    private long last_read_time = SystemTime.getCurrentTime();
    private TransportHelperFilter filter;
    private boolean delay_outbound_4;
    private boolean processing_complete;
    private AEMonitor process_mon = new AEMonitor("ProtocolDecoderPHE:process");

    public static int getMaxIncomingInitialPacketSize(boolean bl) {
        return MIN_INCOMING_INITIAL_PACKET_SIZE + (bl ? 128 : 512) / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cryptoSetup() {
        Map map = global_shared_secrets;
        synchronized (map) {
            if (crypto_setup_done) {
                return;
            }
            crypto_setup_done = true;
            try {
                DHParameterSpec dHParameterSpec = new DHParameterSpec(DH_P_BI, DH_G_BI, 160);
                dh_key_generator = KeyPairGenerator.getInstance("DH");
                dh_key_generator.initialize(dHParameterSpec);
                dh_key_generator.generateKeyPair();
                byte[] byArray = new byte[16];
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, 16, "RC4");
                TransportCipher transportCipher = new TransportCipher("RC4", 1, secretKeySpec);
                transportCipher = new TransportCipher("RC4", 2, secretKeySpec);
                crypto_ok = true;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "PHE crypto initialised"));
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Logger.log(new LogEvent(LOGID, "PHE crypto disabled as classes unavailable"));
                crypto_ok = false;
            }
            catch (Throwable throwable) {
                Logger.log(new LogEvent(LOGID, "PHE crypto initialisation failed", throwable));
                crypto_ok = false;
            }
        }
    }

    public static boolean isCryptoOK() {
        ProtocolDecoderPHE.cryptoSetup();
        return crypto_ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSecretsSupport(byte[][] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            SHA1Hasher sHA1Hasher = new SHA1Hasher();
            sHA1Hasher.update(REQ2_IV);
            sHA1Hasher.update(byArray[i]);
            byte[] byArray2 = sHA1Hasher.getDigest();
            Map map = global_shared_secrets;
            synchronized (map) {
                global_shared_secrets.put(new HashWrapper(byArray2), byArray[i]);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSecretsSupport(byte[][] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            SHA1Hasher sHA1Hasher = new SHA1Hasher();
            sHA1Hasher.update(REQ2_IV);
            sHA1Hasher.update(byArray[i]);
            byte[] byArray2 = sHA1Hasher.getDigest();
            Map map = global_shared_secrets;
            synchronized (map) {
                global_shared_secrets.remove(new HashWrapper(byArray2));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolDecoderPHE(TransportHelper transportHelper, byte[][] byArray, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ProtocolDecoderAdapter protocolDecoderAdapter) throws IOException {
        super(false);
        if (!ProtocolDecoderPHE.isCryptoOK()) {
            throw new IOException("PHE crypto broken");
        }
        this.transport = transportHelper;
        this.transport.setScatteringMode(768 + random.nextInt(256));
        this.initial_data_out = byteBuffer2;
        this.adapter = protocolDecoderAdapter;
        this.shared_secret = byArray == null || byArray.length == 0 ? new byte[0] : (byArray.length == 1 ? byArray[0] : byArray[random.nextInt(byArray.length)]);
        this.outbound = byteBuffer == null;
        this.my_supported_protocols = (byte)3;
        if (this.outbound) {
            this.my_supported_protocols = MIN_CRYPTO;
        } else if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE) {
            this.my_supported_protocols = MIN_CRYPTO;
        }
        this.initCrypto();
        try {
            this.process_mon.enter();
            this.transport.registerForReadSelects(new TransportHelper.selectListener(){

                public boolean selectSuccess(TransportHelper transportHelper, Object object) {
                    return ProtocolDecoderPHE.this.selectSuccess(transportHelper, object, false);
                }

                public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
                    ProtocolDecoderPHE.this.selectFailure(transportHelper, object, throwable);
                }
            }, null);
            this.transport.registerForWriteSelects(new TransportHelper.selectListener(){

                public boolean selectSuccess(TransportHelper transportHelper, Object object) {
                    return ProtocolDecoderPHE.this.selectSuccess(transportHelper, object, true);
                }

                public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
                    ProtocolDecoderPHE.this.selectFailure(transportHelper, object, throwable);
                }
            }, null);
            this.transport.pauseWriteSelects();
            if (this.outbound) {
                this.protocol_state = 0;
                this.transport.pauseReadSelects();
            } else {
                this.protocol_state = 10;
                this.read_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length);
                this.read_buffer.put(byteBuffer);
                this.bytes_read += byteBuffer.limit();
            }
            Object var7_6 = null;
            this.process_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.process_mon.exit();
            throw throwable;
        }
        this.process();
    }

    protected void initCrypto() throws IOException {
        try {
            KeyPair keyPair = ProtocolDecoderPHE.generateDHKeyPair(this.transport, this.outbound);
            this.key_agreement = KeyAgreement.getInstance("DH");
            this.key_agreement.init(keyPair.getPrivate());
            DHPublicKey dHPublicKey = (DHPublicKey)keyPair.getPublic();
            BigInteger bigInteger = dHPublicKey.getY();
            this.dh_public_key_bytes = this.bigIntegerToBytes(bigInteger, DH_SIZE_BYTES);
        }
        catch (Throwable throwable) {
            throw new IOException(Debug.getNestedExceptionMessage(throwable));
        }
    }

    protected void completeDH(byte[] byArray) throws IOException {
        try {
            BigInteger bigInteger = this.bytesToBigInteger(byArray, 0, DH_SIZE_BYTES);
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            PublicKey publicKey = keyFactory.generatePublic(new DHPublicKeySpec(bigInteger, DH_P_BI, DH_G_BI));
            this.key_agreement.doPhase(publicKey, true);
            this.secret_bytes = this.key_agreement.generateSecret();
            this.adapter.gotSecret(this.secret_bytes);
        }
        catch (Throwable throwable) {
            throw new IOException(Debug.getNestedExceptionMessage(throwable));
        }
    }

    protected void setupCrypto() throws IOException {
        try {
            SHA1Hasher sHA1Hasher = new SHA1Hasher();
            sHA1Hasher.update(KEYA_IV);
            sHA1Hasher.update(this.secret_bytes);
            sHA1Hasher.update(this.shared_secret);
            byte[] byArray = sHA1Hasher.getDigest();
            sHA1Hasher = new SHA1Hasher();
            sHA1Hasher.update(KEYB_IV);
            sHA1Hasher.update(this.secret_bytes);
            sHA1Hasher.update(this.shared_secret);
            byte[] byArray2 = sHA1Hasher.getDigest();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "RC4");
            SecretKeySpec secretKeySpec2 = new SecretKeySpec(byArray2, "RC4");
            this.write_cipher = new TransportCipher("RC4", 1, this.outbound ? secretKeySpec : secretKeySpec2);
            this.read_cipher = new TransportCipher("RC4", 2, this.outbound ? secretKeySpec2 : secretKeySpec);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException(Debug.getNestedExceptionMessage(throwable));
        }
    }

    protected void handshakeComplete() throws IOException {
        if (this.selected_protocol == 1) {
            this.filter = new TransportHelperFilterTransparent(this.transport, true);
        } else if (this.selected_protocol == 4) {
            this.filter = new TransportHelperFilterStreamXOR(this.transport, this.secret_bytes);
        } else if (this.selected_protocol == 2) {
            this.filter = new TransportHelperFilterStreamCipher(this.transport, this.read_cipher, this.write_cipher);
        } else {
            throw new IOException("Invalid selected protocol '" + this.selected_protocol + "'");
        }
        if (this.initial_data_in != null) {
            this.filter = new TransportHelperFilterInserter(this.filter, this.initial_data_in);
        }
        this.handshake_complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void process() throws IOException {
        block58: {
            block57: {
                try {
                    try {
                        this.process_mon.enter();
                        if (this.handshake_complete) {
                            Debug.out("Handshake process already completed");
                            var13_1 = null;
                            this.process_mon.exit();
                            return;
                        }
                        var1_4 = true;
                        block6: while (var1_4) {
                            block64: {
                                block63: {
                                    block62: {
                                        block61: {
                                            block60: {
                                                block59: {
                                                    if (this.protocol_state != 0) break block59;
                                                    if (this.write_buffer == null) {
                                                        var2_6 = ProtocolDecoderPHE.getRandomPadding(this.getPaddingMax() / 2);
                                                        this.write_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length + var2_6.length);
                                                        this.write_buffer.put(this.dh_public_key_bytes);
                                                        this.write_buffer.put(var2_6);
                                                        this.write_buffer.flip();
                                                    }
                                                    this.write(this.write_buffer);
                                                    if (!this.write_buffer.hasRemaining()) {
                                                        this.write_buffer = null;
                                                        this.protocol_state = 11;
                                                    }
                                                    ** GOTO lbl211
                                                }
                                                if (this.protocol_state != 10) break block60;
                                                this.read(this.read_buffer);
                                                if (!this.read_buffer.hasRemaining()) {
                                                    this.read_buffer.flip();
                                                    var2_7 = new byte[this.read_buffer.remaining()];
                                                    this.read_buffer.get(var2_7);
                                                    this.completeDH(var2_7);
                                                    this.read_buffer = null;
                                                    this.protocol_state = 1;
                                                }
                                                ** GOTO lbl211
                                            }
                                            if (this.protocol_state != 1) break block61;
                                            if (this.write_buffer == null) {
                                                var2_8 = ProtocolDecoderPHE.getRandomPadding(this.getPaddingMax() / 2);
                                                this.write_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length + var2_8.length);
                                                this.write_buffer.put(this.dh_public_key_bytes);
                                                this.write_buffer.put(var2_8);
                                                this.write_buffer.flip();
                                            }
                                            this.write(this.write_buffer);
                                            if (!this.write_buffer.hasRemaining()) {
                                                this.write_buffer = null;
                                                this.protocol_state = 12;
                                            }
                                            ** GOTO lbl211
                                        }
                                        if (this.protocol_state != 11) break block62;
                                        if (this.read_buffer == null) {
                                            this.read_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length);
                                        }
                                        this.read(this.read_buffer);
                                        if (!this.read_buffer.hasRemaining()) {
                                            this.read_buffer.flip();
                                            var2_9 = new byte[this.read_buffer.remaining()];
                                            this.read_buffer.get(var2_9);
                                            this.completeDH(var2_9);
                                            this.setupCrypto();
                                            this.read_buffer = null;
                                            this.protocol_state = 2;
                                        }
                                        ** GOTO lbl211
                                    }
                                    if (this.protocol_state != 2) break block63;
                                    if (this.write_buffer == null) {
                                        var2_10 = this.initial_data_out == null ? 0 : this.initial_data_out.remaining();
                                        var3_20 = this.getPaddingMax();
                                        var4_27 = ProtocolDecoderPHE.getRandomPadding(var3_20 / 2);
                                        var5_32 /* !! */  = ProtocolDecoderPHE.getZeroPadding(var3_20);
                                        this.write_buffer = ByteBuffer.allocate(var4_27.length + 20 + 20 + (ProtocolDecoderPHE.VC.length + 4 + 2 + var5_32 /* !! */ .length + 2) + var2_10);
                                        this.write_buffer.put(var4_27);
                                        var6_34 = new SHA1Hasher();
                                        var6_34.update(ProtocolDecoderPHE.REQ1_IV);
                                        var6_34.update(this.secret_bytes);
                                        var7_35 = var6_34.getDigest();
                                        this.write_buffer.put(var7_35);
                                        var6_34 = new SHA1Hasher();
                                        var6_34.update(ProtocolDecoderPHE.REQ2_IV);
                                        var6_34.update(this.shared_secret);
                                        var8_37 = var6_34.getDigest();
                                        var6_34 = new SHA1Hasher();
                                        var6_34.update(ProtocolDecoderPHE.REQ3_IV);
                                        var6_34.update(this.secret_bytes);
                                        var9_39 = var6_34.getDigest();
                                        for (var10_41 = 0; var10_41 < var8_37.length; ++var10_41) {
                                            v0 = var10_41;
                                            var8_37[v0] = (byte)(var8_37[v0] ^ var9_39[var10_41]);
                                        }
                                        this.write_buffer.put(var8_37);
                                        this.write_buffer.put(this.write_cipher.update(ProtocolDecoderPHE.VC));
                                        this.write_buffer.put(this.write_cipher.update(new byte[]{0, 0, 0, this.my_supported_protocols}));
                                        this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(var5_32 /* !! */ .length >> 8), (byte)var5_32 /* !! */ .length}));
                                        this.write_buffer.put(this.write_cipher.update(var5_32 /* !! */ ));
                                        this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(var2_10 >> 8), (byte)var2_10}));
                                        if (var2_10 > 0) {
                                            var10_41 = this.initial_data_out.position();
                                            this.write_cipher.update(this.initial_data_out, this.write_buffer);
                                            this.initial_data_out.position(var10_41);
                                            this.initial_data_out = null;
                                        }
                                        this.write_buffer.flip();
                                    }
                                    this.write(this.write_buffer);
                                    if (!this.write_buffer.hasRemaining()) {
                                        this.write_buffer = null;
                                        this.protocol_state = 13;
                                    }
                                    ** GOTO lbl211
                                }
                                if (this.protocol_state == 12) {
                                    if (this.read_buffer == null) {
                                        this.read_buffer = ByteBuffer.allocate(532);
                                        this.read_buffer.limit(20);
                                        var2_11 = new SHA1Hasher();
                                        var2_11.update(ProtocolDecoderPHE.REQ1_IV);
                                        var2_11.update(this.secret_bytes);
                                        this.padding_skip_marker = var2_11.getDigest();
                                        this.protocol_substate = 1;
                                    }
                                    break block57;
                                }
                                if (this.protocol_state != 3) break block64;
                                if (this.write_buffer == null) {
                                    var2_16 = this.getPaddingMax();
                                    var3_24 = ProtocolDecoderPHE.getRandomPadding(var2_16 / 2);
                                    var4_30 = ProtocolDecoderPHE.getZeroPadding(var2_16);
                                    this.write_buffer = ByteBuffer.allocate(var3_24.length + ProtocolDecoderPHE.VC.length + 4 + 2 + var4_30.length);
                                    this.write_buffer.put(var3_24);
                                    this.write_buffer.put(this.write_cipher.update(ProtocolDecoderPHE.VC));
                                    this.write_buffer.put(this.write_cipher.update(new byte[]{0, 0, 0, this.selected_protocol}));
                                    this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(var4_30.length >> 8), (byte)var4_30.length}));
                                    this.write_buffer.put(this.write_cipher.update(var4_30));
                                    this.write_buffer.flip();
                                }
                                if (this.delay_outbound_4) {
                                    if (this.transport.delayWrite(this.write_buffer)) {
                                        this.write_buffer = null;
                                        this.handshakeComplete();
                                    } else {
                                        this.delay_outbound_4 = false;
                                    }
                                }
                                if (!this.delay_outbound_4) {
                                    this.write(this.write_buffer);
                                    if (!this.write_buffer.hasRemaining()) {
                                        this.write_buffer = null;
                                        this.handshakeComplete();
                                    }
                                }
                                ** GOTO lbl211
                            }
                            if (this.protocol_state != 13) ** GOTO lbl211
                            if (this.read_buffer == null) {
                                this.read_buffer = ByteBuffer.allocate(ProtocolDecoderPHE.VC.length + 512);
                                this.read_buffer.limit(ProtocolDecoderPHE.VC.length);
                                this.padding_skip_marker = new byte[ProtocolDecoderPHE.VC.length];
                                this.padding_skip_marker = this.read_cipher.update(this.padding_skip_marker);
                                this.protocol_substate = 1;
                            }
lbl177:
                            // 4 sources

                            while (true) {
                                this.read(this.read_buffer);
                                if (!this.read_buffer.hasRemaining()) {
                                    if (this.protocol_substate == 1) {
                                        var2_17 = this.read_buffer.limit();
                                        this.read_buffer.position(var2_17 - ProtocolDecoderPHE.VC.length);
                                        var3_25 = true;
                                        break block58;
                                    }
                                    if (this.protocol_substate == 2) {
                                        this.read_buffer.flip();
                                        var2_18 = new byte[6];
                                        this.read_buffer.get(var2_18);
                                        var3_26 = this.read_cipher.update(var2_18);
                                        this.selected_protocol = var3_26[3];
                                        if ((this.selected_protocol & this.my_supported_protocols) == 0) {
                                            throw new IOException("Selected protocol has nothing in common: mine = " + Integer.toHexString(this.my_supported_protocols) + ", theirs = " + Integer.toHexString(this.selected_protocol));
                                        }
                                        var4_31 = 65535 & ((var3_26[4] & 255) << 8) + (var3_26[5] & 255);
                                        if (var4_31 > 65535) {
                                            throw new IOException("Invalid pad length '" + var4_31 + "'");
                                        }
                                        this.read_buffer = ByteBuffer.allocate(var4_31);
                                        this.protocol_substate = 3;
                                        continue;
                                    }
                                    if (this.protocol_substate != 3) continue;
                                    this.read_buffer.flip();
                                    var2_19 = new byte[this.read_buffer.remaining()];
                                    this.read_buffer.get(var2_19);
                                    var2_19 = this.read_cipher.update(var2_19);
                                    this.handshakeComplete();
                                    this.read_buffer = null;
                                }
lbl211:
                                // 15 sources

                                while (true) {
                                    if (this.handshake_complete) {
                                        this.transport.cancelReadSelects();
                                        this.transport.cancelWriteSelects();
                                        var1_4 = false;
                                        this.complete();
                                        continue block6;
                                    }
                                    if (this.read_buffer == null) {
                                        this.transport.pauseReadSelects();
                                    } else {
                                        this.transport.resumeReadSelects();
                                        var1_4 = false;
                                    }
                                    if (this.write_buffer == null) {
                                        this.transport.pauseWriteSelects();
                                        continue block6;
                                    }
                                    this.transport.resumeWriteSelects();
                                    var1_4 = false;
                                    continue block6;
                                    break;
                                }
                                break;
                            }
                        }
                        var13_2 = null;
                        this.process_mon.exit();
                        return;
                    }
                    catch (Throwable var1_5) {
                        this.failed(var1_5);
                        if (var1_5 instanceof IOException == false) throw new IOException(Debug.getNestedExceptionMessage(var1_5));
                        throw (IOException)var1_5;
                    }
                }
                catch (Throwable var12_42) {
                    var13_3 = null;
                    this.process_mon.exit();
                    throw var12_42;
                }
            }
            while (true) {
                block68: {
                    block66: {
                        block67: {
                            block65: {
                                this.read(this.read_buffer);
                                if (this.read_buffer.hasRemaining()) ** GOTO lbl211
                                if (this.protocol_substate != 1) break block65;
                                var2_12 = this.read_buffer.limit();
                                this.read_buffer.position(var2_12 - 20);
                                var3_21 = true;
                                break block66;
                            }
                            if (this.protocol_substate == 2) {
                                this.read_buffer.flip();
                                var2_13 = new byte[20];
                                this.read_buffer.get(var2_13);
                                var3_22 = new SHA1Hasher();
                                var3_22.update(ProtocolDecoderPHE.REQ3_IV);
                                var3_22.update(this.secret_bytes);
                                var4_29 = var3_22.getDigest();
                                for (var5_33 = 0; var5_33 < var2_13.length; ++var5_33) {
                                    v1 = var5_33;
                                    var2_13[v1] = (byte)(var2_13[v1] ^ var4_29[var5_33]);
                                }
                                v2 = ProtocolDecoderPHE.global_shared_secrets;
                                var5_32 /* !! */  = (byte[])v2;
                                // MONITORENTER : v2
                                this.shared_secret = (byte[])ProtocolDecoderPHE.global_shared_secrets.get(new HashWrapper(var2_13));
                                // MONITOREXIT : var5_32 /* !! */ 
                                if (this.shared_secret == null) {
                                    throw new IOException("No matching shared secret");
                                }
                                this.setupCrypto();
                                var5_32 /* !! */  = new byte[ProtocolDecoderPHE.VC.length + 4 + 2];
                                this.read_buffer.get(var5_32 /* !! */ );
                                var6_34 = this.read_cipher.update(var5_32 /* !! */ );
                                var7_36 = var6_34[ProtocolDecoderPHE.VC.length + 3];
                                var8_38 = this.my_supported_protocols & var7_36;
                                if ((var8_38 & 1) != 0) {
                                    this.selected_protocol = 1;
                                } else if ((var8_38 & 4) != 0) {
                                    this.selected_protocol = (byte)4;
                                } else if ((var8_38 & 2) != 0) {
                                    this.selected_protocol = (byte)2;
                                } else {
                                    if ((var8_38 & 8) == 0) throw new IOException("No crypto protocol in common: mine = " + Integer.toHexString(this.my_supported_protocols) + ", theirs = " + Integer.toHexString((int)var7_36));
                                    this.selected_protocol = (byte)8;
                                }
                                var9_40 = ((var6_34[ProtocolDecoderPHE.VC.length + 4] & 255) << 8) + (var6_34[ProtocolDecoderPHE.VC.length + 5] & 255);
                                if (var9_40 > 512) {
                                    throw new IOException("Invalid padding '" + var9_40 + "'");
                                }
                                this.read_buffer = ByteBuffer.allocate(var9_40 + 2);
                                this.protocol_substate = 3;
                                continue;
                            }
                            if (this.protocol_substate != 3) break block67;
                            this.read_buffer.flip();
                            var2_14 = new byte[this.read_buffer.remaining()];
                            this.read_buffer.get(var2_14);
                            var2_14 = this.read_cipher.update(var2_14);
                            var3_23 = 65535 & ((var2_14[var2_14.length - 2] & 255) << 8) + (var2_14[var2_14.length - 1] & 255);
                            if (var3_23 > 65535) {
                                throw new IOException("Invalid IA length '" + var3_23 + "'");
                            }
                            if (var3_23 > 0) {
                                this.read_buffer = ByteBuffer.allocate(var3_23);
                                this.protocol_substate = 4;
                                continue;
                            }
                            this.read_buffer = null;
                            this.protocol_state = 3;
                            ** GOTO lbl211
                        }
                        if (this.protocol_substate != 4) continue;
                        this.read_buffer.flip();
                        var2_15 = new byte[this.read_buffer.remaining()];
                        this.read_buffer.get(var2_15);
                        var2_15 = this.read_cipher.update(var2_15);
                        this.delay_outbound_4 = new String(var2_15).indexOf("BitTorrent") != -1;
                        this.initial_data_in = ByteBuffer.wrap(var2_15);
                        this.read_buffer = null;
                        this.protocol_state = 3;
                        ** GOTO lbl211
                    }
                    for (var4_28 = 0; var4_28 < 20; ++var4_28) {
                        if (this.read_buffer.get() == this.padding_skip_marker[var4_28]) continue;
                        var3_21 = false;
                        break;
                    }
                    if (!var3_21) break block68;
                    this.read_buffer = ByteBuffer.allocate(20 + ProtocolDecoderPHE.VC.length + 4 + 2);
                    this.protocol_substate = 2;
                    ** GOTO lbl211
                }
                if (var2_12 == this.read_buffer.capacity()) {
                    throw new IOException("PHE skip to SHA1 marker failed");
                }
                this.read_buffer.limit(var2_12 + 1);
                this.read_buffer.position(var2_12);
            }
        }
        for (var4_31 = 0; var4_31 < ProtocolDecoderPHE.VC.length; ++var4_31) {
            if (this.read_buffer.get() == this.padding_skip_marker[var4_31]) continue;
            var3_25 = false;
            break;
        }
        if (var3_25) {
            this.read_buffer = ByteBuffer.allocate(6);
            this.protocol_substate = 2;
            ** continue;
        }
        if (var2_17 == this.read_buffer.capacity()) {
            throw new IOException("PHE skip to SHA1 marker failed");
        }
        this.read_buffer.limit(var2_17 + 1);
        this.read_buffer.position(var2_17);
        ** while (true)
    }

    protected void read(ByteBuffer byteBuffer) throws IOException {
        int n = this.transport.read(byteBuffer);
        if (n < 0) {
            throw new IOException("end of stream on socket read - phe: " + this.getString());
        }
        this.bytes_read += n;
    }

    protected void write(ByteBuffer byteBuffer) throws IOException {
        int n = this.transport.write(byteBuffer, false);
        if (n < 0) {
            throw new IOException("bytes written < 0 ");
        }
        this.bytes_written += n;
    }

    public boolean selectSuccess(TransportHelper transportHelper, Object object, boolean bl) {
        try {
            boolean bl2;
            int n = this.bytes_read;
            int n2 = this.bytes_written;
            this.process();
            if (bl) {
                return this.bytes_written != n2;
            }
            boolean bl3 = bl2 = this.bytes_read != n;
            if (bl2) {
                this.last_read_time = SystemTime.getCurrentTime();
            }
            return bl2;
        }
        catch (Throwable throwable) {
            this.failed(throwable);
            return false;
        }
    }

    public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
        this.failed(throwable);
    }

    protected byte[] bigIntegerToBytes(BigInteger bigInteger, int n) {
        String string = bigInteger.toString(16);
        while (string.length() < n * 2) {
            string = "0" + string;
        }
        return ByteFormatter.decodeString(string);
    }

    protected BigInteger bytesToBigInteger(byte[] byArray, int n, int n2) {
        return new BigInteger(ByteFormatter.encodeString(byArray, n, n2), 16);
    }

    protected int getPaddingMax() {
        if (this.transport.minimiseOverheads()) {
            return 128;
        }
        return 512;
    }

    protected static synchronized byte[] getRandomPadding(int n) {
        byte[] byArray = new byte[random.nextInt(n)];
        random.nextBytes(byArray);
        return byArray;
    }

    protected static synchronized byte[] getZeroPadding(int n) {
        byte[] byArray = new byte[random.nextInt(n)];
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static KeyPair generateDHKeyPair(TransportHelper transportHelper, boolean bl) throws IOException {
        if (dh_key_generator == null) {
            throw new IOException("Crypto not setup");
        }
        KeyPairGenerator keyPairGenerator = dh_key_generator;
        synchronized (keyPairGenerator) {
            Object object;
            if (!bl) {
                object = transportHelper.getAddress().getAddress().getAddress();
                int n = generate_bloom.add((byte[])object);
                long l = SystemTime.getCurrentTime();
                if (generate_bloom.getSize() / generate_bloom.getEntryCount() < 10) {
                    generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize() + 1000);
                    generate_bloom_create_time = l;
                    Logger.log(new LogEvent(LOGID, "PHE bloom: size increased to " + generate_bloom.getSize()));
                } else if (l < generate_bloom_create_time || l - generate_bloom_create_time > 30000L) {
                    generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize());
                    generate_bloom_create_time = l;
                }
                if (n >= 15) {
                    Logger.log(new LogEvent(LOGID, "PHE bloom: too many recent connection attempts from " + transportHelper.getAddress()));
                    throw new IOException("Too many recent connection attempts (phe)");
                }
                long l2 = l - last_dh_incoming_key_generate;
                long l3 = 100L - l2;
                if (l3 > 0L && l3 < 100L) {
                    try {
                        Thread.sleep(l3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                last_dh_incoming_key_generate = l;
            }
            object = dh_key_generator.generateKeyPair();
            return object;
        }
    }

    protected void complete() {
        this.processing_complete = true;
        this.transport.setScatteringMode(0L);
        this.adapter.decodeComplete(this, this.initial_data_out);
    }

    protected void failed(Throwable throwable) {
        this.processing_complete = true;
        this.transport.cancelReadSelects();
        this.transport.cancelWriteSelects();
        this.adapter.decodeFailed(this, throwable);
    }

    public boolean isComplete(long l) {
        return this.processing_complete;
    }

    public TransportHelperFilter getFilter() {
        return this.filter;
    }

    public long getLastReadTime() {
        long l = SystemTime.getCurrentTime();
        if (this.last_read_time > l) {
            this.last_read_time = l;
        }
        return this.last_read_time;
    }

    public String getString() {
        return "state=" + this.protocol_state + ",sub=" + this.protocol_substate + ",in=" + this.bytes_read + ",out=" + this.bytes_written;
    }

    static {
        MIN_INCOMING_INITIAL_PACKET_SIZE = DH_SIZE_BYTES = DH_P.length() / 2;
        DH_P_BI = new BigInteger(DH_P, 16);
        DH_G_BI = new BigInteger(DH_G, 16);
        generate_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
        generate_bloom_create_time = SystemTime.getCurrentTime();
        random = RandomUtils.SECURE_RANDOM;
        global_shared_secrets = new LightHashMap();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.transport.encrypted.min_level"}, new ParameterListener(){

            public void parameterChanged(String string) {
                String string2;
                if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE && !ProtocolDecoderPHE.isCryptoOK()) {
                    Logger.log(new LogAlert(true, 3, "Connection encryption unavailable, please update your Java version"));
                }
                if ((string2 = COConfigurationManager.getStringParameter("network.transport.encrypted.min_level")).equals("XOR")) {
                    MIN_CRYPTO = (byte)14;
                } else if (string2.equals("RC4")) {
                    MIN_CRYPTO = (byte)10;
                } else if (string2.equals("AES")) {
                    MIN_CRYPTO = (byte)8;
                } else {
                    MIN_CRYPTO = (byte)15;
                }
                MIN_CRYPTO = (byte)(MIN_CRYPTO & 3);
            }
        });
        KEYA_IV = "keyA".getBytes();
        KEYB_IV = "keyB".getBytes();
        REQ1_IV = "req1".getBytes();
        REQ2_IV = "req2".getBytes();
        REQ3_IV = "req3".getBytes();
        VC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    }
}

