/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTester;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterImpl;
import java.io.File;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class NetworkAdminSpeedTesterBTImpl
extends NetworkAdminSpeedTesterImpl
implements NetworkAdminSpeedTester {
    public static final String DOWNLOAD_AVE = "download-ave";
    public static final String UPLOAD_AVE = "upload-ave";
    public static final String DOWNLOAD_STD_DEV = "download-std-dev";
    public static final String UPLOAD_STD_DEV = "upload-std-dev";
    private static int testMode = 0;
    private static TorrentAttribute speedTestAttrib;
    private static NetworkAdminSpeedTesterResult lastResult;
    private PluginInterface plugin;
    private boolean test_started;
    private boolean test_completed;
    private boolean use_crypto;
    private volatile boolean aborted;
    private String deferred_abort;

    protected static void startUp() {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        speedTestAttrib = pluginInterface.getTorrentManager().getPluginAttribute(NetworkAdminSpeedTesterBTImpl.class.getName() + ".test.attrib");
        DownloadManager downloadManager = pluginInterface.getDownloadManager();
        Download[] downloadArray = downloadManager.getDownloads();
        if (downloadArray != null) {
            int n = downloadArray.length;
            for (int i = 0; i < n; ++i) {
                Download download = downloadArray[i];
                if (!download.getBooleanAttribute(speedTestAttrib)) continue;
                try {
                    if (download.getState() != 7) {
                        try {
                            download.stop();
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                    download.remove(true, true);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.out("Had " + throwable.getMessage() + " while trying to remove " + downloadArray[i].getName());
                }
            }
        }
    }

    protected static NetworkAdminSpeedTesterResult getLastResult() {
        return lastResult;
    }

    public NetworkAdminSpeedTesterBTImpl(PluginInterface pluginInterface) {
        this.plugin = pluginInterface;
    }

    public int getTestType() {
        return 1;
    }

    public void setMode(int n) {
        testMode = n;
    }

    public int getMode() {
        return testMode;
    }

    public void setUseCrypto(boolean bl) {
        this.use_crypto = bl;
    }

    public boolean getUseCrypto() {
        return this.use_crypto;
    }

    public synchronized void start(TOTorrent tOTorrent) {
        if (this.test_started) {
            Debug.out("Test already started!");
            return;
        }
        this.test_started = true;
        try {
            TorrentUtils.setFlag(tOTorrent, 1, true);
            TorrentImpl torrentImpl = new TorrentImpl(tOTorrent);
            String string = torrentImpl.getName();
            this.sendStageUpdateToListeners(MessageText.getString("SpeedTestWizard.stage.message.preparing"));
            File file = AETemporaryFileHandler.createTempFile();
            File file2 = file.getParentFile();
            File file3 = new File(file2, string);
            File file4 = new File(file2, "speedTestTorrent.torrent");
            torrentImpl.writeToFile(file4);
            URL uRL = torrentImpl.getAnnounceURL();
            if (uRL.getProtocol().equalsIgnoreCase("https")) {
                SESecurityManager.setCertificateHandler(uRL, new SECertificateListener(){

                    public boolean trustCertificate(String string, X509Certificate x509Certificate) {
                        return true;
                    }
                });
            }
            Download download = this.plugin.getDownloadManager().addDownloadStopped(torrentImpl, file4, file3);
            download.setBooleanAttribute(speedTestAttrib, true);
            org.gudy.azureus2.core3.download.DownloadManager downloadManager = PluginCoreUtils.unwrap(download);
            downloadManager.setPieceCheckingEnabled(false);
            downloadManager.getDownloadState().setIntParameter("max.uploads", 32);
            downloadManager.getDownloadState().setIntParameter("max.uploads.when.seeding", 32);
            if (this.use_crypto) {
                downloadManager.setCryptoLevel(1);
            }
            downloadManager.addPeerListener(new DownloadManagerPeerListener(){

                public void peerManagerWillBeAdded(PEPeerManager pEPeerManager) {
                    int n;
                    DiskManager diskManager = pEPeerManager.getDiskManager();
                    DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
                    for (int i = n = NetworkAdminSpeedTesterBTImpl.setStartPieceBasedOnMode(testMode, diskManagerPieceArray.length); i < diskManagerPieceArray.length; ++i) {
                        diskManagerPieceArray[i].setDone(true);
                    }
                }

                public void peerManagerAdded(PEPeerManager pEPeerManager) {
                }

                public void peerManagerRemoved(PEPeerManager pEPeerManager) {
                }

                public void peerAdded(PEPeer pEPeer) {
                }

                public void peerRemoved(PEPeer pEPeer) {
                }
            });
            download.moveTo(1);
            download.setFlag(4L, true);
            downloadManager.initialize();
            downloadManager.setForceStart(true);
            TorrentSpeedTestMonitorThread torrentSpeedTestMonitorThread = new TorrentSpeedTestMonitorThread(download);
            torrentSpeedTestMonitorThread.start();
        }
        catch (Throwable throwable) {
            this.test_completed = true;
            this.abort("Could not start test", throwable);
        }
    }

    public void complete(NetworkAdminSpeedTesterResult networkAdminSpeedTesterResult) {
        this.sendResultToListeners(networkAdminSpeedTesterResult);
    }

    protected void abort(String string, Throwable throwable) {
        String string2 = throwable instanceof RuntimeException ? Debug.getNestedExceptionMessageAndStack(throwable) : Debug.getNestedExceptionMessage(throwable);
        this.abort(string + ": " + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(String string) {
        string = "Test aborted: " + string;
        NetworkAdminSpeedTesterBTImpl networkAdminSpeedTesterBTImpl = this;
        synchronized (networkAdminSpeedTesterBTImpl) {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            if (this.test_started && !this.test_completed) {
                this.deferred_abort = string;
                return;
            }
        }
        this.sendResultToListeners(new BitTorrentResult(string));
    }

    public NetworkAdminSpeedTesterResult getResult() {
        return lastResult;
    }

    private static int setStartPieceBasedOnMode(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return n2;
        }
        throw new IllegalStateException("Did not recognize the NetworkAdmin Speed Test type. mode=" + n);
    }

    private static long autoboxLong(Object object) {
        return NetworkAdminSpeedTesterBTImpl.autoboxLong((Long)object);
    }

    private static long autoboxLong(Long l) {
        return l;
    }

    private static Long autoboxLong(long l) {
        return new Long(l);
    }

    private static Double autoboxDouble(double d) {
        return new Double(d);
    }

    class BitTorrentResult
    implements NetworkAdminSpeedTesterResult {
        long time = SystemTime.getCurrentTime();
        int downspeed;
        int upspeed;
        boolean hadError = false;
        String lastError = "";

        public BitTorrentResult(Map map, Map map2) {
            Double d = (Double)map2.get("ave");
            Double d2 = (Double)map.get("ave");
            this.downspeed = d.intValue();
            this.upspeed = d2.intValue();
        }

        public BitTorrentResult(String string) {
            this.hadError = true;
            this.lastError = string;
        }

        public NetworkAdminSpeedTester getTest() {
            return NetworkAdminSpeedTesterBTImpl.this;
        }

        public long getTestTime() {
            return this.time;
        }

        public int getDownloadSpeed() {
            return this.downspeed;
        }

        public int getUploadSpeed() {
            return this.upspeed;
        }

        public boolean hadError() {
            return this.hadError;
        }

        public String getLastError() {
            return this.lastError;
        }

        public String getResultString() {
            StringBuffer stringBuffer = new StringBuffer();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmss z");
            String string = simpleDateFormat.format(new Date(this.time));
            stringBuffer.append(string).append(" ");
            stringBuffer.append("type: BT test ");
            stringBuffer.append("mode: ").append(NetworkAdminSpeedTesterBTImpl.this.getMode());
            stringBuffer.append(" encrypted: ");
            if (NetworkAdminSpeedTesterBTImpl.this.use_crypto) {
                stringBuffer.append("y");
            } else {
                stringBuffer.append("n");
            }
            if (this.hadError) {
                stringBuffer.append(" Last Error: ").append(this.lastError);
            } else {
                stringBuffer.append(" download speed: ").append(this.downspeed).append(" bits/sec");
                stringBuffer.append(" upload speed: ").append(this.upspeed).append(" bits/sec");
            }
            return stringBuffer.toString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterBTImpl");
            stringBuffer.append(" ").append(this.getResultString()).append(" ");
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private class TorrentSpeedTestMonitorThread
    extends Thread {
        List historyDownloadSpeed = new LinkedList();
        List historyUploadSpeed = new LinkedList();
        List timestamps = new LinkedList();
        Download testDownload;
        public static final long MAX_TEST_TIME = 120000L;
        public static final long MAX_PEAK_TIME = 30000L;
        long startTime;
        long peakTime;
        long peakRate;
        public static final String AVE = "ave";
        public static final String STD_DEV = "stddev";

        public TorrentSpeedTestMonitorThread(Download download) {
            this.testDownload = download;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NetworkAdminSpeedTesterBTImpl networkAdminSpeedTesterBTImpl;
            try {
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = new HashSet<String>();
                HashSet<String> hashSet3 = new HashSet<String>();
                try {
                    this.peakTime = this.startTime = SystemTime.getCurrentTime();
                    boolean bl = false;
                    long l = 0L;
                    NetworkAdminSpeedTesterBTImpl.this.sendStageUpdateToListeners(MessageText.getString("SpeedTestWizard.stage.message.starting"));
                    while (!bl && !NetworkAdminSpeedTesterBTImpl.this.aborted) {
                        Object object;
                        Object object2;
                        int n = this.testDownload.getState();
                        if (n == 8) {
                            object2 = MessageText.getString("SpeedTestWizard.abort.message.entered.error", new String[]{this.testDownload.getErrorStateDetails()});
                            NetworkAdminSpeedTesterBTImpl.this.abort((String)object2);
                            break;
                        }
                        if (n == 7) {
                            NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.entered.queued"));
                            break;
                        }
                        if (!this.testDownload.isForceStart()) {
                            this.testDownload.setForceStart(true);
                        }
                        if ((object2 = this.testDownload.getPeerManager()) != null) {
                            Peer[] peerArray = object2.getPeers();
                            for (int i = 0; i < peerArray.length; ++i) {
                                object = peerArray[i];
                                String string = object.getIp();
                                hashSet.add(string);
                                if (!object.isChoked()) {
                                    hashSet2.add(string);
                                }
                                if (object.isChoking()) continue;
                                hashSet3.add(string);
                            }
                        }
                        long l2 = SystemTime.getCurrentTime();
                        object = this.testDownload.getStats();
                        this.historyDownloadSpeed.add(NetworkAdminSpeedTesterBTImpl.autoboxLong(object.getDownloaded()));
                        this.historyUploadSpeed.add(NetworkAdminSpeedTesterBTImpl.autoboxLong(object.getUploaded()));
                        this.timestamps.add(NetworkAdminSpeedTesterBTImpl.autoboxLong(l2));
                        this.updateTestProgress(l2, (DownloadStats)object);
                        l = this.checkForNewPeakValue((DownloadStats)object, l, l2);
                        bl = this.checkForTestDone();
                        if (bl) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.interrupted"));
                            break;
                        }
                    }
                    try {
                        if (this.testDownload.getState() != 7) {
                            try {
                                this.testDownload.stop();
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        this.testDownload.remove(true, true);
                    }
                    catch (DownloadException downloadException) {
                        NetworkAdminSpeedTesterBTImpl.this.abort("TorrentSpeedTestMonitorThread could not stop the torrent " + this.testDownload.getName(), downloadException);
                    }
                    catch (DownloadRemovalVetoException downloadRemovalVetoException) {
                        NetworkAdminSpeedTesterBTImpl.this.abort("TorrentSpeedTestMonitorTheard could not remove the torrent " + this.testDownload.getName(), downloadRemovalVetoException);
                    }
                }
                catch (Exception exception) {
                    NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.execution.failed"), exception);
                }
                if (!NetworkAdminSpeedTesterBTImpl.this.aborted) {
                    String string = MessageText.getString("SpeedTestWizard.stage.message.connect.stats", new String[]{"" + hashSet.size(), "" + hashSet2.size(), "" + hashSet3.size()});
                    NetworkAdminSpeedTesterBTImpl.this.sendStageUpdateToListeners(string);
                    if (hashSet.size() == 0) {
                        NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.failed.peers"));
                    } else if (hashSet3.size() == 0 && testMode != 1) {
                        NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.insufficient.slots"));
                    } else if (hashSet2.size() == 0 && testMode != 0) {
                        NetworkAdminSpeedTesterBTImpl.this.abort(MessageText.getString("SpeedTestWizard.abort.message.not.unchoked"));
                    }
                }
                if (!NetworkAdminSpeedTesterBTImpl.this.aborted) {
                    NetworkAdminSpeedTesterResult networkAdminSpeedTesterResult = this.calculateDownloadRate();
                    lastResult = networkAdminSpeedTesterResult;
                    AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.STres");
                    aEDiagnosticsLogger.log(networkAdminSpeedTesterResult.toString());
                    NetworkAdminSpeedTesterBTImpl.this.complete(networkAdminSpeedTesterResult);
                }
                Object var14_21 = null;
                networkAdminSpeedTesterBTImpl = NetworkAdminSpeedTesterBTImpl.this;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                NetworkAdminSpeedTesterBTImpl networkAdminSpeedTesterBTImpl2 = NetworkAdminSpeedTesterBTImpl.this;
                synchronized (networkAdminSpeedTesterBTImpl2) {
                    NetworkAdminSpeedTesterBTImpl.this.test_completed = true;
                    if (NetworkAdminSpeedTesterBTImpl.this.deferred_abort != null) {
                        NetworkAdminSpeedTesterBTImpl.this.sendResultToListeners(new BitTorrentResult(NetworkAdminSpeedTesterBTImpl.this.deferred_abort));
                    }
                }
                throw throwable;
            }
            synchronized (networkAdminSpeedTesterBTImpl) {
                NetworkAdminSpeedTesterBTImpl.this.test_completed = true;
                if (NetworkAdminSpeedTesterBTImpl.this.deferred_abort != null) {
                    NetworkAdminSpeedTesterBTImpl.this.sendResultToListeners(new BitTorrentResult(NetworkAdminSpeedTesterBTImpl.this.deferred_abort));
                }
            }
        }

        public void updateTestProgress(long l, DownloadStats downloadStats) {
            long l2 = l - this.peakTime;
            float f = (float)l2 / 30000.0f;
            long l3 = l - this.startTime;
            float f2 = (float)l3 / 120000.0f;
            float f3 = f2;
            if (f > f3) {
                f3 = f;
            }
            int n = Math.round(f3 * 100.0f);
            StringBuffer stringBuffer = new StringBuffer("progress: ");
            stringBuffer.append(n);
            stringBuffer.append(" : download ave ");
            stringBuffer.append(downloadStats.getDownloadAverage());
            stringBuffer.append(" : upload ave ");
            stringBuffer.append(downloadStats.getUploadAverage());
            stringBuffer.append(" : ");
            int n2 = (int)((120000L - l3) / 1000L);
            stringBuffer.append(n2);
            stringBuffer.append(" : ");
            int n3 = (int)((30000L - l2) / 1000L);
            stringBuffer.append(n3);
            NetworkAdminSpeedTesterBTImpl.this.sendStageUpdateToListeners(stringBuffer.toString());
        }

        private Map calculate(List list) {
            int n;
            int n2;
            List list2 = this.convertSumToDeltas(list);
            Collections.sort(list2);
            int n3 = list2.size();
            int n4 = n3 / 10;
            for (n2 = n3 - 1; n2 < n3 - n4; --n2) {
                list2.remove(n2);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                list2.remove(0);
            }
            long l = 0L;
            for (n = 0; n < list2.size(); ++n) {
                l += NetworkAdminSpeedTesterBTImpl.autoboxLong(list2.get(n));
            }
            double d = l / (long)list2.size();
            double d2 = 0.0;
            for (n = 0; n < list2.size(); ++n) {
                double d3 = (double)NetworkAdminSpeedTesterBTImpl.autoboxLong(list2.get(n)) - d;
                d2 += d3 * d3;
            }
            double d4 = Math.sqrt(d2 / (double)(n - 1));
            HashMap<String, Double> hashMap = new HashMap<String, Double>();
            hashMap.put(AVE, NetworkAdminSpeedTesterBTImpl.autoboxDouble(d));
            hashMap.put(STD_DEV, NetworkAdminSpeedTesterBTImpl.autoboxDouble(d4));
            return hashMap;
        }

        private List convertSumToDeltas(List list) {
            int n;
            int n2 = list.size();
            ArrayList<Long> arrayList = new ArrayList<Long>(n2);
            if (n == 0) {
                return arrayList;
            }
            long l = NetworkAdminSpeedTesterBTImpl.autoboxLong(list.get(n - 1));
            for (n = this.findIndexPeak(n2); n < n2; ++n) {
                long l2 = NetworkAdminSpeedTesterBTImpl.autoboxLong(list.get(n));
                Long l3 = NetworkAdminSpeedTesterBTImpl.autoboxLong(l2 - l);
                arrayList.add(l3);
                l = l2;
            }
            return arrayList;
        }

        private int findIndexPeak(int n) {
            long l;
            int n2;
            for (n2 = 0; n2 < n && (l = NetworkAdminSpeedTesterBTImpl.autoboxLong(this.timestamps.get(n2))) <= this.peakTime; ++n2) {
            }
            return n2;
        }

        NetworkAdminSpeedTesterResult calculateDownloadRate() {
            Map map = this.calculate(this.historyDownloadSpeed);
            Map map2 = this.calculate(this.historyUploadSpeed);
            return new BitTorrentResult(map2, map);
        }

        boolean checkForTestDone() {
            long l = SystemTime.getCurrentTime();
            if (l - this.startTime > 120000L) {
                return true;
            }
            return l - this.peakTime > 30000L;
        }

        long checkForNewPeakValue(DownloadStats downloadStats, long l, long l2) {
            long l3 = testMode == 0 ? downloadStats.getUploaded() : downloadStats.getDownloaded();
            long l4 = l3 - l;
            if (l4 > this.peakRate) {
                this.peakRate = (long)((double)l4 * 1.1);
                this.peakTime = l2;
            }
            return l3;
        }
    }
}

