/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.instancemanager.impl.AZInstanceImpl;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AZOtherInstanceImpl
extends AZInstanceImpl {
    private String id;
    private String app_id;
    private List internal_addresses = new ArrayList();
    private InetAddress external_address;
    private int tcp_port;
    private int udp_port;
    private int udp_non_data_port;
    private Map<String, Object> props;
    private long alive_time;

    protected static AZOtherInstanceImpl decode(InetAddress inetAddress, Map map) {
        String string = new String((byte[])map.get("id"));
        String string2 = new String((byte[])map.get("iip"));
        String string3 = new String((byte[])map.get("eip"));
        int n = ((Long)map.get("tp")).intValue();
        int n2 = ((Long)map.get("dp")).intValue();
        Long l = (Long)map.get("dp2");
        int n3 = l == null ? n2 : l.intValue();
        byte[] byArray = (byte[])map.get("ai");
        String string4 = byArray == null ? "az_4.2.0.2" : new String(byArray);
        Map map2 = (Map)map.get("pr");
        try {
            InetAddress inetAddress2;
            if (!string2.equals("0.0.0.0")) {
                inetAddress = InetAddress.getByName(string2);
            }
            if (inetAddress instanceof Inet4Address == (inetAddress2 = InetAddress.getByName(string3)) instanceof Inet4Address) {
                return new AZOtherInstanceImpl(string, string4, inetAddress, inetAddress2, n, n2, n3, map2);
            }
            return null;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    protected AZOtherInstanceImpl(String string, String string2, InetAddress inetAddress, InetAddress inetAddress2, int n, int n2, int n3, Map<String, Object> map) {
        this.id = string;
        this.app_id = string2;
        this.internal_addresses.add(inetAddress);
        this.external_address = inetAddress2;
        this.tcp_port = n;
        this.udp_port = n2;
        this.udp_non_data_port = n3;
        this.props = map;
        this.alive_time = SystemTime.getCurrentTime();
    }

    protected boolean update(AZOtherInstanceImpl aZOtherInstanceImpl) {
        this.alive_time = SystemTime.getCurrentTime();
        InetAddress inetAddress = aZOtherInstanceImpl.getInternalAddress();
        boolean bl = true;
        if (!this.internal_addresses.contains(inetAddress)) {
            bl = false;
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this.internal_addresses);
            arrayList.add(0, inetAddress);
            this.internal_addresses = arrayList;
        }
        bl = bl && this.external_address.equals(aZOtherInstanceImpl.external_address) && this.tcp_port == aZOtherInstanceImpl.tcp_port && this.udp_port == aZOtherInstanceImpl.udp_port;
        this.external_address = aZOtherInstanceImpl.external_address;
        this.tcp_port = aZOtherInstanceImpl.tcp_port;
        this.udp_port = aZOtherInstanceImpl.udp_port;
        return !bl;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getApplicationID() {
        return this.app_id;
    }

    @Override
    public InetAddress getInternalAddress() {
        return (InetAddress)this.internal_addresses.get(0);
    }

    @Override
    public List getInternalAddresses() {
        return new ArrayList(this.internal_addresses);
    }

    @Override
    public InetAddress getExternalAddress() {
        return this.external_address;
    }

    @Override
    public int getTCPListenPort() {
        return this.tcp_port;
    }

    @Override
    public int getUDPListenPort() {
        return this.udp_port;
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.props;
    }

    protected long getAliveTime() {
        long l = SystemTime.getCurrentTime();
        if (l < this.alive_time) {
            this.alive_time = l;
        }
        return this.alive_time;
    }
}

