/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.drivedetector.impl;

import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetectedListener;
import com.aelitis.azureus.core.drivedetector.DriveDetector;
import com.aelitis.azureus.core.drivedetector.impl.DriveDetectedInfoImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class DriveDetectorImpl
implements DriveDetector,
AEDiagnosticsEvidenceGenerator {
    private AEMonitor2 mon_driveDetector = new AEMonitor2("driveDetector");
    private CopyOnWriteList<DriveDetectedListener> listListeners = new CopyOnWriteList(1);
    private Map<File, Map> mapDrives = new HashMap<File, Map>(1);

    public DriveDetectorImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveDetectedInfo[] getDetectedDriveInfo() {
        this.mon_driveDetector.enter();
        try {
            int n = 0;
            DriveDetectedInfo[] driveDetectedInfoArray = new DriveDetectedInfo[this.mapDrives.size()];
            for (File file : this.mapDrives.keySet()) {
                driveDetectedInfoArray[n++] = new DriveDetectedInfoImpl(file, this.mapDrives.get(file));
            }
            DriveDetectedInfo[] driveDetectedInfoArray2 = driveDetectedInfoArray;
            Object var6_5 = null;
            this.mon_driveDetector.exit();
            return driveDetectedInfoArray2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DriveDetectedListener driveDetectedListener) {
        this.mon_driveDetector.enter();
        try {
            if (this.listListeners.contains(driveDetectedListener)) {
                Object var6_2 = null;
                this.mon_driveDetector.exit();
                return;
            }
            this.listListeners.add(driveDetectedListener);
            for (File file : this.mapDrives.keySet()) {
                try {
                    driveDetectedListener.driveDetected(new DriveDetectedInfoImpl(file, this.mapDrives.get(file)));
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
        Object var6_3 = null;
        this.mon_driveDetector.exit();
    }

    public void removeListener(DriveDetectedListener driveDetectedListener) {
        this.listListeners.remove(driveDetectedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveDetected(File file, Map map) {
        file = this.normaliseFile(file);
        this.mon_driveDetector.enter();
        try {
            if (this.mapDrives.containsKey(file)) {
                Object var4_3 = null;
                this.mon_driveDetector.exit();
                return;
            }
            map.put("File", file);
            this.mapDrives.put(file, map);
            DriveDetectedListener driveDetectedListener = null;
            this.mon_driveDetector.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
        for (DriveDetectedListener driveDetectedListener : this.listListeners) {
            try {
                driveDetectedListener.driveDetected(new DriveDetectedInfoImpl(file, map));
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveRemoved(File file) {
        Map map;
        file = this.normaliseFile(file);
        this.mon_driveDetector.enter();
        try {
            map = this.mapDrives.remove(file);
            if (map == null) {
                Object var4_3 = null;
                this.mon_driveDetector.exit();
                return;
            }
            DriveDetectedListener driveDetectedListener = null;
            this.mon_driveDetector.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.mon_driveDetector.exit();
            throw throwable;
        }
        for (DriveDetectedListener driveDetectedListener : this.listListeners) {
            try {
                driveDetectedListener.driveRemoved(new DriveDetectedInfoImpl(file, map));
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    protected File normaliseFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        Map<File, Map> map = this.mapDrives;
        synchronized (map) {
            indentWriter.println("DriveDetector: " + this.mapDrives.size() + " drives");
            for (File file : this.mapDrives.keySet()) {
                Object var12_11;
                try {
                    try {
                        Object var10_10;
                        indentWriter.indent();
                        indentWriter.println(file.getPath());
                        try {
                            indentWriter.indent();
                            Map map2 = this.mapDrives.get(file);
                            for (Object k : map2.keySet()) {
                                Object v = map2.get(k);
                                indentWriter.println(k + ": " + v);
                            }
                            var10_10 = null;
                            indentWriter.exdent();
                        }
                        catch (Throwable throwable) {
                            var10_10 = null;
                            indentWriter.exdent();
                            throw throwable;
                        }
                        var12_11 = null;
                        indentWriter.exdent();
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                        var12_11 = null;
                        indentWriter.exdent();
                    }
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    indentWriter.exdent();
                    throw throwable;
                }
            }
        }
    }
}

