/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessCompact;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessLinear;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessPieceReorderer;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.StringInterner;

public class FMFileAccessController
implements FMFileAccess {
    private static final String REORDER_SUFFIX = ".2";
    private static final boolean TEST_PIECE_REORDER = System.getProperty("azureus.file.piece.reorder.force", "0").equals("1");
    private FMFileImpl owner;
    private int type = 1;
    private File control_dir;
    private String controlFileName;
    private FMFileAccess file_access;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FMFileAccessController(FMFileImpl fMFileImpl, int n) throws FMFileManagerException {
        if (TEST_PIECE_REORDER) {
            n = 3;
        }
        this.owner = fMFileImpl;
        this.setControlFile();
        if (this.control_dir == null) {
            if (n != 1) throw new FMFileManagerException("Compact storage not supported: no control file available");
            this.file_access = new FMFileAccessLinear(this.owner);
            return;
        } else {
            if (new File(this.control_dir, this.controlFileName).exists()) {
                this.type = 2;
            } else if (new File(this.control_dir, this.controlFileName + REORDER_SUFFIX).exists()) {
                this.type = n == 3 ? 3 : 4;
            } else if (n == 3 || n == 4) {
                File file = this.owner.getLinkedFile();
                if (file.exists()) {
                    FMFileAccessPieceReorderer.recoverConfig(this.owner.getOwner().getTorrentFile(), file, new File(this.control_dir, this.controlFileName + REORDER_SUFFIX));
                }
                this.type = n;
            } else {
                this.type = 1;
            }
            this.file_access = this.type == 1 ? new FMFileAccessLinear(this.owner) : (this.type == 2 ? new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName, new FMFileAccessLinear(this.owner)) : new FMFileAccessPieceReorderer(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName + REORDER_SUFFIX, new FMFileAccessLinear(this.owner)));
            this.convert(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void convert(int n) throws FMFileManagerException {
        block32: {
            Object v0;
            if (this.type == n) {
                return;
            }
            if (this.type == 3 || n == 3) {
                if (n == 4 || this.type == 4) {
                    this.type = n;
                    return;
                }
                throw new FMFileManagerException("Conversion to/from piece-reorder not supported");
            }
            File file = this.owner.getLinkedFile();
            RandomAccessFile randomAccessFile = null;
            boolean bl = false;
            FMFileAccess fMFileAccess = n == 1 ? new FMFileAccessLinear(this.owner) : new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName, new FMFileAccessLinear(this.owner));
            if (file.exists()) {
                randomAccessFile = new RandomAccessFile(file, "rw");
                FMFileAccessCompact fMFileAccessCompact = n == 1 ? (FMFileAccessCompact)this.file_access : (FMFileAccessCompact)fMFileAccess;
                long l = this.file_access.getLength(randomAccessFile);
                long l2 = fMFileAccessCompact.getLastPieceStart();
                long l3 = fMFileAccessCompact.getLastPieceLength();
                if (l3 > 0L && l > l2) {
                    long l4 = l - l2;
                    if (l4 > l3) {
                        Debug.out("data length inconsistent: len=" + l4 + ",limit=" + l3);
                        l4 = l3;
                    }
                    DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)25, (int)l4);
                    try {
                        this.file_access.read(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l2);
                        if (n == 2) {
                            long l5 = fMFileAccessCompact.getFirstPieceLength();
                            long l6 = randomAccessFile.length();
                            if (l6 > l5) {
                                randomAccessFile.setLength(l5);
                            }
                        }
                        directByteBuffer.flip((byte)25);
                        fMFileAccess.write(randomAccessFile, new DirectByteBuffer[]{directByteBuffer}, l2);
                        Object var21_17 = null;
                        directByteBuffer.returnToPool();
                    }
                    catch (Throwable throwable) {
                        Object var21_18 = null;
                        directByteBuffer.returnToPool();
                        throw throwable;
                    }
                } else if (n == 2) {
                    long l7 = fMFileAccessCompact.getFirstPieceLength();
                    long l8 = randomAccessFile.length();
                    if (l8 > l7) {
                        randomAccessFile.setLength(l7);
                    }
                }
                fMFileAccess.setLength(randomAccessFile, l);
                fMFileAccess.flush();
            }
            this.type = n;
            this.file_access = fMFileAccess;
            bl = true;
            Object var23_20 = null;
            try {
                block29: {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Throwable throwable) {
                            if (!bl) break block29;
                            bl = false;
                            throw new FMFileManagerException("convert fails", throwable);
                        }
                    }
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                Object var26_26;
                v0 = var26_26 = null;
            }
            if (!bl) {
                this.type = 1;
                this.file_access = new FMFileAccessLinear(this.owner);
            }
            if (this.type == 1) {
                new File(this.control_dir, this.controlFileName).delete();
            }
            break block32;
            {
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    throw new FMFileManagerException("convert fails", throwable);
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var23_21 = null;
                try {
                    block31: {
                        if (randomAccessFile != null) {
                            try {
                                randomAccessFile.close();
                            }
                            catch (Throwable throwable2) {
                                if (!bl) break block31;
                                bl = false;
                                throw new FMFileManagerException("convert fails", throwable2);
                            }
                        }
                    }
                    v1 = null;
                }
                catch (Throwable throwable3) {
                    Object var26_27;
                    v1 = var26_27 = null;
                }
                if (!bl) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type == 1) {
                    new File(this.control_dir, this.controlFileName).delete();
                }
                throw throwable;
            }
        }
    }

    protected void setControlFile() {
        TOTorrentFile tOTorrentFile = this.owner.getOwner().getTorrentFile();
        if (tOTorrentFile == null) {
            this.controlFileName = null;
            this.control_dir = null;
        }
        TOTorrent tOTorrent = tOTorrentFile.getTorrent();
        TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
        int n = -1;
        for (int i = 0; i < tOTorrentFileArray.length; ++i) {
            if (tOTorrentFileArray[i] != tOTorrentFile) continue;
            n = i;
            break;
        }
        if (n == -1) {
            Debug.out("File '" + this.owner.getName() + "' not found in torrent!");
            this.controlFileName = null;
            this.control_dir = null;
        } else {
            this.control_dir = this.owner.getOwner().getControlFileDir();
            this.controlFileName = StringInterner.intern("fmfile" + n + ".dat");
        }
    }

    public void setStorageType(int n) throws FMFileManagerException {
        this.convert(n);
    }

    public int getStorageType() {
        return this.type;
    }

    public void aboutToOpen() throws FMFileManagerException {
        this.file_access.aboutToOpen();
    }

    public long getLength(RandomAccessFile randomAccessFile) throws FMFileManagerException {
        return this.file_access.getLength(randomAccessFile);
    }

    public void setLength(RandomAccessFile randomAccessFile, long l) throws FMFileManagerException {
        this.file_access.setLength(randomAccessFile, l);
    }

    public boolean isPieceCompleteProcessingNeeded(int n) {
        return this.file_access.isPieceCompleteProcessingNeeded(n);
    }

    public void setPieceComplete(RandomAccessFile randomAccessFile, int n, DirectByteBuffer directByteBuffer) throws FMFileManagerException {
        this.file_access.setPieceComplete(randomAccessFile, n, directByteBuffer);
    }

    public void read(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        this.file_access.read(randomAccessFile, directByteBufferArray, l);
    }

    public void write(RandomAccessFile randomAccessFile, DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        this.file_access.write(randomAccessFile, directByteBufferArray, l);
    }

    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    public FMFileImpl getFile() {
        return this.owner;
    }

    public String getString() {
        return "type=" + this.type + ",acc=" + this.file_access.getString();
    }

    static {
        if (TEST_PIECE_REORDER) {
            Debug.out("*** Piece reordering storage forced ***");
        }
    }
}

