/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerStats;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessControllerInstance;
import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessRequestImpl;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class DiskAccessControllerImpl
implements DiskAccessController,
AzureusCoreStatsProvider {
    private DiskAccessControllerInstance read_dispatcher;
    private DiskAccessControllerInstance write_dispatcher;

    public DiskAccessControllerImpl(String string, int n, int n2, int n3, int n4) {
        boolean bl = COConfigurationManager.getBooleanParameter("diskmanager.perf.read.aggregate.enable");
        int n5 = COConfigurationManager.getIntParameter("diskmanager.perf.read.aggregate.request.limit", 4);
        int n6 = COConfigurationManager.getIntParameter("diskmanager.perf.read.aggregate.byte.limit", 65536);
        boolean bl2 = COConfigurationManager.getBooleanParameter("diskmanager.perf.write.aggregate.enable");
        int n7 = COConfigurationManager.getIntParameter("diskmanager.perf.write.aggregate.request.limit", 8);
        int n8 = COConfigurationManager.getIntParameter("diskmanager.perf.write.aggregate.byte.limit", 131072);
        this.read_dispatcher = new DiskAccessControllerInstance(string + "/" + "read", bl, n5, n6, n, n2);
        this.write_dispatcher = new DiskAccessControllerInstance(string + "/" + "write", bl2, n7, n8, n3, n4);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("disk.read.queue.length");
        hashSet.add("disk.read.queue.bytes");
        hashSet.add("disk.read.request.count");
        hashSet.add("disk.read.request.single");
        hashSet.add("disk.read.request.multiple");
        hashSet.add("disk.read.request.blocks");
        hashSet.add("disk.read.bytes.total");
        hashSet.add("disk.read.bytes.single");
        hashSet.add("disk.read.bytes.multiple");
        hashSet.add("disk.read.io.time");
        hashSet.add("disk.read.io.count");
        hashSet.add("disk.write.queue.length");
        hashSet.add("disk.write.queue.bytes");
        hashSet.add("disk.write.request.count");
        hashSet.add("disk.write.request.blocks");
        hashSet.add("disk.write.bytes.total");
        hashSet.add("disk.write.bytes.single");
        hashSet.add("disk.write.bytes.multiple");
        hashSet.add("disk.write.io.time");
        AzureusCoreStats.registerProvider(hashSet, this);
    }

    public void updateStats(Set set, Map map) {
        if (set.contains("disk.read.queue.length")) {
            map.put("disk.read.queue.length", new Long(this.read_dispatcher.getQueueSize()));
        }
        if (set.contains("disk.read.queue.bytes")) {
            map.put("disk.read.queue.bytes", new Long(this.read_dispatcher.getQueuedBytes()));
        }
        if (set.contains("disk.read.request.count")) {
            map.put("disk.read.request.count", new Long(this.read_dispatcher.getTotalRequests()));
        }
        if (set.contains("disk.read.request.single")) {
            map.put("disk.read.request.single", new Long(this.read_dispatcher.getTotalSingleRequests()));
        }
        if (set.contains("disk.read.request.multiple")) {
            map.put("disk.read.request.multiple", new Long(this.read_dispatcher.getTotalAggregatedRequests()));
        }
        if (set.contains("disk.read.request.blocks")) {
            map.put("disk.read.request.blocks", new Long(this.read_dispatcher.getBlockCount()));
        }
        if (set.contains("disk.read.bytes.total")) {
            map.put("disk.read.bytes.total", new Long(this.read_dispatcher.getTotalBytes()));
        }
        if (set.contains("disk.read.bytes.single")) {
            map.put("disk.read.bytes.single", new Long(this.read_dispatcher.getTotalSingleBytes()));
        }
        if (set.contains("disk.read.bytes.multiple")) {
            map.put("disk.read.bytes.multiple", new Long(this.read_dispatcher.getTotalAggregatedBytes()));
        }
        if (set.contains("disk.read.io.time")) {
            map.put("disk.read.io.time", new Long(this.read_dispatcher.getIOTime()));
        }
        if (set.contains("disk.read.io.count")) {
            map.put("disk.read.io.count", new Long(this.read_dispatcher.getIOCount()));
        }
        if (set.contains("disk.write.queue.length")) {
            map.put("disk.write.queue.length", new Long(this.write_dispatcher.getQueueSize()));
        }
        if (set.contains("disk.write.queue.bytes")) {
            map.put("disk.write.queue.bytes", new Long(this.write_dispatcher.getQueuedBytes()));
        }
        if (set.contains("disk.write.request.count")) {
            map.put("disk.write.request.count", new Long(this.write_dispatcher.getTotalRequests()));
        }
        if (set.contains("disk.write.request.blocks")) {
            map.put("disk.write.request.blocks", new Long(this.write_dispatcher.getBlockCount()));
        }
        if (set.contains("disk.write.bytes.total")) {
            map.put("disk.write.bytes.total", new Long(this.write_dispatcher.getTotalBytes()));
        }
        if (set.contains("disk.write.bytes.single")) {
            map.put("disk.write.bytes.single", new Long(this.write_dispatcher.getTotalSingleBytes()));
        }
        if (set.contains("disk.write.bytes.multiple")) {
            map.put("disk.write.bytes.multiple", new Long(this.write_dispatcher.getTotalAggregatedBytes()));
        }
        if (set.contains("disk.write.io.time")) {
            map.put("disk.write.io.time", new Long(this.write_dispatcher.getIOTime()));
        }
        if (set.contains("disk.write.io.count")) {
            map.put("disk.write.io.count", new Long(this.write_dispatcher.getIOCount()));
        }
    }

    public DiskAccessRequest queueReadRequest(CacheFile cacheFile, long l, DirectByteBuffer directByteBuffer, short s, DiskAccessRequestListener diskAccessRequestListener) {
        DiskAccessRequestImpl diskAccessRequestImpl = new DiskAccessRequestImpl(cacheFile, l, directByteBuffer, diskAccessRequestListener, 1, s);
        this.read_dispatcher.queueRequest(diskAccessRequestImpl);
        return diskAccessRequestImpl;
    }

    public DiskAccessRequest queueWriteRequest(CacheFile cacheFile, long l, DirectByteBuffer directByteBuffer, boolean bl, DiskAccessRequestListener diskAccessRequestListener) {
        DiskAccessRequestImpl diskAccessRequestImpl = new DiskAccessRequestImpl(cacheFile, l, directByteBuffer, diskAccessRequestListener, bl ? (short)3 : 2, 0);
        this.write_dispatcher.queueRequest(diskAccessRequestImpl);
        return diskAccessRequestImpl;
    }

    public DiskAccessControllerStats getStats() {
        return new DiskAccessControllerStats(){
            long read_total_req;
            long read_total_bytes;
            {
                this.read_total_req = DiskAccessControllerImpl.this.read_dispatcher.getTotalRequests();
                this.read_total_bytes = DiskAccessControllerImpl.this.read_dispatcher.getTotalBytes();
            }

            public long getTotalReadRequests() {
                return this.read_total_req;
            }

            public long getTotalReadBytes() {
                return this.read_total_bytes;
            }
        };
    }

    public String getString() {
        return "read: " + this.read_dispatcher.getString() + ", write: " + this.write_dispatcher.getString();
    }
}

