/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestStore
extends DHTUDPPacketRequest {
    public static final int MAX_KEYS_PER_PACKET = 255;
    public static final int MAX_VALUES_PER_KEY = 255;
    private int random_id;
    private byte[][] keys;
    private DHTTransportValue[][] value_sets;

    public DHTUDPPacketRequestStore(DHTTransportUDPImpl dHTTransportUDPImpl, long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportUDPContactImpl dHTTransportUDPContactImpl2) {
        super(dHTTransportUDPImpl, 1026, l, dHTTransportUDPContactImpl, dHTTransportUDPContactImpl2);
    }

    protected DHTUDPPacketRequestStore(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, DataInputStream dataInputStream, long l, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, dataInputStream, 1026, l, n);
        if (this.getProtocolVersion() >= 7) {
            this.random_id = dataInputStream.readInt();
        }
        this.keys = DHTUDPUtils.deserialiseByteArrayArray(dataInputStream, 255);
        this.value_sets = DHTUDPUtils.deserialiseTransportValuesArray(this, dataInputStream, this.getClockSkew(), 255);
        super.postDeserialise(dataInputStream);
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        if (this.getProtocolVersion() >= 7) {
            dataOutputStream.writeInt(this.random_id);
        }
        DHTUDPUtils.serialiseByteArrayArray(dataOutputStream, this.keys, 255);
        try {
            DHTUDPUtils.serialiseTransportValuesArray(this, dataOutputStream, this.value_sets, 0L, 255);
        }
        catch (DHTTransportException dHTTransportException) {
            throw new IOException(dHTTransportException.getMessage());
        }
        super.postSerialise(dataOutputStream);
    }

    protected void setRandomID(int n) {
        this.random_id = n;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    protected void setValueSets(DHTTransportValue[][] dHTTransportValueArray) {
        this.value_sets = dHTTransportValueArray;
    }

    protected DHTTransportValue[][] getValueSets() {
        return this.value_sets;
    }

    protected void setKeys(byte[][] byArray) {
        this.keys = byArray;
    }

    protected byte[][] getKeys() {
        return this.keys;
    }

    public String getString() {
        return super.getString();
    }
}

